/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.generic;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import org.intellij.lang.regexp.RegExpFileType;
import org.jetbrains.annotations.NotNull;

public enum ResponseType {
    XML("application/xml", (FileType)XmlFileType.INSTANCE, ResponseType.findXPathFileType()),
    JSON("application/json", ResponseType.findFileTypePlainDefault("JSON"), (FileType)PlainTextFileType.INSTANCE),
    HTML("text/html", (FileType)HtmlFileType.INSTANCE, (FileType)PlainTextFileType.INSTANCE),
    TEXT("text/plain", (FileType)PlainTextFileType.INSTANCE, (FileType)RegExpFileType.INSTANCE);

    private final String myMimeType;
    private final FileType myContentFileType;
    private final FileType mySelectorFileType;
    private static Logger LOG;

    private ResponseType(@NotNull String s, FileType contentFileType, FileType selectorFileType) {
        if (s == null) {
            ResponseType.$$$reportNull$$$0(0);
        }
        if (contentFileType == null) {
            ResponseType.$$$reportNull$$$0(1);
        }
        if (selectorFileType == null) {
            ResponseType.$$$reportNull$$$0(2);
        }
        this.myMimeType = s;
        this.myContentFileType = contentFileType;
        this.mySelectorFileType = selectorFileType;
    }

    @NotNull
    private static FileType findFileTypePlainDefault(@NotNull String name) {
        FileType fileType;
        if (name == null) {
            ResponseType.$$$reportNull$$$0(3);
        }
        Object object = (fileType = FileTypeManager.getInstance().findFileTypeByName(name)) == null ? PlainTextFileType.INSTANCE : fileType;
        if (object == null) {
            ResponseType.$$$reportNull$$$0(4);
        }
        return object;
    }

    @NotNull
    private static FileType findXPathFileType() {
        FileType fileType;
        if (LOG == null) {
            LOG = Logger.getInstance(ResponseType.class);
        }
        try {
            Class<?> xPathClass = Class.forName("org.intellij.lang.xpath.XPathFileType");
            LOG.debug("XPathFileType class loaded successfully");
            fileType = (FileType)xPathClass.getField("XPATH").get(null);
        }
        catch (Exception e) {
            LOG.debug("XPathFileType class not found. Using PlainText.INSTANCE instead");
            PlainTextFileType plainTextFileType = PlainTextFileType.INSTANCE;
            if (plainTextFileType == null) {
                ResponseType.$$$reportNull$$$0(6);
            }
            return plainTextFileType;
        }
        if (fileType == null) {
            ResponseType.$$$reportNull$$$0(5);
        }
        return fileType;
    }

    @NotNull
    public String getMimeType() {
        String string = this.myMimeType;
        if (string == null) {
            ResponseType.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public FileType getContentFileType() {
        FileType fileType = this.myContentFileType;
        if (fileType == null) {
            ResponseType.$$$reportNull$$$0(8);
        }
        return fileType;
    }

    @NotNull
    public FileType getSelectorFileType() {
        FileType fileType = this.mySelectorFileType;
        if (fileType == null) {
            ResponseType.$$$reportNull$$$0(9);
        }
        return fileType;
    }

    static {
        LOG = Logger.getInstance(ResponseType.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentFileType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectorFileType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/generic/ResponseType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/generic/ResponseType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findFileTypePlainDefault";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findXPathFileType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMimeType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentFileType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectorFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findFileTypePlainDefault";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

