/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.blobstore.transfer.stream;

import com.jcraft.jzlib.CRC32;
import java.io.FilterInputStream;
import java.io.IOException;
import org.opensearch.common.blobstore.transfer.stream.OffsetRangeInputStream;

public class ResettableCheckedInputStream
extends FilterInputStream {
    private final CRC32 checksum = new CRC32();
    private final CRC32 markedChecksum = new CRC32();
    private final long startPos;
    private final String file;
    private final OffsetRangeInputStream offsetRangeInputStream;

    public ResettableCheckedInputStream(OffsetRangeInputStream offsetRangeInputStream, String file) throws IOException {
        super(offsetRangeInputStream);
        this.offsetRangeInputStream = offsetRangeInputStream;
        this.startPos = offsetRangeInputStream.getFilePointer();
        this.file = file;
    }

    @Override
    public int read() throws IOException {
        byte[] buffer = new byte[1];
        int len = this.read(buffer, 0, 1);
        if (len == -1) {
            return -1;
        }
        return buffer[0];
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if ((len = this.in.read(buf, off, len)) != -1) {
            this.checksum.update(buf, off, len);
        }
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        long total;
        long len;
        byte[] buf = new byte[512];
        for (total = 0L; total < n; total += len) {
            len = n - total;
            len = this.read(buf, 0, len < (long)buf.length ? (int)len : buf.length);
            if (len != -1L) continue;
            return total;
        }
        return total;
    }

    public long getChecksum() {
        return this.checksum.getValue();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.markedChecksum.reset(this.checksum.getValue());
        super.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.startPos == this.offsetRangeInputStream.getFilePointer()) {
            return;
        }
        this.checksum.reset(this.markedChecksum.getValue());
        super.reset();
    }
}

