/**
An XML document. It inherits from the generic Document and does not add any specific methods or properties to it: nevertheless, several algorithms behave differently with the two types of documents.

@returns {XMLDocument}
*/
XMLDocument = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**

Appends an event listener for events whose type attribute value is type. The callback argument sets the callback that will be invoked when the event is dispatched.

The options argument sets listener-specific options. For compatibility this can be a boolean, in which case the method behaves exactly as if the value was specified as options's capture.

When set to true, options's capture prevents callback from being invoked when the event's eventPhase attribute value is BUBBLING_PHASE. When false (or not present), callback will not be invoked when event's eventPhase attribute value is CAPTURING_PHASE. Either way, callback will be invoked if event's eventPhase attribute value is AT_TARGET.

When set to true, options's passive indicates that the callback will not cancel the event by invoking preventDefault(). This is used to enable performance optimizations described in § 2.8 Observing event listeners.

When set to true, options's once indicates that the callback will only be invoked once after which the event listener will be removed.

If an AbortSignal is passed for options's signal, then the event listener will be removed when signal is aborted.

The event listener is appended to target's event listener list and is not appended if it has the same type, callback, and capture.

@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | AddEventListenerOptions)} [options] boolean | AddEventListenerOptions
@returns {undefined}
**/
XMLDocument.prototype.addEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**

Removes the event listener in target's event listener list with the same type, callback, and options.

@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | EventListenerOptions)} [options] boolean | EventListenerOptions
@returns {undefined}
**/
XMLDocument.prototype.removeEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
XMLDocument.prototype.URL = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
XMLDocument.prototype.alinkColor = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {HTMLAllCollection}
**/
XMLDocument.prototype.all = new HTMLAllCollection();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {HTMLCollectionOf}
**/
XMLDocument.prototype.anchors = new HTMLCollectionOf();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {HTMLCollection}
**/
XMLDocument.prototype.applets = new HTMLCollection();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
XMLDocument.prototype.bgColor = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {HTMLElement}
**/
XMLDocument.prototype.body = new HTMLElement();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
XMLDocument.prototype.characterSet = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
XMLDocument.prototype.charset = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
XMLDocument.prototype.compatMode = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
XMLDocument.prototype.contentType = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
XMLDocument.prototype.cookie = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(HTMLScriptElement | SVGScriptElement | null)} HTMLOrSVGScriptElement | null
**/
XMLDocument.prototype.currentScript = new Object();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Window | null)} (WindowProxy & typeof globalThis) | null
**/
XMLDocument.prototype.defaultView = new Window();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
XMLDocument.prototype.designMode = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
XMLDocument.prototype.dir = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(DocumentType | null)} DocumentType | null
**/
XMLDocument.prototype.doctype = new DocumentType();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {HTMLElement}
**/
XMLDocument.prototype.documentElement = new HTMLElement();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
XMLDocument.prototype.documentURI = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
XMLDocument.prototype.domain = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {HTMLCollectionOf}
**/
XMLDocument.prototype.embeds = new HTMLCollectionOf();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
XMLDocument.prototype.fgColor = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {HTMLCollectionOf}
**/
XMLDocument.prototype.forms = new HTMLCollectionOf();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
XMLDocument.prototype.fullscreen = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
XMLDocument.prototype.fullscreenEnabled = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {HTMLHeadElement}
**/
XMLDocument.prototype.head = new HTMLHeadElement();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
XMLDocument.prototype.hidden = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {HTMLCollectionOf}
**/
XMLDocument.prototype.images = new HTMLCollectionOf();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {DOMImplementation}
**/
XMLDocument.prototype.implementation = new DOMImplementation();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
XMLDocument.prototype.inputEncoding = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
XMLDocument.prototype.lastModified = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
XMLDocument.prototype.linkColor = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {HTMLCollectionOf}
**/
XMLDocument.prototype.links = new HTMLCollectionOf();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: Document, ev: Event) => any) | null
**/
XMLDocument.prototype.onfullscreenchange = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: Document, ev: Event) => any) | null
**/
XMLDocument.prototype.onfullscreenerror = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: Document, ev: Event) => any) | null
**/
XMLDocument.prototype.onpointerlockchange = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: Document, ev: Event) => any) | null
**/
XMLDocument.prototype.onpointerlockerror = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: Document, ev: Event) => any) | null
**/
XMLDocument.prototype.onreadystatechange = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: Document, ev: Event) => any) | null
**/
XMLDocument.prototype.onvisibilitychange = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {null}
**/
XMLDocument.prototype.ownerDocument = null;

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
XMLDocument.prototype.pictureInPictureEnabled = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {HTMLCollectionOf}
**/
XMLDocument.prototype.plugins = new HTMLCollectionOf();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {("complete" | "interactive" | "loading")} DocumentReadyState
**/
XMLDocument.prototype.readyState = new Object();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
XMLDocument.prototype.referrer = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(SVGSVGElement | null)} SVGSVGElement | null
**/
XMLDocument.prototype.rootElement = new SVGSVGElement();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {HTMLCollectionOf}
**/
XMLDocument.prototype.scripts = new HTMLCollectionOf();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Element | null)} Element | null
**/
XMLDocument.prototype.scrollingElement = new Element();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {DocumentTimeline}
**/
XMLDocument.prototype.timeline = new DocumentTimeline();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
XMLDocument.prototype.title = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {("hidden" | "visible")} DocumentVisibilityState
**/
XMLDocument.prototype.visibilityState = new Object();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
XMLDocument.prototype.vlinkColor = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Moves node from another document and returns it.

If node is a document, throws a "NotSupportedError" DOMException or, if node is a shadow root, throws a "HierarchyRequestError" DOMException.

@param {Object} node T
@returns {Object} T
**/
XMLDocument.prototype.adoptNode = function(node) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {undefined}
**/
XMLDocument.prototype.captureEvents = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} x
@param {Number} y
@returns {(Range | null)} Range | null
**/
XMLDocument.prototype.caretRangeFromPoint = function(x, y) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {undefined}
**/
XMLDocument.prototype.clear = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Closes an output stream and forces the sent data to display.

@returns {undefined}
**/
XMLDocument.prototype.close = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Creates an attribute object with a specified name.

@param {String} localName
@returns {Attr}
**/
XMLDocument.prototype.createAttribute = function(localName) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(String | null)} namespace string | null
@param {String} qualifiedName
@returns {Attr}
**/
XMLDocument.prototype.createAttributeNS = function(namespace, qualifiedName) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns a CDATASection node whose data is data.

@param {String} data
@returns {CDATASection}
**/
XMLDocument.prototype.createCDATASection = function(data) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Creates a comment object with the specified data.

@param {String} data Sets the comment object's data.
@returns {Comment}
**/
XMLDocument.prototype.createComment = function(data) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Creates a new document.

@returns {DocumentFragment}
**/
XMLDocument.prototype.createDocumentFragment = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Creates an instance of the element for the specified tag.

@param {String} tagName
@param {ElementCreationOptions} [options] ElementCreationOptions
@returns {HTMLElement}
**/
XMLDocument.prototype.createElement = function(tagName) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns an element with namespace namespace. Its namespace prefix will be everything before ":" (U+003E) in qualifiedName or null. Its local name will be everything after ":" (U+003E) in qualifiedName or qualifiedName.

If localName does not match the Name production an "InvalidCharacterError" DOMException will be thrown.

If one of the following conditions is true a "NamespaceError" DOMException will be thrown:

localName does not match the QName production.
Namespace prefix is not null and namespace is the empty string.
Namespace prefix is "xml" and namespace is not the XML namespace.
qualifiedName or namespace prefix is "xmlns" and namespace is not the XMLNS namespace.
namespace is the XMLNS namespace and neither qualifiedName nor namespace prefix is "xmlns".

When supplied, options's is can be used to create a customized built-in element.

@param {(String | null)} namespace string | null
@param {String} qualifiedName
@param {(String | ElementCreationOptions)} [options] string | ElementCreationOptions
@returns {Element}
**/
XMLDocument.prototype.createElementNS = function(namespace, qualifiedName) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} eventInterface
@returns {Event}
**/
XMLDocument.prototype.createEvent = function(eventInterface) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Creates a NodeIterator object that you can use to traverse filtered lists of nodes or elements in a document.

@param {Node} root Node - The root element or node to start traversing on.
@param {Number} [whatToShow] The type of nodes or elements to appear in the node list
@param {(Function | Object | null)} [filter] NodeFilter | null - A custom NodeFilter function to use. For more information, see filter. Use null for no filter.
@returns {NodeIterator}
**/
XMLDocument.prototype.createNodeIterator = function(root) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns a ProcessingInstruction node whose target is target and data is data. If target does not match the Name production an "InvalidCharacterError" DOMException will be thrown. If data contains "?>" an "InvalidCharacterError" DOMException will be thrown.

@param {String} target
@param {String} data
@returns {ProcessingInstruction}
**/
XMLDocument.prototype.createProcessingInstruction = function(target, data) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns an empty range object that has both of its boundary points positioned at the beginning of the document.

@returns {Range}
**/
XMLDocument.prototype.createRange = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Creates a text string from the specified value.

@param {String} data String that specifies the nodeValue property of the text node.
@returns {Text}
**/
XMLDocument.prototype.createTextNode = function(data) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Creates a TreeWalker object that you can use to traverse filtered lists of nodes or elements in a document.

@param {Node} root Node - The root element or node to start traversing on.
@param {Number} [whatToShow] The type of nodes or elements to appear in the node list. For more information, see whatToShow.
@param {(Function | Object | null)} [filter] NodeFilter | null - A custom NodeFilter function to use.
@returns {TreeWalker}
**/
XMLDocument.prototype.createTreeWalker = function(root) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Executes a command on the current document, current selection, or the given range.

@param {String} commandId String that specifies the command to execute. This command can be any of the command identifiers that can be executed in script.
@param {Boolean} [showUI] Display the user interface, defaults to false.
@param {String} [value] Value to assign.
@returns {Boolean}
**/
XMLDocument.prototype.execCommand = function(commandId) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Stops document's fullscreen element from being displayed fullscreen and resolves promise when done.

@returns {Promise}
**/
XMLDocument.prototype.exitFullscreen = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Promise}
**/
XMLDocument.prototype.exitPictureInPicture = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {undefined}
**/
XMLDocument.prototype.exitPointerLock = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns a reference to the first object with the specified value of the ID attribute.

@param {String} elementId String that specifies the ID value.
@returns {(HTMLElement | null)} HTMLElement | null
**/
XMLDocument.prototype.getElementById = function(elementId) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns a HTMLCollection of the elements in the object on which the method was invoked (a document or an element) that have all the classes given by classNames. The classNames argument is interpreted as a space-separated list of classes.

@param {String} classNames
@returns {HTMLCollectionOf}
**/
XMLDocument.prototype.getElementsByClassName = function(classNames) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Gets a collection of objects based on the value of the NAME or ID attribute.

@param {String} elementName Gets a collection of objects based on the value of the NAME or ID attribute.
@returns {NodeListOf}
**/
XMLDocument.prototype.getElementsByName = function(elementName) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Retrieves a collection of objects based on the specified element name.

@param {String} qualifiedName
@returns {HTMLCollectionOf}
**/
XMLDocument.prototype.getElementsByTagName = function(qualifiedName) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
If namespace and localName are "*" returns a HTMLCollection of all descendant elements.

If only namespace is "*" returns a HTMLCollection of all descendant elements whose local name is localName.

If only localName is "*" returns a HTMLCollection of all descendant elements whose namespace is namespace.

Otherwise, returns a HTMLCollection of all descendant elements whose namespace is namespace and local name is localName.

@param {(String | null)} namespace string | null
@param {String} localName
@returns {HTMLCollectionOf}
**/
XMLDocument.prototype.getElementsByTagNameNS = function(namespace, localName) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns an object representing the current selection of the document that is loaded into the object displaying a webpage.

@returns {(Selection | null)} Selection | null
**/
XMLDocument.prototype.getSelection = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Gets a value indicating whether the object currently has focus.

@returns {Boolean}
**/
XMLDocument.prototype.hasFocus = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Promise}
**/
XMLDocument.prototype.hasStorageAccess = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns a copy of node. If deep is true, the copy also includes the node's descendants.

If node is a document or a shadow root, throws a "NotSupportedError" DOMException.

@param {Object} node T
@param {Boolean} [deep]
@returns {Object} T
**/
XMLDocument.prototype.importNode = function(node) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Opens a new window and loads a document specified by a given URL. Also, opens a new window that uses the url parameter and the name parameter to collect the output of the write method and the writeln method.

@param {(String | URL)} url string | URL
@param {String} name
@param {String} features
@returns {(Window | null)} WindowProxy | null
**/
XMLDocument.prototype.open = function(url, name, features) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns a Boolean value that indicates whether a specified command can be successfully executed using execCommand, given the current state of the document.

@param {String} commandId Specifies a command identifier.
@returns {Boolean}
**/
XMLDocument.prototype.queryCommandEnabled = function(commandId) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns a Boolean value that indicates whether the specified command is in the indeterminate state.

@param {String} commandId String that specifies a command identifier.
@returns {Boolean}
**/
XMLDocument.prototype.queryCommandIndeterm = function(commandId) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns a Boolean value that indicates the current state of the command.

@param {String} commandId String that specifies a command identifier.
@returns {Boolean}
**/
XMLDocument.prototype.queryCommandState = function(commandId) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns a Boolean value that indicates whether the current command is supported on the current range.

@param {String} commandId Specifies a command identifier.
@returns {Boolean}
**/
XMLDocument.prototype.queryCommandSupported = function(commandId) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns the current value of the document, range, or current selection for the given command.

@param {String} commandId String that specifies a command identifier.
@returns {String}
**/
XMLDocument.prototype.queryCommandValue = function(commandId) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {undefined}
**/
XMLDocument.prototype.releaseEvents = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Promise}
**/
XMLDocument.prototype.requestStorageAccess = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Writes one or more HTML expressions to a document in the specified window.

@param {String} text
@returns {undefined}
**/
XMLDocument.prototype.write = function(text) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Writes one or more HTML expressions, followed by a carriage return, to a document in the specified window.

@param {String} text
@returns {undefined}
**/
XMLDocument.prototype.writeln = function(text) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**

Appends an event listener for events whose type attribute value is type. The callback argument sets the callback that will be invoked when the event is dispatched.

The options argument sets listener-specific options. For compatibility this can be a boolean, in which case the method behaves exactly as if the value was specified as options's capture.

When set to true, options's capture prevents callback from being invoked when the event's eventPhase attribute value is BUBBLING_PHASE. When false (or not present), callback will not be invoked when event's eventPhase attribute value is CAPTURING_PHASE. Either way, callback will be invoked if event's eventPhase attribute value is AT_TARGET.

When set to true, options's passive indicates that the callback will not cancel the event by invoking preventDefault(). This is used to enable performance optimizations described in § 2.8 Observing event listeners.

When set to true, options's once indicates that the callback will only be invoked once after which the event listener will be removed.

If an AbortSignal is passed for options's signal, then the event listener will be removed when signal is aborted.

The event listener is appended to target's event listener list and is not appended if it has the same type, callback, and capture.

@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | AddEventListenerOptions)} [options] boolean | AddEventListenerOptions
@returns {undefined}
**/
XMLDocument.prototype.addEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**

Removes the event listener in target's event listener list with the same type, callback, and options.

@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | EventListenerOptions)} [options] boolean | EventListenerOptions
@returns {undefined}
**/
XMLDocument.prototype.removeEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
XMLDocument.prototype.baseURI = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {NodeListOf}
**/
XMLDocument.prototype.childNodes = new NodeListOf();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
XMLDocument.prototype.firstChild = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
XMLDocument.prototype.isConnected = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
XMLDocument.prototype.lastChild = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
XMLDocument.prototype.nextSibling = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
XMLDocument.prototype.nodeName = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
XMLDocument.prototype.nodeType = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
XMLDocument.prototype.nodeValue = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Document | null)} Document | null
**/
XMLDocument.prototype.ownerDocument = new Document();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(HTMLElement | null)} HTMLElement | null
**/
XMLDocument.prototype.parentElement = new HTMLElement();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ParentNode | null)} ParentNode | null
**/
XMLDocument.prototype.parentNode = new ParentNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
XMLDocument.prototype.previousSibling = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
XMLDocument.prototype.textContent = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Object} node T
@returns {Object} T
**/
XMLDocument.prototype.appendChild = function(node) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns a copy of node. If deep is true, the copy also includes the node's descendants.

@param {Boolean} [deep]
@returns {Node}
**/
XMLDocument.prototype.cloneNode = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns a bitmask indicating the position of other relative to node.

@param {Node} other Node
@returns {Number}
**/
XMLDocument.prototype.compareDocumentPosition = function(other) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns true if other is an inclusive descendant of node, and false otherwise.

@param {(Node | null)} other Node | null
@returns {Boolean}
**/
XMLDocument.prototype.contains = function(other) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns node's root.

@param {GetRootNodeOptions} [options] GetRootNodeOptions
@returns {Node}
**/
XMLDocument.prototype.getRootNode = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns whether node has children.

@returns {Boolean}
**/
XMLDocument.prototype.hasChildNodes = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Object} node T
@param {(Node | null)} child Node | null
@returns {Object} T
**/
XMLDocument.prototype.insertBefore = function(node, child) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(String | null)} namespace string | null
@returns {Boolean}
**/
XMLDocument.prototype.isDefaultNamespace = function(namespace) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns whether node and otherNode have the same properties.

@param {(Node | null)} otherNode Node | null
@returns {Boolean}
**/
XMLDocument.prototype.isEqualNode = function(otherNode) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(Node | null)} otherNode Node | null
@returns {Boolean}
**/
XMLDocument.prototype.isSameNode = function(otherNode) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(String | null)} prefix string | null
@returns {(String | null)} string | null
**/
XMLDocument.prototype.lookupNamespaceURI = function(prefix) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(String | null)} namespace string | null
@returns {(String | null)} string | null
**/
XMLDocument.prototype.lookupPrefix = function(namespace) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes empty exclusive Text nodes and concatenates the data of remaining contiguous exclusive Text nodes into the first of their nodes.

@returns {undefined}
**/
XMLDocument.prototype.normalize = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Object} child T
@returns {Object} T
**/
XMLDocument.prototype.removeChild = function(child) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Node} node Node
@param {Object} child T
@returns {Object} T
**/
XMLDocument.prototype.replaceChild = function(node, child) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
XMLDocument.prototype.ATTRIBUTE_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
XMLDocument.prototype.CDATA_SECTION_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
XMLDocument.prototype.COMMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
XMLDocument.prototype.DOCUMENT_FRAGMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
XMLDocument.prototype.DOCUMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
XMLDocument.prototype.DOCUMENT_POSITION_CONTAINED_BY = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
XMLDocument.prototype.DOCUMENT_POSITION_CONTAINS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
XMLDocument.prototype.DOCUMENT_POSITION_DISCONNECTED = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
XMLDocument.prototype.DOCUMENT_POSITION_FOLLOWING = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
XMLDocument.prototype.DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
XMLDocument.prototype.DOCUMENT_POSITION_PRECEDING = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
XMLDocument.prototype.DOCUMENT_TYPE_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
XMLDocument.prototype.ELEMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
XMLDocument.prototype.ENTITY_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
XMLDocument.prototype.ENTITY_REFERENCE_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
XMLDocument.prototype.NOTATION_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
XMLDocument.prototype.PROCESSING_INSTRUCTION_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
XMLDocument.prototype.TEXT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Appends an event listener for events whose type attribute value is type. The callback argument sets the callback that will be invoked when the event is dispatched.

The options argument sets listener-specific options. For compatibility this can be a boolean, in which case the method behaves exactly as if the value was specified as options's capture.

When set to true, options's capture prevents callback from being invoked when the event's eventPhase attribute value is BUBBLING_PHASE. When false (or not present), callback will not be invoked when event's eventPhase attribute value is CAPTURING_PHASE. Either way, callback will be invoked if event's eventPhase attribute value is AT_TARGET.

When set to true, options's passive indicates that the callback will not cancel the event by invoking preventDefault(). This is used to enable performance optimizations described in § 2.8 Observing event listeners.

When set to true, options's once indicates that the callback will only be invoked once after which the event listener will be removed.

If an AbortSignal is passed for options's signal, then the event listener will be removed when signal is aborted.

The event listener is appended to target's event listener list and is not appended if it has the same type, callback, and capture.

@param {String} type
@param {(EventListener | EventListenerObject | null)} callback EventListenerOrEventListenerObject | null
@param {(AddEventListenerOptions | Boolean)} [options] AddEventListenerOptions | boolean
@returns {undefined}
**/
XMLDocument.prototype.addEventListener = function(type, callback) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Dispatches a synthetic event event to target and returns true if either event's cancelable attribute value is false or its preventDefault() method was not invoked, and false otherwise.

@param {Event} event Event
@returns {Boolean}
**/
XMLDocument.prototype.dispatchEvent = function(event) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes the event listener in target's event listener list with the same type, callback, and options.

@param {String} type
@param {(EventListener | EventListenerObject | null)} callback EventListenerOrEventListenerObject | null
@param {(EventListenerOptions | Boolean)} [options] EventListenerOptions | boolean
@returns {undefined}
**/
XMLDocument.prototype.removeEventListener = function(type, callback) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: DocumentAndElementEventHandlers, ev: ClipboardEvent) => any) | null
**/
XMLDocument.prototype.oncopy = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: DocumentAndElementEventHandlers, ev: ClipboardEvent) => any) | null
**/
XMLDocument.prototype.oncut = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: DocumentAndElementEventHandlers, ev: ClipboardEvent) => any) | null
**/
XMLDocument.prototype.onpaste = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | AddEventListenerOptions)} [options] boolean | AddEventListenerOptions
@returns {undefined}
**/
XMLDocument.prototype.addEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | EventListenerOptions)} [options] boolean | EventListenerOptions
@returns {undefined}
**/
XMLDocument.prototype.removeEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Element | null)} Element | null
**/
XMLDocument.prototype.activeElement = new Element();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Element | null)} Element | null
**/
XMLDocument.prototype.fullscreenElement = new Element();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Element | null)} Element | null
**/
XMLDocument.prototype.pictureInPictureElement = new Element();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Element | null)} Element | null
**/
XMLDocument.prototype.pointerLockElement = new Element();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {StyleSheetList}
**/
XMLDocument.prototype.styleSheets = new StyleSheetList();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns the element for the specified x coordinate and the specified y coordinate.

@param {Number} x The x-offset
@param {Number} y The y-offset
@returns {(Element | null)} Element | null
**/
XMLDocument.prototype.elementFromPoint = function(x, y) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Number} x
@param {Number} y
@returns {Element[]}
**/
XMLDocument.prototype.elementsFromPoint = function(x, y) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Animation[]}
**/
XMLDocument.prototype.getAnimations = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {FontFaceSet}
**/
XMLDocument.prototype.fonts = new FontFaceSet();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: UIEvent) => any) | null
**/
XMLDocument.prototype.onabort = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: AnimationEvent) => any) | null
**/
XMLDocument.prototype.onanimationcancel = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: AnimationEvent) => any) | null
**/
XMLDocument.prototype.onanimationend = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: AnimationEvent) => any) | null
**/
XMLDocument.prototype.onanimationiteration = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: AnimationEvent) => any) | null
**/
XMLDocument.prototype.onanimationstart = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
XMLDocument.prototype.onauxclick = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: FocusEvent) => any) | null
**/
XMLDocument.prototype.onblur = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
XMLDocument.prototype.oncanplay = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
XMLDocument.prototype.oncanplaythrough = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
XMLDocument.prototype.onchange = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
XMLDocument.prototype.onclick = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
XMLDocument.prototype.onclose = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
XMLDocument.prototype.oncontextmenu = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
XMLDocument.prototype.oncuechange = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
XMLDocument.prototype.ondblclick = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: DragEvent) => any) | null
**/
XMLDocument.prototype.ondrag = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: DragEvent) => any) | null
**/
XMLDocument.prototype.ondragend = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: DragEvent) => any) | null
**/
XMLDocument.prototype.ondragenter = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: DragEvent) => any) | null
**/
XMLDocument.prototype.ondragleave = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: DragEvent) => any) | null
**/
XMLDocument.prototype.ondragover = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: DragEvent) => any) | null
**/
XMLDocument.prototype.ondragstart = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: DragEvent) => any) | null
**/
XMLDocument.prototype.ondrop = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
XMLDocument.prototype.ondurationchange = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
XMLDocument.prototype.onemptied = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
XMLDocument.prototype.onended = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(OnErrorEventHandlerNonNull | null)} OnErrorEventHandler
**/
XMLDocument.prototype.onerror = new OnErrorEventHandlerNonNull();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: FocusEvent) => any) | null
**/
XMLDocument.prototype.onfocus = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: FormDataEvent) => any) | null
**/
XMLDocument.prototype.onformdata = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null
**/
XMLDocument.prototype.ongotpointercapture = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
XMLDocument.prototype.oninput = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
XMLDocument.prototype.oninvalid = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: KeyboardEvent) => any) | null
**/
XMLDocument.prototype.onkeydown = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: KeyboardEvent) => any) | null
**/
XMLDocument.prototype.onkeypress = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: KeyboardEvent) => any) | null
**/
XMLDocument.prototype.onkeyup = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
XMLDocument.prototype.onload = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
XMLDocument.prototype.onloadeddata = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
XMLDocument.prototype.onloadedmetadata = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
XMLDocument.prototype.onloadstart = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null
**/
XMLDocument.prototype.onlostpointercapture = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
XMLDocument.prototype.onmousedown = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
XMLDocument.prototype.onmouseenter = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
XMLDocument.prototype.onmouseleave = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
XMLDocument.prototype.onmousemove = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
XMLDocument.prototype.onmouseout = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
XMLDocument.prototype.onmouseover = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null
**/
XMLDocument.prototype.onmouseup = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
XMLDocument.prototype.onpause = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
XMLDocument.prototype.onplay = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
XMLDocument.prototype.onplaying = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null
**/
XMLDocument.prototype.onpointercancel = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null
**/
XMLDocument.prototype.onpointerdown = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null
**/
XMLDocument.prototype.onpointerenter = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null
**/
XMLDocument.prototype.onpointerleave = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null
**/
XMLDocument.prototype.onpointermove = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null
**/
XMLDocument.prototype.onpointerout = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null
**/
XMLDocument.prototype.onpointerover = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null
**/
XMLDocument.prototype.onpointerup = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: ProgressEvent) => any) | null
**/
XMLDocument.prototype.onprogress = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
XMLDocument.prototype.onratechange = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
XMLDocument.prototype.onreset = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: UIEvent) => any) | null
**/
XMLDocument.prototype.onresize = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
XMLDocument.prototype.onscroll = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: SecurityPolicyViolationEvent) => any) | null
**/
XMLDocument.prototype.onsecuritypolicyviolation = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
XMLDocument.prototype.onseeked = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
XMLDocument.prototype.onseeking = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
XMLDocument.prototype.onselect = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
XMLDocument.prototype.onselectionchange = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
XMLDocument.prototype.onselectstart = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
XMLDocument.prototype.onslotchange = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
XMLDocument.prototype.onstalled = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: SubmitEvent) => any) | null
**/
XMLDocument.prototype.onsubmit = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
XMLDocument.prototype.onsuspend = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
XMLDocument.prototype.ontimeupdate = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
XMLDocument.prototype.ontoggle = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null | undefined)} ((this: GlobalEventHandlers, ev: TouchEvent) => any) | null | undefined
**/
XMLDocument.prototype.ontouchcancel = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null | undefined)} ((this: GlobalEventHandlers, ev: TouchEvent) => any) | null | undefined
**/
XMLDocument.prototype.ontouchend = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null | undefined)} ((this: GlobalEventHandlers, ev: TouchEvent) => any) | null | undefined
**/
XMLDocument.prototype.ontouchmove = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null | undefined)} ((this: GlobalEventHandlers, ev: TouchEvent) => any) | null | undefined
**/
XMLDocument.prototype.ontouchstart = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: TransitionEvent) => any) | null
**/
XMLDocument.prototype.ontransitioncancel = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: TransitionEvent) => any) | null
**/
XMLDocument.prototype.ontransitionend = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: TransitionEvent) => any) | null
**/
XMLDocument.prototype.ontransitionrun = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: TransitionEvent) => any) | null
**/
XMLDocument.prototype.ontransitionstart = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
XMLDocument.prototype.onvolumechange = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
XMLDocument.prototype.onwaiting = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
XMLDocument.prototype.onwebkitanimationend = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
XMLDocument.prototype.onwebkitanimationiteration = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
XMLDocument.prototype.onwebkitanimationstart = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: Event) => any) | null
**/
XMLDocument.prototype.onwebkittransitionend = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: GlobalEventHandlers, ev: WheelEvent) => any) | null
**/
XMLDocument.prototype.onwheel = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | AddEventListenerOptions)} [options] boolean | AddEventListenerOptions
@returns {undefined}
**/
XMLDocument.prototype.addEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | EventListenerOptions)} [options] boolean | EventListenerOptions
@returns {undefined}
**/
XMLDocument.prototype.removeEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns the first element within node's descendants whose ID is elementId.

@param {String} elementId
@returns {(Element | null)} Element | null
**/
XMLDocument.prototype.getElementById = function(elementId) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
XMLDocument.prototype.childElementCount = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {HTMLCollection}
**/
XMLDocument.prototype.children = new HTMLCollection();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Element | null)} Element | null
**/
XMLDocument.prototype.firstElementChild = new Element();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Element | null)} Element | null
**/
XMLDocument.prototype.lastElementChild = new Element();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Inserts nodes after the last child of node, while replacing strings in nodes with equivalent Text nodes.

Throws a "HierarchyRequestError" DOMException if the constraints of the node tree are violated.

@param {(Node | String)} nodes (Node | string)[]
@returns {undefined}
**/
XMLDocument.prototype.append = function(nodes) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Inserts nodes before the first child of node, while replacing strings in nodes with equivalent Text nodes.

Throws a "HierarchyRequestError" DOMException if the constraints of the node tree are violated.

@param {(Node | String)} nodes (Node | string)[]
@returns {undefined}
**/
XMLDocument.prototype.prepend = function(nodes) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns the first element that is a descendant of node that matches selectors.

@param {String} selectors
@returns {(Object | null)} E | null
**/
XMLDocument.prototype.querySelector = function(selectors) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns all element descendants of node that match selectors.

@param {String} selectors
@returns {NodeListOf}
**/
XMLDocument.prototype.querySelectorAll = function(selectors) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Replace all children of node with nodes, while replacing strings in nodes with equivalent Text nodes.

Throws a "HierarchyRequestError" DOMException if the constraints of the node tree are violated.

@param {(Node | String)} nodes (Node | string)[]
@returns {undefined}
**/
XMLDocument.prototype.replaceChildren = function(nodes) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
XMLDocument.prototype.baseURI = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {NodeListOf}
**/
XMLDocument.prototype.childNodes = new NodeListOf();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
XMLDocument.prototype.firstChild = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
XMLDocument.prototype.isConnected = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
XMLDocument.prototype.lastChild = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
XMLDocument.prototype.nextSibling = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
XMLDocument.prototype.nodeName = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
XMLDocument.prototype.nodeType = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
XMLDocument.prototype.nodeValue = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Document | null)} Document | null
**/
XMLDocument.prototype.ownerDocument = new Document();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(HTMLElement | null)} HTMLElement | null
**/
XMLDocument.prototype.parentElement = new HTMLElement();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ParentNode | null)} ParentNode | null
**/
XMLDocument.prototype.parentNode = new ParentNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(ChildNode | null)} ChildNode | null
**/
XMLDocument.prototype.previousSibling = new ChildNode();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | null)} string | null
**/
XMLDocument.prototype.textContent = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Object} node T
@returns {Object} T
**/
XMLDocument.prototype.appendChild = function(node) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns a copy of node. If deep is true, the copy also includes the node's descendants.

@param {Boolean} [deep]
@returns {Node}
**/
XMLDocument.prototype.cloneNode = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns a bitmask indicating the position of other relative to node.

@param {Node} other Node
@returns {Number}
**/
XMLDocument.prototype.compareDocumentPosition = function(other) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns true if other is an inclusive descendant of node, and false otherwise.

@param {(Node | null)} other Node | null
@returns {Boolean}
**/
XMLDocument.prototype.contains = function(other) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns node's root.

@param {GetRootNodeOptions} [options] GetRootNodeOptions
@returns {Node}
**/
XMLDocument.prototype.getRootNode = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns whether node has children.

@returns {Boolean}
**/
XMLDocument.prototype.hasChildNodes = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Object} node T
@param {(Node | null)} child Node | null
@returns {Object} T
**/
XMLDocument.prototype.insertBefore = function(node, child) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(String | null)} namespace string | null
@returns {Boolean}
**/
XMLDocument.prototype.isDefaultNamespace = function(namespace) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns whether node and otherNode have the same properties.

@param {(Node | null)} otherNode Node | null
@returns {Boolean}
**/
XMLDocument.prototype.isEqualNode = function(otherNode) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(Node | null)} otherNode Node | null
@returns {Boolean}
**/
XMLDocument.prototype.isSameNode = function(otherNode) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(String | null)} prefix string | null
@returns {(String | null)} string | null
**/
XMLDocument.prototype.lookupNamespaceURI = function(prefix) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(String | null)} namespace string | null
@returns {(String | null)} string | null
**/
XMLDocument.prototype.lookupPrefix = function(namespace) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes empty exclusive Text nodes and concatenates the data of remaining contiguous exclusive Text nodes into the first of their nodes.

@returns {undefined}
**/
XMLDocument.prototype.normalize = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Object} child T
@returns {Object} T
**/
XMLDocument.prototype.removeChild = function(child) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Node} node Node
@param {Object} child T
@returns {Object} T
**/
XMLDocument.prototype.replaceChild = function(node, child) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
XMLDocument.prototype.ATTRIBUTE_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
XMLDocument.prototype.CDATA_SECTION_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
XMLDocument.prototype.COMMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
XMLDocument.prototype.DOCUMENT_FRAGMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
XMLDocument.prototype.DOCUMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
XMLDocument.prototype.DOCUMENT_POSITION_CONTAINED_BY = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
XMLDocument.prototype.DOCUMENT_POSITION_CONTAINS = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
XMLDocument.prototype.DOCUMENT_POSITION_DISCONNECTED = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
XMLDocument.prototype.DOCUMENT_POSITION_FOLLOWING = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
XMLDocument.prototype.DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
XMLDocument.prototype.DOCUMENT_POSITION_PRECEDING = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
XMLDocument.prototype.DOCUMENT_TYPE_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
XMLDocument.prototype.ELEMENT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
XMLDocument.prototype.ENTITY_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
XMLDocument.prototype.ENTITY_REFERENCE_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
XMLDocument.prototype.NOTATION_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
XMLDocument.prototype.PROCESSING_INSTRUCTION_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
XMLDocument.prototype.TEXT_NODE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Appends an event listener for events whose type attribute value is type. The callback argument sets the callback that will be invoked when the event is dispatched.

The options argument sets listener-specific options. For compatibility this can be a boolean, in which case the method behaves exactly as if the value was specified as options's capture.

When set to true, options's capture prevents callback from being invoked when the event's eventPhase attribute value is BUBBLING_PHASE. When false (or not present), callback will not be invoked when event's eventPhase attribute value is CAPTURING_PHASE. Either way, callback will be invoked if event's eventPhase attribute value is AT_TARGET.

When set to true, options's passive indicates that the callback will not cancel the event by invoking preventDefault(). This is used to enable performance optimizations described in § 2.8 Observing event listeners.

When set to true, options's once indicates that the callback will only be invoked once after which the event listener will be removed.

If an AbortSignal is passed for options's signal, then the event listener will be removed when signal is aborted.

The event listener is appended to target's event listener list and is not appended if it has the same type, callback, and capture.

@param {String} type
@param {(EventListener | EventListenerObject | null)} callback EventListenerOrEventListenerObject | null
@param {(AddEventListenerOptions | Boolean)} [options] AddEventListenerOptions | boolean
@returns {undefined}
**/
XMLDocument.prototype.addEventListener = function(type, callback) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Dispatches a synthetic event event to target and returns true if either event's cancelable attribute value is false or its preventDefault() method was not invoked, and false otherwise.

@param {Event} event Event
@returns {Boolean}
**/
XMLDocument.prototype.dispatchEvent = function(event) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes the event listener in target's event listener list with the same type, callback, and options.

@param {String} type
@param {(EventListener | EventListenerObject | null)} callback EventListenerOrEventListenerObject | null
@param {(EventListenerOptions | Boolean)} [options] EventListenerOptions | boolean
@returns {undefined}
**/
XMLDocument.prototype.removeEventListener = function(type, callback) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} expression
@param {(Function | Object | null)} [resolver] XPathNSResolver | null
@returns {XPathExpression}
**/
XMLDocument.prototype.createExpression = function(expression) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {Node} nodeResolver Node
@returns {(Function | Object)} XPathNSResolver
**/
XMLDocument.prototype.createNSResolver = function(nodeResolver) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} expression
@param {Node} contextNode Node
@param {(Function | Object | null)} [resolver] XPathNSResolver | null
@param {Number} [type]
@param {(XPathResult | null)} [result] XPathResult | null
@returns {XPathResult}
**/
XMLDocument.prototype.evaluate = function(expression, contextNode) {};

