/**
A DOM event that represents a drag and drop interaction. The user initiates a drag by placing a pointer device (such as a mouse) on the touch surface and then dragging the pointer to a new location (such as another DOM element). Applications are free to interpret a drag and drop interaction in an application-specific way.

@returns {DragEvent}
*/
DragEvent = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(DataTransfer | null)} DataTransfer | null
**/
DragEvent.prototype.dataTransfer = new DataTransfer();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
DragEvent.prototype.altKey = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
DragEvent.prototype.button = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
DragEvent.prototype.buttons = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
DragEvent.prototype.clientX = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
DragEvent.prototype.clientY = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
DragEvent.prototype.ctrlKey = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
DragEvent.prototype.metaKey = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
DragEvent.prototype.movementX = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
DragEvent.prototype.movementY = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
DragEvent.prototype.offsetX = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
DragEvent.prototype.offsetY = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
DragEvent.prototype.pageX = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
DragEvent.prototype.pageY = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(EventTarget | null)} EventTarget | null
**/
DragEvent.prototype.relatedTarget = new EventTarget();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
DragEvent.prototype.screenX = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
DragEvent.prototype.screenY = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
DragEvent.prototype.shiftKey = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
DragEvent.prototype.x = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
DragEvent.prototype.y = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} keyArg
@returns {Boolean}
**/
DragEvent.prototype.getModifierState = function(keyArg) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} typeArg
@param {Boolean} canBubbleArg
@param {Boolean} cancelableArg
@param {Window} viewArg Window
@param {Number} detailArg
@param {Number} screenXArg
@param {Number} screenYArg
@param {Number} clientXArg
@param {Number} clientYArg
@param {Boolean} ctrlKeyArg
@param {Boolean} altKeyArg
@param {Boolean} shiftKeyArg
@param {Boolean} metaKeyArg
@param {Number} buttonArg
@param {(EventTarget | null)} relatedTargetArg EventTarget | null
@returns {undefined}
**/
DragEvent.prototype.initMouseEvent = function(typeArg, canBubbleArg, cancelableArg, viewArg, detailArg, screenXArg, screenYArg, clientXArg, clientYArg, ctrlKeyArg, altKeyArg, shiftKeyArg, metaKeyArg, buttonArg, relatedTargetArg) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
DragEvent.prototype.detail = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Window | null)} Window | null
**/
DragEvent.prototype.view = new Window();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
DragEvent.prototype.which = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} typeArg
@param {Boolean} [bubblesArg]
@param {Boolean} [cancelableArg]
@param {(Window | null)} [viewArg] Window | null
@param {Number} [detailArg]
@returns {undefined}
**/
DragEvent.prototype.initUIEvent = function(typeArg) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
DragEvent.prototype.bubbles = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
DragEvent.prototype.cancelBubble = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
DragEvent.prototype.cancelable = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
DragEvent.prototype.composed = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(EventTarget | null)} EventTarget | null
**/
DragEvent.prototype.currentTarget = new EventTarget();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
DragEvent.prototype.defaultPrevented = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
DragEvent.prototype.eventPhase = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
DragEvent.prototype.isTrusted = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
DragEvent.prototype.returnValue = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(EventTarget | null)} EventTarget | null
**/
DragEvent.prototype.srcElement = new EventTarget();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(EventTarget | null)} EventTarget | null
**/
DragEvent.prototype.target = new EventTarget();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number} DOMHighResTimeStamp
**/
DragEvent.prototype.timeStamp = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
DragEvent.prototype.type = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns the invocation target objects of event's path (objects on which listeners will be invoked), except for any nodes in shadow trees of which the shadow root's mode is "closed" that are not reachable from event's currentTarget.

@returns {EventTarget[]}
**/
DragEvent.prototype.composedPath = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} type
@param {Boolean} [bubbles]
@param {Boolean} [cancelable]
@returns {undefined}
**/
DragEvent.prototype.initEvent = function(type) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
If invoked when the cancelable attribute value is true, and while executing a listener for the event with passive set to false, signals to the operation that caused event to be dispatched that it needs to be canceled.

@returns {undefined}
**/
DragEvent.prototype.preventDefault = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Invoking this method prevents event from reaching any registered event listeners after the current one finishes running and, when dispatched in a tree, also prevents event from reaching any other objects.

@returns {undefined}
**/
DragEvent.prototype.stopImmediatePropagation = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
When dispatched in a tree, invoking this method prevents event from reaching any objects other than the current object.

@returns {undefined}
**/
DragEvent.prototype.stopPropagation = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
DragEvent.prototype.AT_TARGET = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
DragEvent.prototype.BUBBLING_PHASE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
DragEvent.prototype.CAPTURING_PHASE = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
DragEvent.prototype.NONE = new Number();

