/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual;

import java.util.Comparator;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.netbeans.modules.css.lib.api.properties.Properties;
import org.netbeans.modules.css.lib.api.properties.PropertyDefinition;
import org.openide.filesystems.FileObject;

public class AutocompleteJComboBox
extends JComboBox {
    private static Comparator<String> PROPERTY_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            boolean s1vendor = Properties.isVendorSpecificPropertyName((String)s1);
            boolean s2vendor = Properties.isVendorSpecificPropertyName((String)s2);
            if (s1vendor && !s2vendor) {
                return 1;
            }
            if (!s1vendor && s2vendor) {
                return -1;
            }
            return s1.compareTo(s2);
        }
    };

    public AutocompleteJComboBox(FileObject file) {
        super(new DefaultComboBoxModel<String>(AutocompleteJComboBox.getProperties(file)));
    }

    private static String[] getProperties(FileObject file) {
        TreeSet<String> properties = new TreeSet<String>(PROPERTY_COMPARATOR);
        for (PropertyDefinition pdef : Properties.getPropertyDefinitions((FileObject)file, (boolean)true)) {
            properties.add(pdef.getName());
        }
        return properties.toArray(new String[0]);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.setPopupVisible(true);
    }
}

