/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.preprocessorbridge.spi;

import com.sun.source.tree.ModuleTree;
import java.io.IOException;
import java.util.Map;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.java.preprocessorbridge.JavaSourceUtilImplAccessor;
import org.openide.filesystems.FileObject;

public abstract class JavaSourceUtilImpl {
    private static final String EXPECTED_PACKAGE = "org.netbeans.modules.java.source";

    protected JavaSourceUtilImpl() {
        String implPackage = this.getClass().getPackage().getName();
        if (!EXPECTED_PACKAGE.equals(implPackage)) {
            throw new IllegalArgumentException();
        }
    }

    protected long createTaggedCompilationController(FileObject file, int position, long currenTag, Object[] out) throws IOException {
        if (position == -1) {
            return this.createTaggedCompilationController(file, currenTag, out);
        }
        throw new UnsupportedOperationException("Not supported in the registered implementation: " + this.getClass().getName());
    }

    protected abstract long createTaggedCompilationController(FileObject var1, long var2, Object[] var4) throws IOException;

    @NonNull
    protected Map<String, byte[]> generate(@NonNull FileObject root, @NonNull FileObject file, @NullAllowed CharSequence content, @NullAllowed DiagnosticListener<? super JavaFileObject> diagnostics) throws IOException {
        throw new UnsupportedOperationException("Not supported in the registered implementation: " + this.getClass().getName());
    }

    @CheckForNull
    protected abstract ModuleInfoHandle getModuleInfoHandle(@NonNull Object var1) throws IOException;

    static {
        JavaSourceUtilImplAccessor.setInstance(new MyAccessor());
    }

    private static class MyAccessor
    extends JavaSourceUtilImplAccessor {
        private MyAccessor() {
        }

        @Override
        public long createTaggedCompilationController(JavaSourceUtilImpl spi, FileObject fo, int position, long currentTag, Object[] out) throws IOException {
            assert (spi != null);
            return spi.createTaggedCompilationController(fo, currentTag, out);
        }

        @Override
        @NonNull
        public Map<String, byte[]> generate(@NonNull JavaSourceUtilImpl spi, @NonNull FileObject srcRoot, @NonNull FileObject file, @NullAllowed CharSequence content, @NullAllowed DiagnosticListener<? super JavaFileObject> diagnostics) throws IOException {
            assert (spi != null);
            return spi.generate(srcRoot, file, content, diagnostics);
        }

        @Override
        @CheckForNull
        public ModuleInfoHandle getModuleInfoHandle(@NonNull JavaSourceUtilImpl spi, @NonNull Object javaSource) throws IOException {
            assert (spi != null);
            return spi.getModuleInfoHandle(javaSource);
        }
    }

    public static abstract class ModuleInfoHandle {
        @CheckForNull
        public abstract String parseModuleName() throws IOException;

        @CheckForNull
        public abstract ModuleTree parseModule() throws IOException;

        @CheckForNull
        public abstract ModuleElement resolveModule(@NonNull ModuleTree var1) throws IOException;

        @CheckForNull
        public abstract ModuleElement resolveModule(@NonNull String var1) throws IOException;

        @CheckForNull
        public abstract TypeElement readClassFile() throws IOException;
    }
}

