/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jgit.diff.DiffConfig;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.FollowFilter;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.AndRevFilter;
import org.eclipse.jgit.revwalk.filter.AuthorRevFilter;
import org.eclipse.jgit.revwalk.filter.CommitTimeRevFilter;
import org.eclipse.jgit.revwalk.filter.CommitterRevFilter;
import org.eclipse.jgit.revwalk.filter.MaxCountRevFilter;
import org.eclipse.jgit.revwalk.filter.MessageRevFilter;
import org.eclipse.jgit.revwalk.filter.OrRevFilter;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitObjectType;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.SearchCriteria;
import org.netbeans.libs.git.jgit.DelegatingGitProgressMonitor;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.jgit.commands.ListBranchCommand;
import org.netbeans.libs.git.jgit.utils.CancelRevFilter;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.libs.git.progress.RevisionInfoListener;

public class LogCommand
extends GitCommand {
    private final ProgressMonitor monitor;
    private final RevisionInfoListener listener;
    private final List<GitRevisionInfo> revisions;
    private final String revision;
    private final SearchCriteria criteria;
    private final boolean fetchBranchInfo;
    private static final Logger LOG = Logger.getLogger(LogCommand.class.getName());

    public LogCommand(Repository repository, GitClassFactory gitFactory, SearchCriteria criteria, boolean fetchBranchInfo, ProgressMonitor monitor, RevisionInfoListener listener) {
        super(repository, gitFactory, monitor);
        this.monitor = monitor;
        this.listener = listener;
        this.criteria = criteria;
        this.fetchBranchInfo = fetchBranchInfo;
        this.revision = null;
        this.revisions = new LinkedList<GitRevisionInfo>();
    }

    public LogCommand(Repository repository, GitClassFactory gitFactory, String revision, ProgressMonitor monitor, RevisionInfoListener listener) {
        super(repository, gitFactory, monitor);
        this.monitor = monitor;
        this.listener = listener;
        this.criteria = null;
        this.fetchBranchInfo = false;
        this.revision = revision;
        this.revisions = new LinkedList<GitRevisionInfo>();
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        if (this.revision != null) {
            RevCommit commit = Utils.findCommit(repository, this.revision);
            this.addRevision(this.getClassFactory().createRevisionInfo(commit, repository));
        } else {
            Map<RevFlag, List<GitBranch>> branchFlags;
            RevWalk walk = new RevWalk(repository);
            RevWalk fullWalk = new RevWalk(repository);
            DiffConfig diffConfig = (DiffConfig)repository.getConfig().get(DiffConfig.KEY);
            if (this.fetchBranchInfo) {
                Map<String, GitBranch> allBranches = Utils.getAllBranches(repository, this.getClassFactory(), new DelegatingGitProgressMonitor(this.monitor));
                branchFlags = new HashMap(allBranches.size());
                this.markBranchFlags(allBranches, walk, branchFlags);
            } else {
                branchFlags = Collections.emptyMap();
            }
            try {
                RevFlag interestingFlag = walk.newFlag("RESULT_FLAG");
                walk.carry(interestingFlag);
                String revisionFrom = this.criteria.getRevisionFrom();
                String revisionTo = this.criteria.getRevisionTo();
                if (revisionTo != null && revisionFrom != null) {
                    for (RevCommit uninteresting : Utils.findCommit(repository, revisionFrom).getParents()) {
                        walk.markUninteresting(walk.parseCommit((AnyObjectId)uninteresting));
                    }
                    walk.markStart(this.markStartCommit(walk.lookupCommit((AnyObjectId)Utils.findCommit(repository, revisionTo)), interestingFlag));
                } else if (revisionTo != null) {
                    walk.markStart(this.markStartCommit(walk.lookupCommit((AnyObjectId)Utils.findCommit(repository, revisionTo)), interestingFlag));
                } else if (revisionFrom != null) {
                    for (RevCommit uninteresting : Utils.findCommit(repository, revisionFrom).getParents()) {
                        walk.markUninteresting(walk.parseCommit((AnyObjectId)uninteresting));
                    }
                    walk.markStart(this.markStartCommit(walk.lookupCommit((AnyObjectId)Utils.findCommit(repository, "HEAD")), interestingFlag));
                } else {
                    ListBranchCommand branchCommand = new ListBranchCommand(repository, this.getClassFactory(), false, new DelegatingGitProgressMonitor(this.monitor));
                    branchCommand.execute();
                    if (this.monitor.isCanceled()) {
                        return;
                    }
                    for (Map.Entry<String, GitBranch> e : branchCommand.getBranches().entrySet()) {
                        walk.markStart(this.markStartCommit(walk.lookupCommit((AnyObjectId)Utils.findCommit(repository, e.getValue().getId())), interestingFlag));
                    }
                }
                this.applyCriteria(walk, this.criteria, interestingFlag, diffConfig);
                walk.sort(RevSort.TOPO);
                walk.sort(RevSort.COMMIT_TIME_DESC, true);
                Map<String, GitBranch> extraBranches = null;
                for (int remaining = this.criteria.getLimit(); remaining != 0; --remaining) {
                    RevCommit newCommit;
                    Ref replace;
                    if (this.monitor.isCanceled()) {
                        break;
                    }
                    RevCommit commit = walk.next();
                    if (commit == null) {
                        break;
                    }
                    Map<String, GitBranch> branches = this.getAffectedBranches(extraBranches, commit, branchFlags);
                    this.addRevision(this.getClassFactory().createRevisionInfo(fullWalk.parseCommit((AnyObjectId)commit), branches, repository));
                    if (commit.getParentCount() != 0 || (replace = repository.exactRef("refs/replace/" + commit.getId().getName())) == null || (newCommit = Utils.findCommit(repository, replace.getTarget().getName())) == null) continue;
                    if (extraBranches == null) {
                        extraBranches = branches;
                    } else {
                        extraBranches.putAll(branches);
                    }
                    walk.reset();
                    walk.markStart(this.markStartCommit(walk.lookupCommit((AnyObjectId)newCommit), interestingFlag));
                    this.applyCriteria(walk, this.criteria, interestingFlag, diffConfig);
                    walk.sort(RevSort.TOPO);
                    walk.sort(RevSort.COMMIT_TIME_DESC, true);
                }
            }
            catch (MissingObjectException ex) {
                throw new GitException.MissingObjectException(ex.getObjectId().toString(), GitObjectType.COMMIT);
            }
            catch (IOException ex) {
                throw new GitException(ex);
            }
            finally {
                walk.close();
                fullWalk.close();
            }
        }
    }

    private void markBranchFlags(Map<String, GitBranch> allBranches, RevWalk walk, Map<RevFlag, List<GitBranch>> branchFlags) {
        int i = 1;
        HashSet<String> usedFlags = new HashSet<String>();
        Repository repository = this.getRepository();
        for (Map.Entry<String, GitBranch> e : allBranches.entrySet()) {
            if ("(no branch)".equals(e.getKey())) continue;
            String flagId = e.getValue().getId();
            if (usedFlags.contains(flagId)) {
                for (Map.Entry<RevFlag, List<GitBranch>> e2 : branchFlags.entrySet()) {
                    if (!e2.getKey().toString().equals(flagId)) continue;
                    e2.getValue().add(e.getValue());
                }
                continue;
            }
            usedFlags.add(flagId);
            if (i <= 23) {
                ++i;
                RevFlag flag = walk.newFlag(flagId);
                ArrayList<GitBranch> branches = new ArrayList<GitBranch>(allBranches.size());
                branches.add(e.getValue());
                branchFlags.put(flag, branches);
                try {
                    RevCommit branchHeadCommit = walk.parseCommit((AnyObjectId)repository.resolve(e.getValue().getId()));
                    branchHeadCommit.add(flag);
                    branchHeadCommit.carry(flag);
                    walk.markStart(branchHeadCommit);
                }
                catch (IOException ex) {
                    LOG.log(Level.INFO, null, ex);
                }
                continue;
            }
            LOG.log(Level.WARNING, "Out of available flags for branches: {0}", allBranches.size());
            break;
        }
        walk.carry(branchFlags.keySet());
    }

    @Override
    protected String getCommandDescription() {
        StringBuilder sb = new StringBuilder("git log --name-status ");
        if (this.criteria != null && this.criteria.isFollow() && this.criteria.getFiles() != null && this.criteria.getFiles().length == 1) {
            sb.append("--follow ");
        }
        if (this.revision != null) {
            sb.append("--no-walk ").append(this.revision);
        } else if (this.criteria.getRevisionTo() != null && this.criteria.getRevisionFrom() != null) {
            sb.append(this.criteria.getRevisionFrom()).append("..").append(this.criteria.getRevisionTo());
        } else if (this.criteria.getRevisionTo() != null) {
            sb.append(this.criteria.getRevisionTo());
        } else if (this.criteria.getRevisionFrom() != null) {
            sb.append(this.criteria.getRevisionFrom()).append("..");
        }
        return sb.toString();
    }

    public GitRevisionInfo[] getRevisions() {
        return this.revisions.toArray(new GitRevisionInfo[0]);
    }

    private void addRevision(GitRevisionInfo info) {
        this.revisions.add(info);
        this.listener.notifyRevisionInfo(info);
    }

    private void applyCriteria(RevWalk walk, SearchCriteria criteria, final RevFlag partOfResultFlag, DiffConfig diffConfig) {
        String message;
        Collection<PathFilter> pathFilters;
        File[] files = criteria.getFiles();
        if (files.length > 0 && !(pathFilters = Utils.getPathFilters(this.getRepository().getWorkTree(), files)).isEmpty()) {
            if (criteria.isFollow() && pathFilters.size() == 1) {
                walk.setTreeFilter((TreeFilter)FollowFilter.create((String)pathFilters.iterator().next().getPath(), (DiffConfig)diffConfig));
            } else {
                walk.setTreeFilter(AndTreeFilter.create((TreeFilter)TreeFilter.ANY_DIFF, (TreeFilter)PathFilterGroup.create(pathFilters)));
            }
        }
        RevFilter filter = criteria.isIncludeMerges() ? RevFilter.ALL : RevFilter.NO_MERGES;
        filter = AndRevFilter.create((RevFilter)filter, (RevFilter)new CancelRevFilter(this.monitor));
        filter = AndRevFilter.create((RevFilter)filter, (RevFilter)new RevFilter(this){
            final /* synthetic */ LogCommand this$0;
            {
                this.this$0 = this$0;
            }

            public boolean include(RevWalk walker, RevCommit cmit) {
                return cmit.has(partOfResultFlag);
            }

            public RevFilter clone() {
                return this;
            }

            public boolean requiresCommitBody() {
                return false;
            }
        });
        String username = criteria.getUsername();
        if (username != null && !(username = username.trim()).isEmpty()) {
            filter = AndRevFilter.create((RevFilter)filter, (RevFilter)OrRevFilter.create((RevFilter)CommitterRevFilter.create((String)username), (RevFilter)AuthorRevFilter.create((String)username)));
        }
        if ((message = criteria.getMessage()) != null && !(message = message.trim()).isEmpty()) {
            filter = AndRevFilter.create((RevFilter)filter, (RevFilter)MessageRevFilter.create((String)message));
        }
        Date from = criteria.getFrom();
        Date to = criteria.getTo();
        if (from != null && to != null) {
            filter = AndRevFilter.create((RevFilter)filter, (RevFilter)CommitTimeRevFilter.between((Instant)from.toInstant(), (Instant)to.toInstant()));
        } else if (from != null) {
            filter = AndRevFilter.create((RevFilter)filter, (RevFilter)CommitTimeRevFilter.after((Instant)from.toInstant()));
        } else if (to != null) {
            filter = AndRevFilter.create((RevFilter)filter, (RevFilter)CommitTimeRevFilter.before((Instant)to.toInstant()));
        }
        if (criteria.getLimit() != -1) {
            filter = AndRevFilter.create((RevFilter)filter, (RevFilter)MaxCountRevFilter.create((int)criteria.getLimit()));
        }
        walk.setRevFilter(filter);
    }

    private RevCommit markStartCommit(RevCommit commit, RevFlag interestingFlag) {
        commit.add(interestingFlag);
        return commit;
    }

    private Map<String, GitBranch> getAffectedBranches(Map<String, GitBranch> extraBranches, RevCommit commit, Map<RevFlag, List<GitBranch>> flags) {
        LinkedHashMap<String, GitBranch> affected = new LinkedHashMap<String, GitBranch>(extraBranches == null ? Collections.emptyMap() : extraBranches);
        for (Map.Entry<RevFlag, List<GitBranch>> e : flags.entrySet()) {
            if (!commit.has(e.getKey())) continue;
            for (GitBranch b : e.getValue()) {
                affected.put(b.getName(), b);
            }
        }
        return affected;
    }
}

