/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbverification.fixes;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.j2ee.ejbverification.JavaUtils;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class CreateDefaultConstructor
implements Fix {
    private static final Logger LOG = Logger.getLogger(CreateDefaultConstructor.class.getName());
    private FileObject fileObject;
    private ElementHandle<TypeElement> classHandle;

    public CreateDefaultConstructor(FileObject fileObject, ElementHandle<TypeElement> classHandle) {
        this.classHandle = classHandle;
        this.fileObject = fileObject;
    }

    public ChangeInfo implement() {
        CancellableTask<WorkingCopy> task = new CancellableTask<WorkingCopy>(){

            public void cancel() {
            }

            public void run(WorkingCopy workingCopy) throws Exception {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                TypeElement clazz = (TypeElement)CreateDefaultConstructor.this.classHandle.resolve((CompilationInfo)workingCopy);
                if (clazz != null) {
                    ClassTree clazzTree = workingCopy.getTrees().getTree(clazz);
                    TreeMaker make = workingCopy.getTreeMaker();
                    ModifiersTree modifiers = make.Modifiers(Collections.singleton(Modifier.PUBLIC));
                    MethodTree constr = make.Constructor(modifiers, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), "{}");
                    ClassTree newClass = make.insertClassMember(clazzTree, CreateDefaultConstructor.this.getPositionToInsert(clazzTree), (Tree)constr);
                    workingCopy.rewrite((Tree)clazzTree, (Tree)newClass);
                }
            }
        };
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.fileObject);
        try {
            javaSource.runModificationTask((Task)task).commit();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
        return null;
    }

    public String getText() {
        return NbBundle.getMessage(CreateDefaultConstructor.class, (String)"LBL_CreateDefaultConstructor", (Object)JavaUtils.getShortClassName(this.classHandle.getQualifiedName()));
    }

    private int getPositionToInsert(ClassTree classTree) {
        int classMembersCount = classTree.getMembers().size();
        for (int i = 0; i < classMembersCount; ++i) {
            if (classTree.getMembers().get(i).getKind() != Tree.Kind.METHOD) continue;
            return i;
        }
        return classMembersCount;
    }
}

