/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.loaders;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.netbeans.modules.gradle.api.BuildPropertiesSupport;
import org.netbeans.modules.gradle.loaders.BuildPropertiesImplementation;
import org.netbeans.modules.gradle.spi.GradleFiles;
import org.netbeans.modules.gradle.spi.ProjectInfoExtractor;

public class ExtensionPropertiesExtractor
implements ProjectInfoExtractor {
    @Override
    public ProjectInfoExtractor.Result fallback(GradleFiles files) {
        return new ProjectInfoExtractor.Result(){

            @Override
            public Set<?> getExtract() {
                return Set.of();
            }

            @Override
            public Set<String> getProblems() {
                return Collections.emptySet();
            }
        };
    }

    @Override
    public ProjectInfoExtractor.Result extract(final Map<String, Object> props, Map<Class, Object> otherInfo) {
        return new ProjectInfoExtractor.Result(){
            final /* synthetic */ ExtensionPropertiesExtractor this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Set<?> getExtract() {
                Map<String, String> values = props.getOrDefault("extensions.propertyValues", Collections.emptyMap());
                Map<String, String> types = props.getOrDefault("extensions.propertyTypes", Collections.emptyMap());
                Map<String, String> taskValues = props.getOrDefault("tasks.propertyValues", Collections.emptyMap());
                Map<String, String> taskTypes = props.getOrDefault("tasks.propertyTypes", Collections.emptyMap());
                PropertyEvaluator a = new PropertyEvaluator(values, types, taskValues, taskTypes);
                return Set.of(a);
            }

            @Override
            public Set<String> getProblems() {
                return Set.of();
            }
        };
    }

    private static class PropertyEvaluator
    implements BuildPropertiesImplementation {
        private final Map<String, String> propertyMap;
        private final Map<String, String> propertyTypes;
        private final Map<String, String> taskPropertyMap;
        private final Map<String, String> taskPropertyTypes;

        public PropertyEvaluator(Map<String, String> propertyMap, Map<String, String> propertyTypes, Map<String, String> taskPropertyMap, Map<String, String> taskPropertyTypes) {
            this.propertyMap = propertyMap;
            this.propertyTypes = propertyTypes;
            this.taskPropertyMap = taskPropertyMap;
            this.taskPropertyTypes = taskPropertyTypes;
        }

        @Override
        public BuildPropertiesSupport.Property findProperty(BuildPropertiesSupport.Property base, String propertyPath) {
            String path;
            Object suffix;
            Map<String, String> types;
            Map<String, String> values;
            switch (base.getScope()) {
                case "extension": {
                    values = this.propertyMap;
                    types = this.propertyTypes;
                    break;
                }
                case "task": {
                    values = this.taskPropertyMap;
                    types = this.taskPropertyTypes;
                    break;
                }
                default: {
                    return null;
                }
            }
            if (base.getName() == null) {
                return null;
            }
            Object id = base.getId();
            Object object = suffix = propertyPath == null ? "" : "." + propertyPath;
            if (id == null) {
                path = base.getName() + (String)suffix;
            } else if (id instanceof String) {
                path = id.toString() + (String)suffix;
            } else {
                return null;
            }
            return this.find(base.getScope(), path, values, types, "");
        }

        private Map<String, String> types(BuildPropertiesSupport.Property p) {
            switch (p.getScope()) {
                case "extension": {
                    return this.propertyTypes;
                }
                case "task": {
                    return this.taskPropertyTypes;
                }
            }
            return Collections.emptyMap();
        }

        private Map<String, String> values(BuildPropertiesSupport.Property p) {
            switch (p.getScope()) {
                case "extension": {
                    return this.propertyMap;
                }
                case "task": {
                    return this.taskPropertyMap;
                }
            }
            return Collections.emptyMap();
        }

        @Override
        public Collection<String> keys(BuildPropertiesSupport.Property container) {
            if (container.getId() == null) {
                return null;
            }
            String path = container.getId().toString();
            Map<String, String> types = this.types(container);
            String c = types.get(path + "#keys");
            if (c == null) {
                return null;
            }
            return Stream.of(c.split(";;")).map(s -> s.replace("\\;", ";")).collect(Collectors.toList());
        }

        @Override
        public BuildPropertiesSupport.Property get(BuildPropertiesSupport.Property container, String key, String propertyPath) {
            if (container.getId() == null) {
                return null;
            }
            Map<String, String> types = this.types(container);
            String coltype = types.get(container.getId().toString() + "#col");
            if (!"named".equals(coltype) && !"map".equals(coltype)) {
                return null;
            }
            String path = container.getId().toString();
            Map<String, String> values = this.values(container);
            String itemType = types.getOrDefault(container.getId().toString() + "#itemType", "");
            String escaped = key.replace(";", "\\;");
            String k = path + "." + escaped;
            String v = values.get(k);
            if (v == null) {
                k = path + "[" + key + "]";
                v = values.get(k);
            }
            if (v == null) {
                return null;
            }
            return this.find(container.getScope(), k, values, types, itemType);
        }

        @Override
        public Iterator<BuildPropertiesSupport.Property> items(final BuildPropertiesSupport.Property container, final String property) {
            if (container.getId() == null) {
                return null;
            }
            final Map<String, String> types = this.types(container);
            if (!"list".equals(types.get(container.getId().toString() + "#col"))) {
                return null;
            }
            final Map<String, String> values = this.values(container);
            final String path = container.getId().toString() + "[";
            final String itemType = types.getOrDefault(container.getId().toString() + "#itemType", "");
            return new Iterator<BuildPropertiesSupport.Property>(){
                int index = 0;
                String obj;
                final /* synthetic */ PropertyEvaluator this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public boolean hasNext() {
                    if (this.obj != null) {
                        return true;
                    }
                    String k = path + this.index + "]";
                    this.obj = (String)values.get(k);
                    return this.obj != null;
                }

                @Override
                public BuildPropertiesSupport.Property next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    String k = path + this.index + "]";
                    this.obj = null;
                    ++this.index;
                    if (property != null) {
                        k = k + property;
                    }
                    return this.this$0.find(container.getScope(), k, values, types, itemType);
                }
            };
        }

        private BuildPropertiesSupport.Property find(String src, String propertyPath, Map<String, String> values, Map<String, String> types, String defType) {
            String t = types.get(propertyPath);
            String c = types.get(propertyPath + "#col");
            String v = values.get(propertyPath);
            if (t == null && v == null && c == null) {
                return null;
            }
            int lastDot = propertyPath.lastIndexOf(46);
            String n = propertyPath.substring(lastDot + 1);
            if (c != null) {
                return new BuildPropertiesSupport.Property(propertyPath, src, n, "named".equals(c) || "map".equals(c) ? BuildPropertiesSupport.PropertyKind.MAP : BuildPropertiesSupport.PropertyKind.LIST, t, Objects.toString(v, null));
            }
            if (t == null) {
                String string = t = defType == null ? "" : defType;
            }
            if ("".equals(t)) {
                return new BuildPropertiesSupport.Property(propertyPath, src, n, BuildPropertiesSupport.PropertyKind.EXISTS, t, null);
            }
            int dot = t.indexOf(46);
            BuildPropertiesSupport.PropertyKind kind = dot == -1 || t.startsWith("java.lang") && !"java.lang.Object".equals(t) ? BuildPropertiesSupport.PropertyKind.PRIMITIVE : BuildPropertiesSupport.PropertyKind.STRUCTURE;
            return new BuildPropertiesSupport.Property(propertyPath, src, n, kind, t, Objects.toString(v, null));
        }
    }
}

