/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.syntax.dom;

import java.util.ArrayList;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.modules.xml.spi.dom.AbstractNode;
import org.netbeans.modules.xml.spi.dom.NodeListImpl;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.syntax.XMLTokenIDs;
import org.netbeans.modules.xml.text.syntax.dom.EntityReferenceImpl;
import org.netbeans.modules.xml.text.syntax.dom.TextImpl;
import org.netbeans.modules.xml.text.syntax.dom.Util;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AttrImpl
extends AbstractNode
implements Attr,
XMLTokenIDs {
    private TokenItem first;
    private Element parent;
    private XMLSyntaxSupport syntax;

    AttrImpl(XMLSyntaxSupport syntax, TokenItem first, Element parent) {
        this.parent = parent;
        this.first = first;
        this.syntax = syntax;
    }

    public TokenItem getFirstToken() {
        return this.first;
    }

    @Override
    public NodeList getChildNodes() {
        ArrayList<Node> list = new ArrayList<Node>(3);
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            list.add(node);
        }
        return new NodeListImpl(list);
    }

    Node getPreviousSibling(Text text) {
        return null;
    }

    Node getPreviousSibling(EntityReferenceImpl ref) {
        return null;
    }

    Node getNextSibling(Text text) {
        return null;
    }

    Node getNextSibling(EntityReferenceImpl ref) {
        return null;
    }

    @Override
    public Node getNextSibling() {
        return null;
    }

    @Override
    public Node getPreviousSibling() {
        return null;
    }

    @Override
    public Node getFirstChild() {
        TokenItem next;
        for (next = this.first; next != null; next = next.getNext()) {
            char test;
            if (next.getTokenID() != VALUE) continue;
            String image = next.getImage();
            if (image.length() != 1 || (test = image.charAt(0)) != '\"' && test != '\'') break;
            next = next.getNext();
            break;
        }
        if (next == null) {
            return null;
        }
        if (next.getTokenID() == VALUE) {
            return new TextImpl(this.syntax, next, this);
        }
        throw new RuntimeException("Not recognized yet: " + next.getTokenID());
    }

    @Override
    public Node getLastChild() {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public String getNodeName() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.first.getImage();
    }

    @Override
    public boolean getSpecified() {
        return true;
    }

    @Override
    public void setValue(String value) {
        int oldValueStartPos = -1;
        int oldValueLength = 0;
        boolean notClosed = false;
        char firstChar = '\"';
        char lastChar = '\u0000';
        for (TokenItem next = this.first; next != null; next = next.getNext()) {
            String actualImage;
            TokenID nextId = next.getTokenID();
            if (oldValueStartPos != -1 && nextId != VALUE && nextId != CHARACTER) break;
            String nextImage = next.getImage();
            if (!nextImage.equals(actualImage = Util.actualAttributeValue(nextImage))) {
                notClosed = true;
                nextImage = actualImage;
            }
            if (nextId == VALUE && oldValueStartPos == -1 && nextImage.length() > 0) {
                oldValueStartPos = next.getOffset();
                if (nextImage.charAt(0) == '\"' || nextImage.charAt(0) == '\'') {
                    firstChar = nextImage.charAt(0);
                    ++oldValueStartPos;
                    --oldValueLength;
                }
            }
            if (oldValueStartPos != -1 && nextImage.length() > 0) {
                oldValueLength += nextImage.length();
                lastChar = nextImage.charAt(nextImage.length() - 1);
            }
            if (notClosed) break;
        }
        if (lastChar == firstChar) {
            --oldValueLength;
        }
        value = Util.replaceCharsWithEntityStrings(value);
        if (notClosed) {
            value = value + firstChar;
        }
        BaseDocument doc = this.syntax.getDocument();
        doc.atomicLock();
        try {
            doc.remove(oldValueStartPos, oldValueLength);
            doc.insertString(oldValueStartPos, value, null);
            doc.invalidateSyntaxMarks();
        }
        catch (BadLocationException e) {
            throw new DOMException(11, e.getMessage());
        }
        finally {
            doc.atomicUnlock();
        }
        try {
            int endOffset = oldValueStartPos + oldValueLength;
            if (endOffset > doc.getLength()) {
                endOffset = doc.getLength();
            }
            this.first = this.syntax.getTokenChain(this.first.getOffset(), endOffset);
        }
        catch (BadLocationException e) {
            throw new DOMException(11, e.getMessage());
        }
    }

    @Override
    public void setNodeValue(String value) {
        this.setValue(value);
    }

    @Override
    public String getNodeValue() {
        return this.getValue();
    }

    @Override
    public String getValue() {
        char firstChar;
        TokenItem next;
        for (next = this.first; next != null && next.getTokenID() != VALUE; next = next.getNext()) {
        }
        StringBuffer buf = new StringBuffer();
        while (next != null && (next.getTokenID() == VALUE || next.getTokenID() == CHARACTER)) {
            String actual;
            String image = next.getImage();
            if (!image.equals(actual = Util.actualAttributeValue(image))) {
                buf.append(actual);
                break;
            }
            buf.append(image);
            next = next.getNext();
        }
        if (buf.length() > 0 && ((firstChar = buf.charAt(0)) == '\"' || firstChar == '\'')) {
            buf.deleteCharAt(0);
            if (buf.length() > 0 && buf.charAt(buf.length() - 1) == firstChar) {
                buf.deleteCharAt(buf.length() - 1);
            }
        }
        return Util.replaceEntityStringsWithChars(buf.toString());
    }

    @Override
    public short getNodeType() {
        return 2;
    }

    @Override
    public Node getParentNode() {
        return null;
    }

    @Override
    public Element getOwnerElement() {
        return this.parent;
    }

    @Override
    public Document getOwnerDocument() {
        Element parent = this.getOwnerElement();
        if (parent == null) {
            return null;
        }
        return parent.getOwnerDocument();
    }

    public String toString() {
        return "Attr(" + this.getName() + "='" + this.getValue() + "')";
    }
}

