/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.model.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Locale;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.ParameterUsage;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.jdbc.mutation.internal.MutationQueryOptions;
import org.hibernate.engine.jdbc.mutation.internal.PreparedStatementGroupSingleTable;
import org.hibernate.engine.jdbc.mutation.spi.Binding;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.jdbc.Expectation;
import org.hibernate.persister.entity.mutation.EntityMutationTarget;
import org.hibernate.persister.entity.mutation.EntityTableMapping;
import org.hibernate.persister.entity.mutation.UpdateValuesAnalysis;
import org.hibernate.sql.model.ModelMutationLogging;
import org.hibernate.sql.model.MutationTarget;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.SelfExecutingUpdateOperation;
import org.hibernate.sql.model.TableMapping;
import org.hibernate.sql.model.ValuesAnalysis;
import org.hibernate.sql.model.internal.OptionalTableUpdate;
import org.hibernate.sql.model.internal.TableDeleteStandard;
import org.hibernate.sql.model.jdbc.JdbcDeleteMutation;
import org.hibernate.sql.model.jdbc.JdbcValueDescriptor;
import org.hibernate.sql.model.jdbc.UpsertOperation;
import org.hibernate.type.descriptor.WrapperOptions;

public class DeleteOrUpsertOperation
implements SelfExecutingUpdateOperation {
    private final EntityMutationTarget mutationTarget;
    private final EntityTableMapping tableMapping;
    private final UpsertOperation upsertOperation;
    private final OptionalTableUpdate optionalTableUpdate;

    public DeleteOrUpsertOperation(EntityMutationTarget mutationTarget, EntityTableMapping tableMapping, UpsertOperation upsertOperation, OptionalTableUpdate optionalTableUpdate) {
        this.mutationTarget = mutationTarget;
        this.tableMapping = tableMapping;
        this.upsertOperation = upsertOperation;
        this.optionalTableUpdate = optionalTableUpdate;
    }

    protected DeleteOrUpsertOperation(DeleteOrUpsertOperation original) {
        this.mutationTarget = original.mutationTarget;
        this.tableMapping = original.tableMapping;
        this.upsertOperation = original.upsertOperation;
        this.optionalTableUpdate = original.optionalTableUpdate;
    }

    @Override
    public MutationType getMutationType() {
        return MutationType.UPDATE;
    }

    @Override
    public MutationTarget<?> getMutationTarget() {
        return this.mutationTarget;
    }

    @Override
    public TableMapping getTableDetails() {
        return this.tableMapping;
    }

    @Override
    public JdbcValueDescriptor findValueDescriptor(String columnName, ParameterUsage usage) {
        return this.upsertOperation.findValueDescriptor(columnName, usage);
    }

    @Override
    public void performMutation(JdbcValueBindings jdbcValueBindings, ValuesAnalysis valuesAnalysis, SharedSessionContractImplementor session) {
        UpdateValuesAnalysis analysis = (UpdateValuesAnalysis)valuesAnalysis;
        if (analysis.getTablesWithNonNullValues().contains(this.tableMapping)) {
            this.performUpsert(jdbcValueBindings, session);
        } else {
            this.performDelete(jdbcValueBindings, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performDelete(JdbcValueBindings jdbcValueBindings, SharedSessionContractImplementor session) {
        ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef("Performing delete (%s)", (Object)this.tableMapping.getTableName());
        TableDeleteStandard upsertDeleteAst = new TableDeleteStandard(this.optionalTableUpdate.getMutatingTable(), this.mutationTarget, "upsert delete", this.optionalTableUpdate.getKeyBindings(), Collections.emptyList(), Collections.emptyList());
        JdbcServices jdbcServices = session.getJdbcServices();
        JdbcDeleteMutation upsertDelete = jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildModelMutationTranslator(upsertDeleteAst, session.getFactory()).translate(null, MutationQueryOptions.INSTANCE);
        PreparedStatementGroupSingleTable statementGroup = new PreparedStatementGroupSingleTable(upsertDelete, session);
        PreparedStatementDetails statementDetails = statementGroup.resolvePreparedStatementDetails(this.tableMapping.getTableName());
        try {
            PreparedStatement upsertDeleteStatement = statementDetails.resolveStatement();
            jdbcServices.getSqlStatementLogger().logStatement(statementDetails.getSqlString());
            this.bindDeleteKeyValues(jdbcValueBindings, statementDetails, session);
            int rowCount = session.getJdbcCoordinator().getResultSetReturn().executeUpdate(upsertDeleteStatement, statementDetails.getSqlString());
            ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef("%s rows upsert-deleted from '%s'", rowCount, (Object)this.tableMapping.getTableName());
            try {
                this.getExpectation().verifyOutcome(rowCount, upsertDeleteStatement, -1, statementDetails.getSqlString());
            }
            catch (SQLException e) {
                throw jdbcServices.getSqlExceptionHelper().convert(e, "Unable to verify outcome for upsert delete", statementDetails.getSqlString());
            }
        }
        finally {
            statementDetails.releaseStatement(session);
        }
    }

    private void bindDeleteKeyValues(JdbcValueBindings jdbcValueBindings, PreparedStatementDetails statementDetails, SharedSessionContractImplementor session) {
        PreparedStatement statement = statementDetails.resolveStatement();
        int jdbcBindingPosition = 1;
        for (Binding binding : jdbcValueBindings.getBindingGroup(this.tableMapping.getTableName()).getBindings()) {
            if (binding.getValueDescriptor().getUsage() != ParameterUsage.RESTRICT) continue;
            DeleteOrUpsertOperation.bindKeyValue(jdbcBindingPosition++, binding, binding.getValueDescriptor(), statement, statementDetails.getSqlString(), this.tableMapping, session);
        }
    }

    private static void bindKeyValue(int jdbcPosition, Binding binding, JdbcValueDescriptor valueDescriptor, PreparedStatement statement, String sql, EntityTableMapping tableMapping, SharedSessionContractImplementor session) {
        try {
            binding.getValueBinder().bind(statement, binding.getValue(), jdbcPosition, (WrapperOptions)session);
        }
        catch (SQLException e) {
            throw session.getJdbcServices().getSqlExceptionHelper().convert(e, String.format(Locale.ROOT, "Unable to bind parameter for upsert insert : %s.%s", tableMapping.getTableName(), valueDescriptor.getColumnName()), sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performUpsert(JdbcValueBindings jdbcValueBindings, SharedSessionContractImplementor session) {
        ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef("Performing upsert (%s)", (Object)this.tableMapping.getTableName());
        PreparedStatementGroupSingleTable statementGroup = new PreparedStatementGroupSingleTable(this.upsertOperation, session);
        PreparedStatementDetails statementDetails = statementGroup.resolvePreparedStatementDetails(this.tableMapping.getTableName());
        try {
            PreparedStatement updateStatement = statementDetails.resolveStatement();
            JdbcServices jdbcServices = session.getJdbcServices();
            jdbcServices.getSqlStatementLogger().logStatement(statementDetails.getSqlString());
            jdbcValueBindings.beforeStatement(statementDetails);
            int rowCount = session.getJdbcCoordinator().getResultSetReturn().executeUpdate(updateStatement, statementDetails.getSqlString());
            ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef("%s rows upserted in '%s'", rowCount, (Object)this.tableMapping.getTableName());
            try {
                this.getExpectation().verifyOutcome(rowCount, updateStatement, -1, statementDetails.getSqlString());
            }
            catch (SQLException e) {
                throw jdbcServices.getSqlExceptionHelper().convert(e, "Unable to verify outcome for upsert", statementDetails.getSqlString());
            }
        }
        finally {
            statementDetails.releaseStatement(session);
        }
    }

    public UpsertOperation getUpsertOperation() {
        return this.upsertOperation;
    }

    public OptionalTableUpdate getOptionalTableUpdate() {
        return this.optionalTableUpdate;
    }

    protected Expectation getExpectation() {
        return this.upsertOperation.getExpectation();
    }
}

