/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.attribute;

import io.quarkus.vertx.http.runtime.attribute.ExchangeAttribute;
import io.quarkus.vertx.http.runtime.attribute.ExchangeAttributeBuilder;
import io.quarkus.vertx.http.runtime.attribute.ReadOnlyAttributeException;
import io.quarkus.vertx.http.runtime.filters.OriginalRequestContext;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayDeque;
import java.util.List;

public class QueryParameterAttribute
implements ExchangeAttribute {
    private final String parameter;
    private final boolean useOriginalRequest;

    public QueryParameterAttribute(String parameter, boolean useOriginalRequest) {
        this.parameter = parameter;
        this.useOriginalRequest = useOriginalRequest;
    }

    @Override
    public String readAttribute(RoutingContext exchange) {
        List res;
        List list = res = this.useOriginalRequest ? OriginalRequestContext.getAllQueryParams(exchange, this.parameter) : exchange.queryParams().getAll(this.parameter);
        if (res == null) {
            return null;
        }
        if (res.isEmpty()) {
            return "";
        }
        if (res.size() == 1) {
            return (String)res.get(0);
        }
        StringBuilder sb = new StringBuilder("[");
        int i = 0;
        for (String s : res) {
            sb.append(s);
            if (++i == res.size()) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void writeAttribute(RoutingContext exchange, String newValue) throws ReadOnlyAttributeException {
        ArrayDeque<String> value = new ArrayDeque<String>();
        value.add(newValue);
        exchange.queryParams().set(this.parameter, value);
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Query Parameter";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.startsWith("%{q,") && token.endsWith("}")) {
                String qp = token.substring(4, token.length() - 1);
                return new QueryParameterAttribute(qp, false);
            }
            if (token.startsWith("%{<q,") && token.endsWith("}")) {
                String qp = token.substring(5, token.length() - 1);
                return new QueryParameterAttribute(qp, true);
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

