/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Deformably register two images using level set motion.


LevelSetMotionFilter implements a deformable registration algorithm
that aligns a fixed and a moving image under level set motion. The
equations of motion are similar to those of the DemonsRegistrationFilter . The main differences are: (1) Gradients of the moving image are
calculated on a smoothed image while intensity difference are measured
on the original images (2) Magnitude of the motion vector is a
function of the differences in intensity between the fixed and moving
pixel. An adaptive timestep is calculated based on the maximum motion
vector over the entire field to ensure stability. The timestep also
implicitly converts the motion vector measured in units of intensity
to a vector measured in physical units. Demons, on the other hand,
defines its motion vectors as function of both the intensity
differences and gradient magnitude at each respective pixel. Consider
two separate pixels with the same intensity differences between the
corresponding fixed and moving pixel pairs. In demons, the motion
vector of the pixel over a low gradient region will be larger than the
motion vector of the pixel over a large gradient region. This leads to
an unstable vector field. In the levelset approach, the motion vectors
will be proportional to the gradients, scaled by the maximum gradient
over the entire field. The pixel with at the lower gradient position
will more less than the pixel at the higher gradient position. (3)
Gradients are calculated using minmod finite difference instead of
using central differences.

A deformation field is represented as a image whose pixel type is some
vector type with at least N elements, where N is the dimension of the
fixed image. The vector type must support element access via operator
[]. It is assumed that the vector elements behave like floating point
scalars.

This class is templated over the fixed image type, moving image type
and the deformation field type.

The input fixed and moving images are set via methods SetFixedImage
and SetMovingImage respectively. An initial deformation field maybe
set via SetInitialDisplacementField or SetInput. If no initial field
is set, a zero field is used as the initial condition.

The algorithm has one parameters: the number of iteration to be
performed.

The output deformation field can be obtained via methods GetOutput or
GetDisplacementField.

This class make use of the finite difference solver hierarchy. Update
for each iteration is computed in LevelSetMotionFunction.


WARNING:
This filter assumes that the fixed image type, moving image type and
deformation field type all have the same number of dimensions.
 Ref: B.C. Vemuri, J. Ye, Y. Chen, C.M. Leonard. " Image registration via level-set motion: applications to atlas-based
segmentation". Medical Image Analysis. Vol. 7. pp. 1-20. 2003.


See:
 LevelSetMotionRegistrationFunction

 DemonsRegistrationFilter

 itk::LevelSetMotionRegistrationFilter for the Doxygen on the original ITK class.


C++ includes: sitkLevelSetMotionRegistrationFilter.h
*/
public class LevelSetMotionRegistrationFilter extends ImageFilter {
  private transient long swigCPtr;

  protected LevelSetMotionRegistrationFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.LevelSetMotionRegistrationFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(LevelSetMotionRegistrationFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(LevelSetMotionRegistrationFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::LevelSetMotionRegistrationFilter::~LevelSetMotionRegistrationFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_LevelSetMotionRegistrationFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::LevelSetMotionRegistrationFilter::LevelSetMotionRegistrationFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  LevelSetMotionRegistrationFilter() {
    this(SimpleITKJNI.new_LevelSetMotionRegistrationFilter(), true);
  }

  /**
Self&amp; itk::simple::LevelSetMotionRegistrationFilter::SetGradientSmoothingStandardDeviations(double GradientSmoothingStandardDeviations)

Set/Get the standard deviation used for smoothing the moving image
prior to calculating gradients. The standard deviation is measured in
physical units (for instance mm). Note that this smoothing value is
not to be confused with the PDEDeformableRegistrationFilter::SetStandardDeviations() method. The method in PDEDeformableRegistrationFilter is for setting the smoothing parameters for regularizing the
deformation field between iterations. Those smoothing parameters are
set in pixel units not physical units. Deformation field smoothing is
not done by default in LevelSetMotionRegistration. This smoothing
parameter is to condition the gradient calculation and parameter is
specified in physical units.

*/
public  void setGradientSmoothingStandardDeviations(double GradientSmoothingStandardDeviations) {
    SimpleITKJNI.LevelSetMotionRegistrationFilter_setGradientSmoothingStandardDeviations(swigCPtr, this, GradientSmoothingStandardDeviations);
  }

  /**
double itk::simple::LevelSetMotionRegistrationFilter::GetGradientSmoothingStandardDeviations() const
*/
public  double getGradientSmoothingStandardDeviations() {
    return SimpleITKJNI.LevelSetMotionRegistrationFilter_getGradientSmoothingStandardDeviations(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LevelSetMotionRegistrationFilter::SetNumberOfIterations(uint32_t NumberOfIterations)
*/
public  void setNumberOfIterations(long NumberOfIterations) {
    SimpleITKJNI.LevelSetMotionRegistrationFilter_setNumberOfIterations(swigCPtr, this, NumberOfIterations);
  }

  /**
uint32_t itk::simple::LevelSetMotionRegistrationFilter::GetNumberOfIterations() const
*/
public  long getNumberOfIterations() {
    return SimpleITKJNI.LevelSetMotionRegistrationFilter_getNumberOfIterations(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LevelSetMotionRegistrationFilter::SetMaximumRMSError(double MaximumRMSError)
*/
public  void setMaximumRMSError(double MaximumRMSError) {
    SimpleITKJNI.LevelSetMotionRegistrationFilter_setMaximumRMSError(swigCPtr, this, MaximumRMSError);
  }

  /**
double itk::simple::LevelSetMotionRegistrationFilter::GetMaximumRMSError() const
*/
public  double getMaximumRMSError() {
    return SimpleITKJNI.LevelSetMotionRegistrationFilter_getMaximumRMSError(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LevelSetMotionRegistrationFilter::SetStandardDeviations(std::vector&lt; double &gt; StandardDeviations)

Set/Get the Gaussian smoothing standard deviations for the
displacement field. The values are set with respect to pixel
coordinates.

*/
public  void setStandardDeviations(VectorDouble StandardDeviations) {
    SimpleITKJNI.LevelSetMotionRegistrationFilter_setStandardDeviations__SWIG_0(swigCPtr, this, VectorDouble.getCPtr(StandardDeviations), StandardDeviations);
  }

  /**
Self&amp; itk::simple::LevelSetMotionRegistrationFilter::SetStandardDeviations(std::vector&lt; double &gt; StandardDeviations)

Set/Get the Gaussian smoothing standard deviations for the
displacement field. The values are set with respect to pixel
coordinates.

*/
public  void setStandardDeviations(double value) {
    SimpleITKJNI.LevelSetMotionRegistrationFilter_setStandardDeviations__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;double&gt; itk::simple::LevelSetMotionRegistrationFilter::GetStandardDeviations() const

Set/Get the Gaussian smoothing standard deviations for the
displacement field. The values are set with respect to pixel
coordinates.

*/
public  VectorDouble getStandardDeviations() {
    return new VectorDouble(SimpleITKJNI.LevelSetMotionRegistrationFilter_getStandardDeviations(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::LevelSetMotionRegistrationFilter::SetSmoothDisplacementField(bool SmoothDisplacementField)

Set/Get whether the displacement field is smoothed (regularized).
Smoothing the displacement yields a solution elastic in nature. If
SmoothDisplacementField is on, then the displacement field is smoothed
with a Gaussian whose standard deviations are specified with SetStandardDeviations()

*/
public  void setSmoothDisplacementField(boolean SmoothDisplacementField) {
    SimpleITKJNI.LevelSetMotionRegistrationFilter_setSmoothDisplacementField(swigCPtr, this, SmoothDisplacementField);
  }

  /**
Self&amp; itk::simple::LevelSetMotionRegistrationFilter::SmoothDisplacementFieldOn()

Set the value of SmoothDisplacementField to true or false
respectfully.

*/
public  void smoothDisplacementFieldOn() {
    SimpleITKJNI.LevelSetMotionRegistrationFilter_smoothDisplacementFieldOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LevelSetMotionRegistrationFilter::SmoothDisplacementFieldOff()
*/
public  void smoothDisplacementFieldOff() {
    SimpleITKJNI.LevelSetMotionRegistrationFilter_smoothDisplacementFieldOff(swigCPtr, this);
  }

  /**
bool itk::simple::LevelSetMotionRegistrationFilter::GetSmoothDisplacementField() const

Set/Get whether the displacement field is smoothed (regularized).
Smoothing the displacement yields a solution elastic in nature. If
SmoothDisplacementField is on, then the displacement field is smoothed
with a Gaussian whose standard deviations are specified with SetStandardDeviations()

*/
public  boolean getSmoothDisplacementField() {
    return SimpleITKJNI.LevelSetMotionRegistrationFilter_getSmoothDisplacementField(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LevelSetMotionRegistrationFilter::SetUpdateFieldStandardDeviations(std::vector&lt; double &gt; UpdateFieldStandardDeviations)

Set the Gaussian smoothing standard deviations for the update field.
The values are set with respect to pixel coordinates.

*/
public  void setUpdateFieldStandardDeviations(VectorDouble UpdateFieldStandardDeviations) {
    SimpleITKJNI.LevelSetMotionRegistrationFilter_setUpdateFieldStandardDeviations__SWIG_0(swigCPtr, this, VectorDouble.getCPtr(UpdateFieldStandardDeviations), UpdateFieldStandardDeviations);
  }

  /**
Self&amp; itk::simple::LevelSetMotionRegistrationFilter::SetUpdateFieldStandardDeviations(std::vector&lt; double &gt; UpdateFieldStandardDeviations)

Set the Gaussian smoothing standard deviations for the update field.
The values are set with respect to pixel coordinates.

*/
public  void setUpdateFieldStandardDeviations(double value) {
    SimpleITKJNI.LevelSetMotionRegistrationFilter_setUpdateFieldStandardDeviations__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;double&gt; itk::simple::LevelSetMotionRegistrationFilter::GetUpdateFieldStandardDeviations() const

Set the Gaussian smoothing standard deviations for the update field.
The values are set with respect to pixel coordinates.

*/
public  VectorDouble getUpdateFieldStandardDeviations() {
    return new VectorDouble(SimpleITKJNI.LevelSetMotionRegistrationFilter_getUpdateFieldStandardDeviations(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::LevelSetMotionRegistrationFilter::SetSmoothUpdateField(bool SmoothUpdateField)

Set/Get whether the update field is smoothed (regularized). Smoothing
the update field yields a solution viscous in nature. If
SmoothUpdateField is on, then the update field is smoothed with a
Gaussian whose standard deviations are specified with SetUpdateFieldStandardDeviations()

*/
public  void setSmoothUpdateField(boolean SmoothUpdateField) {
    SimpleITKJNI.LevelSetMotionRegistrationFilter_setSmoothUpdateField(swigCPtr, this, SmoothUpdateField);
  }

  /**
Self&amp; itk::simple::LevelSetMotionRegistrationFilter::SmoothUpdateFieldOn()

Set the value of SmoothUpdateField to true or false respectfully.

*/
public  void smoothUpdateFieldOn() {
    SimpleITKJNI.LevelSetMotionRegistrationFilter_smoothUpdateFieldOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LevelSetMotionRegistrationFilter::SmoothUpdateFieldOff()
*/
public  void smoothUpdateFieldOff() {
    SimpleITKJNI.LevelSetMotionRegistrationFilter_smoothUpdateFieldOff(swigCPtr, this);
  }

  /**
bool itk::simple::LevelSetMotionRegistrationFilter::GetSmoothUpdateField() const

Set/Get whether the update field is smoothed (regularized). Smoothing
the update field yields a solution viscous in nature. If
SmoothUpdateField is on, then the update field is smoothed with a
Gaussian whose standard deviations are specified with SetUpdateFieldStandardDeviations()

*/
public  boolean getSmoothUpdateField() {
    return SimpleITKJNI.LevelSetMotionRegistrationFilter_getSmoothUpdateField(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LevelSetMotionRegistrationFilter::SetMaximumKernelWidth(unsigned int MaximumKernelWidth)

Set/Get the desired limits of the Gaussian kernel width.

*/
public  void setMaximumKernelWidth(long MaximumKernelWidth) {
    SimpleITKJNI.LevelSetMotionRegistrationFilter_setMaximumKernelWidth(swigCPtr, this, MaximumKernelWidth);
  }

  /**
unsigned int itk::simple::LevelSetMotionRegistrationFilter::GetMaximumKernelWidth() const

Set/Get the desired limits of the Gaussian kernel width.

*/
public  long getMaximumKernelWidth() {
    return SimpleITKJNI.LevelSetMotionRegistrationFilter_getMaximumKernelWidth(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LevelSetMotionRegistrationFilter::SetMaximumError(double MaximumError)

Set/Get the desired maximum error of the Guassian kernel approximate.

*/
public  void setMaximumError(double MaximumError) {
    SimpleITKJNI.LevelSetMotionRegistrationFilter_setMaximumError(swigCPtr, this, MaximumError);
  }

  /**
double itk::simple::LevelSetMotionRegistrationFilter::GetMaximumError() const

Set/Get the desired maximum error of the Guassian kernel approximate.

*/
public  double getMaximumError() {
    return SimpleITKJNI.LevelSetMotionRegistrationFilter_getMaximumError(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LevelSetMotionRegistrationFilter::SetAlpha(double Alpha)

Set/Get the parameter alpha. Alpha is added to the calculated gradient
magnitude prior to normalizing the gradient to protect against
numerical instability as the gradient magnitude approaches zero. This
should be set as a small fraction of the intensity dynamic range, for
instance 0.04%. Default is the absolute (not percentage) value of 0.1.

*/
public  void setAlpha(double Alpha) {
    SimpleITKJNI.LevelSetMotionRegistrationFilter_setAlpha(swigCPtr, this, Alpha);
  }

  /**
double itk::simple::LevelSetMotionRegistrationFilter::GetAlpha() const
*/
public  double getAlpha() {
    return SimpleITKJNI.LevelSetMotionRegistrationFilter_getAlpha(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LevelSetMotionRegistrationFilter::SetIntensityDifferenceThreshold(double IntensityDifferenceThreshold)

Set/Get the threshold below which the absolute difference of intensity
yields a match. When the intensities match between a moving and fixed
image pixel, the update vector (for that iteration) will be the zero
vector. Default is 0.001.

*/
public  void setIntensityDifferenceThreshold(double IntensityDifferenceThreshold) {
    SimpleITKJNI.LevelSetMotionRegistrationFilter_setIntensityDifferenceThreshold(swigCPtr, this, IntensityDifferenceThreshold);
  }

  /**
double itk::simple::LevelSetMotionRegistrationFilter::GetIntensityDifferenceThreshold() const
*/
public  double getIntensityDifferenceThreshold() {
    return SimpleITKJNI.LevelSetMotionRegistrationFilter_getIntensityDifferenceThreshold(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LevelSetMotionRegistrationFilter::SetGradientMagnitudeThreshold(double GradientMagnitudeThreshold)

Set/Get the threshold below which the gradient magnitude is considered
the zero vector. Default is 1e-9.

*/
public  void setGradientMagnitudeThreshold(double GradientMagnitudeThreshold) {
    SimpleITKJNI.LevelSetMotionRegistrationFilter_setGradientMagnitudeThreshold(swigCPtr, this, GradientMagnitudeThreshold);
  }

  /**
double itk::simple::LevelSetMotionRegistrationFilter::GetGradientMagnitudeThreshold() const
*/
public  double getGradientMagnitudeThreshold() {
    return SimpleITKJNI.LevelSetMotionRegistrationFilter_getGradientMagnitudeThreshold(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LevelSetMotionRegistrationFilter::SetUseImageSpacing(bool UseImageSpacing)
*/
public  void setUseImageSpacing(boolean UseImageSpacing) {
    SimpleITKJNI.LevelSetMotionRegistrationFilter_setUseImageSpacing(swigCPtr, this, UseImageSpacing);
  }

  /**
Self&amp; itk::simple::LevelSetMotionRegistrationFilter::UseImageSpacingOn()

Set the value of UseImageSpacing to true or false respectfully.

*/
public  void useImageSpacingOn() {
    SimpleITKJNI.LevelSetMotionRegistrationFilter_useImageSpacingOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LevelSetMotionRegistrationFilter::UseImageSpacingOff()
*/
public  void useImageSpacingOff() {
    SimpleITKJNI.LevelSetMotionRegistrationFilter_useImageSpacingOff(swigCPtr, this);
  }

  /**
bool itk::simple::LevelSetMotionRegistrationFilter::GetUseImageSpacing() const
*/
public  boolean getUseImageSpacing() {
    return SimpleITKJNI.LevelSetMotionRegistrationFilter_getUseImageSpacing(swigCPtr, this);
  }

  /**
uint32_t itk::simple::LevelSetMotionRegistrationFilter::GetElapsedIterations() const

Number of iterations run.


This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  long getElapsedIterations() {
    return SimpleITKJNI.LevelSetMotionRegistrationFilter_getElapsedIterations(swigCPtr, this);
  }

  /**
double itk::simple::LevelSetMotionRegistrationFilter::GetRMSChange() const

The Root Mean Square of the levelset upon termination.


This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  double getRMSChange() {
    return SimpleITKJNI.LevelSetMotionRegistrationFilter_getRMSChange(swigCPtr, this);
  }

  /**
double itk::simple::LevelSetMotionRegistrationFilter::GetMetric() const

Get the metric value. The metric value is the mean square difference
in intensity between the fixed image and transforming moving image
computed over the overlapping region between the two images. This is
value is only available for the previous iteration and NOT the current
iteration.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  double getMetric() {
    return SimpleITKJNI.LevelSetMotionRegistrationFilter_getMetric(swigCPtr, this);
  }

  /**
std::string itk::simple::LevelSetMotionRegistrationFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.LevelSetMotionRegistrationFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::LevelSetMotionRegistrationFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.LevelSetMotionRegistrationFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::LevelSetMotionRegistrationFilter::Execute(const Image &amp;fixedImage, const Image &amp;movingImage, const
Image &amp;initialDisplacementField)

Execute the filter on the input image

*/
public  Image execute(Image fixedImage, Image movingImage, Image initialDisplacementField) {
    return new Image(SimpleITKJNI.LevelSetMotionRegistrationFilter_execute__SWIG_0(swigCPtr, this, Image.getCPtr(fixedImage), fixedImage, Image.getCPtr(movingImage), movingImage, Image.getCPtr(initialDisplacementField), initialDisplacementField), true);
  }

  /**
Image itk::simple::LevelSetMotionRegistrationFilter::Execute(const Image &amp;fixedImage, const Image &amp;movingImage, const
Image &amp;initialDisplacementField)

Execute the filter on the input image

*/
public  Image execute(Image fixedImage, Image movingImage) {
    return new Image(SimpleITKJNI.LevelSetMotionRegistrationFilter_execute__SWIG_1(swigCPtr, this, Image.getCPtr(fixedImage), fixedImage, Image.getCPtr(movingImage), movingImage), true);
  }

}
