/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.ARM_ElfRelocationHandler;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationHandler;
import ghidra.program.model.address.Address;
import java.util.Map;

class ARM_ElfRelocationContext
extends ElfRelocationContext<ARM_ElfRelocationHandler> {
    private final boolean applyPcBiasToRelativeRelocations;

    protected ARM_ElfRelocationContext(ARM_ElfRelocationHandler handler, ElfLoadHelper loadHelper, Map<ElfSymbol, Address> symbolMap) {
        super((ElfRelocationHandler)handler, loadHelper, symbolMap);
        this.applyPcBiasToRelativeRelocations = (Boolean)loadHelper.getOption("Apply PC Bias to relative relocations", (Object)false);
    }

    int getPcBias(boolean isThumb) {
        if (this.applyPcBiasToRelativeRelocations) {
            return isThumb ? 4 : 8;
        }
        return 0;
    }
}

