/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;

public class UserDefinedTypeModuleSourceAndLineMsType
extends AbstractMsType {
    public static final int PDB_ID = 5639;
    private RecordNumber udtRecordNumber;
    private int sourceFileNameStringOffset;
    private int lineNumber;
    private int module;

    public UserDefinedTypeModuleSourceAndLineMsType(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.udtRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 32);
        this.sourceFileNameStringOffset = reader.parseInt();
        this.lineNumber = reader.parseInt();
        this.module = reader.parseUnsignedShortVal();
        reader.skipPadding();
    }

    @Override
    public int getPdbId() {
        return 5639;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getModuleNumber() {
        return this.module;
    }

    public int getSourceFileNameOffset() {
        return this.sourceFileNameStringOffset;
    }

    public String getSourceFileName() {
        return this.pdb.getNameStringFromOffset(this.sourceFileNameStringOffset);
    }

    public RecordNumber getUdtRecordNumber() {
        return this.udtRecordNumber;
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        builder.append(UserDefinedTypeModuleSourceAndLineMsType.class.getSimpleName());
        builder.append(", module: ");
        builder.append(this.module);
        builder.append(", line: ");
        builder.append(this.lineNumber);
        builder.append(", sourceFileName: ");
        builder.append(this.getSourceFileName());
        builder.append(", type: ");
        builder.append(this.pdb.getTypeRecord(this.udtRecordNumber));
    }
}

