/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel.field;

import docking.widgets.fieldpanel.field.ClippingTextField;
import docking.widgets.fieldpanel.field.CompositeFieldElement;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.StrutFieldElement;
import docking.widgets.fieldpanel.field.TextField;
import docking.widgets.fieldpanel.internal.FieldBackgroundColorManager;
import docking.widgets.fieldpanel.internal.PaintContext;
import docking.widgets.fieldpanel.support.DefaultRowColLocation;
import docking.widgets.fieldpanel.support.FieldHighlightFactory;
import docking.widgets.fieldpanel.support.RowColLocation;
import generic.json.Json;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.apache.commons.lang3.StringUtils;

public class CompositeVerticalLayoutTextField
implements TextField {
    private List<FieldRow> fieldRows;
    private int startX;
    private int width;
    private int preferredWidth;
    private FieldHighlightFactory hlFactory;
    private int height;
    private int heightAbove;
    private int numRows;
    private int numDataRows;
    private boolean isPrimary;
    private String fullText;
    private List<String> lines;
    private String rowSeparator;
    private boolean isClipped;

    public CompositeVerticalLayoutTextField(List<TextField> fields, int startX, int width, int maxLines, FieldHighlightFactory hlFactory) {
        this(fields, startX, width, maxLines, hlFactory, " ");
    }

    protected CompositeVerticalLayoutTextField(List<TextField> fields, int startX, int width, int maxLines, FieldHighlightFactory hlFactory, String rowSeparator) {
        this.startX = startX;
        this.width = width;
        this.hlFactory = hlFactory;
        this.rowSeparator = rowSeparator;
        this.lines = this.generateLines(fields);
        this.fullText = this.generateText(fields, rowSeparator);
        this.heightAbove = fields.get(0).getHeightAbove();
        this.fieldRows = this.layoutRows(fields, maxLines);
        this.calculateRows(fields);
        this.calculatePreferredWidth();
        this.calculateHeight();
    }

    private List<String> generateLines(List<TextField> fields) {
        ArrayList<String> list = new ArrayList<String>();
        for (TextField field : fields) {
            list.add(field.getTextWithLineSeparators());
        }
        return list;
    }

    private String generateText(List<TextField> fields, String delimiter) {
        StringBuilder buf = new StringBuilder();
        for (TextField element : fields) {
            buf.append(element.getText()).append(delimiter);
        }
        return buf.toString();
    }

    private List<FieldRow> layoutRows(List<TextField> fields, int maxLines) {
        int startY;
        ArrayList<FieldRow> newSubFields = new ArrayList<FieldRow>();
        int ySoFar = startY = -this.heightAbove;
        int currentRow = 0;
        boolean tooManyLines = fields.size() > maxLines;
        for (int i = 0; i < fields.size() && i < maxLines; ++i) {
            TextField field = fields.get(i);
            if (tooManyLines && i == maxLines - 1) {
                FieldElement element = field.getFieldElement(0, 0);
                ClippingTextField newField = this.createClippedField(element);
                newSubFields.add(new FieldRow(this, newField, currentRow, ySoFar));
                this.isClipped = true;
            } else {
                newSubFields.add(new FieldRow(this, field, currentRow, ySoFar));
                this.isClipped |= field.isClipped();
            }
            ySoFar += field.getHeight();
            currentRow += field.getNumRows();
        }
        this.isClipped |= tooManyLines;
        return newSubFields;
    }

    private ClippingTextField createClippedField(FieldElement element) {
        FieldElement[] elements = new FieldElement[]{element, new StrutFieldElement(element, 500)};
        CompositeFieldElement compositeElement = new CompositeFieldElement(elements);
        return new ClippingTextField(this.startX, this.width, compositeElement, this.hlFactory);
    }

    private void calculateHeight() {
        for (FieldRow row : this.fieldRows) {
            this.height += row.field.getHeight();
        }
    }

    private void calculatePreferredWidth() {
        this.preferredWidth = 0;
        for (FieldRow row : this.fieldRows) {
            this.preferredWidth = Math.max(this.preferredWidth, row.field.getPreferredWidth());
        }
    }

    private void calculateRows(List<TextField> fields) {
        this.numRows = 0;
        for (FieldRow row : this.fieldRows) {
            this.numRows += row.field.getNumRows();
        }
        this.numDataRows = 0;
        for (TextField field : fields) {
            this.numDataRows += field.getNumDataRows();
        }
    }

    public String toString() {
        return this.getText();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getStartX() {
        return this.startX;
    }

    @Override
    public int getNumDataRows() {
        return this.numDataRows;
    }

    @Override
    public int getNumRows() {
        return this.numRows;
    }

    @Override
    public int getHeightAbove() {
        return this.heightAbove;
    }

    @Override
    public int getHeightBelow() {
        return this.height - this.heightAbove;
    }

    @Override
    public boolean isPrimary() {
        return this.isPrimary;
    }

    @Override
    public void rowHeightChanged(int newHeightAbove, int newHeightBelow) {
    }

    @Override
    public boolean isClipped() {
        return this.isClipped;
    }

    @Override
    public void setPrimary(boolean state) {
        this.isPrimary = state;
    }

    @Override
    public String getText() {
        return this.fullText;
    }

    @Override
    public String getTextWithLineSeparators() {
        return StringUtils.join(this.lines, (char)'\n');
    }

    @Override
    public void paint(JComponent c, Graphics g, PaintContext context, Rectangle clip, FieldBackgroundColorManager colorManager, RowColLocation cursorLocation, int rowHeight) {
        int myStartY = -this.heightAbove;
        int myEndY = myStartY + rowHeight;
        int clipStartY = clip.y;
        int clipEndY = clip.y + clip.height;
        Color fieldBackgroundColor = colorManager.getBackgroundColor();
        if (fieldBackgroundColor != null) {
            g.setColor(fieldBackgroundColor);
            int startY = Math.max(myStartY, clipStartY);
            int endY = Math.min(myEndY, clipEndY);
            int clippedHeight = endY - startY;
            g.fillRect(this.startX, startY, this.width, clippedHeight);
        }
        FieldRow cursorRow = null;
        if (cursorLocation != null) {
            cursorRow = this.getFieldRow(cursorLocation.row());
        }
        int startY = myStartY;
        int translatedY = 0;
        for (FieldRow fieldRow : this.fieldRows) {
            if (startY > clipEndY) break;
            TextField field = fieldRow.field;
            int subFieldHeight = fieldRow.field.getHeight();
            int endY = startY + subFieldHeight;
            if (endY >= clipStartY) {
                RowColLocation cursor = null;
                if (fieldRow == cursorRow) {
                    int relativeRow = fieldRow.getRelativeRow(cursorLocation.row());
                    cursor = cursorLocation.withRow(relativeRow);
                }
                field.paint(c, g, context, clip, colorManager, cursor, rowHeight);
            }
            startY += subFieldHeight;
            g.translate(0, subFieldHeight);
            translatedY += subFieldHeight;
        }
        g.translate(0, -translatedY);
    }

    @Override
    public boolean contains(int x, int y) {
        return x >= this.startX && x < this.startX + this.width && y >= -this.heightAbove && y < this.height - this.heightAbove;
    }

    public String getRowSeparator() {
        return this.rowSeparator;
    }

    private FieldRow getFieldRow(int screenRow) {
        int currentRow = 0;
        for (FieldRow row : this.fieldRows) {
            int n = row.field.getNumRows();
            if (currentRow + n > screenRow) {
                return row;
            }
            currentRow += n;
        }
        return this.fieldRows.get(this.fieldRows.size() - 1);
    }

    private FieldRow getFieldRowFromDataRow(int dataRow) {
        int currentRow = 0;
        for (FieldRow row : this.fieldRows) {
            int length = row.field.getNumDataRows();
            if (currentRow + length > dataRow) {
                return row;
            }
            currentRow += length;
        }
        return this.fieldRows.get(this.fieldRows.size() - 1);
    }

    private List<FieldRow> getAllRows(int maxRow) {
        int currentRow = 0;
        ArrayList<FieldRow> list = new ArrayList<FieldRow>();
        for (FieldRow row : this.fieldRows) {
            if (currentRow > maxRow) break;
            list.add(row);
            currentRow += row.field.getNumRows();
        }
        return list;
    }

    protected List<TextField> getAllRowsUpTo(int maxRowInclusive) {
        return this.getAllRows(maxRowInclusive).stream().map(fieldRow -> fieldRow.field).collect(Collectors.toList());
    }

    @Override
    public FieldElement getFieldElement(int screenRow, int screenColumn) {
        FieldRow fieldRow = this.getFieldRow(screenRow);
        int relativeRow = fieldRow.getRelativeRow(screenRow);
        return fieldRow.field.getFieldElement(relativeRow, screenColumn);
    }

    @Override
    public int getNumCols(int row) {
        FieldRow fieldRow = this.getFieldRow(row);
        int relativeRow = fieldRow.getRelativeRow(row);
        return fieldRow.field.getNumCols(relativeRow);
    }

    @Override
    public int getX(int row, int col) {
        FieldRow fieldRow = this.getFieldRow(row);
        int relativeRow = fieldRow.getRelativeRow(row);
        return fieldRow.field.getX(relativeRow, col);
    }

    @Override
    public int getY(int row) {
        int startY;
        int ySoFar = startY = -this.heightAbove;
        List<FieldRow> rows = this.getAllRows(row);
        int lastHeight = 0;
        for (FieldRow fieldRow : rows) {
            ySoFar += lastHeight;
            if (fieldRow.displayRowOffset >= row) {
                return ySoFar;
            }
            lastHeight = fieldRow.field.getHeight();
        }
        return ySoFar;
    }

    @Override
    public int getRow(int y) {
        int startY = -this.heightAbove;
        if (y < startY) {
            return 0;
        }
        int ySoFar = startY;
        for (FieldRow fieldRow : this.fieldRows) {
            int fieldHeight = fieldRow.field.getHeight();
            int bottom = fieldHeight + ySoFar;
            if (bottom > y) {
                int relativeY = y - ySoFar;
                int relativeRow = fieldRow.field.getRow(relativeY);
                int displayRow = fieldRow.fromRelativeRow(relativeRow);
                return displayRow;
            }
            ySoFar += fieldHeight;
        }
        return this.getNumRows() - 1;
    }

    @Override
    public int getCol(int row, int x) {
        FieldRow fieldRow = this.getFieldRow(row);
        int relativeRow = fieldRow.getRelativeRow(row);
        return fieldRow.field.getCol(relativeRow, x);
    }

    @Override
    public boolean isValid(int row, int col) {
        if (row < 0 || row >= this.getNumRows()) {
            return false;
        }
        FieldRow fieldRow = this.getFieldRow(row);
        int relativeRow = fieldRow.getRelativeRow(row);
        return fieldRow.field.isValid(relativeRow, col);
    }

    @Override
    public Rectangle getCursorBounds(int row, int col) {
        if (row < 0 || row >= this.getNumRows()) {
            return null;
        }
        List<FieldRow> rows = this.getAllRows(row);
        FieldRow cursorRow = rows.get(rows.size() - 1);
        int relativeRow = cursorRow.getRelativeRow(row);
        Rectangle r = cursorRow.field.getCursorBounds(relativeRow, col);
        for (int i = 0; i < rows.size() - 1; ++i) {
            FieldRow previousRow = rows.get(i);
            r.y += previousRow.field.getHeight();
        }
        return r;
    }

    @Override
    public int getScrollableUnitIncrement(int topOfScreen, int direction, int max) {
        if (topOfScreen < -this.heightAbove || topOfScreen > this.height - this.heightAbove) {
            return max;
        }
        int row = this.getRow(topOfScreen);
        int y = this.getY(row);
        int rowOffset = topOfScreen - y;
        FieldRow fieldRow = this.getFieldRow(row);
        int rowHeight = fieldRow.field.getHeight();
        if (direction > 0) {
            return rowHeight - rowOffset;
        }
        if (rowOffset == 0) {
            return -rowHeight;
        }
        return -rowOffset;
    }

    @Override
    public RowColLocation screenToDataLocation(int screenRow, int screenColumn) {
        screenRow = Math.min(screenRow, this.numRows - 1);
        screenRow = Math.max(screenRow, 0);
        FieldRow fieldRow = this.getFieldRow(screenRow);
        screenColumn = Math.min(screenColumn, fieldRow.field.getText().length());
        screenColumn = Math.max(screenColumn, 0);
        int relativeRow = fieldRow.getRelativeRow(screenRow);
        return fieldRow.field.screenToDataLocation(relativeRow, screenColumn);
    }

    @Override
    public RowColLocation dataToScreenLocation(int dataRow, int dataColumn) {
        FieldRow fieldRow = this.getFieldRowFromDataRow(dataRow);
        RowColLocation location = fieldRow.field.dataToScreenLocation(dataRow, dataColumn);
        int relativeRow = fieldRow.fromRelativeRow(location.row());
        return location.withRow(relativeRow);
    }

    @Override
    public int screenLocationToTextOffset(int row, int col) {
        if (row >= this.numRows) {
            return this.getText().length();
        }
        int extraSpace = this.rowSeparator.length();
        int len = 0;
        List<FieldRow> rows = this.getAllRows(row);
        int n = rows.size() - 1;
        for (int i = 0; i < n; ++i) {
            FieldRow fieldRow = rows.get(i);
            len += fieldRow.field.getText().length() + extraSpace;
        }
        FieldRow lastRow = rows.get(n);
        int relativeRow = lastRow.getRelativeRow(row);
        return len += lastRow.field.screenLocationToTextOffset(relativeRow, col);
    }

    @Override
    public RowColLocation textOffsetToScreenLocation(int textOffset) {
        int length;
        int extraSpace = this.rowSeparator.length();
        int n = this.fieldRows.size();
        int textOffsetSoFar = 0;
        for (int i = 0; i < n && textOffsetSoFar <= textOffset; textOffsetSoFar += length, ++i) {
            FieldRow fieldRow = this.fieldRows.get(i);
            length = fieldRow.field.getText().length() + extraSpace;
            int end = textOffsetSoFar + length;
            if (end <= textOffset) continue;
            int relativeOffset = textOffset - textOffsetSoFar;
            RowColLocation location = fieldRow.field.textOffsetToScreenLocation(relativeOffset);
            int screenRow = fieldRow.fromRelativeRow(location.row());
            return location.withRow(screenRow);
        }
        FieldRow lastRow = this.fieldRows.get(this.fieldRows.size() - 1);
        int length2 = lastRow.field.getText().length();
        return new DefaultRowColLocation(this.numRows - 1, length2);
    }

    private class FieldRow {
        private TextField field;
        private int displayRowOffset;
        private int yOffset;

        FieldRow(CompositeVerticalLayoutTextField compositeVerticalLayoutTextField, TextField field, int rowOffset, int yOffset) {
            this.field = field;
            this.displayRowOffset = rowOffset;
        }

        int getRelativeRow(int displayRow) {
            return displayRow - this.displayRowOffset;
        }

        int fromRelativeRow(int relativeRow) {
            return relativeRow + this.displayRowOffset;
        }

        int getY() {
            return this.yOffset;
        }

        public String toString() {
            return Json.toString((Object)this);
        }
    }
}

