/*
 * Decompiled with CFR 0.152.
 */
package docking.help;

import docking.DockingUtils;
import docking.DockingWindowManager;
import docking.actions.KeyBindingUtils;
import docking.widgets.FindDialog;
import docking.widgets.TextComponentSearcher;
import generic.util.WindowUtilities;
import ghidra.util.exception.AssertException;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import javax.help.JHelp;
import javax.help.JHelpContentViewer;
import javax.help.JHelpSearchNavigator;
import javax.help.search.SearchEngine;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;

class HelpViewSearcher {
    private static final String DIALOG_TITLE_PREFIX = "Whole Word Search in ";
    private static final String FIND_ACTION_NAME = "find.action";
    private static KeyStroke FIND_KEYSTROKE = KeyStroke.getKeyStroke(70, DockingUtils.CONTROL_KEY_MODIFIER_MASK);
    private JHelp jHelp;
    private SearchEngine searchEngine;
    private JEditorPane htmlEditorPane;
    private FindDialog findDialog;

    HelpViewSearcher(JHelp jHelp) {
        this.jHelp = jHelp;
        this.grabSearchEngine();
        JHelpContentViewer contentViewer = jHelp.getContentViewer();
        contentViewer.addHelpModelListener(e -> {
            URL url = e.getURL();
            if (!this.isValidHelpURL(url)) {
                return;
            }
            String file = url.getFile();
            int separatorIndex = file.lastIndexOf(File.separator);
            file = file.substring(separatorIndex + 1);
            this.findDialog.setTitle(DIALOG_TITLE_PREFIX + file);
        });
        this.htmlEditorPane = this.getHTMLEditorPane(contentViewer);
        TextComponentSearcher searcher = new TextComponentSearcher(this.htmlEditorPane);
        this.findDialog = new FindDialog(DIALOG_TITLE_PREFIX, searcher);
        this.htmlEditorPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                HelpViewSearcher.this.htmlEditorPane.getCaret().setVisible(true);
            }
        });
        this.installPopup();
        this.installKeybindings();
    }

    private boolean isValidHelpURL(URL url) {
        if (url == null) {
            return false;
        }
        String file = url.getFile();
        return new File(file).exists();
    }

    private void grabSearchEngine() {
        Enumeration navigators = this.jHelp.getHelpNavigators();
        while (navigators.hasMoreElements()) {
            Object element = navigators.nextElement();
            if (!(element instanceof JHelpSearchNavigator)) continue;
            this.searchEngine = ((JHelpSearchNavigator)element).getSearchEngine();
        }
        if (this.searchEngine == null) {
            throw new AssertException("Unable to locate help search engine");
        }
    }

    private void installPopup() {
        this.htmlEditorPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    HelpViewSearcher.this.showPopupMenu(e);
                    return;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    HelpViewSearcher.this.showPopupMenu(e);
                    return;
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    HelpViewSearcher.this.showPopupMenu(e);
                    return;
                }
            }
        });
    }

    private void installKeybindings() {
        KeyBindingUtils.registerAction((JComponent)this.htmlEditorPane, FIND_KEYSTROKE, new FindDialogAction(), 1);
    }

    private void showPopupMenu(MouseEvent e) {
        JMenuItem menuItem = new JMenuItem("Find on Page...");
        menuItem.setAction(new FindDialogAction());
        menuItem.setText("Find on Page...");
        JPopupMenu menu = new JPopupMenu();
        menu.add(menuItem);
        menu.show(this.htmlEditorPane, e.getX(), e.getY());
    }

    private JEditorPane getHTMLEditorPane(JHelpContentViewer contentViewer) {
        Component[] components = contentViewer.getComponents();
        JScrollPane scrollPane = (JScrollPane)components[0];
        JViewport viewport = scrollPane.getViewport();
        return (JEditorPane)viewport.getView();
    }

    private class FindDialogAction
    extends AbstractAction {
        FindDialogAction() {
            super(HelpViewSearcher.FIND_ACTION_NAME);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Window helpWindow = WindowUtilities.windowForComponent((Component)HelpViewSearcher.this.htmlEditorPane);
            DockingWindowManager.showDialog(helpWindow, HelpViewSearcher.this.findDialog);
        }
    }
}

