/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser.filehandlers;

import docking.action.DockingAction;
import docking.action.builder.ActionBuilder;
import ghidra.app.util.bin.ByteProvider;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.plugins.fsbrowser.FSBActionContext;
import ghidra.plugins.fsbrowser.FSBComponentProvider;
import ghidra.plugins.fsbrowser.FSBFileHandler;
import ghidra.plugins.fsbrowser.FSBFileHandlerContext;
import ghidra.plugins.fsbrowser.FSBFileNode;
import ghidra.plugins.fsbrowser.FSBIcons;
import ghidra.plugins.fsbrowser.FSBNode;
import ghidra.plugins.fsbrowser.TextEditorComponentProvider;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import utilities.util.FileUtilities;

public class TextFSBFileHandler
implements FSBFileHandler {
    public static final String FSB_VIEW_AS_TEXT = "FSB View As Text";
    private static final int MAX_TEXT_FILE_LEN = 65536;
    FSBFileHandlerContext context;

    @Override
    public void init(FSBFileHandlerContext context) {
        this.context = context;
    }

    @Override
    public boolean fileDefaultAction(FSBFileNode fileNode) {
        if (fileNode.getFileExtension().equalsIgnoreCase("txt")) {
            FSBComponentProvider fsbComponent = this.context.fsbComponent();
            fsbComponent.runTask(monitor -> this.doViewAsText(fileNode.getFSRL(), fsbComponent.getComponent(), monitor));
            return true;
        }
        return false;
    }

    @Override
    public List<DockingAction> createActions() {
        DockingAction action = (DockingAction)new ActionBuilder(FSB_VIEW_AS_TEXT, this.context.plugin().getName()).withContext(FSBActionContext.class).enabledWhen(ac -> ac.notBusy() && ac.getFileFSRL() != null).popupMenuIcon(FSBIcons.VIEW_AS_TEXT).popupMenuPath(new String[]{"View As", "Text"}).popupMenuGroup("G").onAction(ac -> {
            FSBFileNode fileNode;
            FSBNode patt0$temp = ac.getSelectedNode();
            if (patt0$temp instanceof FSBFileNode && (fileNode = (FSBFileNode)patt0$temp).getFSRL() != null) {
                ac.getTree().runTask(monitor -> this.doViewAsText(fileNode.getFSRL(), (Component)ac.getSourceComponent(), monitor));
            }
        }).build();
        action.getPopupMenuData().setParentMenuGroup("C");
        return List.of(action);
    }

    void doViewAsText(FSRL fsrl, Component parent, TaskMonitor monitor) {
        try (ByteProvider fileBP = this.context.fsService().getByteProvider(fsrl, false, monitor);){
            if (fileBP.length() > 65536L) {
                Msg.showInfo((Object)this, (Component)this.context.fsbComponent().getComponent(), (String)"View As Text Failed", (Object)"File too large to view as text inside Ghidra. Please use the \"EXPORT\" action.");
                return;
            }
            try (InputStream is = fileBP.getInputStream(0L);){
                String text = FileUtilities.getText((InputStream)is);
                Swing.runLater(() -> new TextEditorComponentProvider(this.context.plugin(), fsrl.getName(), text));
            }
        }
        catch (CancelledException | IOException e) {
            FSUtilities.displayException(this, parent, "Error Viewing Text File", "Error when trying to view text file %s".formatted(fsrl.getName()), e);
        }
    }
}

