/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf.omf51;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import java.io.IOException;

public class Omf51LibraryModuleLocation {
    public static final int BLOCK_SIZE = 128;
    private int blockNumber;
    private int byteNumber;

    public Omf51LibraryModuleLocation(BinaryReader reader) throws IOException {
        this.blockNumber = reader.readNextUnsignedShort();
        this.byteNumber = reader.readNextUnsignedShort();
    }

    public int getBlockNumber() {
        return this.blockNumber;
    }

    public int getByteNumber() {
        return this.byteNumber;
    }

    public int getOffset() {
        return this.blockNumber * 128 + this.byteNumber;
    }

    public static DataType toDataType() {
        StructureDataType struct = new StructureDataType("Omf51LibraryModuleLocation", 0);
        struct.add(StructConverter.WORD, "blockNumber", null);
        struct.add(StructConverter.WORD, "byteNumber", null);
        struct.setCategoryPath(new CategoryPath("/OMF"));
        return struct;
    }
}

