/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.LEB128Info;
import ghidra.app.util.bin.MemBufferByteProvider;
import ghidra.app.util.bin.format.elf.AndroidElfRelocationData;
import ghidra.app.util.bin.format.elf.AndroidElfRelocationGroup;
import ghidra.docking.settings.Settings;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DynamicDataType;
import ghidra.program.model.data.ReadOnlyDataTypeComponent;
import ghidra.program.model.data.SignedLeb128DataType;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.WrappedMemBuffer;
import ghidra.util.Msg;
import java.io.IOException;
import java.util.ArrayList;

public class AndroidElfRelocationTableDataType
extends DynamicDataType {
    public AndroidElfRelocationTableDataType() {
        this(null);
    }

    public AndroidElfRelocationTableDataType(DataTypeManager dtm) {
        super(CategoryPath.ROOT, "AndroidElfRelocationTable", dtm);
    }

    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.dataMgr) {
            return this;
        }
        return new AndroidElfRelocationTableDataType(dtm);
    }

    public String getDescription() {
        return "Android Packed Relocation Table for ELF";
    }

    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return null;
    }

    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return "";
    }

    protected DataTypeComponent[] getAllComponents(MemBuffer buf) {
        try {
            byte[] bytes = new byte[4];
            if (buf.getBytes(bytes, 0) != 4 || !"APS2".equals(new String(bytes))) {
                return null;
            }
            MemBufferByteProvider provider = new MemBufferByteProvider(buf);
            BinaryReader reader = new BinaryReader(provider, false);
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(new ReadOnlyDataTypeComponent((DataType)StringDataType.dataType, (DynamicDataType)this, 4, 0, 0, "format", null));
            reader.setPointerIndex(4);
            LEB128Info sleb128 = reader.readNext(LEB128Info::signed);
            long remainingRelocations = sleb128.asLong();
            list.add(AndroidElfRelocationTableDataType.getLEB128Component(sleb128, this, list.size(), "reloc_count", null));
            sleb128 = reader.readNext(LEB128Info::signed);
            long baseRelocOffset = sleb128.asLong();
            list.add(AndroidElfRelocationTableDataType.getLEB128Component(sleb128, this, list.size(), "reloc_baseOffset", null));
            int groupIndex = 0;
            long groupRelocOffset = baseRelocOffset;
            while (remainingRelocations > 0L) {
                int offset = (int)reader.getPointerIndex();
                long groupSize = reader.readNext(LEB128Info::signed).asLong();
                if (groupSize > remainingRelocations) {
                    Msg.debug((Object)((Object)this), (Object)("Group relocation count " + groupSize + " exceeded total count " + remainingRelocations));
                    break;
                }
                AndroidElfRelocationGroup group = new AndroidElfRelocationGroup(this.dataMgr, groupRelocOffset);
                WrappedMemBuffer groupBuffer = new WrappedMemBuffer(buf, offset);
                int groupLength = group.getLength((MemBuffer)groupBuffer, -1);
                ReadOnlyDataTypeComponent dtc = new ReadOnlyDataTypeComponent((DataType)group, (DynamicDataType)this, groupLength, list.size(), offset, "reloc_group_" + groupIndex++, null);
                list.add(dtc);
                groupRelocOffset = group.getLastRelocationOffset(groupBuffer);
                if (groupRelocOffset < 0L) break;
                reader.setPointerIndex(offset += groupLength);
                remainingRelocations -= groupSize;
            }
            DataTypeComponent[] comps = new DataTypeComponent[list.size()];
            return list.toArray(comps);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static DataTypeComponent getLEB128Component(LEB128Info leb128, DynamicDataType parent, int ordinal, String name, String comment, long relocOffset) {
        return new ReadOnlyDataTypeComponent((DataType)new AndroidElfRelocationData(parent.getDataTypeManager(), relocOffset), parent, leb128.getLength(), ordinal, (int)leb128.getOffset(), name, comment);
    }

    public static DataTypeComponent getLEB128Component(LEB128Info leb128, DynamicDataType parent, int ordinal, String name, String comment) {
        return new ReadOnlyDataTypeComponent((DataType)new SignedLeb128DataType(parent.getDataTypeManager()), parent, leb128.getLength(), ordinal, (int)leb128.getOffset(), name, comment);
    }
}

