/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import docking.widgets.table.DynamicTableColumn;
import ghidra.app.plugin.core.navigation.locationreferences.ReferenceUtils;
import ghidra.app.util.XReferenceUtils;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.util.ProgramLocation;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.ReferencesFromTableModel;
import ghidra.util.table.field.AbstractProgramBasedDynamicTableColumn;
import ghidra.util.table.field.IncomingReferenceEndpoint;
import ghidra.util.table.field.ReferenceEndpoint;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;

public class FunctionXrefsTableModel
extends ReferencesFromTableModel {
    private Function function;
    private boolean showAllThunkXrefs;

    public FunctionXrefsTableModel(Function function, Supplier<Collection<Reference>> directRefs, ServiceProvider sp, Program program) {
        super(directRefs, sp, program);
        this.function = function;
        this.addTableColumn((DynamicTableColumn)new IsThunkTableColumn());
    }

    @Override
    protected void doLoad(Accumulator<ReferenceEndpoint> accumulator, TaskMonitor monitor) throws CancelledException {
        if (!this.showAllThunkXrefs) {
            super.doLoad(accumulator, monitor);
            return;
        }
        Function baseFunction = this.function;
        if (this.function.isThunk()) {
            baseFunction = this.function.getThunkedFunction(true);
        }
        this.doLoadThunkFunctionReferences(baseFunction, accumulator, monitor);
    }

    private void doLoadThunkFunctionReferences(Function baseFunction, Accumulator<ReferenceEndpoint> accumulator, TaskMonitor monitor) throws CancelledException {
        this.addReferences(accumulator, baseFunction.getEntryPoint());
        Address[] thunks = baseFunction.getFunctionThunkAddresses(true);
        if (thunks == null) {
            return;
        }
        for (Address address : thunks) {
            monitor.checkCancelled();
            this.addReferences(accumulator, address);
        }
    }

    private void addReferences(Accumulator<ReferenceEndpoint> accumulator, Address address) {
        ProgramLocation location = new ProgramLocation(this.program, address);
        Set<Reference> refs = XReferenceUtils.getAllXrefs(location);
        for (Reference ref : refs) {
            boolean offcut = ReferenceUtils.isOffcut(this.program, ref.getToAddress());
            accumulator.add((Object)new ThunkIncomingReferenceEndpoint(this, ref, offcut));
        }
    }

    void toggleShowAllThunkXRefs() {
        this.showAllThunkXrefs = !this.showAllThunkXrefs;
        this.reload();
    }

    private class IsThunkTableColumn
    extends AbstractProgramBasedDynamicTableColumn<ReferenceEndpoint, String> {
        private IsThunkTableColumn() {
        }

        public String getColumnName() {
            return "Thunk?";
        }

        public String getValue(ReferenceEndpoint rowObject, Settings settings, Program data, ServiceProvider sp) throws IllegalArgumentException {
            Address toAddress = rowObject.getReference().getToAddress();
            FunctionManager fm = FunctionXrefsTableModel.this.program.getFunctionManager();
            Function f = fm.getFunctionAt(toAddress);
            if (f != null && f.isThunk()) {
                return "thunk";
            }
            return "";
        }
    }

    private class ThunkIncomingReferenceEndpoint
    extends IncomingReferenceEndpoint {
        public ThunkIncomingReferenceEndpoint(FunctionXrefsTableModel functionXrefsTableModel, Reference r, boolean isOffcut) {
            super(r, isOffcut);
        }
    }
}

