/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.widgets.OptionDialog;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.FieldRange;
import docking.widgets.fieldpanel.support.FieldSelection;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorModel;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.DataTypeHelper;
import ghidra.program.database.DatabaseObject;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.data.AlignmentType;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeDependencyException;
import ghidra.program.model.data.DataTypeInstance;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeManagerChangeListener;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.PackingType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.lang.InsufficientBytesException;
import ghidra.util.HTMLUtilities;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.UsrException;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.help.UnsupportedOperationException;

public abstract class CompEditorModel<T extends Composite>
extends CompositeEditorModel<T> {
    private volatile boolean consideringReplacedDataType = false;

    CompEditorModel(CompositeEditorProvider<T, ? extends CompEditorModel<T>> provider) {
        super(provider);
    }

    @Override
    public boolean hasChanges() {
        if (this.originalDTM != null && !this.originalDTM.contains((DataType)this.originalComposite)) {
            return true;
        }
        return super.hasChanges();
    }

    @Override
    public void load(T dataType) {
        if (dataType.isDeleted()) {
            if (dataType == this.originalComposite) {
                this.originalDTM.addDataTypeManagerListener((DataTypeManagerChangeListener)this);
                this.dataTypeRemoved(this.originalDTM, this.originalDataTypePath);
            }
            return;
        }
        super.load(dataType);
        this.fixSelection();
        this.selectionChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean apply() throws InvalidDataTypeException {
        Object action;
        Object originalDt;
        if (this.isEditingField()) {
            this.endFieldEditing();
        }
        if ((originalDt = this.getOriginalComposite()) == null || this.originalDTM == null) {
            throw new IllegalStateException("Can't apply edits without a data type or data type manager.");
        }
        boolean originalDtExists = this.originalDTM.contains(originalDt);
        boolean renamed = false;
        if (originalDtExists) {
            String editName;
            String origName = originalDt.getName();
            renamed = !origName.equals(editName = this.getCompositeName());
        }
        Object object = action = originalDtExists ? "Edit" : "Create";
        if (renamed) {
            action = (String)action + "/Rename";
        }
        int transactionID = this.originalDTM.startTransaction((String)action + " " + this.getTypeName());
        try {
            this.originalDTM.removeDataTypeManagerListener((DataTypeManagerChangeListener)this);
            if (originalDtExists) {
                if (renamed) {
                    String editName = this.getCompositeName();
                    try {
                        originalDt.setName(editName);
                    }
                    catch (InvalidNameException e) {
                        String msg = "Apply failed. The data type name \"" + editName + "\" is not valid.";
                        throw new InvalidDataTypeException(msg);
                    }
                    catch (DuplicateNameException e) {
                        String msg = "Apply failed. A data type named \"" + editName + "\" already exists.";
                        throw new InvalidDataTypeException(msg);
                    }
                }
                originalDt.setDescription(this.getDescription());
                this.replaceOriginalComponents();
                this.updateOriginalComponentSettings(this.viewComposite, (Composite)originalDt);
                this.originalDTM.flushEvents();
                Swing.runLater(() -> this.load(originalDt));
            } else {
                Composite dt = (Composite)this.originalDTM.resolve((DataType)this.viewComposite, null);
                this.originalDTM.flushEvents();
                Swing.runLater(() -> this.load(dt));
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.originalDTM.endTransaction(transactionID, true);
        }
    }

    boolean isBlankLastLineSelected() {
        return this.selection.contains(new FieldLocation(this.getNumComponents(), 0, 0, 0));
    }

    protected abstract int getNumBytesInRange(FieldRange var1);

    @Override
    public void setSelection(int[] rows) {
        int numComponents;
        if (this.updatingSelection) {
            return;
        }
        FieldSelection tmpSelection = new FieldSelection();
        if (rows.length == 1) {
            tmpSelection.addRange(rows[0], rows[0] + 1);
        } else {
            numComponents = this.getNumComponents();
            for (int r : rows) {
                if (r >= numComponents) continue;
                tmpSelection.addRange(r, r + 1);
            }
        }
        if (tmpSelection.getNumRanges() == 0) {
            numComponents = this.getNumComponents();
            tmpSelection.addRange(numComponents, numComponents + 1);
        }
        if (this.selection.equals((Object)tmpSelection)) {
            this.selectionChanged();
            return;
        }
        this.endFieldEditing();
        this.selection = tmpSelection;
        this.adjustCurrentRow();
        this.selectionChanged();
    }

    @Override
    public void setSelection(FieldSelection selection) {
        if (this.updatingSelection) {
            return;
        }
        if (this.selection.equals((Object)selection)) {
            return;
        }
        this.endFieldEditing();
        this.selection.clear();
        int numRanges = selection.getNumRanges();
        for (int i = 0; i < numRanges; ++i) {
            FieldRange range = selection.getFieldRange(i);
            this.selection.addRange(range.getStart().getIndex().intValue(), range.getEnd().getIndex().intValue());
        }
        this.fixSelection();
        this.adjustCurrentRow();
        this.selectionChanged();
    }

    boolean fixSelection() {
        int numComps = this.getNumComponents();
        FieldSelection allRows = new FieldSelection();
        allRows.addRange(0, numComps + 1);
        this.selection.intersect(allRows);
        if (this.selection.getNumRanges() == 0) {
            this.selection.addRange(numComps, numComps + 1);
        } else if (this.isBlankLastLineSelected() && this.getNumSelectedComponentRows() > 0) {
            this.selection.removeRange(numComps, numComps + 1);
        } else {
            return false;
        }
        this.adjustCurrentRow();
        return true;
    }

    @Override
    public boolean isAddAllowed(DataType dataType) {
        int rowIndex = this.getMinIndexSelected();
        if (rowIndex == -1) {
            return false;
        }
        return this.isAddAllowed(rowIndex, dataType);
    }

    @Override
    public boolean isClearAllowed() {
        return this.getNumSelectedRows() > 0 && !this.isBlankLastLineSelected();
    }

    public boolean isInsertAllowed(DataType dataType) {
        int rowIndex = this.getMinIndexSelected();
        if (rowIndex == -1) {
            return false;
        }
        return this.isInsertAllowed(rowIndex, dataType);
    }

    @Override
    public boolean isInsertAllowed(int rowIndex, DataType datatype) {
        return true;
    }

    public boolean isReplaceAllowed(DataType dataType) {
        if (this.getNumSelectedComponentRows() != 1) {
            return false;
        }
        int rowIndex = this.getMinIndexSelected();
        return this.isReplaceAllowed(rowIndex, dataType);
    }

    void delete(int componentOrdinal) {
        this.doDelete(componentOrdinal);
        this.selection.removeRange(componentOrdinal, componentOrdinal + 1);
        this.adjustSelection(componentOrdinal + 1, -1);
        this.notifyCompositeChanged();
    }

    private void doDelete(int componentOrdinal) {
        this.viewDTM.withTransaction("Delete Component", () -> this.viewComposite.delete(componentOrdinal));
        if (componentOrdinal < this.currentEditRow) {
            --this.currentEditRow;
        }
    }

    private void delete(int[] rows) throws CancelledException {
        int n = rows.length;
        Arrays.sort(rows);
        HashSet<Integer> rowSet = new HashSet<Integer>();
        for (int i = n - 1; i >= 0; --i) {
            int rowIndex = rows[i];
            int componentOrdinal = this.convertRowToOrdinal(rowIndex);
            if (componentOrdinal < this.currentEditRow) {
                --this.currentEditRow;
            }
            rowSet.add(componentOrdinal);
        }
        this.viewDTM.withTransaction("Delete Components", () -> this.viewComposite.delete(rowSet));
        if (rows.length > 0) {
            this.setSelection(new int[]{rows[0]});
        }
        this.notifyCompositeChanged();
    }

    @Override
    protected void deleteComponent(int rowIndex) {
        if (this.isEditingField()) {
            this.endFieldEditing();
        }
        int componentOrdinal = this.convertRowToOrdinal(rowIndex);
        this.delete(componentOrdinal);
        this.fixSelection();
        this.selectionChanged();
    }

    void deleteComponentRange(int startRowIndex, int endRowIndex, TaskMonitor monitor) throws CancelledException {
        if (this.isEditingField()) {
            this.endFieldEditing();
        }
        int entries = endRowIndex - startRowIndex + 1;
        HashSet<Integer> ordinals = new HashSet<Integer>();
        monitor.initialize((long)entries);
        for (int rowIndex = endRowIndex; rowIndex >= startRowIndex; --rowIndex) {
            monitor.checkCancelled();
            int componentOrdinal = this.convertRowToOrdinal(rowIndex);
            ordinals.add(componentOrdinal);
            if (componentOrdinal < this.currentEditRow) {
                --this.currentEditRow;
            }
            this.selection.removeRange(componentOrdinal, componentOrdinal + 1);
            this.adjustSelection(componentOrdinal + 1, -1);
            monitor.incrementProgress(1L);
        }
        this.viewDTM.withTransaction("Delete Components", () -> this.viewComposite.delete(ordinals));
        this.fixSelection();
        this.selectionChanged();
    }

    @Override
    public void deleteSelectedComponents() throws UsrException {
        if (!this.isDeleteAllowed()) {
            throw new UsrException("Deleting is not allowed.");
        }
        if (this.isEditingField()) {
            this.endFieldEditing();
        }
        int[] selectedComponents = this.getSelectedComponentRows();
        int firstRowIndex = !this.selection.isEmpty() ? selectedComponents[0] : this.getRowCount();
        this.delete(selectedComponents);
        this.selection.addRange(firstRowIndex, firstRowIndex + 1);
        this.fixSelection();
        this.selectionChanged();
    }

    protected abstract DataTypeComponent insert(int var1, DataType var2, int var3, String var4, String var5) throws InvalidDataTypeException;

    protected abstract void insert(int var1, DataType var2, int var3, int var4, TaskMonitor var5) throws InvalidDataTypeException, CancelledException;

    protected void insertMultiple(int rowIndex, DataType dataType, int dtLen, int multiple, TaskMonitor monitor) throws NoSuchElementException, InvalidDataTypeException, CancelledException {
        if (multiple < 1) {
            return;
        }
        this.insert(rowIndex, dataType, dtLen, multiple, monitor);
    }

    @Override
    public DataTypeComponent insert(DataType dataType) throws UsrException {
        if (this.hasSelection()) {
            return this.insert(this.getMinIndexSelected(), dataType);
        }
        return null;
    }

    @Override
    public DataTypeComponent insert(int rowIndex, DataType dt) throws UsrException {
        return this.insert(rowIndex, dt, dt.getLength());
    }

    @Override
    public DataTypeComponent insert(int rowIndex, DataType datatype, int length) throws InvalidDataTypeException, UsrException {
        if (this.isEditingField()) {
            this.endFieldEditing();
        }
        this.checkIsAllowableDataType(datatype);
        if (length < 1) {
            DataTypeInstance dti = DataTypeHelper.getSizedDataType(this.getProvider(), datatype, this.lastNumBytes, Integer.MAX_VALUE);
            if (dti == null) {
                return null;
            }
            datatype = dti.getDataType();
            length = dti.getLength();
        }
        DataTypeComponent dtc = this.insert(rowIndex, datatype, length, null, null);
        this.fixSelection();
        this.selectionChanged();
        return dtc;
    }

    protected void insertComponentMultiple(int rowIndex, DataType dataType, int dtLen, int multiple, TaskMonitor monitor) throws NoSuchElementException, InvalidDataTypeException, CancelledException {
        if (this.isEditingField()) {
            this.endFieldEditing();
        }
        this.checkIsAllowableDataType(dataType);
        this.insertMultiple(rowIndex, dataType, dtLen, multiple, monitor);
        this.fixSelection();
        this.selectionChanged();
    }

    @Override
    public DataTypeComponent add(DataType dataType) throws UsrException {
        if (!this.isContiguousSelection()) {
            this.setStatus("Replace data type only works on a contiguous selection", true);
            return null;
        }
        return this.add(this.getMinIndexSelected(), dataType);
    }

    @Override
    public DataTypeComponent add(int rowIndex, DataType dt) throws UsrException {
        String descr = rowIndex < this.getNumComponents() ? "Replace Component" : "Add Component";
        DataTypeComponent dtc = (DataTypeComponent)this.viewDTM.withTransaction(descr, () -> {
            DataType resolvedDt = this.viewDTM.resolve(dt, DataTypeConflictHandler.DEFAULT_HANDLER);
            try {
                DataTypeInstance dti = this.getDropDataType(rowIndex, resolvedDt);
                return this.add(rowIndex, dti.getDataType(), dti.getLength());
            }
            catch (CancelledException e) {
                return null;
            }
        });
        this.fixSelection();
        this.selectionChanged();
        return dtc;
    }

    @Override
    public DataTypeComponent add(int rowIndex, DataType dt, int dtLength) throws UsrException {
        DataTypeComponent dtc = null;
        dtc = rowIndex < this.getNumComponents() ? (DataTypeComponent)this.viewDTM.withTransaction("Replace Component", () -> {
            FieldRange range = this.getSelectedRangeContaining(rowIndex);
            if (range == null || range.getStart().getIndex().intValue() == range.getEnd().getIndex().intValue() - 1) {
                return this.replace(rowIndex, dt, dtLength);
            }
            return this.replaceComponentRange(range.getStart().getIndex().intValue(), range.getEnd().getIndex().intValue() - 1, dt, dtLength);
        }) : (DataTypeComponent)this.viewDTM.withTransaction("Add Component", () -> this.insert(rowIndex, dt, dtLength));
        this.fixSelection();
        this.selectionChanged();
        return dtc;
    }

    public DataTypeComponent replace(DataType dataType) throws UsrException {
        if (this.isContiguousComponentSelection()) {
            return this.replace(this.getMinIndexSelected(), dataType);
        }
        return null;
    }

    public DataTypeComponent replace(int rowIndex, DataType dt) throws UsrException {
        return (DataTypeComponent)this.viewDTM.withTransaction("Replace Component", () -> {
            DataTypeInstance dti = DataTypeHelper.getFixedLength(this, rowIndex, dt, this.usesAlignedLengthComponents());
            if (dti == null) {
                return null;
            }
            if (rowIndex < this.getNumComponents()) {
                FieldRange range = this.getSelectedRangeContaining(rowIndex);
                if (range == null || range.getStart().getIndex().intValue() == range.getEnd().getIndex().intValue() - 1) {
                    return this.replace(rowIndex, dti.getDataType(), dti.getLength());
                }
                return this.replaceComponentRange(range.getStart().getIndex().intValue(), range.getEnd().getIndex().intValue() - 1, dti.getDataType(), dti.getLength());
            }
            return null;
        });
    }

    protected abstract DataTypeComponent replace(int var1, DataType var2, int var3, String var4, String var5) throws InvalidDataTypeException;

    protected abstract boolean replaceRange(int var1, int var2, DataType var3, int var4, TaskMonitor var5) throws InvalidDataTypeException, InsufficientBytesException, CancelledException;

    @Override
    public DataTypeComponent replace(int rowIndex, DataType datatype, int length) throws UsrException {
        if (this.isEditingField()) {
            this.endFieldEditing();
        }
        if (rowIndex == this.getNumComponents()) {
            return this.insert(rowIndex, datatype, length);
        }
        DataTypeComponent oldDtc = this.getComponent(rowIndex);
        if (oldDtc == null) {
            return null;
        }
        this.checkIsAllowableDataType(datatype);
        int oldCompSize = oldDtc.getLength();
        int newCompSize = length;
        int sizeDiff = newCompSize - oldCompSize;
        if (!this.isAtEnd(rowIndex) && sizeDiff > 0) {
            this.checkForReplace(rowIndex, datatype, newCompSize);
        }
        DataTypeComponent dtc = this.replace(rowIndex, datatype, newCompSize, oldDtc.getFieldName(), oldDtc.getComment());
        this.fixSelection();
        this.selectionChanged();
        return dtc;
    }

    protected DataTypeComponent replaceComponentRange(int startRowIndex, int endRowIndex, DataType datatype, int length) throws UsrException {
        if (this.isEditingField()) {
            this.endFieldEditing();
        }
        if (!this.isShowingUndefinedBytes() && startRowIndex == this.getNumComponents()) {
            return this.insert(startRowIndex, datatype, length);
        }
        DataTypeComponent oldDtc = this.getComponent(startRowIndex);
        if (oldDtc == null) {
            throw new AssertException();
        }
        this.checkIsAllowableDataType(datatype);
        TaskMonitor monitor = TaskMonitor.DUMMY;
        this.replaceRange(startRowIndex, endRowIndex, datatype, length, monitor);
        DataTypeComponent dtc = this.getComponent(startRowIndex);
        try {
            dtc.setFieldName(oldDtc.getFieldName());
        }
        catch (DuplicateNameException e) {
            Msg.showError((Object)this, null, (String)"Unexcected Exception", (Object)"Exception applying field name", (Throwable)e);
        }
        dtc.setComment(oldDtc.getComment());
        this.fixSelection();
        this.selectionChanged();
        return dtc;
    }

    private void checkForReplace(int rowIndex, DataType datatype, int length) throws InvalidDataTypeException {
        DataTypeComponent dtc = this.getComponent(rowIndex);
        if (dtc == null) {
            throw new InvalidDataTypeException("Invalid component selection");
        }
        Composite composite = this.viewComposite;
        if (!(composite instanceof Structure)) {
            return;
        }
        Structure struct = (Structure)composite;
        if (struct.isPackingEnabled()) {
            return;
        }
        if (this.isAtEnd(rowIndex)) {
            return;
        }
        int newCompSize = length;
        int currentCompSize = dtc.getLength();
        int sizeDiff = newCompSize - currentCompSize;
        if (sizeDiff <= 0) {
            return;
        }
        int undefinedSpaceAvail = this.getNumUndefinedBytesAfter(dtc);
        if (sizeDiff > undefinedSpaceAvail) {
            int spaceNeeded = sizeDiff - undefinedSpaceAvail;
            String msg = newCompSize + " byte replacement at 0x" + Integer.toHexString(dtc.getOffset());
            if (struct.getDefinedComponentAtOrAfterOffset(dtc.getOffset() + 1) == null) {
                int suggestedSize = this.getLength() + spaceNeeded;
                throw new InvalidDataTypeException(msg + " requires structure length of " + suggestedSize + "-bytes.");
            }
            throw new InvalidDataTypeException(msg + " requires " + spaceNeeded + " additional undefined bytes.");
        }
    }

    protected final int getNumUndefinedBytesAfter(DataTypeComponent dtc) {
        if (!this.isShowingUndefinedBytes()) {
            throw new UnsupportedOperationException();
        }
        Composite composite = this.viewComposite;
        if (!(composite instanceof Structure)) {
            throw new UnsupportedOperationException();
        }
        Structure struct = (Structure)composite;
        if (struct.isPackingEnabled()) {
            throw new UnsupportedOperationException();
        }
        int length = this.getLength();
        int nextCompOffset = dtc.getEndOffset() + 1;
        if (nextCompOffset >= length) {
            return 0;
        }
        DataTypeComponent nextDefinedDtc = struct.getDefinedComponentAtOrAfterOffset(nextCompOffset);
        int nextDefinedOffset = nextDefinedDtc == null ? length : nextDefinedDtc.getOffset();
        return Math.max(0, nextDefinedOffset - nextCompOffset);
    }

    protected abstract void replaceOriginalComponents();

    @Override
    protected void checkIsAllowableDataType(DataType dataType) throws InvalidDataTypeException {
        super.checkIsAllowableDataType(dataType);
        if (dataType.equals((Object)this.viewComposite)) {
            String msg = "Data type \"" + dataType.getDisplayName() + "\" can't contain itself.";
            throw new InvalidDataTypeException(msg);
        }
        if (DataTypeUtilities.isSecondPartOfFirst((DataType)dataType, (DataType)this.viewComposite)) {
            String msg = "Data type \"" + dataType.getDisplayName() + "\" has \"" + this.viewComposite.getDisplayName() + "\" within it.";
            throw new InvalidDataTypeException(msg);
        }
    }

    private boolean shiftComponentsUp(int startRowIndex, int endRowIndex) {
        int numComps = this.getNumComponents();
        if (startRowIndex > endRowIndex || startRowIndex <= 0 || startRowIndex >= numComps || endRowIndex <= 0 || endRowIndex >= numComps) {
            return false;
        }
        return (Boolean)this.viewDTM.withTransaction("Shift Up", () -> {
            DataTypeComponent comp = this.getComponent(startRowIndex - 1);
            this.deleteComponent(startRowIndex - 1);
            try {
                this.insert(endRowIndex, comp.getDataType(), comp.getLength(), comp.getFieldName(), comp.getComment());
            }
            catch (InvalidDataTypeException e) {
                return false;
            }
            return true;
        });
    }

    private boolean shiftComponentsDown(int startRowIndex, int endRowIndex) {
        int numComps = this.getNumComponents();
        if (startRowIndex > endRowIndex || startRowIndex < 0 || startRowIndex >= numComps - 1 || endRowIndex < 0 || endRowIndex >= numComps - 1) {
            return false;
        }
        return (Boolean)this.viewDTM.withTransaction("Shift Down", () -> {
            DataTypeComponent comp = this.getComponent(endRowIndex + 1);
            this.deleteComponent(endRowIndex + 1);
            try {
                this.insert(startRowIndex, comp.getDataType(), comp.getLength(), comp.getFieldName(), comp.getComment());
            }
            catch (InvalidDataTypeException e) {
                return false;
            }
            return true;
        });
    }

    @Override
    public boolean moveUp() throws NoSuchElementException {
        if (this.selection.getNumRanges() != 1) {
            return false;
        }
        if (this.isEditingField()) {
            this.endFieldEditing();
        }
        FieldRange range = this.selection.getFieldRange(0);
        int startIndex = range.getStart().getIndex().intValue();
        int endIndex = range.getEnd().getIndex().intValue() - 1;
        int numSelected = endIndex - startIndex + 1;
        boolean moved = false;
        int newIndex = startIndex - 1;
        moved = this.shiftComponentsUp(startIndex, endIndex);
        if (moved) {
            FieldSelection tmpFieldSelection = new FieldSelection();
            tmpFieldSelection.addRange(newIndex, newIndex + numSelected);
            this.setSelection(tmpFieldSelection);
        }
        return moved;
    }

    @Override
    public boolean moveDown() throws NoSuchElementException {
        if (this.selection.getNumRanges() != 1) {
            return false;
        }
        if (this.isEditingField()) {
            this.endFieldEditing();
        }
        FieldRange range = this.selection.getFieldRange(0);
        int startIndex = range.getStart().getIndex().intValue();
        int endIndex = range.getEnd().getIndex().intValue() - 1;
        int numSelected = endIndex - startIndex + 1;
        boolean moved = false;
        int newIndex = startIndex + 1;
        moved = this.shiftComponentsDown(startIndex, endIndex);
        if (moved) {
            FieldSelection tmpFieldSelection = new FieldSelection();
            tmpFieldSelection.addRange(newIndex, newIndex + numSelected);
            this.setSelection(tmpFieldSelection);
        }
        return moved;
    }

    @Override
    public void duplicateMultiple(int rowIndex, int multiple, TaskMonitor monitor) throws UsrException {
        DataTypeComponent originalComp = this.getComponent(rowIndex);
        DataType dt = originalComp.getDataType();
        int dtLen = originalComp.getLength();
        this.insertComponentMultiple(rowIndex + 1, dt, dtLen, multiple, monitor);
        this.setSelection(new int[]{rowIndex + multiple});
        this.lastNumDuplicates = multiple;
    }

    @Override
    protected void createArray(int numElements) throws InvalidDataTypeException, UsrException {
        if (this.selection.getNumRanges() != 1) {
            throw new UsrException("Can only create arrays on a contiguous selection.");
        }
        int rowIndex = this.selection.getFieldRange(0).getStart().getIndex().intValue();
        DataTypeComponent comp = this.getComponent(rowIndex);
        if (comp == null) {
            throw new UsrException("A component must be selected.");
        }
        if (this.isEditingField()) {
            this.endFieldEditing();
        }
        DataType dt = comp.getDataType();
        ArrayDataType array = new ArrayDataType(dt, numElements, comp.getLength(), (DataTypeManager)this.viewDTM);
        this.viewDTM.withTransaction("Create Array", () -> {
            if (this.getNumSelectedComponentRows() > 1) {
                this.replaceComponentRange(rowIndex, this.selection.getFieldRange(0).getEnd().getIndex().intValue() - 1, (DataType)array, array.getLength());
            } else {
                this.replace(rowIndex, (DataType)array, array.getLength());
            }
        });
        this.componentEdited();
    }

    protected boolean isAtEnd(int rowIndex) {
        int numRowComponents = this.getNumComponents();
        if (rowIndex < 0) {
            return false;
        }
        if (rowIndex >= numRowComponents) {
            return true;
        }
        return rowIndex + 1 == numRowComponents;
    }

    protected int consumeByComponent(int rowIndex) {
        int numComps = this.viewComposite.getNumComponents();
        if (rowIndex >= 0 && rowIndex < numComps) {
            DataTypeComponent comp = this.viewComposite.getComponent(rowIndex);
            int compLen = comp.getLength();
            DataType dt = comp.getDataType();
            int dtLen = dt.getLength();
            if (dtLen > compLen) {
                this.viewComposite.dataTypeSizeChanged(dt);
                comp = this.viewComposite.getComponent(rowIndex);
                int diff = comp.getLength() - compLen;
                if (diff > 0) {
                    int first = rowIndex + 1;
                    int last = rowIndex + diff;
                    this.selection.removeRange(first, last);
                    this.adjustSelection(first, 0 - diff);
                }
                return diff;
            }
        }
        return 0;
    }

    @Override
    public int getRowCount() {
        int numRows = 0;
        if (this.viewComposite != null) {
            numRows = this.viewComposite.getNumComponents();
        }
        if (!this.isShowingUndefinedBytes()) {
            ++numRows;
        }
        return numRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object aValue, int rowIndex, int modelColumnIndex) {
        try {
            this.settingValueAt = true;
            this.fieldEdited(aValue, rowIndex, modelColumnIndex);
        }
        finally {
            this.settingValueAt = false;
        }
    }

    @Override
    public void setComponentDataTypeInstance(int rowIndex, DataType dt, int length) throws UsrException {
        if (this.getComponent(rowIndex) == null) {
            this.insert(rowIndex, dt, length);
        } else {
            this.replace(rowIndex, dt, length);
        }
    }

    @Override
    public void validateComponentName(int rowIndex, String name) throws UsrException {
        if (this.nameExistsElsewhere(name, rowIndex)) {
            throw new InvalidNameException("Name \"" + name + "\" already exists.");
        }
    }

    @Override
    public boolean setComponentName(int rowIndex, String name) throws InvalidNameException {
        String oldName = this.getComponent(rowIndex).getFieldName();
        if (Objects.equals(oldName, name)) {
            return false;
        }
        if (this.nameExistsElsewhere(name, rowIndex)) {
            throw new InvalidNameException("Name \"" + name + "\" already exists.");
        }
        return (Boolean)this.viewDTM.withTransaction("Set Component Name", () -> {
            try {
                this.getComponent(rowIndex).setFieldName(name);
                return true;
            }
            catch (DuplicateNameException exc) {
                throw new InvalidNameException(exc.getMessage());
            }
        });
    }

    @Override
    public boolean setComponentComment(int rowIndex, String comment) {
        String oldComment = this.getComponent(rowIndex).getComment();
        String newComment = comment;
        if (newComment.equals("")) {
            newComment = null;
        }
        if (Objects.equals(oldComment, newComment)) {
            return false;
        }
        this.viewDTM.withTransaction("Set Component Comment", () -> this.getComponent(rowIndex).setComment(comment));
        this.fireTableCellUpdated(rowIndex, this.getCommentColumn());
        this.componentDataChanged();
        return true;
    }

    @Override
    public boolean isMoveUpAllowed() {
        if (!this.isContiguousSelection()) {
            return false;
        }
        int start = this.selection.getFieldRange(0).getStart().getIndex().intValue();
        return start > 0 && start < this.getNumComponents();
    }

    @Override
    public boolean isMoveDownAllowed() {
        return this.isContiguousSelection() && this.selection.getFieldRange(0).getEnd().getIndex().intValue() < this.getNumComponents();
    }

    @Override
    public void restored(DataTypeManager dataTypeManager) {
        if (this.originalDTM == null) {
            return;
        }
        if (!this.originalCompositeExists()) {
            if (this.originalCompositeId != -1L && !this.hasChanges) {
                this.provider.dispose();
                return;
            }
            if (this.viewDTM.refreshDBTypesFromOriginal()) {
                this.setStatus("Dependency datatypes have changed or been removed");
            }
            if (this.originalCompositeId != -1L) {
                this.provider.show();
                String question = "The " + this.getOriginType() + " \"" + this.originalDTM.getName() + "\" has changed and \n\"" + this.currentName + "\" no longer exists outside the editor.\nDiscard edits and close the " + this.getTypeName() + " editor?";
                String title = "Close " + this.getTypeName() + " Editor?";
                int response = OptionDialog.showYesNoDialogWithNoAsDefaultButton((Component)this.provider.getComponent(), (String)title, (String)question);
                if (response == 1) {
                    this.provider.dispose();
                    return;
                }
                this.reloadFromView();
                return;
            }
            this.fireTableDataChanged();
            this.componentDataChanged();
            return;
        }
        Object composite = this.getOriginalComposite();
        boolean reload = true;
        if (this.hasChanges || !this.viewComposite.isEquivalent(composite)) {
            this.hasChanges = true;
            this.provider.show();
            String question = "The " + this.getOriginType() + " \"" + this.originalDTM.getName() + "\" has been restored.\n\"" + this.currentName + "\" may have changed outside the editor.\nDiscard edits and reload the " + this.getTypeName() + "?";
            String title = "Reload " + this.getTypeName() + " Editor?";
            int response = OptionDialog.showYesNoDialogWithNoAsDefaultButton((Component)this.provider.getComponent(), (String)title, (String)question);
            if (response != 1) {
                reload = false;
            }
        }
        if (reload) {
            this.originalDTM.removeDataTypeManagerListener((DataTypeManagerChangeListener)this);
            this.originalDTM.flushEvents();
            Swing.runLater(() -> this.load(composite));
            this.setStatus("Editor reloaded");
            return;
        }
        if (this.viewDTM.refreshDBTypesFromOriginal()) {
            this.setStatus("Dependency datatypes have changed or been removed");
        }
        this.fireTableDataChanged();
        this.componentDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataTypeRemoved(DataTypeManager dtm, DataTypePath path) {
        if (dtm != this.originalDTM) {
            throw new AssertException("Listener only supports original DTM");
        }
        if (!this.isLoaded()) {
            return;
        }
        DataType dataType = this.viewDTM.getDataType(path);
        if (dataType == null) {
            return;
        }
        if (!path.equals((Object)this.originalDataTypePath)) {
            if (!this.viewDTM.isViewDataTypeFromOriginalDTM(dataType)) {
                return;
            }
            if (this.hasSubDt(this.viewComposite, path)) {
                String msg = "Removed sub-component data type \"" + String.valueOf(path);
                this.setStatus(msg, true);
            }
            this.viewDTM.withTransaction("Removed Dependency", () -> {
                this.viewDTM.clearUndoOnChange();
                this.viewDTM.remove(dataType);
            });
            this.fireTableDataChanged();
            this.componentDataChanged();
            return;
        }
        if (this.originalCompositeId == -1L) {
            return;
        }
        this.consideringReplacedDataType = true;
        try {
            this.provider.show();
            String question = "The " + this.getOriginType() + " \"" + this.originalDTM.getName() + "\" has changed and \n\"" + this.getCompositeName() + "\" no longer exists outside the editor.\nDiscard edits and close the " + this.getTypeName() + " editor?";
            String title = "Close " + this.getTypeName() + " Editor?";
            int response = OptionDialog.showYesNoDialogWithNoAsDefaultButton((Component)this.provider.getComponent(), (String)title, (String)question);
            if (response == 1) {
                this.provider.closeComponent(true);
                return;
            }
            this.reloadFromView();
            this.setStatus("The original " + this.getTypeName() + " has been deleted");
        }
        finally {
            this.consideringReplacedDataType = false;
        }
    }

    public void dataTypeRenamed(DataTypeManager dtm, DataTypePath oldPath, DataTypePath newPath) {
        this.dataTypeMoved(dtm, oldPath, newPath);
    }

    public void dataTypeMoved(DataTypeManager dtm, DataTypePath oldPath, DataTypePath newPath) {
        if (dtm != this.originalDTM) {
            throw new AssertException("Listener only supports original DTM");
        }
        if (!this.isLoaded()) {
            return;
        }
        if (oldPath.equals((Object)newPath)) {
            return;
        }
        String newName = newPath.getDataTypeName();
        String oldName = oldPath.getDataTypeName();
        CategoryPath newCategoryPath = newPath.getCategoryPath();
        CategoryPath oldCategoryPath = oldPath.getCategoryPath();
        if (this.originalCompositeId != -1L && oldPath.equals((Object)this.originalDataTypePath)) {
            this.viewDTM.withTransaction("Name Changed", () -> {
                this.viewDTM.clearUndoOnChange();
                this.originalDataTypePath = newPath;
                try {
                    if (this.viewComposite.getName().equals(oldName)) {
                        this.setName(newName);
                    }
                    if (!newCategoryPath.equals((Object)oldCategoryPath)) {
                        this.viewComposite.setCategoryPath(newCategoryPath);
                    }
                }
                catch (InvalidNameException | DuplicateNameException e) {
                    Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                }
            });
            this.compositeInfoChanged();
        } else {
            DataType originalDt = this.originalDTM.getDataType(newPath);
            if (!(originalDt instanceof DatabaseObject)) {
                return;
            }
            DataType dt = this.viewDTM.findMyDataTypeFromOriginalID(this.originalDTM.getID(originalDt));
            if (dt == null) {
                return;
            }
            this.viewDTM.withTransaction("Renamed Dependency", () -> {
                this.viewDTM.clearUndoOnChange();
                try {
                    dt.setName(newName);
                    if (!newCategoryPath.equals((Object)oldCategoryPath)) {
                        dt.setCategoryPath(newCategoryPath);
                    }
                }
                catch (InvalidNameException | DuplicateNameException e) {
                    Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                }
            });
        }
        this.fireTableDataChanged();
        this.componentDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataTypeChanged(DataTypeManager dtm, DataTypePath path) {
        block18: {
            try {
                if (dtm != this.originalDTM) {
                    throw new AssertException("Listener only supports original DTM");
                }
                if (!this.isLoaded()) {
                    return;
                }
                if (path.equals((Object)this.originalDataTypePath)) {
                    if (this.consideringReplacedDataType) {
                        return;
                    }
                    if (this.originalIsChanging) {
                        return;
                    }
                    this.originalIsChanging = true;
                    try {
                        if (this.hasChanges) {
                            this.provider.show();
                            String message = "<html>" + HTMLUtilities.escapeHTML((String)this.originalDataTypePath.getDataTypeName()) + " has changed outside the editor.<br>Discard edits and reload the " + this.getTypeName() + "?";
                            String title = "Reload " + this.getTypeName() + " Editor?";
                            int response = OptionDialog.showYesNoDialogWithNoAsDefaultButton((Component)this.provider.getComponent(), (String)title, (String)message);
                            if (response == 1) {
                                this.originalDTM.removeDataTypeManagerListener((DataTypeManagerChangeListener)this);
                                this.originalDTM.flushEvents();
                                Swing.runLater(() -> this.load(this.getOriginalComposite()));
                            }
                        } else {
                            Object changedComposite = this.getOriginalComposite();
                            if (changedComposite != null && !this.viewComposite.isEquivalent(changedComposite)) {
                                this.originalDTM.removeDataTypeManagerListener((DataTypeManagerChangeListener)this);
                                this.originalDTM.flushEvents();
                                Swing.runLater(() -> this.load(this.getOriginalComposite()));
                                this.setStatus(this.viewComposite.getPathName() + " changed outside the editor.", false);
                            }
                        }
                        break block18;
                    }
                    finally {
                        this.originalIsChanging = false;
                    }
                }
                DataType changedDt = this.originalDTM.getDataType(path);
                if (!(changedDt instanceof DatabaseObject)) {
                    return;
                }
                DataType viewDt = this.viewDTM.findMyDataTypeFromOriginalID(this.originalDTM.getID(changedDt));
                if (viewDt == null) {
                    return;
                }
                try {
                    this.viewDTM.withTransaction("Changed " + String.valueOf(path), () -> {
                        this.viewDTM.clearUndoOnChange();
                        this.viewDTM.replaceDataType(viewDt, changedDt, true);
                    });
                }
                catch (DataTypeDependencyException e) {
                    throw new AssertException((Throwable)e);
                }
                this.viewDTM.clearUndo();
                this.fireTableDataChanged();
                this.componentDataChanged();
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataTypeReplaced(DataTypeManager dtm, DataTypePath oldPath, DataTypePath newPath, DataType newDataType) {
        if (dtm != this.originalDTM) {
            throw new AssertException("Listener only supports original DTM");
        }
        if (!this.isLoaded()) {
            return;
        }
        if (!oldPath.equals((Object)this.originalDataTypePath)) {
            DataType dt = this.viewDTM.getDataType(oldPath);
            if (dt == null || !this.viewDTM.isViewDataTypeFromOriginalDTM(dt)) {
                return;
            }
            if (this.hasSubDt(this.viewComposite, oldPath)) {
                String msg = "Replaced data type \"" + String.valueOf(oldPath) + "\", which is a sub-component of \"" + this.getOriginalDataTypeName() + "\".";
                this.setStatus(msg, true);
            }
            try {
                this.viewDTM.withTransaction("Replaced Dependency", () -> {
                    this.viewDTM.clearUndoOnChange();
                    this.viewDTM.replaceDataType(dt, newDataType, true);
                });
            }
            catch (DataTypeDependencyException e) {
                throw new AssertException((Throwable)e);
            }
            this.viewDTM.clearUndo();
            this.fireTableDataChanged();
            this.componentDataChanged();
            return;
        }
        this.consideringReplacedDataType = true;
        try {
            this.provider.show();
            if (this.hasChanges) {
                String message = "<html>" + HTMLUtilities.escapeHTML((String)oldPath.getPath()) + " has been replaced outside the editor.<br>Discard edits and close?</html>";
                String title = "Close " + this.getTypeName() + " Editor?";
                int response = OptionDialog.showYesNoDialogWithNoAsDefaultButton((Component)this.provider.getComponent(), (String)title, (String)message);
                if (response != 1) {
                    this.compositeInfoChanged();
                    return;
                }
            } else {
                String message = "<html>" + HTMLUtilities.escapeHTML((String)oldPath.getPath()) + " has been replaced outside the editor.</html>";
                Msg.showWarn((Object)this, (Component)this.provider.getComponent(), (String)("Closing " + this.getTypeName() + " Editor"), (Object)message);
            }
            this.provider.closeComponent(true);
        }
        finally {
            this.consideringReplacedDataType = false;
        }
    }

    @Override
    public void fireTableDataChanged() {
        this.updatingSelection(() -> {
            super.fireTableDataChanged();
            this.selectionChanged();
        });
    }

    @Override
    public int getMaxDuplicates(int rowIndex) {
        int numRowComponents = this.getNumComponents();
        if (rowIndex < 0 || rowIndex >= numRowComponents) {
            return 0;
        }
        DataTypeComponent dtc = this.getComponent(rowIndex);
        DataType dt = dtc.getDataType();
        int dtcLen = dtc.getLength();
        int maxDups = Integer.MAX_VALUE - this.getLength();
        if (dtcLen > 0) {
            maxDups /= dtcLen;
            if (dt != DataType.DEFAULT && this.isShowingUndefinedBytes() && !this.isAtEnd(rowIndex)) {
                maxDups = this.getNumUndefinedBytesAfter(dtc) / dtcLen;
            }
        }
        return maxDups;
    }

    @Override
    public int getMaxElements() {
        if (!this.isContiguousSelection()) {
            return 0;
        }
        int rowIndex = this.selection.getFieldRange(0).getStart().getIndex().intValue();
        if (rowIndex < this.getNumComponents()) {
            boolean singleLineSelection;
            DataTypeComponent comp = this.getComponent(rowIndex);
            DataType dt = comp.getDataType();
            int len = dt.getLength() > 0 ? dt.getLength() : comp.getLength();
            FieldRange range = this.getSelectedRangeContaining(rowIndex);
            boolean bl = singleLineSelection = this.getNumSelectedComponentRows() == 1;
            if (range != null && !singleLineSelection) {
                int numBytesInRange = this.getNumBytesInRange(range);
                return numBytesInRange / len;
            }
            return this.getMaxDuplicates(rowIndex) + 1;
        }
        return 0;
    }

    @Override
    public int getLastNumDuplicates() {
        return this.lastNumDuplicates;
    }

    protected int convertRowToOrdinal(int rowIndex) {
        return rowIndex;
    }

    protected boolean isSizeEditable() {
        return false;
    }

    @Override
    public boolean updateAndCheckChangeState() {
        if (this.originalIsChanging) {
            return false;
        }
        boolean compositeChanged = super.updateAndCheckChangeState();
        if (compositeChanged) {
            return true;
        }
        Object oldComposite = this.getOriginalComposite();
        if (oldComposite == null) {
            this.hasChanges = false;
            return this.hasChanges;
        }
        PackingType packingType = this.getPackingType();
        AlignmentType alignmentType = this.getAlignmentType();
        this.hasChanges = packingType != oldComposite.getPackingType() || alignmentType != oldComposite.getAlignmentType() || packingType == PackingType.EXPLICIT && this.getExplicitPackingValue() != oldComposite.getExplicitPackingValue() || alignmentType == AlignmentType.EXPLICIT && this.getExplicitMinimumAlignment() != oldComposite.getExplicitMinimumAlignment();
        return this.hasChanges;
    }

    public AlignmentType getAlignmentType() {
        return this.viewComposite.getAlignmentType();
    }

    public int getExplicitMinimumAlignment() {
        return this.viewComposite.getExplicitMinimumAlignment();
    }

    public void setAlignmentType(AlignmentType alignmentType, int explicitValue) {
        this.viewDTM.withTransaction("Set Alignment", () -> {
            AlignmentType currentAlignType = this.getAlignmentType();
            if (alignmentType == AlignmentType.DEFAULT) {
                if (currentAlignType == AlignmentType.DEFAULT) {
                    return;
                }
                this.viewComposite.setToDefaultAligned();
            } else if (alignmentType == AlignmentType.MACHINE) {
                if (currentAlignType == AlignmentType.MACHINE) {
                    return;
                }
                this.viewComposite.setToMachineAligned();
            } else {
                if (currentAlignType == AlignmentType.EXPLICIT && explicitValue == this.viewComposite.getExplicitMinimumAlignment()) {
                    return;
                }
                this.viewComposite.setExplicitMinimumAlignment(explicitValue);
            }
        });
        if (this.fixSelection()) {
            this.selectionChanged();
        }
        this.notifyCompositeChanged();
    }

    public boolean isPackingEnabled() {
        return this.viewComposite.isPackingEnabled();
    }

    public PackingType getPackingType() {
        return this.viewComposite.getPackingType();
    }

    public int getExplicitPackingValue() {
        return this.viewComposite.getExplicitPackingValue();
    }

    public void setPackingType(PackingType packingType, int explicitValue) {
        this.viewDTM.withTransaction("Set Packing", () -> {
            PackingType currentPacktype = this.getPackingType();
            if (packingType == PackingType.DISABLED) {
                if (currentPacktype == PackingType.DISABLED) {
                    return;
                }
                this.viewComposite.setPackingEnabled(false);
            } else if (packingType == PackingType.DEFAULT) {
                if (currentPacktype == PackingType.DEFAULT) {
                    return;
                }
                this.viewComposite.setToDefaultPacking();
            } else {
                if (currentPacktype == PackingType.EXPLICIT && explicitValue == this.viewComposite.getExplicitPackingValue()) {
                    return;
                }
                this.viewComposite.setExplicitPackingValue(explicitValue);
            }
        });
        if (this.fixSelection()) {
            this.selectionChanged();
        }
        this.notifyCompositeChanged();
    }

    public int getActualAlignment() {
        return this.viewComposite.getAlignment();
    }
}

