/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data;

import ghidra.framework.cmd.Command;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.listing.Program;

public abstract class AbstractCreateStructureCmd
implements Command<Program> {
    private String statusMessage;
    private String structureName;
    private DataType newDataType;
    private Address structureAddress;

    AbstractCreateStructureCmd(String name, Address address) {
        this.structureAddress = address;
        this.structureName = name;
    }

    public boolean applyTo(Program program) {
        try {
            Structure structure = this.createStructure(this.structureAddress, program);
            this.setNewDataType(this.initializeStructureData(program, structure));
        }
        catch (IllegalArgumentException iae) {
            this.setStatusMsg(iae.getMessage());
            return false;
        }
        return true;
    }

    abstract Structure createStructure(Address var1, Program var2) throws IllegalArgumentException;

    abstract DataType initializeStructureData(Program var1, Structure var2);

    void setNewDataType(DataType dataType) {
        this.newDataType = dataType;
    }

    public DataType getNewDataType() {
        return this.newDataType;
    }

    Address getStructureAddress() {
        return this.structureAddress;
    }

    void setStatusMsg(String message) {
        this.statusMessage = message;
    }

    public String getStatusMsg() {
        return this.statusMessage;
    }

    String getStructureName() {
        return this.structureName;
    }

    public String getName() {
        return "Create Structure";
    }
}

