/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.decompiler.DecompInterface;
import ghidra.app.decompiler.DecompileOptions;
import ghidra.app.decompiler.DecompileResults;
import ghidra.app.decompiler.parallel.DecompileConfigurer;
import ghidra.app.decompiler.parallel.DecompilerCallback;
import ghidra.app.decompiler.parallel.ParallelDecompiler;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_Constants;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.PcodeOpAST;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ObjectiveC2_DecompilerMessageAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "Objective-C 2 Decompiler Message";
    private static final String DESCRIPTION = "An analyzer for extracting Objective-C 2.0 message information.";
    private final int MAX_RECURSION_DEPTH = 10;

    public ObjectiveC2_DecompilerMessageAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.FUNCTION_ANALYZER);
        this.setDefaultEnablement(true);
        this.setPriority(new AnalysisPriority(10000000));
    }

    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.initialize(set.getNumAddresses());
        AddressIterator iterator = set.getAddresses(true);
        ArrayList<Function> functions = new ArrayList<Function>();
        while (iterator.hasNext() && !monitor.isCancelled()) {
            monitor.incrementProgress(1L);
            Address address = iterator.next();
            Function function = program.getListing().getFunctionAt(address);
            if (!this.isFunctionInTextSection(program, function)) continue;
            functions.add(function);
        }
        try {
            this.runDecompilerAnalysis(program, functions, monitor);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public boolean canAnalyze(Program program) {
        return ObjectiveC2_Constants.isObjectiveC2((Program)program);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDecompilerAnalysis(final Program program, List<Function> functions, final TaskMonitor monitor) throws InterruptedException, Exception {
        DecompileConfigurer configurer = decompiler -> this.setupDecompiler(program, decompiler);
        DecompilerCallback<Void> callback = new DecompilerCallback<Void>(program, configurer){

            @Override
            public Void process(DecompileResults results, TaskMonitor m) throws Exception {
                ObjectiveC2_DecompilerMessageAnalyzer.this.inspectFunction(program, results, monitor);
                return null;
            }
        };
        try {
            ParallelDecompiler.decompileFunctions(callback, functions, monitor);
        }
        finally {
            callback.dispose();
        }
    }

    private void inspectFunction(Program program, DecompileResults results, TaskMonitor monitor) {
        String currentClassName = null;
        String currentMethodName = null;
        HighFunction highFunction = results.getHighFunction();
        if (highFunction == null) {
            return;
        }
        Function function = results.getFunction();
        Iterator pcodeOps = highFunction.getPcodeOps();
        while (pcodeOps.hasNext()) {
            int paramStart;
            Varnode[] inputs;
            if (monitor.isCancelled()) {
                return;
            }
            currentClassName = null;
            currentMethodName = null;
            PcodeOpAST op = (PcodeOpAST)pcodeOps.next();
            String mnemonic = op.getMnemonic();
            if (mnemonic == null || !mnemonic.equals("CALL") && !mnemonic.equals("CALLIND") || !this.isObjcCall(program, (inputs = op.getInputs())[0], monitor)) continue;
            boolean isStret = this.isStretCall(program, inputs[0], monitor);
            for (int i = 1; i < inputs.length; ++i) {
                boolean isClass = this.isClass(i, isStret);
                boolean isMessage = this.isMessage(i, isStret);
                String name = this.getNameForVarnode(program, function, inputs[i], isClass, isMessage, 0, 1, monitor);
                if (isClass) {
                    currentClassName = name;
                } else if (isMessage) {
                    currentMethodName = name;
                }
                if (currentClassName != null && currentMethodName != null) break;
            }
            if (currentClassName == null || currentMethodName == null) continue;
            ArrayList<String> parameters = new ArrayList<String>();
            for (int i = paramStart = isStret ? 4 : 3; i < inputs.length; ++i) {
                String paramValue = this.getNameForVarnode(program, function, inputs[i], false, false, 0, 1, monitor);
                parameters.add(this.getIvarNameFromQualifiedName(paramValue));
            }
            this.setCommentAndReference(program, currentClassName, currentMethodName, op, parameters);
        }
    }

    private void setCommentAndReference(Program program, String currentClassName, String currentMethodName, PcodeOpAST op, List<String> parameters) {
        Address objcCallAddress = op.getSeqnum().getTarget();
        objcCallAddress = this.getAddressInProgram(program, objcCallAddress.getOffset());
        Instruction instruction = program.getListing().getInstructionAt(objcCallAddress);
        String fullyQualifiedName = currentClassName;
        if (currentClassName.contains("::")) {
            currentClassName = this.getClassNameFromQualifiedName(fullyQualifiedName);
        }
        this.setReference(objcCallAddress, program, currentClassName, (String)currentMethodName);
        if (instruction == null) {
            return;
        }
        if (instruction.getComment(CommentType.EOL) != null) {
            return;
        }
        currentClassName = this.getIvarNameFromQualifiedName(fullyQualifiedName);
        currentMethodName = (String)currentMethodName + (((String)currentMethodName).contains(":") ? "]" : " ]");
        String[] split = ((String)currentMethodName).split(":");
        StringBuilder builder = new StringBuilder();
        builder.append("[" + currentClassName + " " + split[0]);
        for (int i = 1; i < split.length; ++i) {
            try {
                builder.append(":" + parameters.get(i - 1) + " ");
            }
            catch (Exception e) {
                builder.append(":<<unknown>> ");
            }
            builder.append(split[i]);
        }
        builder.delete(builder.length() - 2, builder.length() - 1);
        instruction.setComment(CommentType.EOL, builder.toString());
    }

    private boolean isObjcCall(Program program, Varnode input, TaskMonitor monitor) {
        Address address = this.getAddressFromVarnode(program, input, 0, monitor);
        if (address == null) {
            return false;
        }
        Symbol symbol = this.getSymbolFromVarnode(program, input, monitor);
        return this.isObjcNameMatch(symbol);
    }

    private Address getAddressFromVarnode(Program program, Varnode input, int depth, TaskMonitor monitor) {
        if (monitor.isCancelled()) {
            return null;
        }
        if (input == null) {
            return null;
        }
        if (depth >= 10) {
            return null;
        }
        if (!input.isAddress() && !input.isConstant()) {
            Varnode[] inputs;
            PcodeOp def = input.getDef();
            if (def == null) {
                return null;
            }
            for (Varnode subInput : inputs = def.getInputs()) {
                if (monitor.isCancelled()) {
                    return null;
                }
                Address address = this.getAddressFromVarnode(program, subInput, depth + 1, monitor);
                if (address == null || (address = this.getAddressInProgram(program, address.getOffset())) == null || !program.getMemory().contains(address)) continue;
                return address;
            }
        }
        return input.getAddress();
    }

    private Symbol getSymbolFromVarnode(Program program, Varnode input, TaskMonitor monitor) {
        Address address = this.getAddressFromVarnode(program, input, 0, monitor);
        if (address == null) {
            return null;
        }
        SymbolTable symbolTable = program.getSymbolTable();
        Symbol symbol = symbolTable.getPrimarySymbol(address);
        return symbol;
    }

    private String getNameForVarnode(Program program, Function function, Varnode input, boolean isClass, boolean isMethod, int depth, int numInputs, TaskMonitor monitor) {
        try {
            int index;
            PcodeOp def;
            if (depth >= 10) {
                return "<<unknown>>";
            }
            String name = null;
            if (input == null) {
                return null;
            }
            if (input.isAddress() || input.isConstant()) {
                long offset = input.getOffset();
                name = this.getNameFromOffset(program, offset, input, isClass, isMethod);
            }
            if ((def = input.getDef()) == null) {
                if (name == null) {
                    name = this.getParamNameOrOffset(function, input, isClass, isMethod, numInputs);
                }
                return name;
            }
            if (this.isSuper2Call(program, input) && !isMethod) {
                name = this.getSuperClassName(program, input, function);
                return name;
            }
            Varnode[] inputs = def.getInputs();
            if (this.isObjcCall(program, inputs[0], monitor)) {
                Symbol objcSymbol = this.getSymbolFromVarnode(program, inputs[0], monitor);
                int classIndex = 1;
                if (objcSymbol.getName().contains("stret")) {
                    classIndex = 2;
                }
                if (inputs.length <= classIndex) {
                    PcodeOp callDefinition = inputs[0].getDef();
                    if (callDefinition == null) {
                        return null;
                    }
                    inputs = new Varnode[]{callDefinition.getInput(classIndex)};
                } else {
                    inputs = new Varnode[]{inputs[classIndex]};
                }
                numInputs = 1;
            }
            if ((index = this.getIndexOfAddress(inputs)) != -1 && (name = this.getNameFromOffset(program, inputs[index].getOffset(), input, isClass, isMethod)) != null) {
                return name;
            }
            for (Varnode subInput : inputs) {
                if (name != null && !this.stringIsLong(name)) break;
                name = this.getNameForVarnode(program, function, subInput, isClass, isMethod, depth + 1, inputs.length, monitor);
            }
            return name;
        }
        catch (Exception e) {
            return null;
        }
    }

    private int getIndexOfAddress(Varnode[] inputs) {
        for (int i = 0; i < inputs.length; ++i) {
            if (inputs[i] == null || !inputs[i].isAddress()) continue;
            return i;
        }
        return -1;
    }

    private String getSuperClassName(Program program, Varnode input, Function function) {
        String name = null;
        SymbolTable symbolTable = program.getSymbolTable();
        Namespace namespace = function.getParentNamespace();
        SymbolIterator symbolIt = symbolTable.getSymbols(namespace.getName());
        while (symbolIt.hasNext()) {
            Symbol symbol = symbolIt.next();
            Address address = symbol.getAddress();
            MemoryBlock block = program.getMemory().getBlock(address);
            if (!this.isObjcDataBlock(block)) continue;
            Data data = program.getListing().getDataAt(address);
            Data superClassData = data.getComponent(1);
            name = this.getNameFromData(program, input, true, false, address, superClassData);
        }
        return name;
    }

    private String getParamNameOrOffset(Function function, Varnode input, boolean isClass, boolean isMethod, int numInputs) {
        Object name = null;
        HighVariable highVar = input.getHigh();
        if (highVar != null && (name = highVar.getName()) != null && ((String)name).equals("param_1")) {
            if (numInputs == 1) {
                Namespace namespace;
                if (isClass && (namespace = function.getParentNamespace()) != null) {
                    name = namespace.getName();
                }
            } else {
                name = null;
            }
        }
        if (name == null && !isClass && !isMethod) {
            name = "0x" + Long.toString(input.getOffset(), 16);
        }
        return name;
    }

    private boolean stringIsLong(String value) {
        if (value.startsWith("0x")) {
            value = value.substring(2);
        }
        try {
            Long.parseUnsignedLong(value, 16);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private String getNameFromOffset(Program program, long offset, Varnode input, boolean isClass, boolean isMethod) {
        Object name;
        Address address = this.getAddressInProgram(program, offset);
        if (address == null) {
            return null;
        }
        MemoryBlock block = program.getMemory().getBlock(address);
        if (block == null) {
            return null;
        }
        if (this.isIvarBlock(block) || this.isObjcConstBlock(block)) {
            name = this.getIvarName(program, address);
        } else if (this.isMessageRefsBlock(block)) {
            name = this.getFixupMethodName(program, address);
        } else if (this.isCFStringBlock(block)) {
            name = this.getCFString(program, address);
            if (name != null) {
                if (((String)name).startsWith("\\")) {
                    name = "\\" + (String)name;
                }
                name = "\"" + (String)name + "\"";
            }
        } else if (this.isDataBlock(block)) {
            name = this.getDataName(program, address);
            if (name != null) {
                if (((String)name).startsWith("\\")) {
                    name = "\\" + (String)name;
                }
                name = "\"" + (String)name + "\"";
            }
        } else {
            Data nameData = program.getListing().getDataAt(address);
            if (nameData == null) {
                Function function = program.getListing().getFunctionAt(address);
                if (function != null && !function.getName().contains("_objc_msgSend")) {
                    DataType returnType = function.getReturnType();
                    String name2 = returnType.getName();
                    return name2;
                }
                return null;
            }
            name = this.getNameFromData(program, input, isClass, isMethod, address, nameData);
        }
        return name;
    }

    private String getIvarNameFromQualifiedName(String qualifiedName) {
        String iVarName = qualifiedName;
        if (qualifiedName == null) {
            return null;
        }
        if (qualifiedName.contains("::")) {
            String[] classParts = qualifiedName.split("::");
            iVarName = classParts[1];
        }
        return iVarName;
    }

    private String getClassNameFromQualifiedName(String qualifiedName) {
        String className = qualifiedName;
        if (qualifiedName.contains("::")) {
            String[] classParts = qualifiedName.split("::");
            className = classParts[1];
        }
        return className;
    }

    private String getNameFromData(Program program, Varnode input, boolean isClass, boolean isMethod, Address address, Data nameData) {
        Object name;
        if (!nameData.isDefined()) {
            name = this.getLabelFromUndefinedData(program, address);
        } else {
            Object dataValue = nameData.getValue();
            if (dataValue instanceof String) {
                name = (String)dataValue;
                if (!isClass && !isMethod) {
                    name = "\"" + (String)name + "\"";
                }
            } else if (dataValue instanceof Address) {
                long offset = ((Address)dataValue).getOffset();
                name = offset == address.getOffset() ? null : this.getNameFromOffset(program, offset, input, isClass, isMethod);
            } else {
                name = this.getClassName(program, address);
                if (name == null) {
                    name = this.getValueAtAddress(program, address);
                }
            }
        }
        return name;
    }

    private String getDataName(Program program, Address address) {
        String name = null;
        Data data = program.getListing().getDataAt(address);
        Address nameAddress = null;
        if (data.isPointer()) {
            Object value = data.getValue();
            nameAddress = (Address)value;
        } else {
            Data namePointerData = data.getComponent(1);
            if (namePointerData == null) {
                return null;
            }
            Object namePointerValue = namePointerData.getValue();
            nameAddress = (Address)namePointerValue;
        }
        Data nameData = program.getListing().getDataAt(nameAddress);
        Object nameValue = nameData.getValue();
        if (nameValue instanceof String) {
            name = (String)nameValue;
        } else if (this.isCFStringBlock(program.getMemory().getBlock(nameAddress))) {
            name = this.getCFString(program, nameAddress);
        }
        return name;
    }

    private String getValueAtAddress(Program program, Address address) {
        String value = null;
        Data data = program.getListing().getDataAt(address);
        Object dataValue = data.getValue();
        if (dataValue instanceof Scalar) {
            value = dataValue.toString();
        }
        return value;
    }

    private String getCFString(Program program, Address address) {
        String name = null;
        Data cfStringData = program.getListing().getDataAt(address);
        Data stringPointer = cfStringData.getComponent(2);
        Object pointerValue = stringPointer.getValue();
        Data stringData = program.getListing().getDataAt((Address)pointerValue);
        Object stringValue = stringData.getValue();
        if (stringValue instanceof String) {
            name = (String)stringValue;
        }
        return name;
    }

    private String getIvarName(Program program, Address address) {
        Listing listing = program.getListing();
        Data ivarOffset = listing.getDataAt(address);
        ReferenceIterator references = ivarOffset.getReferenceIteratorTo();
        while (references.hasNext()) {
            Reference reference = references.next();
            Address fromAddress = reference.getFromAddress();
            MemoryBlock block = program.getMemory().getBlock(fromAddress);
            if (!block.getName().equals("__objc_const")) continue;
            Data ivarList = listing.getDataContaining(fromAddress);
            int numComponents = ivarList.getNumComponents();
            for (int i = 2; i < numComponents; ++i) {
                Data nameDataPointer;
                Object nameAddress;
                Data ivarData = ivarList.getComponent(i);
                Address ivarAddress = ivarData.getAddress();
                if (!ivarAddress.equals((Object)fromAddress)) continue;
                Data typeDataPointer = ivarData.getComponent(2);
                Object typeAddress = typeDataPointer.getValue();
                String className = null;
                if (typeAddress instanceof Address) {
                    Data typeData = listing.getDataAt((Address)typeAddress);
                    className = this.getClassNameFromIvarData(typeData);
                }
                if (className == null) {
                    className = "";
                }
                if (!((nameAddress = (nameDataPointer = ivarData.getComponent(1)).getValue()) instanceof Address)) continue;
                Data nameData = listing.getDataAt((Address)nameAddress);
                String ivarName = (String)nameData.getValue();
                return className + "::" + ivarName;
            }
        }
        return null;
    }

    private String getClassNameFromIvarData(Data typeData) {
        Object typeValue = typeData.getValue();
        String type = null;
        if (typeValue instanceof String) {
            type = (String)typeValue;
            if (type.startsWith("@\"")) {
                type = type.substring(2, type.length() - 1);
            } else if (type.startsWith("_")) {
                type = type.substring(1);
            }
        }
        return type;
    }

    private String getFixupMethodName(Program program, Address address) {
        String name = null;
        Data fixupData = program.getListing().getDataAt(address);
        Data messageNamePointer = fixupData.getComponent(1);
        Object messageNameAddress = messageNamePointer.getValue();
        Data messageNameData = program.getListing().getDataAt((Address)messageNameAddress);
        name = (String)messageNameData.getValue();
        return name;
    }

    private Address getAddressInProgram(Program program, long offset) {
        Address address;
        try {
            address = program.getAddressFactory().getDefaultAddressSpace().getAddress(offset);
        }
        catch (AddressOutOfBoundsException e) {
            address = null;
        }
        catch (Exception e) {
            address = null;
        }
        return address;
    }

    private void setReference(Address fromAddress, Program program, String currentClassName, String currentMethodName) {
        SymbolTable symbolTable = program.getSymbolTable();
        Symbol classSymbol = symbolTable.getClassSymbol(currentClassName, (Namespace)null);
        if (classSymbol == null) {
            return;
        }
        Namespace namespace = (Namespace)classSymbol.getObject();
        List functionSymbols = symbolTable.getSymbols(currentMethodName, namespace);
        if (functionSymbols.size() == 1) {
            Address toAddress = ((Symbol)functionSymbols.get(0)).getAddress();
            ReferenceManager referenceManager = program.getReferenceManager();
            Reference reference = referenceManager.addMemoryReference(fromAddress, toAddress, (RefType)RefType.UNCONDITIONAL_CALL, SourceType.ANALYSIS, 0);
            referenceManager.setPrimary(reference, true);
        }
    }

    private String getLabelFromUndefinedData(Program program, Address address) {
        Symbol primary = program.getSymbolTable().getPrimarySymbol(address);
        if (primary == null) {
            return null;
        }
        String symbolName = primary.getName();
        if (symbolName.contains("_OBJC_CLASS_$_")) {
            symbolName = symbolName.substring("_OBJC_CLASS_$_".length());
        } else if (symbolName.contains("_objc_msgSend")) {
            return null;
        }
        return symbolName;
    }

    private String getClassName(Program program, Address toAddress) {
        try {
            boolean is32Bit = false;
            int pointerSize = program.getAddressFactory().getDefaultAddressSpace().getPointerSize();
            if (pointerSize * 8 == 32) {
                is32Bit = true;
            }
            int nameIndex = is32Bit ? 4 : 3;
            Data classData = program.getListing().getDefinedDataAt(toAddress);
            Data classRwPointerData = classData.getComponent(4);
            Address classRwPointerAddress = (Address)classRwPointerData.getValue();
            Memory memory = program.getMemory();
            MemoryBlock block = memory.getBlock(classRwPointerAddress);
            if (!this.isObjcConstBlock(block)) {
                return null;
            }
            Data classRwData = program.getListing().getDefinedDataAt(classRwPointerAddress);
            Data classNamePointerData = classRwData.getComponent(nameIndex);
            Address classNameAddress = (Address)classNamePointerData.getValue();
            block = memory.getBlock(classNameAddress);
            if (!this.isCStringBlock(block) && !this.isClassNameBlock(block)) {
                return null;
            }
            Data classNameData = program.getListing().getDefinedDataAt(classNameAddress);
            String className = (String)classNameData.getValue();
            return className;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean isFunctionInTextSection(Program program, Function function) {
        if (function == null) {
            return false;
        }
        Address address = function.getEntryPoint();
        Memory memory = program.getMemory();
        MemoryBlock block = memory.getBlock(address);
        return block.getName().equals("__text");
    }

    private boolean isClass(int index, boolean isStret) {
        boolean isClass = isStret ? index == 2 : index == 1;
        return isClass;
    }

    private boolean isMessage(int index, boolean isStret) {
        boolean isMessage = isStret ? index == 3 : index == 2;
        return isMessage;
    }

    private boolean isStretCall(Program program, Varnode input, TaskMonitor monitor) {
        Address address = this.getAddressFromVarnode(program, input, 0, monitor);
        if (address == null) {
            return false;
        }
        Symbol symbol = this.getSymbolFromVarnode(program, input, monitor);
        return symbol.getName().contains("stret");
    }

    private boolean isSuper2Call(Program program, Varnode input) {
        PcodeOp op = input.getLoneDescend();
        if (op != null && op.getOpcode() == 7) {
            Varnode calledAddress = op.getInput(0);
            long offset = calledAddress.getOffset();
            Address address = this.getAddressInProgram(program, offset);
            if (address == null) {
                return false;
            }
            Function function = program.getListing().getFunctionAt(address);
            if (function.getName().equals("_objc_msgSendSuper2")) {
                return true;
            }
        }
        return false;
    }

    private boolean isObjcNameMatch(Symbol symbol) {
        if (symbol == null) {
            return false;
        }
        String name = symbol.getName();
        return name.startsWith("_objc_msgSend") || name.equals("_read$UNIX2003");
    }

    private boolean isMessageRefsBlock(MemoryBlock block) {
        return block.getName().equals("__objc_msgrefs");
    }

    private boolean isClassNameBlock(MemoryBlock block) {
        return block != null && block.getName().equals("__objc_classname");
    }

    private boolean isCStringBlock(MemoryBlock block) {
        return block != null && block.getName().equals("__cstring");
    }

    private boolean isCFStringBlock(MemoryBlock block) {
        return block != null && block.getName().equals("__cfstring");
    }

    private boolean isDataBlock(MemoryBlock block) {
        return block != null && block.getName().equals("__data");
    }

    private boolean isObjcDataBlock(MemoryBlock block) {
        return block != null && block.getName().equals("__objc_data");
    }

    private boolean isIvarBlock(MemoryBlock block) {
        return block != null && block.getName().equals("__objc_ivar");
    }

    private boolean isObjcConstBlock(MemoryBlock block) {
        return block != null && block.getName().equals("__objc_const");
    }

    private void setupDecompiler(Program p, DecompInterface decompiler) {
        decompiler.toggleCCode(false);
        decompiler.toggleSyntaxTree(true);
        decompiler.setSimplificationStyle("decompile");
        DecompileOptions options = new DecompileOptions();
        options.grabFromProgram(p);
        options.setEliminateUnreachable(false);
        decompiler.setOptions(options);
    }
}

