/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.mvc;

import ghidra.app.plugin.core.functiongraph.mvc.EmptyFunctionGraphData;
import ghidra.app.plugin.core.functiongraph.mvc.FGController;
import ghidra.app.plugin.core.functiongraph.mvc.FGData;
import ghidra.app.plugin.core.functiongraph.mvc.FunctionGraphRunnable;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.task.MonitoredRunnable;
import ghidra.util.task.RunManager;
import ghidra.util.task.SwingUpdateManager;
import javax.swing.JComponent;

public class FGModel {
    private final FGController controller;
    private SwingUpdateManager updateManager;
    private RunManager runManager;
    private volatile FunctionGraphRunnable pendingGraphRunnable;
    private volatile FunctionGraphRunnable currentGraphRunnable;

    public FGModel(FGController controller) {
        this.controller = controller;
        this.runManager = new RunManager("Graph Builder", null);
        this.updateManager = new SwingUpdateManager(500, () -> this.doPendingFunctionGraph());
    }

    JComponent getTaskMonitorComponent() {
        return this.runManager.getMonitorComponent();
    }

    void reset() {
        this.updateManager.stop();
        this.cleanupCurrentRunnableState();
        this.cancelAll();
    }

    void cleanup() {
        this.reset();
    }

    synchronized void graphFunction(Program program, ProgramLocation location) {
        if (this.currentRunnableContainsLocation(location)) {
            return;
        }
        this.pendingGraphRunnable = new FunctionGraphRunnable(this.controller, program, location);
        this.updateManager.update();
    }

    private boolean currentRunnableContainsLocation(ProgramLocation location) {
        if (this.pendingGraphRunnable != null) {
            return false;
        }
        if (this.currentGraphRunnable == null) {
            return false;
        }
        return this.currentGraphRunnable.containsLocation(location);
    }

    private synchronized void cleanupCurrentRunnableState() {
        this.currentGraphRunnable = null;
    }

    synchronized void cancelAll() {
        if (this.pendingGraphRunnable != null) {
            this.pendingGraphRunnable = null;
        }
        this.runManager.cancelAllRunnables();
    }

    private synchronized void doPendingFunctionGraph() {
        if (this.pendingGraphRunnable == null) {
            return;
        }
        this.currentGraphRunnable = this.pendingGraphRunnable;
        this.pendingGraphRunnable = null;
        this.controller.setFunctionGraphData(new EmptyFunctionGraphData("Graphing function at " + String.valueOf(this.currentGraphRunnable.getLocation().getAddress())));
        this.runManager.runNow((MonitoredRunnable)this.currentGraphRunnable, "Graph Function", 500);
    }

    synchronized void setFunctionGraphData(FunctionGraphRunnable graphRunnable, FGData graphData) {
        if (this.currentGraphRunnable != graphRunnable) {
            return;
        }
        this.currentGraphRunnable = null;
        this.controller.setFunctionGraphData(graphData);
    }

    synchronized boolean isBusy() {
        return this.currentGraphRunnable != null || this.pendingGraphRunnable != null;
    }
}

