/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.symbol;

import ghidra.program.model.symbol.RefType;

public final class FlowType
extends RefType {
    private final boolean hasFall;
    private final boolean isCall;
    private final boolean isJump;
    private final boolean isTerminal;
    private final boolean isConditional;
    private final boolean isComputed;
    private final boolean isOverride;

    private FlowType(Builder builder) {
        super(builder.type, builder.name);
        this.hasFall = builder.hasFall;
        this.isCall = builder.isCall;
        this.isJump = builder.isJump;
        this.isTerminal = builder.isTerminal;
        this.isComputed = builder.isComputed;
        this.isConditional = builder.isConditional;
        this.isOverride = builder.isOverride;
    }

    @Override
    public boolean hasFallthrough() {
        return this.hasFall;
    }

    @Override
    public boolean isCall() {
        return this.isCall;
    }

    @Override
    public boolean isComputed() {
        return this.isComputed;
    }

    @Override
    public boolean isConditional() {
        return this.isConditional;
    }

    @Override
    public boolean isFlow() {
        return true;
    }

    @Override
    public boolean isJump() {
        return this.isJump;
    }

    @Override
    public boolean isTerminal() {
        return this.isTerminal;
    }

    @Override
    public boolean isUnConditional() {
        return !this.isConditional;
    }

    @Override
    public boolean isOverride() {
        return this.isOverride;
    }

    protected static class Builder {
        private byte type;
        private String name;
        private boolean hasFall = false;
        private boolean isCall = false;
        private boolean isJump = false;
        private boolean isTerminal = false;
        private boolean isComputed = false;
        private boolean isConditional = false;
        private boolean isOverride = false;

        protected Builder(byte type, String name) {
            this.type = type;
            this.name = name;
        }

        protected Builder setHasFall() {
            this.hasFall = true;
            return this;
        }

        protected Builder setIsCall() {
            this.isCall = true;
            return this;
        }

        protected Builder setIsJump() {
            this.isJump = true;
            return this;
        }

        protected Builder setIsTerminal() {
            this.isTerminal = true;
            return this;
        }

        protected Builder setIsComputed() {
            this.isComputed = true;
            return this;
        }

        protected Builder setIsConditional() {
            this.isConditional = true;
            return this;
        }

        protected Builder setIsOverride() {
            this.isOverride = true;
            return this;
        }

        protected FlowType build() {
            return new FlowType(this);
        }
    }
}

