/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghpatexpress;

import generic.stl.VectorSTL;
import ghidra.pcodeCPort.slghpatexpress.OperandResolve;
import ghidra.pcodeCPort.slghpatexpress.PatternEquation;
import ghidra.pcodeCPort.slghpatexpress.TokenPattern;
import ghidra.pcodeCPort.slghsymbol.Constructor;
import ghidra.pcodeCPort.slghsymbol.OperandSymbol;
import ghidra.sleigh.grammar.Location;

public class EquationCat
extends PatternEquation {
    private PatternEquation left;
    private PatternEquation right;

    public EquationCat(Location location, PatternEquation l, PatternEquation r) {
        super(location);
        this.left = l;
        this.left.layClaim();
        this.right = r;
        this.right.layClaim();
    }

    @Override
    public void dispose() {
        PatternEquation.release(this.left);
        PatternEquation.release(this.right);
    }

    @Override
    public void genPattern(VectorSTL<TokenPattern> ops) {
        this.left.genPattern(ops);
        this.right.genPattern(ops);
        this.setTokenPattern(this.left.getTokenPattern().doCat(this.right.getTokenPattern()));
    }

    @Override
    public void operandOrder(Constructor ct, VectorSTL<OperandSymbol> order) {
        this.left.operandOrder(ct, order);
        this.right.operandOrder(ct, order);
    }

    @Override
    public boolean resolveOperandLeft(OperandResolve state) {
        boolean res = this.left.resolveOperandLeft(state);
        if (!res) {
            return false;
        }
        int cur_base = state.base;
        int cur_offset = state.offset;
        if (!this.left.getTokenPattern().getLeftEllipsis() && !this.left.getTokenPattern().getRightEllipsis()) {
            state.offset += this.left.getTokenPattern().getMinimumLength();
        } else if (state.cur_rightmost != -1) {
            state.base = state.cur_rightmost;
            state.offset = state.size;
        } else if (state.size != -1) {
            state.offset += state.size;
        } else {
            state.base = -2;
        }
        int cur_rightmost = state.cur_rightmost;
        int cur_size = state.size;
        res = this.right.resolveOperandLeft(state);
        if (!res) {
            return false;
        }
        state.base = cur_base;
        state.offset = cur_offset;
        if (state.cur_rightmost == -1 && state.size != -1 && cur_rightmost != -1 && cur_size != -1) {
            state.cur_rightmost = cur_rightmost;
            state.size += cur_size;
        }
        return true;
    }
}

