/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.generic;

import ghidra.app.plugin.processors.generic.MemoryBlockDefinition;
import ghidra.framework.store.LockException;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.data.ProgramDataTypeManager;
import ghidra.program.database.symbol.SymbolManager;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.AddressLabelInfo;
import ghidra.program.model.lang.Language;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBlockException;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.HashSet;

public class LanguageFixupUtil {
    public static void applyPSpecFixups(ProgramDB programDB, TaskMonitor monitor) throws CancelledException {
        try {
            Language language = programDB.getLanguage();
            ProgramDataTypeManager dtm = programDB.getDataTypeManager();
            AddressSpace defaultSpace = language.getDefaultSpace();
            AddressSpace defaultDataSpace = language.getDefaultDataSpace();
            AddressSet processorDefinedBlockSet = new AddressSet();
            AddressSet processorDefinedSafeBlockSet = new AddressSet();
            for (MemoryBlockDefinition defaultMemoryBlockDef : language.getDefaultMemoryBlocks()) {
                monitor.checkCancelled();
                try {
                    MemoryBlock block = defaultMemoryBlockDef.fixupBlock(programDB);
                    AddressRange blockRange = block.getAddressRange();
                    processorDefinedBlockSet.add(blockRange);
                    AddressSpace space = block.getStart().getAddressSpace();
                    if (space.equals(defaultSpace) || space.equals(defaultDataSpace)) continue;
                    processorDefinedSafeBlockSet.add(blockRange);
                }
                catch (MemoryBlockException e) {
                    Msg.error(LanguageFixupUtil.class, (Object)("Failed to create or fixup processor defined memory block '" + defaultMemoryBlockDef.getBlockName() + "': " + e.getMessage()));
                }
                catch (LockException e) {
                    throw new RuntimeException(e);
                }
            }
            SymbolManager symbolTable = programDB.getSymbolTable();
            HashSet<Symbol> goodSymbols = new HashSet<Symbol>();
            for (AddressLabelInfo labelInfo : language.getDefaultSymbols()) {
                String name = labelInfo.getLabel();
                Address addr = labelInfo.getAddress();
                if (!processorDefinedBlockSet.contains(addr)) continue;
                Symbol existingSymbol = null;
                for (Symbol s : symbolTable.getGlobalSymbols(name)) {
                    monitor.checkCancelled();
                    if (s.getSymbolType() != SymbolType.LABEL) continue;
                    if (addr.equals(s.getAddress())) {
                        existingSymbol = s;
                        goodSymbols.add(s);
                        continue;
                    }
                    if (s.getSource() != SourceType.IMPORTED || !processorDefinedBlockSet.contains(s.getAddress())) continue;
                    s.delete();
                }
                if (existingSymbol != null) continue;
                try {
                    Symbol s = symbolTable.createLabel(addr, name, null, SourceType.IMPORTED);
                    goodSymbols.add(s);
                }
                catch (InvalidInputException e) {
                    throw new AssertException((Throwable)e);
                }
            }
            ArrayList<Symbol> deleteSet = new ArrayList<Symbol>();
            for (Symbol s : symbolTable.getSymbols(processorDefinedSafeBlockSet, SymbolType.LABEL, true)) {
                monitor.checkCancelled();
                if (s.getSource() != SourceType.IMPORTED || goodSymbols.contains(s)) continue;
                deleteSet.add(s);
            }
            for (Symbol s : deleteSet) {
                monitor.checkCancelled();
                s.delete();
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

