/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.task;

import ghidra.app.plugin.core.analysis.AnalysisWorker;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTAssociationStatus;
import ghidra.feature.vt.api.main.VTAssociationType;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMarkupItemApplyActionType;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.markuptype.FunctionNameMarkupType;
import ghidra.feature.vt.api.markuptype.LabelMarkupType;
import ghidra.feature.vt.api.util.VTAssociationStatusException;
import ghidra.feature.vt.api.util.VersionTrackingApplyException;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.task.VtTask;
import ghidra.feature.vt.gui.util.VTMatchApplyChoices;
import ghidra.feature.vt.gui.util.VTOptionDefines;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.List;

public class AcceptMatchTask
extends VtTask {
    protected final VTController controller;
    private final List<VTMatch> matches;
    private boolean doApplyFunctionNames = true;
    private boolean doApplyDataNames = true;

    public AcceptMatchTask(VTController controller, List<VTMatch> matches) {
        super("Accept Matches", controller.getSession());
        this.controller = controller;
        this.matches = matches;
        ToolOptions options = controller.getOptions();
        this.doApplyFunctionNames = options.getBoolean("Accept Match Options.Automatically Apply Function Name on Accept", true);
        this.doApplyDataNames = options.getBoolean("Accept Match Options.Automatically Apply Data Label on Accept", true);
    }

    @Override
    protected boolean shouldSuspendSessionEvents() {
        return this.matches.size() > 20;
    }

    @Override
    protected boolean doWork(TaskMonitor monitor) {
        Program destinationProgram = this.controller.getDestinationProgram();
        AutoAnalysisManager manager = AutoAnalysisManager.getAnalysisManager((Program)destinationProgram);
        try {
            return manager.scheduleWorker(new AnalysisWorker(){

                public String getWorkerName() {
                    return AcceptMatchTask.this.getTaskTitle();
                }

                public boolean analysisWorkerCallback(Program program, Object workerContext, TaskMonitor tm) throws CancelledException {
                    AcceptMatchTask.this.acceptMatches(tm);
                    return true;
                }
            }, null, false, monitor);
        }
        catch (CancelledException cancelledException) {
        }
        catch (Exception e) {
            this.reportError(e);
        }
        return false;
    }

    private void acceptMatches(TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Processing matches");
        monitor.initialize((long)this.matches.size());
        for (VTMatch match : this.matches) {
            monitor.checkCancelled();
            VTAssociation association = match.getAssociation();
            VTAssociationStatus status = association.getStatus();
            if (status != VTAssociationStatus.AVAILABLE) continue;
            this.acceptMatch(match);
            if (match.getAssociation().getType() == VTAssociationType.FUNCTION) {
                if (this.doApplyFunctionNames) {
                    this.applyFunctionNames(match, monitor);
                }
            } else if (this.doApplyDataNames) {
                this.applyDataNames(match, monitor);
            }
            monitor.incrementProgress(1L);
        }
        monitor.setProgress((long)this.matches.size());
    }

    private void applyDataNames(VTMatch match, TaskMonitor monitor) throws CancelledException {
        ToolOptions options;
        ToolOptions copyOfOptions;
        VTAssociation association = match.getAssociation();
        Collection<VTMarkupItem> markupItems = association.getMarkupItems(monitor);
        VTMarkupItem vtMarkupItem = this.getDataLabelMarkupItem(association.getSourceAddress(), markupItems);
        if (vtMarkupItem == null) {
            return;
        }
        if (vtMarkupItem.getDestinationAddress() == null) {
            vtMarkupItem.setDestinationAddress(match.getAssociation().getDestinationAddress());
        }
        if ((copyOfOptions = (options = this.controller.getOptions()).copy()).getEnum("Apply Markup Options.Labels", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_LABELS) == VTMatchApplyChoices.LabelChoices.EXCLUDE) {
            copyOfOptions.setEnum("Apply Markup Options.Labels", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_LABELS);
        }
        try {
            vtMarkupItem.apply(VTMarkupItemApplyActionType.REPLACE, copyOfOptions);
        }
        catch (VersionTrackingApplyException e) {
            this.reportError(e);
        }
    }

    private void applyFunctionNames(VTMatch match, TaskMonitor monitor) throws CancelledException {
        ToolOptions options;
        ToolOptions copyOfOptions;
        VTAssociation association = match.getAssociation();
        Collection<VTMarkupItem> markupItems = association.getMarkupItems(monitor);
        VTMarkupItem vtMarkupItem = this.getFunctionNameMarkupItem(markupItems);
        if (vtMarkupItem == null) {
            return;
        }
        if (vtMarkupItem.getDestinationAddress() == null) {
            vtMarkupItem.setDestinationAddress(match.getAssociation().getDestinationAddress());
        }
        if ((copyOfOptions = (options = this.controller.getOptions()).copy()).getEnum("Apply Markup Options.Function Name", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_FUNCTION_NAME) == VTMatchApplyChoices.FunctionNameChoices.EXCLUDE) {
            copyOfOptions.setEnum("Apply Markup Options.Function Name", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_FUNCTION_NAME);
        }
        try {
            vtMarkupItem.apply(VTMarkupItemApplyActionType.REPLACE, copyOfOptions);
        }
        catch (VersionTrackingApplyException e) {
            this.reportError(e);
        }
    }

    private VTMarkupItem getFunctionNameMarkupItem(Collection<VTMarkupItem> markupItems) {
        for (VTMarkupItem vtMarkupItem : markupItems) {
            if (vtMarkupItem.getMarkupType() != FunctionNameMarkupType.INSTANCE) continue;
            return vtMarkupItem;
        }
        return null;
    }

    private VTMarkupItem getDataLabelMarkupItem(Address source, Collection<VTMarkupItem> markupItems) {
        for (VTMarkupItem vtMarkupItem : markupItems) {
            if (vtMarkupItem.getMarkupType() != LabelMarkupType.INSTANCE || !vtMarkupItem.getSourceAddress().equals((Object)source)) continue;
            return vtMarkupItem;
        }
        return null;
    }

    private void acceptMatch(VTMatch match) {
        VTAssociation association = match.getAssociation();
        VTAssociationStatus status = association.getStatus();
        if (status == VTAssociationStatus.ACCEPTED) {
            return;
        }
        try {
            association.setAccepted();
        }
        catch (VTAssociationStatusException e) {
            throw new AssertException("Should have been given an association that is not blocked - current status: " + String.valueOf((Object)association.getStatus()));
        }
    }
}

