/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.task;

import ghidra.framework.task.GScheduledTask;
import ghidra.framework.task.GTask;
import ghidra.framework.task.GTaskMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GTaskGroup {
    private static long nextID = 0L;
    private long id = nextID++;
    private String description;
    private List<GScheduledTask> taskList = new ArrayList<GScheduledTask>();
    private boolean startNewTransaction;
    private volatile boolean cancelled = false;
    private GTaskMonitor monitor;
    private boolean scheduled = false;

    public GTaskGroup(String description, boolean startNewTransaction) {
        this.description = description;
        this.startNewTransaction = startNewTransaction;
        this.monitor = new GTaskMonitor();
    }

    public GScheduledTask addTask(GTask task, int priority) {
        if (this.scheduled) {
            throw new IllegalStateException("Can't directly add new tasks on a group that has been scheduled with a GTaskManager");
        }
        return this.doAddTask(task, priority);
    }

    GScheduledTask doAddTask(GTask task, int priority) {
        GScheduledTask scheduledTask = new GScheduledTask(this, task, priority);
        this.taskList.add(scheduledTask);
        this.monitor.setMaximum(this.taskList.size());
        return scheduledTask;
    }

    public List<GScheduledTask> getTasks() {
        ArrayList<GScheduledTask> list = new ArrayList<GScheduledTask>(this.taskList);
        Collections.sort(list);
        return list;
    }

    public GTaskMonitor getTaskMonitor() {
        return this.monitor;
    }

    public boolean wantsNewTransaction() {
        return this.startNewTransaction;
    }

    public String getDescription() {
        return this.description;
    }

    public int compareTo(GTaskGroup group) {
        return (int)(this.id - group.id);
    }

    public String toString() {
        return "Task Group: " + this.description;
    }

    public void setCancelled() {
        this.cancelled = true;
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    public void taskCompleted() {
        this.monitor.incrementProgress(1L);
    }

    public void setScheduled() {
        this.scheduled = true;
    }
}

