/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.symbol;

import ghidra.program.model.address.Address;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolType;
import ghidra.trace.database.symbol.AbstractDBTraceSymbolSingleTypeWithLocationView;
import ghidra.trace.database.symbol.DBTraceLabelSymbol;
import ghidra.trace.database.symbol.DBTraceNamespaceSymbol;
import ghidra.trace.database.symbol.DBTraceSymbolManager;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.symbol.TraceLabelSymbolView;
import ghidra.trace.model.symbol.TraceNamespaceSymbol;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceEvents;
import ghidra.util.LockHold;
import ghidra.util.exception.InvalidInputException;
import java.util.concurrent.locks.Lock;

public class DBTraceLabelSymbolView
extends AbstractDBTraceSymbolSingleTypeWithLocationView<DBTraceLabelSymbol>
implements TraceLabelSymbolView {
    public DBTraceLabelSymbolView(DBTraceSymbolManager manager) {
        super(manager, SymbolType.LABEL.getID(), manager.labelStore);
    }

    @Override
    public DBTraceLabelSymbol add(Lifespan lifespan, Address address, String name, TraceNamespaceSymbol parent, SourceType source) throws InvalidInputException, IllegalArgumentException {
        if (source == SourceType.DEFAULT) {
            throw new IllegalArgumentException();
        }
        DBTraceSymbolManager.assertValidName(name);
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            DBTraceNamespaceSymbol dbnsParent = this.manager.assertIsMine(parent);
            DBTraceLabelSymbol label = (DBTraceLabelSymbol)this.store.create();
            label.set(lifespan, address, name, dbnsParent, source);
            this.manager.putID(lifespan, address, label.getID());
            this.cacheForAt.notifyNewEntry(lifespan, address, label);
            this.manager.trace.setChanged(new TraceChangeRecord<DBTraceLabelSymbol, Void>(TraceEvents.SYMBOL_ADDED, label.getAddressSpace(), label));
            DBTraceLabelSymbol dBTraceLabelSymbol = label;
            return dBTraceLabelSymbol;
        }
    }
}

