/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.program;

import generic.util.FlattenedIterator;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.util.AbstractProgramContext;
import ghidra.trace.database.context.DBTraceRegisterContextManager;
import ghidra.trace.database.program.DBTraceProgramView;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.util.LockHold;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class DBTraceProgramViewProgramContext
extends AbstractProgramContext {
    private final DBTraceProgramView program;
    private final Language language;
    private final DBTraceRegisterContextManager registerContextManager;
    private final ProgramContext defaultContext;

    public DBTraceProgramViewProgramContext(DBTraceProgramView program) {
        super(program.language);
        this.program = program;
        this.language = program.language;
        this.registerContextManager = program.trace.getRegisterContextManager();
        this.defaultContext = this.registerContextManager.getDefaultContext(this.language);
    }

    public Register[] getRegistersWithValues() {
        List registers = this.language.getRegisters();
        ArrayList<Register> result = new ArrayList<Register>(registers.size());
        block0: for (Register register : registers) {
            for (long s : this.program.viewport.getReversedSnaps()) {
                if (!this.registerContextManager.hasRegisterValue(this.language, register, s)) continue;
                result.add(register);
                continue block0;
            }
        }
        return result.toArray(new Register[result.size()]);
    }

    public BigInteger getValue(Register register, Address address, boolean signed) {
        RegisterValue value = this.getRegisterValue(register, address);
        return value == null ? null : (signed ? value.getSignedValue() : value.getUnsignedValue());
    }

    protected RegisterValue combine(RegisterValue v1, RegisterValue v2) {
        if (v1 == null) {
            return v2;
        }
        if (v2 == null) {
            return v1;
        }
        return v1.combineValues(v2);
    }

    protected RegisterValue stack(RegisterValue value, Register register, Address address) {
        for (long s : this.program.viewport.getReversedSnaps()) {
            value = this.combine(value, this.registerContextManager.getValue(this.language, register, s, address));
        }
        return value;
    }

    public RegisterValue getRegisterValue(Register register, Address address) {
        RegisterValue value = this.registerContextManager.getDefaultValue(this.language, register, address);
        return this.stack(value, register, address);
    }

    public void setRegisterValue(Address start, Address end, RegisterValue value) throws ContextChangeException {
        this.registerContextManager.setValue(this.language, value, Lifespan.nowOn(this.program.snap), (AddressRange)new AddressRangeImpl(start, end));
    }

    public RegisterValue getNonDefaultValue(Register register, Address address) {
        RegisterValue value = new RegisterValue(register);
        return this.stack(value, register, address);
    }

    public void setValue(Register register, Address start, Address end, BigInteger value) throws ContextChangeException {
        this.setRegisterValue(start, end, new RegisterValue(register, value));
    }

    public AddressRangeIterator getRegisterValueAddressRanges(Register register) {
        return this.program.viewport.unionedAddresses(s -> this.registerContextManager.getRegisterValueAddressRanges(this.language, register, (long)s)).getAddressRanges();
    }

    public AddressRangeIterator getRegisterValueAddressRanges(Register register, Address start, Address end) {
        return new NestedAddressRangeIterator<AddressRange>(this.language.getAddressFactory().getAddressSet(start, end).iterator(), range -> this.program.viewport.unionedAddresses(s -> this.registerContextManager.getRegisterValueAddressRanges(this.language, register, (long)s, (AddressRange)range)).iterator());
    }

    public AddressRange getRegisterValueRangeContaining(Register register, Address address) {
        Map.Entry<TraceAddressSnapRange, RegisterValue> entry = this.registerContextManager.getEntry(this.language, register, this.program.snap, address);
        if (entry != null) {
            return entry.getKey().getRange();
        }
        AddressSetView ranges = this.registerContextManager.getRegisterValueAddressRanges(this.language, register, this.program.snap);
        AddressIterator prevIt = ranges.getAddresses(address, false);
        Address min = prevIt.hasNext() ? ((Address)prevIt.next()).next() : address.getAddressSpace().getMinAddress();
        AddressIterator nextIt = ranges.getAddresses(address, true);
        Address max = nextIt.hasNext() ? ((Address)nextIt.next()).previous() : address.getAddressSpace().getMaxAddress();
        return new AddressRangeImpl(min, max);
    }

    public AddressRangeIterator getDefaultRegisterValueAddressRanges(Register register) {
        return this.defaultContext.getDefaultRegisterValueAddressRanges(register);
    }

    public AddressRangeIterator getDefaultRegisterValueAddressRanges(Register register, Address start, Address end) {
        return this.defaultContext.getDefaultRegisterValueAddressRanges(register, start, end);
    }

    public void remove(Address start, Address end, Register register) throws ContextChangeException {
        try (LockHold hold = this.program.trace.lockWrite();){
            Lifespan span = Lifespan.at(this.program.snap);
            for (AddressRange range : this.language.getAddressFactory().getAddressSet(start, end)) {
                this.registerContextManager.removeValue(this.language, register, span, range);
            }
        }
    }

    public boolean hasValueOverRange(Register register, BigInteger value, AddressSetView addressSet) {
        RegisterValue regVal = new RegisterValue(register, value);
        try (LockHold hold = this.program.trace.lockRead();){
            AddressSet remains = new AddressSet(addressSet);
            while (!remains.isEmpty()) {
                AddressSet toRemove = new AddressSet();
                for (AddressRange range : remains) {
                    Map.Entry<TraceAddressSnapRange, RegisterValue> entry = this.registerContextManager.getEntry(this.language, register, this.program.snap, range.getMinAddress());
                    if (entry == null) {
                        boolean bl = false;
                        return bl;
                    }
                    if (!regVal.equals((Object)entry.getValue())) {
                        boolean bl = false;
                        return bl;
                    }
                    toRemove.add(entry.getKey().getRange());
                }
                remains.delete((AddressSetView)toRemove);
            }
            boolean bl = true;
            return bl;
        }
    }

    public RegisterValue getDefaultValue(Register register, Address address) {
        return this.defaultContext.getDefaultValue(register, address);
    }

    public RegisterValue getDisassemblyContext(Address address) {
        RegisterValue value = this.getRegisterValue(this.baseContextRegister, address);
        if (value != null) {
            return value;
        }
        return this.defaultContext.getDisassemblyContext(address);
    }

    public void setDefaultValue(RegisterValue registerValue, Address start, Address end) {
        throw new UnsupportedOperationException();
    }

    private static class NestedAddressRangeIterator<U>
    extends FlattenedIterator<U, AddressRange>
    implements AddressRangeIterator {
        protected NestedAddressRangeIterator(Iterator<U> it, Function<U, Iterator<? extends AddressRange>> f) {
            super(it, f);
        }

        public Iterator<AddressRange> iterator() {
            return this;
        }
    }
}

