/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec.trace;

import ghidra.pcode.emu.PcodeEmulationCallbacks;
import ghidra.pcode.emu.PcodeMachine;
import ghidra.pcode.emu.PcodeThread;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeStateCallbacks;
import ghidra.pcode.exec.trace.data.PcodeTraceAccess;
import ghidra.pcode.exec.trace.data.PcodeTraceDataAccess;
import ghidra.pcode.exec.trace.data.PcodeTraceMemoryAccess;
import ghidra.pcode.exec.trace.data.PcodeTracePropertyAccess;
import ghidra.pcode.exec.trace.data.PcodeTraceRegistersAccess;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.MathUtilities;
import ghidra.util.Msg;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public final class TraceEmulationIntegration
extends Enum<TraceEmulationIntegration> {
    private static final /* synthetic */ TraceEmulationIntegration[] $VALUES;

    public static TraceEmulationIntegration[] values() {
        return (TraceEmulationIntegration[])$VALUES.clone();
    }

    public static TraceEmulationIntegration valueOf(String name) {
        return Enum.valueOf(TraceEmulationIntegration.class, name);
    }

    public static Writer bytesDelayedWrite(PcodeTraceAccess from) {
        TraceWriter writer = new TraceWriter(from);
        writer.putHandler(new BytesPieceHandler());
        return writer;
    }

    public static Writer bytesImmediateWrite(PcodeTraceAccess access) {
        TraceWriter writer = new TraceWriter(access);
        writer.putHandler(new ImmediateBytesPieceHandler());
        return writer;
    }

    public static PcodeStateCallbacks bytesImmediateWrite(PcodeTraceAccess access, final TraceThread thread, final int frame) {
        TraceWriter writer = new TraceWriter(access){

            @Override
            protected PcodeTraceRegistersAccess getRegAccess(PcodeThread<?> ignored) {
                return this.access.getDataForLocalState(thread, frame);
            }
        };
        writer.putHandler(new ImmediateBytesPieceHandler());
        return writer.wrapFor(null);
    }

    private static /* synthetic */ TraceEmulationIntegration[] $values() {
        return new TraceEmulationIntegration[0];
    }

    static {
        $VALUES = TraceEmulationIntegration.$values();
    }

    public static class TraceWriter
    implements Writer {
        protected final PcodeTraceAccess access;
        protected final PcodeTraceMemoryAccess memAccess;
        protected final Map<PcodeThread<?>, PcodeTraceRegistersAccess> regAccess = new HashMap();
        protected final AddressSet memWritten = new AddressSet();
        protected final Map<PcodeThread<?>, AddressSet> regsWritten = new HashMap();
        protected final Map<PieceType<?, ?>, PieceHandler<?, ?>> handlers = new HashMap();
        private PcodeMachine<?> emulator;

        public TraceWriter(PcodeTraceAccess access) {
            this.access = access;
            this.memAccess = access.getDataForSharedState();
        }

        @Override
        public void putHandler(PieceHandler<?, ?> handler) {
            this.handlers.put(PieceType.forHandler(handler), handler);
        }

        public void emulatorCreated(PcodeMachine<Object> emulator) {
            this.emulator = emulator;
        }

        public void threadCreated(PcodeThread<Object> thread) {
            this.access.getDataForLocalState(thread, 0).initializeThreadContext(thread);
        }

        protected <B, U> PieceHandler<B, U> handlerFor(PcodeExecutorStatePiece<B, U> piece) {
            return this.handlers.getOrDefault(PieceType.forPiece(piece), PieceHandler.NONE);
        }

        protected <B, U> void writePieceDown(PcodeTraceDataAccess into, PcodeThread<?> thread, PcodeExecutorStatePiece<B, U> piece, AddressSetView written) {
            PieceHandler<B, U> handler = this.handlerFor(piece);
            handler.writeDown(into, thread, piece, written);
        }

        @Override
        public void writeDown(PcodeTraceAccess into) {
            PcodeTraceMemoryAccess memInto = into.getDataForSharedState();
            for (PcodeExecutorStatePiece piece : this.emulator.getSharedState().streamPieces().toList()) {
                this.writePieceDown(memInto, null, piece, (AddressSetView)this.memWritten);
            }
            for (PcodeThread thread : this.emulator.getAllThreads()) {
                PcodeTraceRegistersAccess regInto = into.getDataForLocalState(thread, 0);
                AddressSetView written = (AddressSetView)this.regsWritten.getOrDefault(thread, new AddressSet());
                for (PcodeExecutorStatePiece piece : thread.getState().streamPieces().toList()) {
                    this.writePieceDown(regInto, thread, piece, written);
                }
            }
        }

        @Override
        public void writeDown(long snap) {
            this.writeDown(this.access.deriveForWrite(snap));
        }

        protected PcodeTraceRegistersAccess getRegAccess(PcodeThread<?> thread) {
            return this.regAccess.computeIfAbsent(thread, t -> this.access.getDataForLocalState((PcodeThread<?>)t, 0));
        }

        public <B, U> void dataWritten(PcodeThread<Object> thread, PcodeExecutorStatePiece<B, U> piece, Address address, int length, U value) {
            AddressSet written;
            PcodeTraceDataAccess acc = address.isRegisterAddress() ? this.getRegAccess(thread) : this.memAccess;
            AddressSet addressSet = written = address.isRegisterAddress() ? this.regsWritten.computeIfAbsent(thread, t -> new AddressSet()) : this.memWritten;
            if (this.handlerFor(piece).dataWritten(acc, written, thread, piece, address, length, value)) {
                return;
            }
            Address end = address.addWrap((long)(length - 1));
            if (address.compareTo((Object)end) <= 0) {
                written.add(address, end);
            } else {
                AddressSpace space = address.getAddressSpace();
                written.add(address, space.getMaxAddress());
                written.add(space.getMinAddress(), end);
            }
        }

        public <B, U> void dataWritten(PcodeThread<Object> thread, PcodeExecutorStatePiece<B, U> piece, AddressSpace space, B offset, int length, U value) {
            PcodeTraceDataAccess acc = space.isRegisterSpace() ? this.getRegAccess(thread) : this.memAccess;
            AddressSet written = space.isRegisterSpace() ? this.regsWritten.computeIfAbsent(thread, t -> new AddressSet()) : this.memWritten;
            this.handlerFor(piece).abstractWritten(acc, written, thread, piece, space, offset, length, value);
        }

        public <B, U> int readUninitialized(PcodeThread<Object> thread, PcodeExecutorStatePiece<B, U> piece, AddressSpace space, B offset, int length) {
            PcodeTraceDataAccess acc = space.isRegisterSpace() ? this.getRegAccess(thread) : this.memAccess;
            return this.handlerFor(piece).abstractReadUninit(acc, thread, piece, space, offset, length);
        }

        public <B, U> AddressSetView readUninitialized(PcodeThread<Object> thread, PcodeExecutorStatePiece<B, U> piece, AddressSetView set) {
            if (set.isEmpty()) {
                return set;
            }
            AddressSpace space = set.getMinAddress().getAddressSpace();
            if (space.isUniqueSpace()) {
                return set;
            }
            PcodeTraceDataAccess acc = space.isRegisterSpace() ? this.getRegAccess(thread) : this.memAccess;
            return this.handlerFor(piece).readUninitialized(acc, thread, piece, set);
        }
    }

    public static class BytesPieceHandler
    implements PieceHandler<byte[], byte[]> {
        public static final int CHUNK_SIZE = 4096;

        @Override
        public Class<byte[]> getAddressDomain() {
            return byte[].class;
        }

        @Override
        public Class<byte[]> getValueDomain() {
            return byte[].class;
        }

        @Override
        public AddressSetView readUninitialized(PcodeTraceDataAccess acc, PcodeThread<?> thread, PcodeExecutorStatePiece<byte[], byte[]> piece, AddressSetView set) {
            AddressSetView knownButUninit = acc.intersectViewKnown(set, true);
            if (knownButUninit.isEmpty()) {
                return set;
            }
            AddressSet remains = new AddressSet(set);
            AddressRangeImpl knownBound = new AddressRangeImpl(knownButUninit.getMinAddress(), knownButUninit.getMaxAddress());
            ByteBuffer buf = ByteBuffer.allocate((int)knownBound.getLength());
            acc.getBytes(knownBound.getMinAddress(), buf);
            for (AddressRange range : knownButUninit) {
                piece.setVarInternal(range.getAddressSpace(), range.getMinAddress().getOffset(), (int)range.getLength(), (Object)buf.array());
                remains.delete(range);
            }
            return remains;
        }

        @Override
        public void writeDown(PcodeTraceDataAccess into, PcodeThread<?> thread, PcodeExecutorStatePiece<byte[], byte[]> piece, AddressSetView written) {
            for (AddressRange range : written) {
                byte[] bytes;
                AddressSpace space = range.getAddressSpace();
                if (space.isUniqueSpace()) continue;
                long lower = range.getMinAddress().getOffset();
                for (long fullLen = range.getLength(); fullLen > 0L; fullLen -= (long)bytes.length) {
                    int len = MathUtilities.unsignedMin((int)4096, (long)fullLen);
                    bytes = (byte[])piece.getVarInternal(space, lower, len, PcodeExecutorStatePiece.Reason.INSPECT);
                    into.putBytes(space.getAddress(lower), ByteBuffer.wrap(bytes));
                    lower += (long)bytes.length;
                }
            }
        }
    }

    public static interface Writer
    extends PcodeEmulationCallbacks<Object> {
        public void writeDown(PcodeTraceAccess var1);

        public void writeDown(long var1);

        public void putHandler(PieceHandler<?, ?> var1);

        default public <T> PcodeEmulationCallbacks<T> callbacks() {
            return this;
        }
    }

    public static interface PieceHandler<A, T> {
        public static final PieceHandler<?, ?> NONE = VoidPieceHandler.INSTANCE;

        public Class<A> getAddressDomain();

        public Class<T> getValueDomain();

        public AddressSetView readUninitialized(PcodeTraceDataAccess var1, PcodeThread<?> var2, PcodeExecutorStatePiece<A, T> var3, AddressSetView var4);

        default public int abstractReadUninit(PcodeTraceDataAccess acc, PcodeThread<?> thread, PcodeExecutorStatePiece<A, T> piece, AddressSpace space, A offset, int length) {
            return 0;
        }

        default public boolean dataWritten(PcodeTraceDataAccess acc, AddressSet written, PcodeThread<?> thread, PcodeExecutorStatePiece<A, T> piece, Address address, int length, T value) {
            return false;
        }

        default public void abstractWritten(PcodeTraceDataAccess acc, AddressSet written, PcodeThread<?> thread, PcodeExecutorStatePiece<A, T> piece, AddressSpace space, A offset, int length, T value) {
        }

        public void writeDown(PcodeTraceDataAccess var1, PcodeThread<?> var2, PcodeExecutorStatePiece<A, T> var3, AddressSetView var4);
    }

    public static class ImmediateBytesPieceHandler
    extends BytesPieceHandler {
        @Override
        public boolean dataWritten(PcodeTraceDataAccess acc, AddressSet written, PcodeThread<?> thread, PcodeExecutorStatePiece<byte[], byte[]> piece, Address address, int length, byte[] value) {
            if (address.isUniqueAddress()) {
                return true;
            }
            acc.putBytes(address, ByteBuffer.wrap(value));
            return true;
        }
    }

    public static abstract class AbstractSimplePropertyBasedPieceHandler<A, T, P>
    extends AbstractPropertyBasedPieceHandler<A, T, P> {
        protected abstract T decode(P var1);

        @Override
        protected void decodeFrom(PcodeExecutorStatePiece<A, T> piece, AddressSetView limit, AddressRange range, P propertyValue) {
            piece.setVarInternal(range.getAddressSpace(), range.getMinAddress().getOffset(), (int)range.getLength(), this.decode(propertyValue));
        }

        protected abstract P encode(T var1);

        @Override
        protected void encodeInto(PcodeTracePropertyAccess<P> property, AddressRange range, T value) {
            property.put(range, this.encode(value));
        }
    }

    public static abstract class AbstractPropertyBasedPieceHandler<A, T, P>
    implements PieceHandler<A, T> {
        protected abstract String getPropertyName();

        protected abstract Class<P> getPropertyType();

        protected abstract void decodeFrom(PcodeExecutorStatePiece<A, T> var1, AddressSetView var2, AddressRange var3, P var4);

        protected abstract void encodeInto(PcodeTracePropertyAccess<P> var1, AddressRange var2, T var3);

        @Override
        public AddressSetView readUninitialized(PcodeTraceDataAccess acc, PcodeThread<?> thread, PcodeExecutorStatePiece<A, T> piece, AddressSetView set) {
            PcodeTracePropertyAccess<P> property = acc.getPropertyAccess(this.getPropertyName(), this.getPropertyType());
            AddressSet remains = new AddressSet(set);
            AddressSet cursor = new AddressSet(set);
            boolean result = false;
            while (!cursor.isEmpty()) {
                Address cur = cursor.getMinAddress();
                Map.Entry<AddressRange, P> entry = property.getEntry(cur);
                if (entry == null) {
                    cursor.delete(cur, cur);
                    continue;
                }
                AddressRangeImpl physical = new AddressRangeImpl(entry.getKey().getMinAddress().getPhysicalAddress(), entry.getKey().getMaxAddress().getPhysicalAddress());
                this.decodeFrom(piece, set, (AddressRange)physical, entry.getValue());
                result = true;
                remains.delete((AddressRange)physical);
                cursor.delete((AddressRange)physical);
            }
            return result ? remains : set;
        }

        @Override
        public int abstractReadUninit(PcodeTraceDataAccess acc, PcodeThread<?> thread, PcodeExecutorStatePiece<A, T> piece, AddressSpace space, A offset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeDown(PcodeTraceDataAccess into, PcodeThread<?> thread, PcodeExecutorStatePiece<A, T> piece, AddressSetView written) {
            PcodeTracePropertyAccess<P> property = into.getPropertyAccess(this.getPropertyName(), this.getPropertyType());
            AddressSet remains = new AddressSet(written);
            while (!remains.isEmpty()) {
                Address cur = remains.getMinAddress();
                AddressSpace space = cur.getAddressSpace();
                Map.Entry entry = piece.getNextEntryInternal(space, cur.getOffset());
                if (entry == null) {
                    remains.delete(space.getMinAddress(), space.getMaxAddress());
                    continue;
                }
                if (Long.compareUnsigned((Long)entry.getKey(), cur.getOffset()) < 0) {
                    Msg.error((Object)this, (Object)"getNextEntryInternal return an incorrect entry.");
                    remains.delete(space.getMinAddress(), space.getMaxAddress());
                    continue;
                }
                Address min = space.getAddress(((Long)entry.getKey()).longValue());
                AddressRangeImpl range = new AddressRangeImpl(min, min.add(piece.getArithmetic().sizeOf(entry.getValue()) - 1L));
                this.encodeInto(property, (AddressRange)range, entry.getValue());
                remains.delete(space.getMinAddress(), range.getMaxAddress());
            }
        }

        @Override
        public void abstractWritten(PcodeTraceDataAccess acc, AddressSet written, PcodeThread<?> thread, PcodeExecutorStatePiece<A, T> piece, AddressSpace space, A offset, int length, T value) {
            throw new UnsupportedOperationException();
        }
    }

    private static enum VoidPieceHandler implements PieceHandler<Void, Void>
    {
        INSTANCE;


        @Override
        public Class<Void> getAddressDomain() {
            return Void.class;
        }

        @Override
        public Class<Void> getValueDomain() {
            return Void.class;
        }

        @Override
        public AddressSetView readUninitialized(PcodeTraceDataAccess acc, PcodeThread<?> thread, PcodeExecutorStatePiece<Void, Void> piece, AddressSetView set) {
            return set;
        }

        @Override
        public void writeDown(PcodeTraceDataAccess into, PcodeThread<?> thread, PcodeExecutorStatePiece<Void, Void> piece, AddressSetView written) {
        }
    }

    record PieceType<A, T>(Class<A> addressDomain, Class<T> valueDomain) {
        public static <A, T> PieceType<A, T> forPiece(PcodeExecutorStatePiece<A, T> piece) {
            return new PieceType<A, T>(piece.getAddressArithmetic().getDomain(), piece.getArithmetic().getDomain());
        }

        public static <A, T> PieceType<A, T> forHandler(PieceHandler<A, T> handler) {
            return new PieceType<A, T>(handler.getAddressDomain(), handler.getValueDomain());
        }
    }
}

