/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.description;

import generic.lsh.vector.LSHVector;
import generic.lsh.vector.LSHVectorFactory;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.description.CategoryRecord;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.description.FunctionDescription;
import ghidra.features.bsim.query.description.RowKey;
import ghidra.features.bsim.query.description.SignatureRecord;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public class DescriptionManager {
    public static final int LAYOUT_VERSION = 5;
    private TreeSet<FunctionDescription> funcrec = new TreeSet();
    private TreeSet<ExecutableRecord> exerec = new TreeSet();
    private TreeMap<RowKey, ExecutableRecord> rowCache = null;
    private short major;
    private short minor;
    private int settings;

    public void setVersion(short maj, short min) {
        this.major = maj;
        this.minor = min;
    }

    public void setSettings(int set) {
        this.settings = set;
    }

    public short getMajorVersion() {
        return this.major;
    }

    public short getMinorVersion() {
        return this.minor;
    }

    public int getSettings() {
        return this.settings;
    }

    public void setExeCategories(ExecutableRecord erec, List<CategoryRecord> cats) {
        erec.setCategory(cats);
    }

    public void setExeRowId(ExecutableRecord erec, RowKey id) {
        erec.setRowId(id);
    }

    public void setExeAlreadyStored(ExecutableRecord erec) {
        erec.setAlreadyStored();
    }

    public void setSignatureId(FunctionDescription frec, long id) {
        frec.setVectorId(id);
    }

    public void setSignatureId(SignatureRecord sigrec, long id) {
        sigrec.setVectorId(id);
    }

    public void setFunctionDescriptionId(FunctionDescription fd, RowKey id) {
        fd.setId(id);
    }

    public void setFunctionDescriptionFlags(FunctionDescription fd, int fl) {
        fd.setFlags(fl);
    }

    public TreeSet<ExecutableRecord> getExecutableRecordSet() {
        return this.exerec;
    }

    public void clearFunctions() {
        this.funcrec.clear();
    }

    public void clear() {
        this.clearFunctions();
        this.major = 0;
        this.minor = 0;
        this.settings = 0;
        this.exerec.clear();
        this.rowCache = null;
    }

    public int numExecutables() {
        return this.exerec.size();
    }

    public int numFunctions() {
        return this.funcrec.size();
    }

    public FunctionDescription newFunctionDescription(String fnm, long address, ExecutableRecord erec) {
        FunctionDescription newfunc = new FunctionDescription(erec, fnm, address);
        if (!this.funcrec.add(newfunc)) {
            newfunc = this.funcrec.floor(newfunc);
        }
        return newfunc;
    }

    public ExecutableRecord newExecutableRecord(String md5, String enm, String cnm, String arc, Date dt, String repo, String path, RowKey id) throws LSHException {
        if (md5.length() != 32) {
            throw new LSHException("MD5 field must be exactly 32 hex characters");
        }
        ExecutableRecord newexe = new ExecutableRecord(md5, enm, cnm, arc, dt, id, repo, path);
        if (!this.exerec.add(newexe)) {
            ExecutableRecord oldexe = this.exerec.floor(newexe);
            if (oldexe.compareMetadata(newexe) != 0) {
                throw new LSHException("Duplicate md5 hash, different metadata");
            }
            if (oldexe.getRowId() != null && id != null && !oldexe.getRowId().equals(id)) {
                throw new LSHException("Overwriting existing executable id");
            }
            newexe = oldexe;
        }
        return newexe;
    }

    public ExecutableRecord newExecutableLibrary(String enm, String arc, RowKey id) throws LSHException {
        ExecutableRecord newexe = new ExecutableRecord(enm, arc, id);
        if (!this.exerec.add(newexe)) {
            ExecutableRecord oldexe = this.exerec.floor(newexe);
            if (oldexe.compareMetadata(newexe) != 0) {
                throw new LSHException("Duplicate md5 hash, different metadata");
            }
            if (oldexe.getRowId() != null && id != null && !oldexe.getRowId().equals(id)) {
                throw new LSHException("Overwriting existing executable id");
            }
            newexe = oldexe;
        }
        return newexe;
    }

    public void transferSettings(DescriptionManager op2) {
        this.major = op2.major;
        this.minor = op2.minor;
        this.settings = op2.settings;
    }

    public ExecutableRecord transferExecutable(ExecutableRecord erec) throws LSHException {
        RowKey id = erec.getRowId();
        ExecutableRecord res = erec.isLibrary() ? this.newExecutableLibrary(erec.getNameExec(), erec.getArchitecture(), id) : this.newExecutableRecord(erec.getMd5(), erec.getNameExec(), erec.getNameCompiler(), erec.getArchitecture(), (Date)erec.getDate().clone(), erec.getRepository(), erec.getPath(), id);
        res.cloneCategories(erec);
        return res;
    }

    public FunctionDescription transferFunction(FunctionDescription fdesc, boolean transsig) throws LSHException {
        ExecutableRecord erec = this.transferExecutable(fdesc.getExecutableRecord());
        FunctionDescription res = this.newFunctionDescription(fdesc.getFunctionName(), fdesc.getAddress(), erec);
        res.setVectorId(fdesc.getVectorId());
        res.setFlags(fdesc.getFlags());
        SignatureRecord srec = fdesc.getSignatureRecord();
        if (transsig && srec != null) {
            SignatureRecord sigclone = this.newSignature(srec.getLSHVector(), srec.getCount());
            this.attachSignature(res, sigclone);
        }
        return res;
    }

    public void generateFunctionIdMap(Map<RowKey, FunctionDescription> funcmap) {
        for (FunctionDescription func : this.funcrec) {
            funcmap.put(func.getId(), func);
        }
    }

    public SignatureRecord newSignature(LSHVector vec, int count) {
        SignatureRecord srec = new SignatureRecord(vec);
        srec.setCount(count);
        return srec;
    }

    public SignatureRecord newSignature(XmlPullParser parser, LSHVectorFactory vectorFactory, int count) {
        LSHVector res = vectorFactory.restoreVectorFromXml(parser);
        SignatureRecord srec = new SignatureRecord(res);
        srec.setCount(count);
        return srec;
    }

    public void attachSignature(FunctionDescription fd, SignatureRecord srec) {
        fd.setSignatureRecord(srec);
        this.setSignatureId(fd, srec.getVectorId());
    }

    public void makeCallgraphLink(FunctionDescription src, FunctionDescription dest, int lhash) {
        src.insertCall(dest, lhash);
    }

    public ExecutableRecord findExecutable(String md5) throws LSHException {
        ExecutableRecord templ = new ExecutableRecord(md5);
        ExecutableRecord res = this.exerec.floor(templ);
        if (res != null && res.getMd5().equals(md5)) {
            return res;
        }
        throw new LSHException("Unable to find executable");
    }

    public ExecutableRecord findExecutable(String name, String arch, String comp) throws LSHException {
        if (StringUtils.isEmpty((CharSequence)arch)) {
            arch = null;
        }
        if (StringUtils.isEmpty((CharSequence)comp)) {
            comp = null;
        }
        for (ExecutableRecord erec : this.exerec) {
            if (!erec.getNameExec().equals(name) || arch != null && !erec.getArchitecture().equals(arch) || comp != null && !erec.getNameCompiler().equals(comp)) continue;
            return erec;
        }
        throw new LSHException("Unable to find executable");
    }

    public FunctionDescription findFunction(String fname, long address, ExecutableRecord exe) throws LSHException {
        FunctionDescription fdesc = new FunctionDescription(exe, fname, address);
        FunctionDescription res = this.funcrec.floor(fdesc);
        if (res == null || !res.equals(fdesc)) {
            throw new LSHException("Unable to find FunctionDescription");
        }
        return res;
    }

    public FunctionDescription findFunctionByName(String fname, ExecutableRecord exe) {
        FunctionDescription fdesc = new FunctionDescription(exe, fname, 0L);
        FunctionDescription res = this.funcrec.ceiling(fdesc);
        if (res == null || !fname.equals(res.getFunctionName()) || !res.getExecutableRecord().equals(exe)) {
            return null;
        }
        return res;
    }

    public FunctionDescription containsDescription(String fname, long address, ExecutableRecord exe) {
        FunctionDescription fdesc = new FunctionDescription(exe, fname, address);
        FunctionDescription res = this.funcrec.floor(fdesc);
        if (res == null || !res.equals(fdesc)) {
            return null;
        }
        return res;
    }

    public Iterator<FunctionDescription> listFunctions(ExecutableRecord exe) {
        ExecutableRecord startexe = this.exerec.floor(exe);
        ExecutableRecord endexe = this.exerec.higher(exe);
        if (startexe == null) {
            return null;
        }
        FunctionDescription startfunc = new FunctionDescription(startexe, "", 0L);
        if ((startfunc = this.funcrec.ceiling(startfunc)) == null) {
            startfunc = this.funcrec.last();
            return this.funcrec.subSet(startfunc, startfunc).iterator();
        }
        FunctionDescription endfunc = null;
        if (endexe != null) {
            endfunc = new FunctionDescription(endexe, "", 0L);
            endfunc = this.funcrec.ceiling(endfunc);
        }
        if (endfunc == null) {
            return this.funcrec.tailSet(startfunc).iterator();
        }
        return this.funcrec.subSet(startfunc, endfunc).iterator();
    }

    public Iterator<FunctionDescription> listAllFunctions() {
        return this.funcrec.iterator();
    }

    public Iterator<FunctionDescription> listFunctionsAfter(FunctionDescription func) {
        return this.funcrec.tailSet(func, false).iterator();
    }

    public void cacheExecutableByRow(ExecutableRecord erec, RowKey rowKey) {
        if (this.rowCache == null) {
            this.rowCache = new TreeMap();
        }
        this.rowCache.put(rowKey, erec);
    }

    public ExecutableRecord findExecutableByRow(RowKey rowKey) {
        if (this.rowCache == null) {
            return null;
        }
        return this.rowCache.get(rowKey);
    }

    public void populateExecutableXref() {
        if (this.exerec.isEmpty()) {
            return;
        }
        if (this.exerec.first().getXrefIndex() == 1) {
            return;
        }
        int xrefIndex = 1;
        for (ExecutableRecord exe : this.exerec) {
            exe.setXrefIndex(xrefIndex);
            ++xrefIndex;
        }
    }

    public void matchAndSetXrefs(DescriptionManager manage) {
        TreeSet<ExecutableRecord> manageSet = manage.exerec;
        for (ExecutableRecord currentRecord : this.exerec) {
            ExecutableRecord match = manageSet.floor(currentRecord);
            if (match != null && match.getMd5().equals(currentRecord.getMd5())) {
                currentRecord.setXrefIndex(match.getXrefIndex());
                continue;
            }
            currentRecord.setXrefIndex(0);
        }
    }

    public Map<Integer, ExecutableRecord> generateExecutableXrefMap() {
        TreeMap<Integer, ExecutableRecord> treeMap = new TreeMap<Integer, ExecutableRecord>();
        int xrefIndex = 1;
        for (ExecutableRecord exe : this.exerec) {
            exe.setXrefIndex(xrefIndex);
            treeMap.put(xrefIndex, exe);
            ++xrefIndex;
        }
        return treeMap;
    }

    public void overrideRepository(String repo, String path) {
        for (ExecutableRecord element : this.exerec) {
            element.setRepository(repo, path);
        }
    }

    public void saveXml(Writer fwrite) throws IOException {
        fwrite.append("<description");
        fwrite.append(" layout_version=\"").append(Integer.toString(5)).append('\"');
        if (this.major != 0) {
            fwrite.append(" major=\"").append(Short.toString(this.major)).append('\"');
            fwrite.append(" minor=\"").append(Short.toString(this.minor)).append('\"');
        }
        if (this.settings != 0) {
            fwrite.append(" settings=\"0x").append(Integer.toHexString(this.settings)).append('\"');
        }
        fwrite.append(">\n");
        ExecutableRecord curexe = null;
        for (FunctionDescription fdesc : this.funcrec) {
            if (curexe == null || 0 != fdesc.getExecutableRecord().compareTo(curexe)) {
                if (curexe != null) {
                    fwrite.append("</execlist>\n");
                }
                curexe = fdesc.getExecutableRecord();
                fwrite.append("<execlist>\n");
                curexe.saveXml(fwrite);
            }
            fdesc.sortCallgraph();
            fdesc.saveXml(fwrite);
        }
        if (curexe != null) {
            fwrite.append("</execlist>\n");
        }
        fwrite.append("</description>\n");
    }

    public void restoreXml(XmlPullParser parser, LSHVectorFactory vectorFactory) throws LSHException {
        this.major = 0;
        this.minor = 0;
        this.settings = 0;
        int layout_version = 0;
        XmlElement el = parser.start(new String[]{"description"});
        if (el.hasAttribute("layout_version")) {
            layout_version = SpecXmlUtils.decodeInt((String)el.getAttribute("layout_version"));
        }
        if (layout_version < 5) {
            throw new LSHException("Old XML layout is no longer supported");
        }
        if (layout_version > 5) {
            throw new LSHException("XML layout for newer version of BSIM");
        }
        if (el.hasAttribute("major")) {
            this.major = (short)SpecXmlUtils.decodeInt((String)el.getAttribute("major"));
            this.minor = (short)SpecXmlUtils.decodeInt((String)el.getAttribute("minor"));
        }
        if (el.hasAttribute("settings")) {
            this.settings = SpecXmlUtils.decodeInt((String)el.getAttribute("settings"));
        }
        while (parser.peek().isStart()) {
            parser.start(new String[]{"execlist"});
            ExecutableRecord erec = ExecutableRecord.restoreXml(parser, this);
            while (parser.peek().isStart()) {
                FunctionDescription.restoreXml(parser, vectorFactory, this, erec);
            }
            parser.end();
        }
        parser.end();
    }
}

