/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.search.results;

import ghidra.features.bsim.gui.search.results.BSimMatchResult;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.description.FunctionDescription;
import java.util.List;
import java.util.TreeSet;

public class ExecutableResult
implements Comparable<ExecutableResult> {
    private ExecutableRecord exerecord;
    private int funccount;
    private double sumsignif;
    private int hashCode;

    public ExecutableResult() {
        this.exerecord = null;
        this.funccount = 0;
        this.sumsignif = 0.0;
    }

    public ExecutableResult(ExecutableRecord rec) {
        this.exerecord = rec;
        this.funccount = 0;
        this.sumsignif = 0.0;
    }

    public void addFunction(double signif) {
        ++this.funccount;
        this.sumsignif += signif;
    }

    public ExecutableRecord getExecutableRecord() {
        return this.exerecord;
    }

    public int getFunctionCount() {
        return this.funccount;
    }

    public double getSignificanceSum() {
        return this.sumsignif;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ExecutableResult op2 = (ExecutableResult)obj;
        return this.exerecord.equals(op2.exerecord);
    }

    @Override
    public int compareTo(ExecutableResult o) {
        return this.exerecord.compareTo(o.exerecord);
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        this.hashCode = this.exerecord.hashCode();
        return this.hashCode;
    }

    private static void finalizeExecutableResult(TreeSet<ExecutableResult> singlefunc, TreeSet<ExecutableResult> globalfunc) {
        for (ExecutableResult eres : singlefunc) {
            ExecutableResult tmpres = globalfunc.floor(eres);
            if (tmpres == null || !tmpres.equals(eres)) {
                tmpres = new ExecutableResult(eres.exerecord);
                globalfunc.add(tmpres);
            }
            tmpres.addFunction(eres.getSignificanceSum());
        }
    }

    public static TreeSet<ExecutableResult> generateFromMatchRows(List<BSimMatchResult> filteredrows) {
        TreeSet<ExecutableResult> execrows = new TreeSet<ExecutableResult>();
        ExecutableResult curres = new ExecutableResult();
        TreeSet<ExecutableResult> exetree = new TreeSet<ExecutableResult>();
        FunctionDescription curdescription = null;
        for (BSimMatchResult simres : filteredrows) {
            double signif = simres.getSignificance();
            if (curdescription != simres.getOriginalFunctionDescription()) {
                ExecutableResult.finalizeExecutableResult(exetree, execrows);
                curdescription = simres.getOriginalFunctionDescription();
                exetree = new TreeSet();
            }
            curres.exerecord = simres.getMatchFunctionDescription().getExecutableRecord();
            ExecutableResult tmpres = exetree.floor(curres);
            if (tmpres == null || !tmpres.equals(curres)) {
                tmpres = new ExecutableResult(curres.exerecord);
                tmpres.sumsignif = signif;
                exetree.add(tmpres);
                continue;
            }
            if (!(tmpres.getSignificanceSum() < signif)) continue;
            tmpres.sumsignif = signif;
        }
        if (!exetree.isEmpty()) {
            ExecutableResult.finalizeExecutableResult(exetree, execrows);
        }
        return execrows;
    }
}

