/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.bootldr;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.file.formats.android.bootldr.AndroidBootLoaderConstants;
import ghidra.file.formats.android.bootldr.AndroidBootLoaderHeader;
import ghidra.file.formats.android.bootldr.AndroidBootLoaderImageInfo;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemBase;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.factory.GFileSystemBaseFactory;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.CryptoException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@FileSystemInfo(type="androidbootloader", description="Android Boot Loader Image", factory=GFileSystemBaseFactory.class)
public class AndroidBootLoaderFileSystem
extends GFileSystemBase {
    private List<GFileImpl> fileList = new ArrayList<GFileImpl>();
    private List<Integer> offsetList = new ArrayList<Integer>();

    public AndroidBootLoaderFileSystem(String fileSystemName, ByteProvider provider) {
        super(fileSystemName, provider);
    }

    public boolean isValid(TaskMonitor monitor) throws IOException {
        byte[] bytes = this.provider.readBytes(0L, (long)AndroidBootLoaderConstants.BOOTLDR_MAGIC_SIZE);
        return "BOOTLDR!".equals(new String(bytes).trim());
    }

    public void open(TaskMonitor monitor) throws IOException, CryptoException, CancelledException {
        BinaryReader reader = new BinaryReader(this.provider, true);
        AndroidBootLoaderHeader header = new AndroidBootLoaderHeader(reader);
        int runningOffset = header.getStartOffset();
        for (AndroidBootLoaderImageInfo imageInfo : header.getImageInfoList()) {
            GFileImpl file = GFileImpl.fromFilename((GFileSystem)this, (GFile)this.root, (String)imageInfo.getName(), (boolean)false, (long)imageInfo.getSize(), null);
            this.fileList.add(file);
            this.offsetList.add(runningOffset);
            runningOffset += imageInfo.getSize();
        }
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        return new ArrayList<GFileImpl>(this.fileList);
    }

    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        int index = this.fileList.indexOf(file);
        if (index < 0) {
            throw new IOException("Unknown file: " + String.valueOf(file));
        }
        int offset = this.offsetList.get(index);
        return new ByteProviderWrapper(this.provider, (long)offset, file.getLength(), file.getFSRL());
    }
}

