/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.rmi.jpda;

import com.sun.jdi.connect.Connector;
import ghidra.dbg.jdi.manager.JdiCause;
import ghidra.dbg.jdi.manager.impl.JdiManagerImpl;
import ghidra.dbg.jdi.rmi.jpda.JdiArguments;
import ghidra.dbg.jdi.rmi.jpda.JdiCommands;
import ghidra.dbg.jdi.rmi.jpda.JdiConnector;
import ghidra.util.Msg;
import java.util.Map;

public class JdiClientThread
extends Thread {
    private final Map<String, String> env;
    private final JdiArguments arguments;
    private JdiManagerImpl manager;
    private JdiConnector connector;

    public JdiClientThread(Map<String, String> env) {
        this.env = env;
        this.arguments = new JdiArguments(env);
    }

    @Override
    public void run() {
        try {
            this.manager = new JdiManagerImpl();
            this.connector = new JdiConnector(this.manager, this.env);
            Connector cx = this.arguments.getConnector(this.manager.getVirtualMachineManager());
            Map<String, Connector.Argument> args = cx.defaultArguments();
            this.arguments.putArguments(args);
            if (this.manager.addVM(cx, args) != null) {
                this.connector.getCommands().ghidraTraceSyncEnable();
                this.connector.getHooks().vmStarted(null, JdiCause.Causes.UNCLAIMED);
            }
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)"Could not start the JDI client", (Throwable)e);
        }
    }

    public JdiConnector connector() {
        return this.connector;
    }

    public JdiCommands cmds() {
        return this.connector.getCommands();
    }
}

