/*
 * Decompiled with CFR 0.152.
 */
package utility.application;

import ghidra.GhidraApplicationLayout;
import ghidra.GhidraLaunchable;
import ghidra.framework.OperatingSystem;
import ghidra.util.SystemUtilities;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import utilities.util.FileUtilities;
import utility.application.ApplicationLayout;
import utility.application.ApplicationUtilities;

public class AppCleaner
implements GhidraLaunchable {
    @Override
    public void launch(GhidraApplicationLayout layout, String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("Expected 1 argument but got " + args.length);
            System.exit(1);
        }
        String appName = args[0];
        System.out.println("\nDiscovering " + appName + " artifact directories....");
        LinkedHashSet<File> discoveredSet = new LinkedHashSet<File>();
        discoveredSet.addAll(this.findSettingsDirs(appName, layout));
        discoveredSet.addAll(this.findCacheDirs(appName, layout));
        discoveredSet.addAll(this.findTempDirs(appName, layout));
        ArrayList discoveredDirs = new ArrayList(discoveredSet);
        if (discoveredDirs.isEmpty()) {
            System.out.println("NONE FOUND");
            return;
        }
        File potentialParentDir = null;
        for (int i = 0; i < discoveredDirs.size(); ++i) {
            File d = (File)discoveredDirs.get(i);
            File parentDir = d.getParentFile();
            boolean indent = parentDir.equals(potentialParentDir);
            System.out.println("%2d)%s %s".formatted(i + 1, indent ? "   " : "", d));
            if (indent) continue;
            potentialParentDir = d;
        }
        System.out.println("*) All");
        System.out.println("0) Exit");
        System.out.print("Enter a directory to delete: ");
        String choice = null;
        try (Scanner scanner2 = new Scanner(System.in);){
            ArrayList<File> failures = new ArrayList<File>();
            switch (choice = scanner2.nextLine().trim()) {
                case "0": {
                    System.out.println("Exiting...");
                    return;
                }
                case "*": {
                    for (File dir2 : discoveredDirs) {
                        if (!dir2.isDirectory() || FileUtilities.deleteDir(dir2)) continue;
                        failures.add(dir2);
                    }
                    break;
                }
                default: {
                    File dir3 = (File)discoveredDirs.get(Integer.parseInt(choice) - 1);
                    if (FileUtilities.deleteDir(dir3)) break;
                    failures.add(dir3);
                }
            }
            System.out.println(failures.isEmpty() ? "SUCCESS" : "Failed to delete:");
            failures.forEach(dir -> System.out.println("   " + String.valueOf(dir)));
        }
        catch (NoSuchElementException scanner2) {
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            System.out.println("Invalid entry: \"" + choice + "\"");
        }
    }

    private Set<File> findSettingsDirs(String appName, ApplicationLayout layout) {
        LinkedHashSet<File> discoveredDirs = new LinkedHashSet<File>();
        appName = ApplicationUtilities.normalizeApplicationName(appName);
        String userNameAndAppName = SystemUtilities.getUserName() + "-" + appName;
        this.getDirFromProperty("user.home", "." + appName).ifPresent(dir -> {
            discoveredDirs.add((File)dir);
            discoveredDirs.addAll(this.getSubdirs((File)dir));
        });
        File settingsDir = layout.getUserSettingsDir();
        File settingsParentDir = settingsDir.getParentFile();
        if (settingsParentDir != null && (settingsParentDir.getName().equals(appName) || settingsParentDir.getName().equals(userNameAndAppName))) {
            discoveredDirs.add(settingsParentDir);
            discoveredDirs.addAll(this.getSubdirs(settingsParentDir));
        }
        this.getDirFromProperty("application.settingsdir", appName).ifPresent(dir -> {
            discoveredDirs.add((File)dir);
            discoveredDirs.addAll(this.getSubdirs((File)dir));
        });
        this.getDirFromProperty("application.settingsdir", userNameAndAppName).ifPresent(dir -> {
            discoveredDirs.add((File)dir);
            discoveredDirs.addAll(this.getSubdirs((File)dir));
        });
        this.getDirFromEnv("XDG_CONFIG_HOME", appName).ifPresent(dir -> {
            discoveredDirs.add((File)dir);
            discoveredDirs.addAll(this.getSubdirs((File)dir));
        });
        this.getDirFromEnv("XDG_CONFIG_HOME", userNameAndAppName).ifPresent(dir -> {
            discoveredDirs.add((File)dir);
            discoveredDirs.addAll(this.getSubdirs((File)dir));
        });
        return discoveredDirs;
    }

    private Set<File> findCacheDirs(String appName, ApplicationLayout layout) {
        LinkedHashSet<File> discoveredDirs = new LinkedHashSet<File>();
        if (OperatingSystem.CURRENT_OPERATING_SYSTEM.equals((Object)OperatingSystem.WINDOWS)) {
            this.getDirFromEnv("LOCALAPPDATA", appName).ifPresent(discoveredDirs::add);
        } else {
            String legacyName = SystemUtilities.getUserName() + "-" + appName;
            this.getDirFromProperty("java.io.tmpdir", legacyName).ifPresent(discoveredDirs::add);
        }
        appName = ApplicationUtilities.normalizeApplicationName(appName);
        String userNameAndAppName = SystemUtilities.getUserName() + "-" + appName;
        File cacheDir = layout.getUserCacheDir();
        if (cacheDir != null && cacheDir.isDirectory()) {
            discoveredDirs.add(cacheDir);
        }
        this.getDirFromProperty("application.cachedir", appName).ifPresent(discoveredDirs::add);
        this.getDirFromProperty("application.cachedir", userNameAndAppName).ifPresent(discoveredDirs::add);
        this.getDirFromEnv("XDG_CACHE_HOME", appName).ifPresent(discoveredDirs::add);
        this.getDirFromEnv("XDG_CACHE_HOME", userNameAndAppName).ifPresent(discoveredDirs::add);
        return discoveredDirs;
    }

    private Set<File> findTempDirs(String appName, ApplicationLayout layout) {
        LinkedHashSet<File> discoveredDirs = new LinkedHashSet<File>();
        String legacyName = SystemUtilities.getUserName() + "-" + appName;
        if (OperatingSystem.CURRENT_OPERATING_SYSTEM.equals((Object)OperatingSystem.WINDOWS)) {
            this.getDirFromEnv("TEMP", legacyName).ifPresent(discoveredDirs::add);
        } else {
            this.getDirFromProperty("java.io.tmpdir", legacyName).ifPresent(discoveredDirs::add);
        }
        appName = ApplicationUtilities.normalizeApplicationName(appName);
        String userNameAndAppName = SystemUtilities.getUserName() + "-" + appName;
        File tempDir = layout.getUserTempDir();
        if (tempDir != null && tempDir.isDirectory()) {
            discoveredDirs.add(tempDir);
        }
        this.getDirFromProperty("application.tempdir", appName).ifPresent(discoveredDirs::add);
        this.getDirFromProperty("application.tempdir", userNameAndAppName).ifPresent(discoveredDirs::add);
        this.getDirFromEnv("XDG_RUNTIME_DIR", appName).ifPresent(discoveredDirs::add);
        this.getDirFromEnv("XDG_RUNTIME_DIR", userNameAndAppName).ifPresent(discoveredDirs::add);
        return discoveredDirs;
    }

    private Optional<File> getDirFromProperty(String propertyName, String subdirName) {
        File dir;
        String path = System.getProperty(propertyName, "").trim();
        if (!path.isEmpty() && (dir = new File(path, subdirName)).isDirectory()) {
            return Optional.of(dir);
        }
        return Optional.empty();
    }

    private Optional<File> getDirFromEnv(String envName, String subdirName) {
        File dir;
        String path = System.getenv(envName);
        if (path != null && !path.isBlank() && (dir = new File(path, subdirName)).isDirectory()) {
            return Optional.of(dir);
        }
        return Optional.empty();
    }

    private List<File> getSubdirs(File dir) {
        File[] listing = dir.listFiles(File::isDirectory);
        return listing != null ? Arrays.asList(listing) : List.of();
    }
}

