/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.Collections;
import java.util.Map;
import org.knopflerfish.framework.BundlePackages;
import org.knopflerfish.framework.DTOId;
import org.knopflerfish.framework.Util;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.VersionRange;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;

class RequireBundle
extends DTOId
implements BundleRequirement,
Comparable<RequireBundle> {
    private static int requireBundleCount = 0;
    final int orderal = ++requireBundleCount;
    final BundlePackages requestor;
    final String name;
    final String visibility;
    final String resolution;
    final VersionRange bundleRange;
    BundlePackages bpkgs = null;
    final Map<String, Object> attributes;
    final Map<String, String> directives;

    RequireBundle(RequireBundle parent, BundlePackages requestor) {
        this.requestor = requestor;
        this.name = parent.name;
        this.visibility = parent.visibility;
        this.resolution = parent.resolution;
        this.bundleRange = parent.bundleRange;
        this.attributes = parent.attributes;
        this.directives = parent.directives;
    }

    RequireBundle(BundlePackages requestor, Util.HeaderEntry he) {
        String resolution;
        this.requestor = requestor;
        this.name = he.getKey();
        Map<String, String> dirs = he.getDirectives();
        String visibility = dirs.get("visibility");
        if (visibility != null) {
            this.visibility = visibility.intern();
            if (this.visibility != "private" && this.visibility != "reexport") {
                throw new IllegalArgumentException("Invalid directive : 'visibility:=" + this.visibility + "' in manifest header '" + "Require-Bundle" + ": " + this.name + "' of bundle with id " + this.requestor.bg.bundle.getBundleId() + " (" + this.requestor.bg.symbolicName + ")" + ". The value must be either '" + "private" + "' or '" + "reexport" + "'.");
            }
        } else {
            this.visibility = "private";
        }
        if ((resolution = dirs.get("resolution")) != null) {
            this.resolution = resolution.intern();
            if (this.resolution != "mandatory" && this.resolution != "optional") {
                throw new IllegalArgumentException("Invalid directive : 'resolution:=" + this.resolution + "' in manifest header '" + "Require-Bundle" + ": " + this.name + "' of bundle with id " + this.requestor.bg.bundle.getBundleId() + " (" + this.requestor.bg.symbolicName + ")" + ". The value must be either '" + "mandatory" + "' or '" + "optional" + "'.");
            }
        } else {
            this.resolution = "mandatory";
        }
        this.attributes = he.getAttributes();
        String range = (String)this.attributes.remove("bundle-version");
        this.bundleRange = range != null ? new VersionRange(range) : null;
        Filter filter = this.toFilter();
        if (null != filter) {
            dirs.put("filter", ((Object)filter).toString());
        }
        this.directives = Collections.unmodifiableMap(dirs);
    }

    boolean overlap(RequireBundle rb) {
        if (this.visibility.equals("reexport") && !rb.visibility.equals("reexport")) {
            return false;
        }
        if (this.resolution.equals("mandatory") && !rb.resolution.equals("mandatory")) {
            return false;
        }
        return this.bundleRange == null || rb.bundleRange == null || !this.bundleRange.intersection(rb.bundleRange).isEmpty();
    }

    @Override
    public String getNamespace() {
        return "osgi.wiring.bundle";
    }

    @Override
    public Map<String, String> getDirectives() {
        return this.directives;
    }

    private Filter toFilter() {
        StringBuffer sb = new StringBuffer(80);
        boolean multipleConditions = false;
        sb.append('(');
        sb.append("osgi.wiring.bundle");
        sb.append('=');
        sb.append(this.name);
        sb.append(')');
        if (this.bundleRange != null) {
            sb.append(this.bundleRange.toFilterString("bundle-version"));
            multipleConditions = true;
        }
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            sb.append('(');
            sb.append(entry.getKey());
            sb.append('=');
            sb.append(entry.getValue().toString());
            sb.append(')');
            multipleConditions = true;
        }
        if (multipleConditions) {
            sb.insert(0, "(&");
            sb.append(')');
        }
        try {
            return FrameworkUtil.createFilter(sb.toString());
        }
        catch (InvalidSyntaxException _ise) {
            throw new RuntimeException("Internal error, createFilter: '" + sb.toString() + "': " + _ise.getMessage());
        }
    }

    @Override
    public Map<String, Object> getAttributes() {
        return Collections.EMPTY_MAP;
    }

    @Override
    public BundleRevision getRevision() {
        return this.requestor.bg.bundleRevision;
    }

    @Override
    public BundleRevision getResource() {
        return this.requestor.bg.bundleRevision;
    }

    @Override
    public boolean matches(BundleCapability capability) {
        if ("osgi.wiring.bundle".equals(capability.getNamespace())) {
            return this.toFilter().matches(capability.getAttributes());
        }
        return false;
    }

    @Override
    public int compareTo(RequireBundle o) {
        return this.orderal - o.orderal;
    }
}

