# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_bcachefs_global_optspecs
	string join \n h/help
end

function __fish_bcachefs_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_bcachefs_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_bcachefs_using_subcommand
	set -l cmd (__fish_bcachefs_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c bcachefs -n "__fish_bcachefs_needs_command" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "list" -d 'List filesystem metadata in textual form'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "mount" -d 'Mount a bcachefs filesystem by its UUID'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "completions" -d 'Generate shell completions'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "subvolume" -d 'Subvolumes-related commands'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "subvol" -d 'Subvolumes-related commands'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list" -s m -l mode -r -f -a "{keys\t'',formats\t'',nodes\t'',nodes-ondisk\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list" -s b -l btree -d 'Btree to list from' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list" -s k -l bkey-type -d 'Bkey type to list' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list" -s l -l level -d 'Btree depth to descend to (0 == leaves)' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list" -s s -l start -d 'Start position to list from' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list" -s e -l end -d 'End position' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list" -s c -l colorize -d 'Force color on/off. Default: autodetect tty' -r -f -a "{true\t'',false\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list" -s f -l fsck -d 'Check (fsck) the filesystem first'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list" -s v -l verbose -d 'Verbose mode'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand mount" -s f -l passphrase-file -d 'Path to passphrase file' -r -F
complete -c bcachefs -n "__fish_bcachefs_using_subcommand mount" -s k -l key_location -d 'Passphrase policy to use in case of an encrypted filesystem. If not specified, the password will be searched for in the keyring. If not found, the password will be prompted or read from stdin, depending on whether the stdin is connected to a terminal or not' -r -f -a "{fail\t'Don\'t ask for passphrase, if the key cannot be found in the keyring just fail',wait\t'Wait for passphrase to become available before mounting',ask\t'Interactively prompt the user for a passphrase',stdin\t'Try to read the passphrase from `stdin` without prompting'}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand mount" -s o -d 'Mount options' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand mount" -s t -l type -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand mount" -s c -l colorize -d 'Force color on/off. Autodetect tty is used to define default:' -r -f -a "{true\t'',false\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand mount" -s v -l verbose -d 'Verbose mode'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand mount" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand mount" -s V -l version -d 'Print version'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand completions" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and not __fish_seen_subcommand_from create new delete del snapshot snap help" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and not __fish_seen_subcommand_from create new delete del snapshot snap help" -f -a "create"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and not __fish_seen_subcommand_from create new delete del snapshot snap help" -f -a "new"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and not __fish_seen_subcommand_from create new delete del snapshot snap help" -f -a "delete"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and not __fish_seen_subcommand_from create new delete del snapshot snap help" -f -a "del"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and not __fish_seen_subcommand_from create new delete del snapshot snap help" -f -a "snapshot"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and not __fish_seen_subcommand_from create new delete del snapshot snap help" -f -a "snap"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and not __fish_seen_subcommand_from create new delete del snapshot snap help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from create" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from new" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from delete" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from del" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from snapshot" -s r -l read-only -d 'Make snapshot read only'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from snapshot" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from snap" -s r -l read-only -d 'Make snapshot read only'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from snap" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from help" -f -a "create"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from help" -f -a "delete"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from help" -f -a "snapshot"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and not __fish_seen_subcommand_from create new delete del snapshot snap help" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and not __fish_seen_subcommand_from create new delete del snapshot snap help" -f -a "create"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and not __fish_seen_subcommand_from create new delete del snapshot snap help" -f -a "new"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and not __fish_seen_subcommand_from create new delete del snapshot snap help" -f -a "delete"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and not __fish_seen_subcommand_from create new delete del snapshot snap help" -f -a "del"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and not __fish_seen_subcommand_from create new delete del snapshot snap help" -f -a "snapshot"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and not __fish_seen_subcommand_from create new delete del snapshot snap help" -f -a "snap"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and not __fish_seen_subcommand_from create new delete del snapshot snap help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from create" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from new" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from delete" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from del" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from snapshot" -s r -l read-only -d 'Make snapshot read only'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from snapshot" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from snap" -s r -l read-only -d 'Make snapshot read only'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from snap" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from help" -f -a "create"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from help" -f -a "delete"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from help" -f -a "snapshot"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume help" -f -a "list" -d 'List filesystem metadata in textual form'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume help" -f -a "mount" -d 'Mount a bcachefs filesystem by its UUID'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume help" -f -a "completions" -d 'Generate shell completions'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume help" -f -a "subvolume" -d 'Subvolumes-related commands'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and __fish_seen_subcommand_from subvolume" -f -a "create"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and __fish_seen_subcommand_from subvolume" -f -a "delete"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and __fish_seen_subcommand_from subvolume" -f -a "snapshot"
