/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSStyleImageValue.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCSSStyleImageValueConstructor);

class JSCSSStyleImageValuePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCSSStyleImageValuePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSStyleImageValuePrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSStyleImageValuePrototype>(vm)) JSCSSStyleImageValuePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSStyleImageValuePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSStyleImageValuePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSStyleImageValuePrototype, JSCSSStyleImageValuePrototype::Base);

using JSCSSStyleImageValueDOMConstructor = JSDOMConstructorNotConstructable<JSCSSStyleImageValue>;

template<> const ClassInfo JSCSSStyleImageValueDOMConstructor::s_info = { "CSSImageValue"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSStyleImageValueDOMConstructor) };

template<> JSValue JSCSSStyleImageValueDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSCSSStyleValue::getConstructor(vm, &globalObject);
}

template<> void JSCSSStyleImageValueDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CSSImageValue"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCSSStyleImageValue::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 1> JSCSSStyleImageValuePrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleImageValueConstructor, 0 } },
};

const ClassInfo JSCSSStyleImageValuePrototype::s_info = { "CSSImageValue"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSStyleImageValuePrototype) };

void JSCSSStyleImageValuePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSSStyleImageValue::info(), JSCSSStyleImageValuePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCSSStyleImageValue::s_info = { "CSSImageValue"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSStyleImageValue) };

JSCSSStyleImageValue::JSCSSStyleImageValue(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSStyleImageValue>&& impl)
    : JSCSSStyleValue(structure, globalObject, WTFMove(impl))
{
}

Ref<CSSStyleImageValue> JSCSSStyleImageValue::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, CSSStyleImageValue>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCSSStyleImageValue::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCSSStyleImageValuePrototype::createStructure(vm, &globalObject, JSCSSStyleValue::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSCSSStyleImageValuePrototype::create(vm, &globalObject, structure);
}

JSObject* JSCSSStyleImageValue::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCSSStyleImageValue>(vm, globalObject);
}

JSValue JSCSSStyleImageValue::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSStyleImageValueDOMConstructor, DOMConstructorID::CSSStyleImageValue>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSStyleImageValueConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCSSStyleImageValuePrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCSSStyleImageValue::getConstructor(vm, prototype->globalObject()));
}

JSC::GCClient::IsoSubspace* JSCSSStyleImageValue::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCSSStyleImageValue, UseCustomHeapCellType::No>(vm, "JSCSSStyleImageValue"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCSSStyleImageValue.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCSSStyleImageValue = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCSSStyleImageValue.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCSSStyleImageValue = std::forward<decltype(space)>(space); }
    );
}

void JSCSSStyleImageValue::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCSSStyleImageValue*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

CSSStyleImageValue* JSCSSStyleImageValue::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCSSStyleImageValue*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
