/** @file
 * VirtualBox API class wrapper code for IVRDEServer.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_VRDESERVER

#include "VRDEServerWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(VRDEServerWrap)

//
// IVRDEServer properties
//

STDMETHODIMP VRDEServerWrap::COMGETTER(Enabled)(BOOL *aEnabled)
{
    LogRelFlow(("{%p} %s: enter aEnabled=%p\n", this, "VRDEServer::getEnabled", aEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_GET_ENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEnabled(aEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_GET_ENABLED_RETURN(this, hrc, 0 /*normal*/,*aEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_GET_ENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_GET_ENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEnabled=%RTbool hrc=%Rhrc\n", this, "VRDEServer::getEnabled", *aEnabled, hrc));
    return hrc;
}

STDMETHODIMP VRDEServerWrap::COMSETTER(Enabled)(BOOL aEnabled)
{
    LogRelFlow(("{%p} %s: enter aEnabled=%RTbool\n", this, "VRDEServer::setEnabled", aEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_SET_ENABLED_ENTER(this, aEnabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setEnabled(aEnabled != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_SET_ENABLED_RETURN(this, hrc, 0 /*normal*/,aEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_SET_ENABLED_RETURN(this, hrc, 1 /*hrc exception*/,aEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_SET_ENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,aEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "VRDEServer::setEnabled", hrc));
    return hrc;
}

STDMETHODIMP VRDEServerWrap::COMGETTER(AuthType)(AuthType_T *aAuthType)
{
    LogRelFlow(("{%p} %s: enter aAuthType=%p\n", this, "VRDEServer::getAuthType", aAuthType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAuthType);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_GET_AUTHTYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAuthType(aAuthType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_GET_AUTHTYPE_RETURN(this, hrc, 0 /*normal*/,*aAuthType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_GET_AUTHTYPE_RETURN(this, hrc, 1 /*hrc exception*/,*aAuthType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_GET_AUTHTYPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aAuthType);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAuthType=%RU32 hrc=%Rhrc\n", this, "VRDEServer::getAuthType", *aAuthType, hrc));
    return hrc;
}

STDMETHODIMP VRDEServerWrap::COMSETTER(AuthType)(AuthType_T aAuthType)
{
    LogRelFlow(("{%p} %s: enter aAuthType=%RU32\n", this, "VRDEServer::setAuthType", aAuthType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_SET_AUTHTYPE_ENTER(this, aAuthType);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setAuthType(aAuthType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_SET_AUTHTYPE_RETURN(this, hrc, 0 /*normal*/,aAuthType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_SET_AUTHTYPE_RETURN(this, hrc, 1 /*hrc exception*/,aAuthType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_SET_AUTHTYPE_RETURN(this, hrc, 9 /*unhandled exception*/,aAuthType);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "VRDEServer::setAuthType", hrc));
    return hrc;
}

STDMETHODIMP VRDEServerWrap::COMGETTER(AuthTimeout)(ULONG *aAuthTimeout)
{
    LogRelFlow(("{%p} %s: enter aAuthTimeout=%p\n", this, "VRDEServer::getAuthTimeout", aAuthTimeout));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAuthTimeout);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_GET_AUTHTIMEOUT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAuthTimeout(aAuthTimeout);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_GET_AUTHTIMEOUT_RETURN(this, hrc, 0 /*normal*/,*aAuthTimeout);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_GET_AUTHTIMEOUT_RETURN(this, hrc, 1 /*hrc exception*/,*aAuthTimeout);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_GET_AUTHTIMEOUT_RETURN(this, hrc, 9 /*unhandled exception*/,*aAuthTimeout);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAuthTimeout=%RU32 hrc=%Rhrc\n", this, "VRDEServer::getAuthTimeout", *aAuthTimeout, hrc));
    return hrc;
}

STDMETHODIMP VRDEServerWrap::COMSETTER(AuthTimeout)(ULONG aAuthTimeout)
{
    LogRelFlow(("{%p} %s: enter aAuthTimeout=%RU32\n", this, "VRDEServer::setAuthTimeout", aAuthTimeout));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_SET_AUTHTIMEOUT_ENTER(this, aAuthTimeout);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setAuthTimeout(aAuthTimeout);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_SET_AUTHTIMEOUT_RETURN(this, hrc, 0 /*normal*/,aAuthTimeout);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_SET_AUTHTIMEOUT_RETURN(this, hrc, 1 /*hrc exception*/,aAuthTimeout);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_SET_AUTHTIMEOUT_RETURN(this, hrc, 9 /*unhandled exception*/,aAuthTimeout);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "VRDEServer::setAuthTimeout", hrc));
    return hrc;
}

STDMETHODIMP VRDEServerWrap::COMGETTER(AllowMultiConnection)(BOOL *aAllowMultiConnection)
{
    LogRelFlow(("{%p} %s: enter aAllowMultiConnection=%p\n", this, "VRDEServer::getAllowMultiConnection", aAllowMultiConnection));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAllowMultiConnection);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_GET_ALLOWMULTICONNECTION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAllowMultiConnection(aAllowMultiConnection);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_GET_ALLOWMULTICONNECTION_RETURN(this, hrc, 0 /*normal*/,*aAllowMultiConnection != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_GET_ALLOWMULTICONNECTION_RETURN(this, hrc, 1 /*hrc exception*/,*aAllowMultiConnection != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_GET_ALLOWMULTICONNECTION_RETURN(this, hrc, 9 /*unhandled exception*/,*aAllowMultiConnection != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAllowMultiConnection=%RTbool hrc=%Rhrc\n", this, "VRDEServer::getAllowMultiConnection", *aAllowMultiConnection, hrc));
    return hrc;
}

STDMETHODIMP VRDEServerWrap::COMSETTER(AllowMultiConnection)(BOOL aAllowMultiConnection)
{
    LogRelFlow(("{%p} %s: enter aAllowMultiConnection=%RTbool\n", this, "VRDEServer::setAllowMultiConnection", aAllowMultiConnection));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_SET_ALLOWMULTICONNECTION_ENTER(this, aAllowMultiConnection != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setAllowMultiConnection(aAllowMultiConnection != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_SET_ALLOWMULTICONNECTION_RETURN(this, hrc, 0 /*normal*/,aAllowMultiConnection != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_SET_ALLOWMULTICONNECTION_RETURN(this, hrc, 1 /*hrc exception*/,aAllowMultiConnection != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_SET_ALLOWMULTICONNECTION_RETURN(this, hrc, 9 /*unhandled exception*/,aAllowMultiConnection != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "VRDEServer::setAllowMultiConnection", hrc));
    return hrc;
}

STDMETHODIMP VRDEServerWrap::COMGETTER(ReuseSingleConnection)(BOOL *aReuseSingleConnection)
{
    LogRelFlow(("{%p} %s: enter aReuseSingleConnection=%p\n", this, "VRDEServer::getReuseSingleConnection", aReuseSingleConnection));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aReuseSingleConnection);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_GET_REUSESINGLECONNECTION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getReuseSingleConnection(aReuseSingleConnection);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_GET_REUSESINGLECONNECTION_RETURN(this, hrc, 0 /*normal*/,*aReuseSingleConnection != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_GET_REUSESINGLECONNECTION_RETURN(this, hrc, 1 /*hrc exception*/,*aReuseSingleConnection != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_GET_REUSESINGLECONNECTION_RETURN(this, hrc, 9 /*unhandled exception*/,*aReuseSingleConnection != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aReuseSingleConnection=%RTbool hrc=%Rhrc\n", this, "VRDEServer::getReuseSingleConnection", *aReuseSingleConnection, hrc));
    return hrc;
}

STDMETHODIMP VRDEServerWrap::COMSETTER(ReuseSingleConnection)(BOOL aReuseSingleConnection)
{
    LogRelFlow(("{%p} %s: enter aReuseSingleConnection=%RTbool\n", this, "VRDEServer::setReuseSingleConnection", aReuseSingleConnection));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_SET_REUSESINGLECONNECTION_ENTER(this, aReuseSingleConnection != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setReuseSingleConnection(aReuseSingleConnection != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_SET_REUSESINGLECONNECTION_RETURN(this, hrc, 0 /*normal*/,aReuseSingleConnection != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_SET_REUSESINGLECONNECTION_RETURN(this, hrc, 1 /*hrc exception*/,aReuseSingleConnection != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_SET_REUSESINGLECONNECTION_RETURN(this, hrc, 9 /*unhandled exception*/,aReuseSingleConnection != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "VRDEServer::setReuseSingleConnection", hrc));
    return hrc;
}

STDMETHODIMP VRDEServerWrap::COMGETTER(VRDEExtPack)(BSTR *aVRDEExtPack)
{
    LogRelFlow(("{%p} %s: enter aVRDEExtPack=%p\n", this, "VRDEServer::getVRDEExtPack", aVRDEExtPack));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVRDEExtPack);
        BSTROutConverter TmpVRDEExtPack(aVRDEExtPack);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_GET_VRDEEXTPACK_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVRDEExtPack(TmpVRDEExtPack.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_GET_VRDEEXTPACK_RETURN(this, hrc, 0 /*normal*/,TmpVRDEExtPack.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_GET_VRDEEXTPACK_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_GET_VRDEEXTPACK_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVRDEExtPack=%ls hrc=%Rhrc\n", this, "VRDEServer::getVRDEExtPack", *aVRDEExtPack, hrc));
    return hrc;
}

STDMETHODIMP VRDEServerWrap::COMSETTER(VRDEExtPack)(IN_BSTR aVRDEExtPack)
{
    LogRelFlow(("{%p} %s: enter aVRDEExtPack=%ls\n", this, "VRDEServer::setVRDEExtPack", aVRDEExtPack));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpVRDEExtPack(aVRDEExtPack);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_SET_VRDEEXTPACK_ENTER(this, TmpVRDEExtPack.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setVRDEExtPack(TmpVRDEExtPack.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_SET_VRDEEXTPACK_RETURN(this, hrc, 0 /*normal*/,TmpVRDEExtPack.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_SET_VRDEEXTPACK_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_SET_VRDEEXTPACK_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "VRDEServer::setVRDEExtPack", hrc));
    return hrc;
}

STDMETHODIMP VRDEServerWrap::COMGETTER(AuthLibrary)(BSTR *aAuthLibrary)
{
    LogRelFlow(("{%p} %s: enter aAuthLibrary=%p\n", this, "VRDEServer::getAuthLibrary", aAuthLibrary));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAuthLibrary);
        BSTROutConverter TmpAuthLibrary(aAuthLibrary);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_GET_AUTHLIBRARY_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAuthLibrary(TmpAuthLibrary.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_GET_AUTHLIBRARY_RETURN(this, hrc, 0 /*normal*/,TmpAuthLibrary.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_GET_AUTHLIBRARY_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_GET_AUTHLIBRARY_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAuthLibrary=%ls hrc=%Rhrc\n", this, "VRDEServer::getAuthLibrary", *aAuthLibrary, hrc));
    return hrc;
}

STDMETHODIMP VRDEServerWrap::COMSETTER(AuthLibrary)(IN_BSTR aAuthLibrary)
{
    LogRelFlow(("{%p} %s: enter aAuthLibrary=%ls\n", this, "VRDEServer::setAuthLibrary", aAuthLibrary));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpAuthLibrary(aAuthLibrary);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_SET_AUTHLIBRARY_ENTER(this, TmpAuthLibrary.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setAuthLibrary(TmpAuthLibrary.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_SET_AUTHLIBRARY_RETURN(this, hrc, 0 /*normal*/,TmpAuthLibrary.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_SET_AUTHLIBRARY_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_SET_AUTHLIBRARY_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "VRDEServer::setAuthLibrary", hrc));
    return hrc;
}

STDMETHODIMP VRDEServerWrap::COMGETTER(VRDEProperties)(ComSafeArrayOut(BSTR, aVRDEProperties))
{
    LogRelFlow(("{%p} %s: enter aVRDEProperties=%p\n", this, "VRDEServer::getVRDEProperties", aVRDEProperties));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVRDEProperties);
        ArrayBSTROutConverter TmpVRDEProperties(ComSafeArrayOutArg(aVRDEProperties));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_GET_VRDEPROPERTIES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVRDEProperties(TmpVRDEProperties.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_GET_VRDEPROPERTIES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpVRDEProperties.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_GET_VRDEPROPERTIES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_GET_VRDEPROPERTIES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVRDEProperties=%zu hrc=%Rhrc\n", this, "VRDEServer::getVRDEProperties", ComSafeArraySize(*aVRDEProperties), hrc));
    return hrc;
}

STDMETHODIMP VRDEServerWrap::COMGETTER(InternalAndReservedAttribute1IVRDEServer)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP VRDEServerWrap::COMGETTER(InternalAndReservedAttribute2IVRDEServer)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP VRDEServerWrap::COMGETTER(InternalAndReservedAttribute3IVRDEServer)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP VRDEServerWrap::COMGETTER(InternalAndReservedAttribute4IVRDEServer)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IVRDEServer methods
//

STDMETHODIMP VRDEServerWrap::SetVRDEProperty(IN_BSTR aKey,
                                             IN_BSTR aValue)
{
    LogRelFlow(("{%p} %s: enter aKey=%ls aValue=%ls\n", this, "VRDEServer::setVRDEProperty", aKey, aValue));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpKey(aKey);
        BSTRInConverter TmpValue(aValue);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_SETVRDEPROPERTY_ENTER(this, TmpKey.str().c_str(), TmpValue.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setVRDEProperty(TmpKey.str(),
                                  TmpValue.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_SETVRDEPROPERTY_RETURN(this, hrc, 0 /*normal*/, TmpKey.str().c_str(), TmpValue.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_SETVRDEPROPERTY_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_SETVRDEPROPERTY_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "VRDEServer::setVRDEProperty", hrc));
    return hrc;
}

STDMETHODIMP VRDEServerWrap::GetVRDEProperty(IN_BSTR aKey,
                                             BSTR *aValue)
{
    LogRelFlow(("{%p} %s: enter aKey=%ls aValue=%p\n", this, "VRDEServer::getVRDEProperty", aKey, aValue));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aValue);


        BSTRInConverter TmpKey(aKey);
        BSTROutConverter TmpValue(aValue);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_GETVRDEPROPERTY_ENTER(this, TmpKey.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVRDEProperty(TmpKey.str(),
                                  TmpValue.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_GETVRDEPROPERTY_RETURN(this, hrc, 0 /*normal*/, TmpKey.str().c_str(), TmpValue.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_GETVRDEPROPERTY_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VRDESERVER_GETVRDEPROPERTY_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aValue=%ls hrc=%Rhrc\n", this, "VRDEServer::getVRDEProperty", *aValue, hrc));
    return hrc;
}

STDMETHODIMP VRDEServerWrap::InternalAndReservedMethod1IVRDEServer()
{
    return E_NOTIMPL;
}

STDMETHODIMP VRDEServerWrap::InternalAndReservedMethod2IVRDEServer()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(VRDEServerWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(VRDEServerWrap, IVRDEServer)
#endif // VBOX_WITH_XPCOM
