//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/imaging/hd/purposeSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
#include "pxr/imaging/hd/tokens.h"
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(HdPurposeSchemaTokens,
    HD_PURPOSE_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--

TfToken
HdPurposeSchema::ResolvePurposeValue()
{
    if (IsDefined()) {
        if (HdTokenDataSourceHandle purposeDs = GetPurpose()) {
            return purposeDs->GetTypedValue(0);
        }
        if (HdTokenDataSourceHandle fallbackDs = GetFallback()) {
            return fallbackDs->GetTypedValue(0);
        }
    }
    // Hydra's default purpose.
    return HdRenderTagTokens->geometry;
}

// --(END CUSTOM CODE: Schema Methods)--

HdTokenDataSourceHandle
HdPurposeSchema::GetPurpose() const
{
    return _GetTypedDataSource<HdTokenDataSource>(
        HdPurposeSchemaTokens->purpose);
}

HdBoolDataSourceHandle
HdPurposeSchema::GetInheritable() const
{
    return _GetTypedDataSource<HdBoolDataSource>(
        HdPurposeSchemaTokens->inheritable);
}

HdTokenDataSourceHandle
HdPurposeSchema::GetFallback() const
{
    return _GetTypedDataSource<HdTokenDataSource>(
        HdPurposeSchemaTokens->fallback);
}

/*static*/
HdContainerDataSourceHandle
HdPurposeSchema::BuildRetained(
        const HdTokenDataSourceHandle &purpose,
        const HdBoolDataSourceHandle &inheritable,
        const HdTokenDataSourceHandle &fallback
)
{
    TfToken _names[3];
    HdDataSourceBaseHandle _values[3];

    size_t _count = 0;

    if (purpose) {
        _names[_count] = HdPurposeSchemaTokens->purpose;
        _values[_count++] = purpose;
    }

    if (inheritable) {
        _names[_count] = HdPurposeSchemaTokens->inheritable;
        _values[_count++] = inheritable;
    }

    if (fallback) {
        _names[_count] = HdPurposeSchemaTokens->fallback;
        _values[_count++] = fallback;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

HdPurposeSchema::Builder &
HdPurposeSchema::Builder::SetPurpose(
    const HdTokenDataSourceHandle &purpose)
{
    _purpose = purpose;
    return *this;
}

HdPurposeSchema::Builder &
HdPurposeSchema::Builder::SetInheritable(
    const HdBoolDataSourceHandle &inheritable)
{
    _inheritable = inheritable;
    return *this;
}

HdPurposeSchema::Builder &
HdPurposeSchema::Builder::SetFallback(
    const HdTokenDataSourceHandle &fallback)
{
    _fallback = fallback;
    return *this;
}

HdContainerDataSourceHandle
HdPurposeSchema::Builder::Build()
{
    return HdPurposeSchema::BuildRetained(
        _purpose,
        _inheritable,
        _fallback
    );
}

/*static*/
HdPurposeSchema
HdPurposeSchema::GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer)
{
    return HdPurposeSchema(
        fromParentContainer
        ? HdContainerDataSource::Cast(fromParentContainer->Get(
                HdPurposeSchemaTokens->purpose))
        : nullptr);
}

/*static*/
const TfToken &
HdPurposeSchema::GetSchemaToken()
{
    return HdPurposeSchemaTokens->purpose;
}

/*static*/
const HdDataSourceLocator &
HdPurposeSchema::GetDefaultLocator()
{
    static const HdDataSourceLocator locator(GetSchemaToken());
    return locator;
} 

PXR_NAMESPACE_CLOSE_SCOPE