// python wrapper for ttkTopologicalCompression
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkTopologicalCompression.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkTopologicalCompression(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkTopologicalCompression_ClassNew(); }


static PyObject *
PyttkTopologicalCompression_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkTopologicalCompression::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompression_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompression *op = static_cast<ttkTopologicalCompression *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkTopologicalCompression::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompression_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkTopologicalCompression *tempr = ttkTopologicalCompression::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompression_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompression *op = static_cast<ttkTopologicalCompression *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkTopologicalCompression *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkTopologicalCompression::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompression_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkTopologicalCompression::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompression_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompression *op = static_cast<ttkTopologicalCompression *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkTopologicalCompression::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompression_SetTolerance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTolerance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompression *op = static_cast<ttkTopologicalCompression *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTolerance(temp0);
    }
    else
    {
      op->ttkTopologicalCompression::SetTolerance(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompression_GetTolerance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTolerance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompression *op = static_cast<ttkTopologicalCompression *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetTolerance() :
      op->ttkTopologicalCompression::GetTolerance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompression_SetMaximumError(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMaximumError");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompression *op = static_cast<ttkTopologicalCompression *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMaximumError(temp0);
    }
    else
    {
      op->ttkTopologicalCompression::SetMaximumError(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompression_GetMaximumError(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMaximumError");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompression *op = static_cast<ttkTopologicalCompression *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetMaximumError() :
      op->ttkTopologicalCompression::GetMaximumError());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompression_SetCompressionType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCompressionType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompression *op = static_cast<ttkTopologicalCompression *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCompressionType(temp0);
    }
    else
    {
      op->ttkTopologicalCompression::SetCompressionType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompression_GetCompressionType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCompressionType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompression *op = static_cast<ttkTopologicalCompression *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetCompressionType() :
      op->ttkTopologicalCompression::GetCompressionType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompression_SetSQMethod(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSQMethod");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompression *op = static_cast<ttkTopologicalCompression *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSQMethod(temp0);
    }
    else
    {
      op->ttkTopologicalCompression::SetSQMethod(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompression_GetSQMethod(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSQMethod");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompression *op = static_cast<ttkTopologicalCompression *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetSQMethod() :
      op->ttkTopologicalCompression::GetSQMethod());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompression_SetSubdivide(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSubdivide");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompression *op = static_cast<ttkTopologicalCompression *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSubdivide(temp0);
    }
    else
    {
      op->ttkTopologicalCompression::SetSubdivide(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompression_GetSubdivide(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSubdivide");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompression *op = static_cast<ttkTopologicalCompression *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetSubdivide() :
      op->ttkTopologicalCompression::GetSubdivide());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompression_SetUseTopologicalSimplification(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseTopologicalSimplification");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompression *op = static_cast<ttkTopologicalCompression *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseTopologicalSimplification(temp0);
    }
    else
    {
      op->ttkTopologicalCompression::SetUseTopologicalSimplification(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompression_GetUseTopologicalSimplification(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseTopologicalSimplification");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompression *op = static_cast<ttkTopologicalCompression *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseTopologicalSimplification() :
      op->ttkTopologicalCompression::GetUseTopologicalSimplification());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompression_SetSQMethodPV(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSQMethodPV");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompression *op = static_cast<ttkTopologicalCompression *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSQMethodPV(temp0);
    }
    else
    {
      op->ttkTopologicalCompression::SetSQMethodPV(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyttkTopologicalCompression_Methods[] = {
  {"IsTypeOf", PyttkTopologicalCompression_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkTopologicalCompression_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkTopologicalCompression_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkTopologicalCompression\nC++: static ttkTopologicalCompression *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkTopologicalCompression_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkTopologicalCompression\nC++: ttkTopologicalCompression *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkTopologicalCompression_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkTopologicalCompression_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetTolerance", PyttkTopologicalCompression_SetTolerance, METH_VARARGS,
   "SetTolerance(self, _arg:float) -> None\nC++: virtual void SetTolerance(double _arg)\n\n"},
  {"GetTolerance", PyttkTopologicalCompression_GetTolerance, METH_VARARGS,
   "GetTolerance(self) -> float\nC++: virtual double GetTolerance()\n\n"},
  {"SetMaximumError", PyttkTopologicalCompression_SetMaximumError, METH_VARARGS,
   "SetMaximumError(self, _arg:float) -> None\nC++: virtual void SetMaximumError(double _arg)\n\n"},
  {"GetMaximumError", PyttkTopologicalCompression_GetMaximumError, METH_VARARGS,
   "GetMaximumError(self) -> float\nC++: virtual double GetMaximumError()\n\n"},
  {"SetCompressionType", PyttkTopologicalCompression_SetCompressionType, METH_VARARGS,
   "SetCompressionType(self, _arg:int) -> None\nC++: virtual void SetCompressionType(int _arg)\n\n"},
  {"GetCompressionType", PyttkTopologicalCompression_GetCompressionType, METH_VARARGS,
   "GetCompressionType(self) -> int\nC++: virtual int GetCompressionType()\n\n"},
  {"SetSQMethod", PyttkTopologicalCompression_SetSQMethod, METH_VARARGS,
   "SetSQMethod(self, _arg:str) -> None\nC++: virtual void SetSQMethod(const std::string &_arg)\n\n"},
  {"GetSQMethod", PyttkTopologicalCompression_GetSQMethod, METH_VARARGS,
   "GetSQMethod(self) -> str\nC++: virtual std::string GetSQMethod()\n\n"},
  {"SetSubdivide", PyttkTopologicalCompression_SetSubdivide, METH_VARARGS,
   "SetSubdivide(self, _arg:bool) -> None\nC++: virtual void SetSubdivide(bool _arg)\n\n"},
  {"GetSubdivide", PyttkTopologicalCompression_GetSubdivide, METH_VARARGS,
   "GetSubdivide(self) -> bool\nC++: virtual bool GetSubdivide()\n\n"},
  {"SetUseTopologicalSimplification", PyttkTopologicalCompression_SetUseTopologicalSimplification, METH_VARARGS,
   "SetUseTopologicalSimplification(self, _arg:bool) -> None\nC++: virtual void SetUseTopologicalSimplification(bool _arg)\n\n"},
  {"GetUseTopologicalSimplification", PyttkTopologicalCompression_GetUseTopologicalSimplification, METH_VARARGS,
   "GetUseTopologicalSimplification(self) -> bool\nC++: virtual bool GetUseTopologicalSimplification()\n\n"},
  {"SetSQMethodPV", PyttkTopologicalCompression_SetSQMethodPV, METH_VARARGS,
   "SetSQMethodPV(self, c:int) -> None\nC++: void SetSQMethodPV(int c)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkTopologicalCompression_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("tolerance"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalCompression_GetTolerance(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalCompression_SetTolerance(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalCompression_SetTolerance(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTolerance/SetTolerance\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("maximum_error"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalCompression_GetMaximumError(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalCompression_SetMaximumError(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalCompression_SetMaximumError(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMaximumError/SetMaximumError\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("compression_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalCompression_GetCompressionType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalCompression_SetCompressionType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalCompression_SetCompressionType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetCompressionType/SetCompressionType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("sq_method"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalCompression_GetSQMethod(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalCompression_SetSQMethod(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalCompression_SetSQMethod(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSQMethod/SetSQMethod\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("subdivide"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalCompression_GetSubdivide(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalCompression_SetSubdivide(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalCompression_SetSubdivide(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSubdivide/SetSubdivide\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_topological_simplification"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalCompression_GetUseTopologicalSimplification(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalCompression_SetUseTopologicalSimplification(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalCompression_SetUseTopologicalSimplification(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseTopologicalSimplification/SetUseTopologicalSimplification\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("sq_method_pv"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalCompression_SetSQMethodPV(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalCompression_SetSQMethodPV(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSQMethodPV\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkTopologicalCompression_Doc =
  "ttkTopologicalCompression - no description provided.\n\n"
  "Superclass: ttkAlgorithm\n\n"
;

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkTopologicalCompression_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkTopologicalCompression.ttkTopologicalCompression", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkTopologicalCompression_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkTopologicalCompression_StaticNew()
{
  return ttkTopologicalCompression::New();
}

PyObject *PyttkTopologicalCompression_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkTopologicalCompression_Type, PyttkTopologicalCompression_Methods,
    "ttkTopologicalCompression",
 &PyttkTopologicalCompression_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkTopologicalCompression_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkTopologicalCompression(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkTopologicalCompression_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkTopologicalCompression", o) != 0)
  {
    Py_DECREF(o);
  }

}

