/* Profiles.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Profiles.vala, do not modify */

/* Copyright 2019 Jens Georg.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include <errno.h>

#define SHOTWELL_PROFILE_SYSTEM "__shotwell_default_system"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SHOTWELL_TYPE_PROFILE (shotwell_profile_get_type ())
#define SHOTWELL_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SHOTWELL_TYPE_PROFILE, ShotwellProfile))
#define SHOTWELL_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SHOTWELL_TYPE_PROFILE, ShotwellProfileClass))
#define SHOTWELL_IS_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SHOTWELL_TYPE_PROFILE))
#define SHOTWELL_IS_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SHOTWELL_TYPE_PROFILE))
#define SHOTWELL_PROFILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SHOTWELL_TYPE_PROFILE, ShotwellProfileClass))

typedef struct _ShotwellProfile ShotwellProfile;
typedef struct _ShotwellProfileClass ShotwellProfileClass;
typedef struct _ShotwellProfilePrivate ShotwellProfilePrivate;
enum  {
	SHOTWELL_PROFILE_0_PROPERTY,
	SHOTWELL_PROFILE_NAME_PROPERTY,
	SHOTWELL_PROFILE_ID_PROPERTY,
	SHOTWELL_PROFILE_DATA_DIR_PROPERTY,
	SHOTWELL_PROFILE_ACTIVE_PROPERTY,
	SHOTWELL_PROFILE_NUM_PROPERTIES
};
static GParamSpec* shotwell_profile_properties[SHOTWELL_PROFILE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define SHOTWELL_TYPE_PROFILE_MANAGER (shotwell_profile_manager_get_type ())
#define SHOTWELL_PROFILE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SHOTWELL_TYPE_PROFILE_MANAGER, ShotwellProfileManager))
#define SHOTWELL_PROFILE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SHOTWELL_TYPE_PROFILE_MANAGER, ShotwellProfileManagerClass))
#define SHOTWELL_IS_PROFILE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SHOTWELL_TYPE_PROFILE_MANAGER))
#define SHOTWELL_IS_PROFILE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SHOTWELL_TYPE_PROFILE_MANAGER))
#define SHOTWELL_PROFILE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SHOTWELL_TYPE_PROFILE_MANAGER, ShotwellProfileManagerClass))

typedef struct _ShotwellProfileManager ShotwellProfileManager;
typedef struct _ShotwellProfileManagerClass ShotwellProfileManagerClass;
typedef struct _ShotwellProfileManagerPrivate ShotwellProfileManagerPrivate;
enum  {
	SHOTWELL_PROFILE_MANAGER_0_PROPERTY,
	SHOTWELL_PROFILE_MANAGER_NUM_PROPERTIES
};
static GParamSpec* shotwell_profile_manager_properties[SHOTWELL_PROFILE_MANAGER_NUM_PROPERTIES];
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_settings_schema_source_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_source_unref (var), NULL)))
typedef struct _Block15Data Block15Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ShotwellProfile {
	GObject parent_instance;
	ShotwellProfilePrivate * priv;
};

struct _ShotwellProfileClass {
	GObjectClass parent_class;
};

struct _ShotwellProfilePrivate {
	gchar* _name;
	gchar* _id;
	gchar* _data_dir;
	gboolean _active;
};

struct _ShotwellProfileManager {
	GObject parent_instance;
	ShotwellProfileManagerPrivate * priv;
};

struct _ShotwellProfileManagerClass {
	GObjectClass parent_class;
};

struct _ShotwellProfileManagerPrivate {
	GKeyFile* profiles;
	gchar* profile;
	gchar* path;
	gchar* group_name;
};

struct _Block15Data {
	int _ref_count_;
	ShotwellProfileManager* self;
	gint index;
};

static gint ShotwellProfile_private_offset;
static gpointer shotwell_profile_parent_class = NULL;
static gint ShotwellProfileManager_private_offset;
static gpointer shotwell_profile_manager_parent_class = NULL;
static ShotwellProfileManager* shotwell_profile_manager_instance;
static ShotwellProfileManager* shotwell_profile_manager_instance = NULL;
static GListModelInterface * shotwell_profile_manager_g_list_model_parent_iface = NULL;

VALA_EXTERN GType shotwell_profile_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ShotwellProfile, g_object_unref)
VALA_EXTERN ShotwellProfile* shotwell_profile_new (const gchar* name,
                                       const gchar* id,
                                       const gchar* data_dir,
                                       gboolean active);
VALA_EXTERN ShotwellProfile* shotwell_profile_construct (GType object_type,
                                             const gchar* name,
                                             const gchar* id,
                                             const gchar* data_dir,
                                             gboolean active);
VALA_EXTERN const gchar* shotwell_profile_get_name (ShotwellProfile* self);
static void shotwell_profile_set_name (ShotwellProfile* self,
                                const gchar* value);
VALA_EXTERN const gchar* shotwell_profile_get_id (ShotwellProfile* self);
static void shotwell_profile_set_id (ShotwellProfile* self,
                              const gchar* value);
VALA_EXTERN const gchar* shotwell_profile_get_data_dir (ShotwellProfile* self);
static void shotwell_profile_set_data_dir (ShotwellProfile* self,
                                    const gchar* value);
VALA_EXTERN gboolean shotwell_profile_get_active (ShotwellProfile* self);
static void shotwell_profile_set_active (ShotwellProfile* self,
                                  gboolean value);
static void shotwell_profile_finalize (GObject * obj);
static GType shotwell_profile_get_type_once (void);
static void _vala_shotwell_profile_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_shotwell_profile_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);
VALA_EXTERN GType shotwell_profile_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ShotwellProfileManager, g_object_unref)
static GType shotwell_profile_manager_real_get_item_type (GListModel* base);
static guint shotwell_profile_manager_real_get_n_items (GListModel* base);
static GObject* shotwell_profile_manager_real_get_item (GListModel* base,
                                                 guint position);
static gchar* shotwell_profile_manager_get_data_dir_for_profile (ShotwellProfileManager* self,
                                                          const gchar* id,
                                                          const gchar* group,
                                                          GError** error);
VALA_EXTERN ShotwellProfileManager* shotwell_profile_manager_get_instance (void);
static ShotwellProfileManager* shotwell_profile_manager_new (void);
static ShotwellProfileManager* shotwell_profile_manager_construct (GType object_type);
static void shotwell_profile_manager_write (ShotwellProfileManager* self);
static void shotwell_profile_manager_real_constructed (GObject* base);
VALA_EXTERN gboolean shotwell_profile_manager_has_profile (ShotwellProfileManager* self,
                                               const gchar* profile,
                                               gchar** group_name);
VALA_EXTERN void shotwell_profile_manager_set_profile (ShotwellProfileManager* self,
                                           const gchar* profile);
VALA_EXTERN void shotwell_profile_manager_add_profile (ShotwellProfileManager* self,
                                           const gchar* id,
                                           const gchar* name,
                                           const gchar* library_folder,
                                           const gchar* data_folder);
VALA_EXTERN gchar* shotwell_profile_manager_derive_data_dir (ShotwellProfileManager* self,
                                                 const gchar* data_dir);
VALA_EXTERN gchar* shotwell_profile_manager_id (ShotwellProfileManager* self);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
VALA_EXTERN void shotwell_profile_manager_print_profiles (ShotwellProfileManager* self);
static void shotwell_profile_manager_reset_all_keys (ShotwellProfileManager* self,
                                              GSettings* settings);
static void shotwell_profile_manager_remove_settings_recursively (ShotwellProfileManager* self,
                                                           const gchar* id);
VALA_EXTERN void shotwell_profile_manager_remove (ShotwellProfileManager* self,
                                      const gchar* id,
                                      gboolean remove_all);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
static gboolean ___lambda18_ (Block15Data* _data15_);
static gboolean ____lambda18__gsource_func (gpointer self);
static void shotwell_profile_manager_finalize (GObject * obj);
static GType shotwell_profile_manager_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const gchar* SHOTWELL_PROFILE_MANAGER_SCHEMAS[9] = {"sharing", "printing", "plugins.enable-state", "preferences.ui", "preferences.slideshow", "preferences.window", "preferences.files", "preferences.editing", "preferences.export"};

static inline gpointer
shotwell_profile_get_instance_private (ShotwellProfile* self)
{
	return G_STRUCT_MEMBER_P (self, ShotwellProfile_private_offset);
}

ShotwellProfile*
shotwell_profile_construct (GType object_type,
                            const gchar* name,
                            const gchar* id,
                            const gchar* data_dir,
                            gboolean active)
{
	ShotwellProfile * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (data_dir != NULL, NULL);
	self = (ShotwellProfile*) g_object_new (object_type, "name", name, "id", id, "data-dir", data_dir, "active", active, NULL);
	return self;
}

ShotwellProfile*
shotwell_profile_new (const gchar* name,
                      const gchar* id,
                      const gchar* data_dir,
                      gboolean active)
{
	return shotwell_profile_construct (SHOTWELL_TYPE_PROFILE, name, id, data_dir, active);
}

const gchar*
shotwell_profile_get_name (ShotwellProfile* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (SHOTWELL_IS_PROFILE (self), NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
shotwell_profile_set_name (ShotwellProfile* self,
                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (SHOTWELL_IS_PROFILE (self));
	old_value = shotwell_profile_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, shotwell_profile_properties[SHOTWELL_PROFILE_NAME_PROPERTY]);
	}
}

const gchar*
shotwell_profile_get_id (ShotwellProfile* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (SHOTWELL_IS_PROFILE (self), NULL);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}

static void
shotwell_profile_set_id (ShotwellProfile* self,
                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (SHOTWELL_IS_PROFILE (self));
	old_value = shotwell_profile_get_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_id);
		self->priv->_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, shotwell_profile_properties[SHOTWELL_PROFILE_ID_PROPERTY]);
	}
}

const gchar*
shotwell_profile_get_data_dir (ShotwellProfile* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (SHOTWELL_IS_PROFILE (self), NULL);
	_tmp0_ = self->priv->_data_dir;
	result = _tmp0_;
	return result;
}

static void
shotwell_profile_set_data_dir (ShotwellProfile* self,
                               const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (SHOTWELL_IS_PROFILE (self));
	old_value = shotwell_profile_get_data_dir (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_data_dir);
		self->priv->_data_dir = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, shotwell_profile_properties[SHOTWELL_PROFILE_DATA_DIR_PROPERTY]);
	}
}

gboolean
shotwell_profile_get_active (ShotwellProfile* self)
{
	gboolean result;
	g_return_val_if_fail (SHOTWELL_IS_PROFILE (self), FALSE);
	result = self->priv->_active;
	return result;
}

static void
shotwell_profile_set_active (ShotwellProfile* self,
                             gboolean value)
{
	gboolean old_value;
	g_return_if_fail (SHOTWELL_IS_PROFILE (self));
	old_value = shotwell_profile_get_active (self);
	if (old_value != value) {
		self->priv->_active = value;
		g_object_notify_by_pspec ((GObject *) self, shotwell_profile_properties[SHOTWELL_PROFILE_ACTIVE_PROPERTY]);
	}
}

static void
shotwell_profile_class_init (ShotwellProfileClass * klass,
                             gpointer klass_data)
{
	shotwell_profile_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ShotwellProfile_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_shotwell_profile_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_shotwell_profile_set_property;
	G_OBJECT_CLASS (klass)->finalize = shotwell_profile_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SHOTWELL_PROFILE_NAME_PROPERTY, shotwell_profile_properties[SHOTWELL_PROFILE_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SHOTWELL_PROFILE_ID_PROPERTY, shotwell_profile_properties[SHOTWELL_PROFILE_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SHOTWELL_PROFILE_DATA_DIR_PROPERTY, shotwell_profile_properties[SHOTWELL_PROFILE_DATA_DIR_PROPERTY] = g_param_spec_string ("data-dir", "data-dir", "data-dir", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SHOTWELL_PROFILE_ACTIVE_PROPERTY, shotwell_profile_properties[SHOTWELL_PROFILE_ACTIVE_PROPERTY] = g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
shotwell_profile_instance_init (ShotwellProfile * self,
                                gpointer klass)
{
	self->priv = shotwell_profile_get_instance_private (self);
}

static void
shotwell_profile_finalize (GObject * obj)
{
	ShotwellProfile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SHOTWELL_TYPE_PROFILE, ShotwellProfile);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_id);
	_g_free0 (self->priv->_data_dir);
	G_OBJECT_CLASS (shotwell_profile_parent_class)->finalize (obj);
}

static GType
shotwell_profile_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ShotwellProfileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) shotwell_profile_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ShotwellProfile), 0, (GInstanceInitFunc) shotwell_profile_instance_init, NULL };
	GType shotwell_profile_type_id;
	shotwell_profile_type_id = g_type_register_static (G_TYPE_OBJECT, "ShotwellProfile", &g_define_type_info, 0);
	ShotwellProfile_private_offset = g_type_add_instance_private (shotwell_profile_type_id, sizeof (ShotwellProfilePrivate));
	return shotwell_profile_type_id;
}

GType
shotwell_profile_get_type (void)
{
	static volatile gsize shotwell_profile_type_id__once = 0;
	if (g_once_init_enter (&shotwell_profile_type_id__once)) {
		GType shotwell_profile_type_id;
		shotwell_profile_type_id = shotwell_profile_get_type_once ();
		g_once_init_leave (&shotwell_profile_type_id__once, shotwell_profile_type_id);
	}
	return shotwell_profile_type_id__once;
}

static void
_vala_shotwell_profile_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	ShotwellProfile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SHOTWELL_TYPE_PROFILE, ShotwellProfile);
	switch (property_id) {
		case SHOTWELL_PROFILE_NAME_PROPERTY:
		g_value_set_string (value, shotwell_profile_get_name (self));
		break;
		case SHOTWELL_PROFILE_ID_PROPERTY:
		g_value_set_string (value, shotwell_profile_get_id (self));
		break;
		case SHOTWELL_PROFILE_DATA_DIR_PROPERTY:
		g_value_set_string (value, shotwell_profile_get_data_dir (self));
		break;
		case SHOTWELL_PROFILE_ACTIVE_PROPERTY:
		g_value_set_boolean (value, shotwell_profile_get_active (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_shotwell_profile_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	ShotwellProfile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SHOTWELL_TYPE_PROFILE, ShotwellProfile);
	switch (property_id) {
		case SHOTWELL_PROFILE_NAME_PROPERTY:
		shotwell_profile_set_name (self, g_value_get_string (value));
		break;
		case SHOTWELL_PROFILE_ID_PROPERTY:
		shotwell_profile_set_id (self, g_value_get_string (value));
		break;
		case SHOTWELL_PROFILE_DATA_DIR_PROPERTY:
		shotwell_profile_set_data_dir (self, g_value_get_string (value));
		break;
		case SHOTWELL_PROFILE_ACTIVE_PROPERTY:
		shotwell_profile_set_active (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
shotwell_profile_manager_get_instance_private (ShotwellProfileManager* self)
{
	return G_STRUCT_MEMBER_P (self, ShotwellProfileManager_private_offset);
}

static GType
shotwell_profile_manager_real_get_item_type (GListModel* base)
{
	ShotwellProfileManager * self;
	GType result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, SHOTWELL_TYPE_PROFILE_MANAGER, ShotwellProfileManager);
	result = SHOTWELL_TYPE_PROFILE;
	return result;
}

static guint
shotwell_profile_manager_real_get_n_items (GListModel* base)
{
	ShotwellProfileManager * self;
	GKeyFile* _tmp0_;
	gsize _tmp1_ = 0;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	guint _tmp4_;
	guint result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, SHOTWELL_TYPE_PROFILE_MANAGER, ShotwellProfileManager);
	_tmp0_ = self->priv->profiles;
	_tmp2_ = g_key_file_get_groups (_tmp0_, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp1_;
	_tmp4_ = (guint) (_tmp1_ + 1);
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
	result = _tmp4_;
	return result;
}

static GObject*
shotwell_profile_manager_real_get_item (GListModel* base,
                                        guint position)
{
	ShotwellProfileManager * self;
	GError* _inner_error0_ = NULL;
	GObject* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, SHOTWELL_TYPE_PROFILE_MANAGER, ShotwellProfileManager);
	if (position == ((guint) 0)) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		ShotwellProfile* _tmp4_;
		GObject* _tmp5_;
		_tmp0_ = g_get_user_data_dir ();
		_tmp1_ = g_build_path (G_DIR_SEPARATOR_S, _tmp0_, "shotwell", NULL);
		_tmp2_ = _tmp1_;
		_tmp3_ = self->priv->profile;
		_tmp4_ = shotwell_profile_new (_ ("System Profile"), SHOTWELL_PROFILE_SYSTEM, _tmp2_, _tmp3_ == NULL);
		_tmp5_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, G_TYPE_OBJECT, GObject);
		_g_free0 (_tmp2_);
		result = _tmp5_;
		return result;
	}
	{
		gchar* group = NULL;
		GKeyFile* _tmp6_;
		gsize _tmp7_ = 0;
		gchar** _tmp8_;
		gchar** _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* id = NULL;
		GKeyFile* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* name = NULL;
		GKeyFile* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		gboolean active = FALSE;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_ = NULL;
		GKeyFile* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_ = NULL;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		const gchar* _tmp29_;
		ShotwellProfile* _tmp30_;
		_tmp6_ = self->priv->profiles;
		_tmp8_ = g_key_file_get_groups (_tmp6_, &_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp9__length1 = _tmp7_;
		_tmp10_ = _tmp9_[position - 1];
		_tmp11_ = g_strdup (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
		group = _tmp12_;
		_tmp13_ = self->priv->profiles;
		_tmp14_ = group;
		_tmp15_ = g_key_file_get_value (_tmp13_, _tmp14_, "Id", &_inner_error0_);
		id = _tmp15_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (group);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp16_ = self->priv->profiles;
		_tmp17_ = group;
		_tmp18_ = g_key_file_get_value (_tmp16_, _tmp17_, "Name", &_inner_error0_);
		name = _tmp18_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (id);
			_g_free0 (group);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp19_ = self->priv->profile;
		_tmp20_ = name;
		active = g_strcmp0 (_tmp19_, _tmp20_) == 0;
		_tmp22_ = self->priv->profiles;
		_tmp23_ = group;
		_tmp24_ = g_key_file_get_value (_tmp22_, _tmp23_, "Name", &_inner_error0_);
		_tmp21_ = _tmp24_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (name);
			_g_free0 (id);
			_g_free0 (group);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp26_ = id;
		_tmp27_ = group;
		_tmp28_ = shotwell_profile_manager_get_data_dir_for_profile (self, _tmp26_, _tmp27_, &_inner_error0_);
		_tmp25_ = _tmp28_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp21_);
			_g_free0 (name);
			_g_free0 (id);
			_g_free0 (group);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp29_ = id;
		_tmp30_ = shotwell_profile_new (_tmp21_, _tmp29_, _tmp25_, active);
		result = G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, G_TYPE_OBJECT, GObject);
		_g_free0 (_tmp25_);
		_g_free0 (_tmp21_);
		_g_free0 (name);
		_g_free0 (id);
		_g_free0 (group);
		return result;
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* err = NULL;
		GError* _tmp31_;
		GError* _tmp32_;
		const gchar* _tmp33_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp31_ = err;
		if (g_error_matches (_tmp31_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND)) {
			g_assert_not_reached ();
		}
		_tmp32_ = err;
		_tmp33_ = _tmp32_->message;
		g_warning ("Profiles.vala:51: Profile configuration file corrupt: %s", _tmp33_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = NULL;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

ShotwellProfileManager*
shotwell_profile_manager_get_instance (void)
{
	ShotwellProfileManager* _tmp0_;
	ShotwellProfileManager* _tmp2_;
	ShotwellProfileManager* _tmp3_;
	ShotwellProfileManager* result;
	_tmp0_ = shotwell_profile_manager_instance;
	if (_tmp0_ == NULL) {
		ShotwellProfileManager* _tmp1_;
		_tmp1_ = shotwell_profile_manager_new ();
		_g_object_unref0 (shotwell_profile_manager_instance);
		shotwell_profile_manager_instance = _tmp1_;
	}
	_tmp2_ = shotwell_profile_manager_instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static ShotwellProfileManager*
shotwell_profile_manager_construct (GType object_type)
{
	ShotwellProfileManager * self = NULL;
	self = (ShotwellProfileManager*) g_object_new (object_type, NULL);
	return self;
}

static ShotwellProfileManager*
shotwell_profile_manager_new (void)
{
	return shotwell_profile_manager_construct (SHOTWELL_TYPE_PROFILE_MANAGER);
}

static void
shotwell_profile_manager_write (ShotwellProfileManager* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (SHOTWELL_IS_PROFILE_MANAGER (self));
	{
		GKeyFile* _tmp0_;
		const gchar* _tmp1_;
		_tmp0_ = self->priv->profiles;
		_tmp1_ = self->priv->path;
		g_key_file_save_to_file (_tmp0_, _tmp1_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = _error_;
		_tmp3_ = _tmp2_->message;
		g_critical ("Profiles.vala:73: Failed to write profiles: %s", _tmp3_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
shotwell_profile_manager_real_constructed (GObject* base)
{
	ShotwellProfileManager * self;
	GKeyFile* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, SHOTWELL_TYPE_PROFILE_MANAGER, ShotwellProfileManager);
	G_OBJECT_CLASS (shotwell_profile_manager_parent_class)->constructed (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
	_tmp0_ = g_key_file_new ();
	_g_key_file_unref0 (self->priv->profiles);
	self->priv->profiles = _tmp0_;
	_tmp1_ = g_get_user_config_dir ();
	_tmp2_ = g_build_filename (_tmp1_, "shotwell", NULL);
	_g_free0 (self->priv->path);
	self->priv->path = _tmp2_;
	_tmp3_ = self->priv->path;
	g_mkdir_with_parents (_tmp3_, 0700);
	_tmp4_ = self->priv->path;
	_tmp5_ = g_build_filename (_tmp4_, "profiles.ini", NULL);
	_g_free0 (self->priv->path);
	self->priv->path = _tmp5_;
	{
		GKeyFile* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = self->priv->profiles;
		_tmp7_ = self->priv->path;
		g_key_file_load_from_file (_tmp6_, _tmp7_, G_KEY_FILE_KEEP_COMMENTS, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = _error_;
		_tmp9_ = _tmp8_->message;
		g_debug ("Profiles.vala:93: Could not read profiles: %s", _tmp9_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

gboolean
shotwell_profile_manager_has_profile (ShotwellProfileManager* self,
                                      const gchar* profile,
                                      gchar** group_name)
{
	gchar* _vala_group_name = NULL;
	guint8* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_ = 0;
	guint8* _tmp2_;
	gint _tmp2__length1;
	gchar* _tmp3_;
	GKeyFile* _tmp4_;
	gboolean result;
	g_return_val_if_fail (SHOTWELL_IS_PROFILE_MANAGER (self), FALSE);
	g_return_val_if_fail (profile != NULL, FALSE);
	_tmp0_ = string_get_data (profile, &_tmp1_);
	_tmp0__length1 = _tmp1_;
	_tmp2_ = _tmp0_;
	_tmp2__length1 = _tmp0__length1;
	_tmp3_ = g_base64_encode (_tmp2_, (gint) _tmp2__length1);
	_g_free0 (_vala_group_name);
	_vala_group_name = _tmp3_;
	_tmp4_ = self->priv->profiles;
	result = g_key_file_has_group (_tmp4_, _vala_group_name);
	if (group_name) {
		*group_name = _vala_group_name;
	} else {
		_g_free0 (_vala_group_name);
	}
	return result;
}

void
shotwell_profile_manager_set_profile (ShotwellProfileManager* self,
                                      const gchar* profile)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (SHOTWELL_IS_PROFILE_MANAGER (self));
	g_return_if_fail (profile != NULL);
	g_message ("Profiles.vala:103: Using profile %s for this session", profile);
	_tmp0_ = self->priv->profile;
	_vala_assert (_tmp0_ == NULL, "this.profile == null");
	_tmp1_ = g_strdup (profile);
	_g_free0 (self->priv->profile);
	self->priv->profile = _tmp1_;
	_tmp2_ = g_uuid_string_random ();
	_tmp3_ = _tmp2_;
	shotwell_profile_manager_add_profile (self, _tmp3_, profile, NULL, NULL);
	_g_free0 (_tmp3_);
}

void
shotwell_profile_manager_add_profile (ShotwellProfileManager* self,
                                      const gchar* id,
                                      const gchar* name,
                                      const gchar* library_folder,
                                      const gchar* data_folder)
{
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	GKeyFile* _tmp24_;
	gsize _tmp25_ = 0;
	gchar** _tmp26_;
	gchar** _tmp27_;
	gint _tmp27__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (SHOTWELL_IS_PROFILE_MANAGER (self));
	g_return_if_fail (id != NULL);
	g_return_if_fail (name != NULL);
	_tmp1_ = shotwell_profile_manager_has_profile (self, name, &_tmp0_);
	_g_free0 (self->priv->group_name);
	self->priv->group_name = _tmp0_;
	if (_tmp1_) {
		return;
	}
	{
		GKeyFile* _tmp2_;
		const gchar* _tmp3_;
		GKeyFile* _tmp4_;
		const gchar* _tmp5_;
		GKeyFile* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp2_ = self->priv->profiles;
		_tmp3_ = self->priv->group_name;
		g_key_file_set_string (_tmp2_, _tmp3_, "Name", name);
		_tmp4_ = self->priv->profiles;
		_tmp5_ = self->priv->group_name;
		g_key_file_set_string (_tmp4_, _tmp5_, "Id", id);
		if (data_folder != NULL) {
			GKeyFile* _tmp6_;
			const gchar* _tmp7_;
			_tmp6_ = self->priv->profiles;
			_tmp7_ = self->priv->group_name;
			g_key_file_set_string (_tmp6_, _tmp7_, "DataDir", data_folder);
		}
		_tmp8_ = self->priv->profiles;
		_tmp9_ = self->priv->group_name;
		_tmp10_ = g_strdup_printf ("Profile settings for \"%s\"", name);
		_tmp11_ = _tmp10_;
		g_key_file_set_comment (_tmp8_, _tmp9_, NULL, _tmp11_, &_inner_error0_);
		_g_free0 (_tmp11_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		shotwell_profile_manager_write (self);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp12_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = err->message;
		g_error ("Profiles.vala:128: Failed to create profile: %s", _tmp12_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	if (library_folder != NULL) {
		GFile* f = NULL;
		GFile* _tmp13_;
		gchar* settings_path = NULL;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		GSettings* settings = NULL;
		const gchar* _tmp21_;
		GSettings* _tmp22_;
		GSettings* _tmp23_;
		errno = 0;
		_tmp13_ = g_file_new_for_commandline_arg (library_folder);
		f = _tmp13_;
		{
			GFile* _tmp14_;
			_tmp14_ = f;
			g_file_make_directory_with_parents (_tmp14_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* err = NULL;
			GError* _tmp15_;
			const gchar* _tmp16_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp15_ = err;
			_tmp16_ = _tmp15_->message;
			g_warning ("Profiles.vala:137: Failed to create library folder: %s", _tmp16_);
			_g_error_free0 (err);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (f);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp17_ = g_strconcat ("/org/gnome/shotwell/profiles/", id, NULL);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strconcat (_tmp18_, "/preferences/files/", NULL);
		_tmp20_ = _tmp19_;
		_g_free0 (_tmp18_);
		settings_path = _tmp20_;
		_tmp21_ = settings_path;
		_tmp22_ = g_settings_new_with_path ("org.gnome.shotwell.preferences.files", _tmp21_);
		settings = _tmp22_;
		_tmp23_ = settings;
		g_settings_set_string (_tmp23_, "import-dir", library_folder);
		_g_object_unref0 (settings);
		_g_free0 (settings_path);
		_g_object_unref0 (f);
	}
	_tmp24_ = self->priv->profiles;
	_tmp26_ = g_key_file_get_groups (_tmp24_, &_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp27__length1 = _tmp25_;
	g_list_model_items_changed (G_TYPE_CHECK_INSTANCE_CAST (self, g_list_model_get_type (), GListModel), (guint) _tmp25_, (guint) 0, (guint) 1);
	_tmp27_ = (_vala_array_free (_tmp27_, _tmp27__length1, (GDestroyNotify) g_free), NULL);
}

gchar*
shotwell_profile_manager_derive_data_dir (ShotwellProfileManager* self,
                                          const gchar* data_dir)
{
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (SHOTWELL_IS_PROFILE_MANAGER (self), NULL);
	if (data_dir != NULL) {
		gchar* _tmp10_;
		g_debug ("Profiles.vala:151: Using user-provided data dir %s", data_dir);
		{
			GKeyFile* _tmp0_;
			const gchar* _tmp1_;
			gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp0_ = self->priv->profiles;
			_tmp1_ = self->priv->group_name;
			_tmp2_ = g_key_file_get_string (_tmp0_, _tmp1_, "DataDir", &_inner_error0_);
			_tmp3_ = _tmp2_;
			_g_free0 (_tmp3_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			gboolean _tmp4_ = FALSE;
			const gchar* _tmp5_;
			g_clear_error (&_inner_error0_);
			_tmp5_ = self->priv->profile;
			if (_tmp5_ != NULL) {
				const gchar* _tmp6_;
				_tmp6_ = self->priv->profile;
				_tmp4_ = g_strcmp0 (_tmp6_, "") != 0;
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				GKeyFile* _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				_tmp7_ = self->priv->profiles;
				_tmp8_ = self->priv->group_name;
				g_key_file_set_string (_tmp7_, _tmp8_, "DataDir", data_dir);
				_tmp9_ = self->priv->profile;
				g_debug ("Profiles.vala:158: Using %s as data dir for profile %s", data_dir, _tmp9_);
				shotwell_profile_manager_write (self);
			}
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = g_strdup (data_dir);
		result = _tmp10_;
		return result;
	}
	_tmp11_ = g_get_user_data_dir ();
	_tmp12_ = shotwell_profile_manager_id (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_build_filename (_tmp11_, "shotwell", "profiles", _tmp13_, NULL);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	result = _tmp15_;
	return result;
}

gchar*
shotwell_profile_manager_id (ShotwellProfileManager* self)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (SHOTWELL_IS_PROFILE_MANAGER (self), NULL);
	_tmp1_ = self->priv->profile;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->profile;
		_tmp0_ = g_strcmp0 (_tmp2_, "") == 0;
	}
	if (_tmp0_) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("");
		result = _tmp3_;
		return result;
	}
	{
		gchar* _tmp4_ = NULL;
		GKeyFile* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp5_ = self->priv->profiles;
		_tmp6_ = self->priv->group_name;
		_tmp7_ = g_key_file_get_string (_tmp5_, _tmp6_, "Id", &_inner_error0_);
		_tmp4_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp8_ = _tmp4_;
		_tmp4_ = NULL;
		result = _tmp8_;
		_g_free0 (_tmp4_);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static gchar*
shotwell_profile_manager_get_data_dir_for_profile (ShotwellProfileManager* self,
                                                   const gchar* id,
                                                   const gchar* group,
                                                   GError** error)
{
	gchar** _tmp0_ = NULL;
	GKeyFile* _tmp1_;
	gsize _tmp2_ = 0;
	gchar** _tmp3_;
	gint _tmp0__length1;
	gint __tmp0__size_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (SHOTWELL_IS_PROFILE_MANAGER (self), NULL);
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	_tmp1_ = self->priv->profiles;
	_tmp3_ = g_key_file_get_keys (_tmp1_, group, &_tmp2_, &_inner_error0_);
	_tmp0_ = _tmp3_;
	_tmp0__length1 = _tmp2_;
	__tmp0__size_ = _tmp0__length1;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (_vala_string_array_contains (_tmp0_, _tmp0__length1, "DataDir")) {
		gchar* _tmp4_ = NULL;
		GKeyFile* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = self->priv->profiles;
		_tmp6_ = g_key_file_get_value (_tmp5_, group, "DataDir", &_inner_error0_);
		_tmp4_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_tmp0_ = (_vala_array_free (_tmp0_, _tmp0__length1, (GDestroyNotify) g_free), NULL);
				return NULL;
			} else {
				_tmp0_ = (_vala_array_free (_tmp0_, _tmp0__length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp7_ = _tmp4_;
		_tmp4_ = NULL;
		result = _tmp7_;
		_g_free0 (_tmp4_);
		_tmp0_ = (_vala_array_free (_tmp0_, _tmp0__length1, (GDestroyNotify) g_free), NULL);
		return result;
	} else {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = g_get_user_data_dir ();
		_tmp9_ = g_build_filename (_tmp8_, "shotwell", "profiles", id, NULL);
		result = _tmp9_;
		_tmp0_ = (_vala_array_free (_tmp0_, _tmp0__length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
}

void
shotwell_profile_manager_print_profiles (ShotwellProfileManager* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (SHOTWELL_IS_PROFILE_MANAGER (self));
	g_print ("Available profiles:\n");
	g_print ("-------------------\n");
	{
		GKeyFile* _tmp0_;
		gsize _tmp1_ = 0;
		gchar** _tmp2_;
		_tmp0_ = self->priv->profiles;
		_tmp2_ = g_key_file_get_groups (_tmp0_, &_tmp1_);
		{
			gchar** group_collection = NULL;
			gint group_collection_length1 = 0;
			gint _group_collection_size_ = 0;
			gint group_it = 0;
			group_collection = _tmp2_;
			group_collection_length1 = _tmp1_;
			for (group_it = 0; group_it < group_collection_length1; group_it = group_it + 1) {
				gchar* _tmp3_;
				gchar* group = NULL;
				_tmp3_ = g_strdup (group_collection[group_it]);
				group = _tmp3_;
				{
					gchar* _tmp4_ = NULL;
					GKeyFile* _tmp5_;
					const gchar* _tmp6_;
					gchar* _tmp7_;
					gchar* id = NULL;
					GKeyFile* _tmp8_;
					const gchar* _tmp9_;
					gchar* _tmp10_;
					const gchar* _tmp11_;
					gchar* _tmp12_ = NULL;
					const gchar* _tmp13_;
					const gchar* _tmp14_;
					gchar* _tmp15_;
					_tmp5_ = self->priv->profiles;
					_tmp6_ = group;
					_tmp7_ = g_key_file_get_value (_tmp5_, _tmp6_, "Name", &_inner_error0_);
					_tmp4_ = _tmp7_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (group);
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
						goto __catch0_g_error;
					}
					g_print ("Profile name: %s\n", _tmp4_);
					_tmp8_ = self->priv->profiles;
					_tmp9_ = group;
					_tmp10_ = g_key_file_get_value (_tmp8_, _tmp9_, "Id", &_inner_error0_);
					id = _tmp10_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (_tmp4_);
						_g_free0 (group);
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
						goto __catch0_g_error;
					}
					_tmp11_ = id;
					g_print ("Profile Id: %s\n", _tmp11_);
					_tmp13_ = id;
					_tmp14_ = group;
					_tmp15_ = shotwell_profile_manager_get_data_dir_for_profile (self, _tmp13_, _tmp14_, &_inner_error0_);
					_tmp12_ = _tmp15_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (id);
						_g_free0 (_tmp4_);
						_g_free0 (group);
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
						goto __catch0_g_error;
					}
					g_print ("Data dir: %s\n", _tmp12_);
					g_print ("\n");
					_g_free0 (_tmp12_);
					_g_free0 (id);
					_g_free0 (_tmp4_);
					_g_free0 (group);
				}
			}
			group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = _error_;
		_tmp17_ = _tmp16_->message;
		g_print ("Failed to print profiles: %s", _tmp17_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
shotwell_profile_manager_reset_all_keys (ShotwellProfileManager* self,
                                         GSettings* settings)
{
	GSettingsSchema* schema = NULL;
	GSettingsSchema* _tmp0_ = NULL;
	GSettingsSchema* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	g_return_if_fail (SHOTWELL_IS_PROFILE_MANAGER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (settings, g_settings_get_type ()));
	g_object_get (G_TYPE_CHECK_INSTANCE_CAST (settings, G_TYPE_OBJECT, GObject), "settings-schema", &_tmp0_, NULL, NULL);
	_g_settings_schema_unref0 (schema);
	schema = _tmp0_;
	_tmp1_ = schema;
	_tmp3_ = _tmp2_ = g_settings_schema_list_keys (_tmp1_);
	{
		gchar** key_collection = NULL;
		gint key_collection_length1 = 0;
		gint _key_collection_size_ = 0;
		gint key_it = 0;
		key_collection = _tmp3_;
		key_collection_length1 = _vala_array_length (_tmp2_);
		for (key_it = 0; key_it < key_collection_length1; key_it = key_it + 1) {
			gchar* _tmp4_;
			gchar* key = NULL;
			_tmp4_ = g_strdup (key_collection[key_it]);
			key = _tmp4_;
			{
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				_tmp5_ = key;
				g_debug ("Profiles.vala:222: Resetting key %s", _tmp5_);
				_tmp6_ = key;
				g_settings_reset (settings, _tmp6_);
				_g_free0 (key);
			}
		}
		key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp8_ = _tmp7_ = g_settings_list_children (settings);
	{
		gchar** c_collection = NULL;
		gint c_collection_length1 = 0;
		gint _c_collection_size_ = 0;
		gint c_it = 0;
		c_collection = _tmp8_;
		c_collection_length1 = _vala_array_length (_tmp7_);
		for (c_it = 0; c_it < c_collection_length1; c_it = c_it + 1) {
			gchar* _tmp9_;
			gchar* c = NULL;
			_tmp9_ = g_strdup (c_collection[c_it]);
			c = _tmp9_;
			{
				const gchar* _tmp10_;
				GSettings* child = NULL;
				const gchar* _tmp11_;
				GSettings* _tmp12_;
				GSettings* _tmp13_;
				_tmp10_ = c;
				g_debug ("Profiles.vala:227: Checking children %s", _tmp10_);
				_tmp11_ = c;
				_tmp12_ = g_settings_get_child (settings, _tmp11_);
				child = _tmp12_;
				_tmp13_ = child;
				shotwell_profile_manager_reset_all_keys (self, _tmp13_);
				_g_object_unref0 (child);
				_g_free0 (c);
			}
		}
		c_collection = (_vala_array_free (c_collection, c_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_g_settings_schema_unref0 (schema);
}

static gpointer
_g_settings_schema_source_ref0 (gpointer self)
{
	return self ? g_settings_schema_source_ref (self) : NULL;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
shotwell_profile_manager_remove_settings_recursively (ShotwellProfileManager* self,
                                                      const gchar* id)
{
	GSettingsSchemaSource* source = NULL;
	GSettingsSchemaSource* _tmp0_;
	GSettingsSchemaSource* _tmp1_;
	g_return_if_fail (SHOTWELL_IS_PROFILE_MANAGER (self));
	g_return_if_fail (id != NULL);
	_tmp0_ = g_settings_schema_source_get_default ();
	_tmp1_ = _g_settings_schema_source_ref0 (_tmp0_);
	source = _tmp1_;
	{
		const gchar** schema_collection = NULL;
		gint schema_collection_length1 = 0;
		gint _schema_collection_size_ = 0;
		gint schema_it = 0;
		schema_collection = SHOTWELL_PROFILE_MANAGER_SCHEMAS;
		schema_collection_length1 = G_N_ELEMENTS (SHOTWELL_PROFILE_MANAGER_SCHEMAS);
		for (schema_it = 0; schema_it < schema_collection_length1; schema_it = schema_it + 1) {
			const gchar* schema = NULL;
			schema = schema_collection[schema_it];
			{
				gchar* path = NULL;
				const gchar* _tmp2_;
				gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				gchar* schema_name = NULL;
				const gchar* _tmp7_;
				gchar* _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				GSettingsSchema* schema_definition = NULL;
				GSettingsSchemaSource* _tmp11_;
				const gchar* _tmp12_;
				GSettingsSchema* _tmp13_;
				GSettings* settings = NULL;
				GSettingsSchema* _tmp14_;
				const gchar* _tmp15_;
				GSettings* _tmp16_;
				GSettings* _tmp17_;
				GSettings* _tmp18_;
				GSettingsSchema* _tmp19_;
				gchar** _tmp20_;
				gchar** _tmp21_;
				GSettings* _tmp26_;
				_tmp2_ = schema;
				_tmp3_ = string_replace (_tmp2_, ".", "/");
				_tmp4_ = _tmp3_;
				_tmp5_ = g_strdup_printf ("/org/gnome/shotwell/profiles/%s/%s/", id, _tmp4_);
				_tmp6_ = _tmp5_;
				_g_free0 (_tmp4_);
				path = _tmp6_;
				_tmp7_ = schema;
				_tmp8_ = g_strdup_printf ("org.gnome.shotwell.%s", _tmp7_);
				schema_name = _tmp8_;
				_tmp9_ = schema_name;
				_tmp10_ = path;
				g_debug ("Profiles.vala:238: %s @ %s", _tmp9_, _tmp10_);
				_tmp11_ = source;
				_tmp12_ = schema_name;
				_tmp13_ = g_settings_schema_source_lookup (_tmp11_, _tmp12_, FALSE);
				schema_definition = _tmp13_;
				_tmp14_ = schema_definition;
				_tmp15_ = path;
				_tmp16_ = g_settings_new_full (_tmp14_, NULL, _tmp15_);
				settings = _tmp16_;
				_tmp17_ = settings;
				g_settings_delay (_tmp17_);
				_tmp18_ = settings;
				shotwell_profile_manager_reset_all_keys (self, _tmp18_);
				_tmp19_ = schema_definition;
				_tmp21_ = _tmp20_ = g_settings_schema_list_keys (_tmp19_);
				{
					gchar** key_collection = NULL;
					gint key_collection_length1 = 0;
					gint _key_collection_size_ = 0;
					gint key_it = 0;
					key_collection = _tmp21_;
					key_collection_length1 = _vala_array_length (_tmp20_);
					for (key_it = 0; key_it < key_collection_length1; key_it = key_it + 1) {
						gchar* _tmp22_;
						gchar* key = NULL;
						_tmp22_ = g_strdup (key_collection[key_it]);
						key = _tmp22_;
						{
							const gchar* _tmp23_;
							GSettings* _tmp24_;
							const gchar* _tmp25_;
							_tmp23_ = key;
							g_debug ("Profiles.vala:244: Resetting key %s", _tmp23_);
							_tmp24_ = settings;
							_tmp25_ = key;
							g_settings_reset (_tmp24_, _tmp25_);
							_g_free0 (key);
						}
					}
					key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
				}
				_tmp26_ = settings;
				g_settings_apply (_tmp26_);
				g_settings_sync ();
				_g_object_unref0 (settings);
				_g_settings_schema_unref0 (schema_definition);
				_g_free0 (schema_name);
				_g_free0 (path);
			}
		}
	}
	_g_settings_schema_source_unref0 (source);
}

static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}

static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		ShotwellProfileManager* self;
		self = _data15_->self;
		_g_object_unref0 (self);
		g_slice_free (Block15Data, _data15_);
	}
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

static gboolean
___lambda18_ (Block15Data* _data15_)
{
	ShotwellProfileManager* self;
	gboolean result;
	self = _data15_->self;
	g_list_model_items_changed (G_TYPE_CHECK_INSTANCE_CAST (self, g_list_model_get_type (), GListModel), (guint) _data15_->index, (guint) 1, (guint) 0);
	result = FALSE;
	return result;
}

static gboolean
____lambda18__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda18_ (self);
	return result;
}

void
shotwell_profile_manager_remove (ShotwellProfileManager* self,
                                 const gchar* id,
                                 gboolean remove_all)
{
	Block15Data* _data15_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* group = NULL;
	GKeyFile* _tmp2_;
	gsize _tmp3_ = 0;
	gchar** _tmp4_;
	const gchar* _tmp13_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (SHOTWELL_IS_PROFILE_MANAGER (self));
	g_return_if_fail (id != NULL);
	_data15_ = g_slice_new0 (Block15Data);
	_data15_->_ref_count_ = 1;
	_data15_->self = g_object_ref (self);
	_tmp0_ = bool_to_string (remove_all);
	_tmp1_ = _tmp0_;
	g_debug ("Profiles.vala:253: Request to remove profile %s, with files? %s", id, _tmp1_);
	_g_free0 (_tmp1_);
	_data15_->index = 1;
	group = NULL;
	_tmp2_ = self->priv->profiles;
	_tmp4_ = g_key_file_get_groups (_tmp2_, &_tmp3_);
	{
		gchar** g_collection = NULL;
		gint g_collection_length1 = 0;
		gint _g_collection_size_ = 0;
		gint g_it = 0;
		g_collection = _tmp4_;
		g_collection_length1 = _tmp3_;
		for (g_it = 0; g_it < g_collection_length1; g_it = g_it + 1) {
			gchar* _tmp5_;
			gchar* g = NULL;
			_tmp5_ = g_strdup (g_collection[g_it]);
			g = _tmp5_;
			{
				{
					gchar* _tmp6_ = NULL;
					GKeyFile* _tmp7_;
					const gchar* _tmp8_;
					gchar* _tmp9_;
					gint _tmp12_;
					_tmp7_ = self->priv->profiles;
					_tmp8_ = g;
					_tmp9_ = g_key_file_get_value (_tmp7_, _tmp8_, "Id", &_inner_error0_);
					_tmp6_ = _tmp9_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
							goto __catch0_g_key_file_error;
						}
						_g_free0 (g);
						g_collection = (_vala_array_free (g_collection, g_collection_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (group);
						block15_data_unref (_data15_);
						_data15_ = NULL;
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
					if (g_strcmp0 (_tmp6_, id) == 0) {
						const gchar* _tmp10_;
						gchar* _tmp11_;
						_tmp10_ = g;
						_tmp11_ = g_strdup (_tmp10_);
						_g_free0 (group);
						group = _tmp11_;
						_g_free0 (_tmp6_);
						_g_free0 (g);
						break;
					}
					_tmp12_ = _data15_->index;
					_data15_->index = _tmp12_ + 1;
					_g_free0 (_tmp6_);
				}
				goto __finally0;
				__catch0_g_key_file_error:
				{
					g_clear_error (&_inner_error0_);
					g_assert_not_reached ();
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (g);
					g_collection = (_vala_array_free (g_collection, g_collection_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (group);
					block15_data_unref (_data15_);
					_data15_ = NULL;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_g_free0 (g);
			}
		}
		g_collection = (_vala_array_free (g_collection, g_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp13_ = group;
	if (_tmp13_ != NULL) {
		gchar* data_dir = NULL;
		data_dir = NULL;
		{
			gchar* _tmp14_ = NULL;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* key = NULL;
			GKeyFile* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			GKeyFile* _tmp21_;
			const gchar* _tmp22_;
			_tmp15_ = group;
			_tmp16_ = shotwell_profile_manager_get_data_dir_for_profile (self, id, _tmp15_, &_inner_error0_);
			_tmp14_ = _tmp16_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
					goto __catch1_g_key_file_error;
				}
				_g_free0 (data_dir);
				_g_free0 (group);
				block15_data_unref (_data15_);
				_data15_ = NULL;
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp17_ = _tmp14_;
			_tmp14_ = NULL;
			_g_free0 (data_dir);
			data_dir = _tmp17_;
			key = NULL;
			_tmp18_ = self->priv->profiles;
			_tmp19_ = group;
			_tmp20_ = key;
			g_key_file_remove_comment (_tmp18_, _tmp19_, _tmp20_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (key);
				_g_free0 (_tmp14_);
				if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
					goto __catch1_g_key_file_error;
				}
				_g_free0 (data_dir);
				_g_free0 (group);
				block15_data_unref (_data15_);
				_data15_ = NULL;
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp21_ = self->priv->profiles;
			_tmp22_ = group;
			g_key_file_remove_group (_tmp21_, _tmp22_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (key);
				_g_free0 (_tmp14_);
				if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
					goto __catch1_g_key_file_error;
				}
				_g_free0 (data_dir);
				_g_free0 (group);
				block15_data_unref (_data15_);
				_data15_ = NULL;
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_g_free0 (key);
			_g_free0 (_tmp14_);
		}
		goto __finally1;
		__catch1_g_key_file_error:
		{
			g_clear_error (&_inner_error0_);
			g_assert_not_reached ();
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (data_dir);
			_g_free0 (group);
			block15_data_unref (_data15_);
			_data15_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		shotwell_profile_manager_remove_settings_recursively (self, id);
		if (remove_all) {
			{
				GFile* file = NULL;
				const gchar* _tmp23_;
				GFile* _tmp24_;
				GFile* _tmp25_;
				_tmp23_ = data_dir;
				_tmp24_ = g_file_new_for_commandline_arg (_tmp23_);
				file = _tmp24_;
				_tmp25_ = file;
				g_file_trash (_tmp25_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (file);
					goto __catch2_g_error;
				}
				_g_object_unref0 (file);
			}
			goto __finally2;
			__catch2_g_error:
			{
				GError* _error_ = NULL;
				GError* _tmp26_;
				const gchar* _tmp27_;
				_error_ = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp26_ = _error_;
				_tmp27_ = _tmp26_->message;
				g_warning ("Profiles.vala:290: Failed to remove data folder: %s", _tmp27_);
				_g_error_free0 (_error_);
			}
			__finally2:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (data_dir);
				_g_free0 (group);
				block15_data_unref (_data15_);
				_data15_ = NULL;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda18__gsource_func, block15_data_ref (_data15_), block15_data_unref);
		shotwell_profile_manager_write (self);
		_g_free0 (data_dir);
	}
	_g_free0 (group);
	block15_data_unref (_data15_);
	_data15_ = NULL;
}

static void
shotwell_profile_manager_class_init (ShotwellProfileManagerClass * klass,
                                     gpointer klass_data)
{
	shotwell_profile_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ShotwellProfileManager_private_offset);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) shotwell_profile_manager_real_constructed;
	G_OBJECT_CLASS (klass)->finalize = shotwell_profile_manager_finalize;
}

static void
shotwell_profile_manager_g_list_model_interface_init (GListModelInterface * iface,
                                                      gpointer iface_data)
{
	shotwell_profile_manager_g_list_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_item_type = (GType (*) (GListModel*)) shotwell_profile_manager_real_get_item_type;
	iface->get_n_items = (guint (*) (GListModel*)) shotwell_profile_manager_real_get_n_items;
	iface->get_item = (GObject* (*) (GListModel*, guint)) shotwell_profile_manager_real_get_item;
}

static void
shotwell_profile_manager_instance_init (ShotwellProfileManager * self,
                                        gpointer klass)
{
	self->priv = shotwell_profile_manager_get_instance_private (self);
	self->priv->profile = NULL;
}

static void
shotwell_profile_manager_finalize (GObject * obj)
{
	ShotwellProfileManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SHOTWELL_TYPE_PROFILE_MANAGER, ShotwellProfileManager);
	_g_key_file_unref0 (self->priv->profiles);
	_g_free0 (self->priv->profile);
	_g_free0 (self->priv->path);
	_g_free0 (self->priv->group_name);
	G_OBJECT_CLASS (shotwell_profile_manager_parent_class)->finalize (obj);
}

static GType
shotwell_profile_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ShotwellProfileManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) shotwell_profile_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ShotwellProfileManager), 0, (GInstanceInitFunc) shotwell_profile_manager_instance_init, NULL };
	static const GInterfaceInfo g_list_model_info = { (GInterfaceInitFunc) shotwell_profile_manager_g_list_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType shotwell_profile_manager_type_id;
	shotwell_profile_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "ShotwellProfileManager", &g_define_type_info, 0);
	g_type_add_interface_static (shotwell_profile_manager_type_id, g_list_model_get_type (), &g_list_model_info);
	ShotwellProfileManager_private_offset = g_type_add_instance_private (shotwell_profile_manager_type_id, sizeof (ShotwellProfileManagerPrivate));
	return shotwell_profile_manager_type_id;
}

GType
shotwell_profile_manager_get_type (void)
{
	static volatile gsize shotwell_profile_manager_type_id__once = 0;
	if (g_once_init_enter (&shotwell_profile_manager_type_id__once)) {
		GType shotwell_profile_manager_type_id;
		shotwell_profile_manager_type_id = shotwell_profile_manager_get_type_once ();
		g_once_init_leave (&shotwell_profile_manager_type_id__once, shotwell_profile_manager_type_id);
	}
	return shotwell_profile_manager_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

