// services/viz/public/mojom/gpu.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_GPU_MOJOM_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_GPU_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/gpu.mojom-features.h"  // IWYU pragma: export
#include "services/viz/public/mojom/gpu.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/public/mojom/gpu.mojom-forward.h"  // IWYU pragma: export
#include "gpu/ipc/common/gpu_feature_info.mojom.h"
#include "gpu/ipc/common/gpu_info.mojom.h"
#include "gpu/ipc/common/client_gmb_interface.mojom-forward.h"
#include "gpu/ipc/common/shared_image_capabilities.mojom.h"
#include "gpu/ipc/common/sync_token.mojom-forward.h"
#include "media/mojo/mojom/video_encode_accelerator.mojom-forward.h"
#include "mojo/public/mojom/base/shared_memory.mojom-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-forward.h"
#include "ui/gfx/mojom/buffer_types.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace viz::mojom {

class GpuProxy;

template <typename ImplRefTraits>
class GpuStub;

class GpuRequestValidator;
class GpuResponseValidator;


class Gpu
    : public GpuInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = GpuInterfaceBase;
  using Proxy_ = GpuProxy;

  template <typename ImplRefTraits>
  using Stub_ = GpuStub<ImplRefTraits>;

  using RequestValidator_ = GpuRequestValidator;
  using ResponseValidator_ = GpuResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateClientGpuMemoryBufferFactoryMinVersion = 0,
    kEstablishGpuChannelMinVersion = 0,
    kCreateVideoEncodeAcceleratorProviderMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateClientGpuMemoryBufferFactory_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EstablishGpuChannel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateVideoEncodeAcceleratorProvider_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Gpu() = default;

  
  virtual void CreateClientGpuMemoryBufferFactory(::mojo::PendingReceiver<::gpu::mojom::ClientGmbInterface> receiver) = 0;


  using EstablishGpuChannelCallback = base::OnceCallback<void(int32_t, ::mojo::ScopedMessagePipeHandle, const ::gpu::GPUInfo&, const ::gpu::GpuFeatureInfo&, const ::gpu::SharedImageCapabilities&)>;
  
  virtual void EstablishGpuChannel(EstablishGpuChannelCallback callback) = 0;

  
  virtual void CreateVideoEncodeAcceleratorProvider(::mojo::PendingReceiver<::media::mojom::VideoEncodeAcceleratorProvider> vea_provider) = 0;
};



class  GpuProxy
    : public Gpu {
 public:
  using InterfaceType = Gpu;

  explicit GpuProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateClientGpuMemoryBufferFactory(::mojo::PendingReceiver<::gpu::mojom::ClientGmbInterface> receiver) final;
  
  void EstablishGpuChannel(EstablishGpuChannelCallback callback) final;
  
  void CreateVideoEncodeAcceleratorProvider(::mojo::PendingReceiver<::media::mojom::VideoEncodeAcceleratorProvider> vea_provider) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  GpuStubDispatch {
 public:
  static bool Accept(Gpu* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Gpu* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Gpu>>
class GpuStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  GpuStub() = default;
  ~GpuStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GpuStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GpuStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  GpuRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  GpuResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // viz::mojom

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_GPU_MOJOM_H_