// components/attribution_reporting/registration.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/attribution_reporting/registration.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/attribution_reporting/registration.mojom-params-data.h"
namespace attribution_reporting {
namespace mojom {

namespace internal {


// static
bool SuitableOrigin_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SuitableOrigin_Data* object =
      static_cast<const SuitableOrigin_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  return true;
}

SuitableOrigin_Data::SuitableOrigin_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FilterData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FilterData_Data* object =
      static_cast<const FilterData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->filter_values, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& filter_values_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>()>();
  if (!mojo::internal::ValidateContainer(object->filter_values, validation_context,
                                         &filter_values_validate_params)) {
    return false;
  }

  return true;
}

FilterData_Data::FilterData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FilterConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FilterConfig_Data* object =
      static_cast<const FilterConfig_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->lookback_window, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->filter_values, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& filter_values_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>()>();
  if (!mojo::internal::ValidateContainer(object->filter_values, validation_context,
                                         &filter_values_validate_params)) {
    return false;
  }

  return true;
}

FilterConfig_Data::FilterConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FilterPair_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FilterPair_Data* object =
      static_cast<const FilterPair_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->positive, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& positive_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->positive, validation_context,
                                         &positive_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->negative, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& negative_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->negative, validation_context,
                                         &negative_validate_params)) {
    return false;
  }

  return true;
}

FilterPair_Data::FilterPair_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AggregationKeys_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AggregationKeys_Data* object =
      static_cast<const AggregationKeys_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->keys, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& keys_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->keys, validation_context,
                                         &keys_validate_params)) {
    return false;
  }

  return true;
}

AggregationKeys_Data::AggregationKeys_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AggregatableTriggerData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AggregatableTriggerData_Data* object =
      static_cast<const AggregatableTriggerData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_piece, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key_piece, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_keys, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& source_keys_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->source_keys, validation_context,
                                         &source_keys_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->filters, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->filters, validation_context))
    return false;

  return true;
}

AggregatableTriggerData_Data::AggregatableTriggerData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DestinationSet_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DestinationSet_Data* object =
      static_cast<const DestinationSet_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->destinations, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& destinations_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->destinations, validation_context,
                                         &destinations_validate_params)) {
    return false;
  }

  return true;
}

DestinationSet_Data::DestinationSet_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EventReportWindows_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const EventReportWindows_Data* object =
      static_cast<const EventReportWindows_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->start_time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->start_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->end_times, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& end_times_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->end_times, validation_context,
                                         &end_times_validate_params)) {
    return false;
  }

  return true;
}

EventReportWindows_Data::EventReportWindows_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TriggerSpec_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TriggerSpec_Data* object =
      static_cast<const TriggerSpec_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event_report_windows, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->event_report_windows, validation_context))
    return false;

  return true;
}

TriggerSpec_Data::TriggerSpec_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TriggerSpecs_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TriggerSpecs_Data* object =
      static_cast<const TriggerSpecs_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->specs, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& specs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->specs, validation_context,
                                         &specs_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->trigger_data_indices, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& trigger_data_indices_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->trigger_data_indices, validation_context,
                                         &trigger_data_indices_validate_params)) {
    return false;
  }

  return true;
}

TriggerSpecs_Data::TriggerSpecs_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AggregatableDebugReportingContribution_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AggregatableDebugReportingContribution_Data* object =
      static_cast<const AggregatableDebugReportingContribution_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_piece, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key_piece, validation_context))
    return false;

  return true;
}

AggregatableDebugReportingContribution_Data::AggregatableDebugReportingContribution_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AggregatableDebugReportingConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AggregatableDebugReportingConfig_Data* object =
      static_cast<const AggregatableDebugReportingConfig_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_piece, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key_piece, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->debug_data, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& debug_data_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::attribution_reporting::mojom::internal::DebugDataType_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->debug_data, validation_context,
                                         &debug_data_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->aggregation_coordinator_origin, validation_context))
    return false;

  return true;
}

AggregatableDebugReportingConfig_Data::AggregatableDebugReportingConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SourceAggregatableDebugReportingConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SourceAggregatableDebugReportingConfig_Data* object =
      static_cast<const SourceAggregatableDebugReportingConfig_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->config, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->config, validation_context))
    return false;

  return true;
}

SourceAggregatableDebugReportingConfig_Data::SourceAggregatableDebugReportingConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AttributionScopesSet_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AttributionScopesSet_Data* object =
      static_cast<const AttributionScopesSet_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scopes, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& scopes_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->scopes, validation_context,
                                         &scopes_validate_params)) {
    return false;
  }

  return true;
}

AttributionScopesSet_Data::AttributionScopesSet_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AttributionScopesData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AttributionScopesData_Data* object =
      static_cast<const AttributionScopesData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->attribution_scopes_set, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->attribution_scopes_set, validation_context))
    return false;

  return true;
}

AttributionScopesData_Data::AttributionScopesData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AggregatableNamedBudgetDefs_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AggregatableNamedBudgetDefs_Data* object =
      static_cast<const AggregatableNamedBudgetDefs_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->budgets, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& budgets_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->budgets, validation_context,
                                         &budgets_validate_params)) {
    return false;
  }

  return true;
}

AggregatableNamedBudgetDefs_Data::AggregatableNamedBudgetDefs_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SourceRegistration_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 128, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SourceRegistration_Data* object =
      static_cast<const SourceRegistration_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->destinations, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->destinations, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->expiry, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->expiry, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->trigger_specs, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->trigger_specs, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->aggregatable_report_window, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->aggregatable_report_window, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->filter_data, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->filter_data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->aggregation_keys, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->aggregation_keys, validation_context))
    return false;


  if (!::attribution_reporting::mojom::internal::TriggerDataMatching_Data
        ::Validate(object->trigger_data_matching, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->aggregatable_debug_reporting_config, 14, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->aggregatable_debug_reporting_config, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->attribution_scopes_data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->aggregatable_named_budget_defs, 17, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->aggregatable_named_budget_defs, validation_context))
    return false;

  return true;
}

SourceRegistration_Data::SourceRegistration_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EventTriggerData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const EventTriggerData_Data* object =
      static_cast<const EventTriggerData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->filters, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->filters, validation_context))
    return false;

  return true;
}

EventTriggerData_Data::EventTriggerData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AggregatableDedupKey_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AggregatableDedupKey_Data* object =
      static_cast<const AggregatableDedupKey_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->filters, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->filters, validation_context))
    return false;

  return true;
}

AggregatableDedupKey_Data::AggregatableDedupKey_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AggregatableValuesValue_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AggregatableValuesValue_Data* object =
      static_cast<const AggregatableValuesValue_Data*>(data);

  return true;
}

AggregatableValuesValue_Data::AggregatableValuesValue_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AggregatableValues_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AggregatableValues_Data* object =
      static_cast<const AggregatableValues_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->values, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& values_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->values, validation_context,
                                         &values_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->filters, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->filters, validation_context))
    return false;

  return true;
}

AggregatableValues_Data::AggregatableValues_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AggregatableNamedBudgetCandidate_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AggregatableNamedBudgetCandidate_Data* object =
      static_cast<const AggregatableNamedBudgetCandidate_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->filters, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->filters, validation_context))
    return false;

  return true;
}

AggregatableNamedBudgetCandidate_Data::AggregatableNamedBudgetCandidate_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TriggerRegistration_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 104, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TriggerRegistration_Data* object =
      static_cast<const TriggerRegistration_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event_triggers, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& event_triggers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->event_triggers, validation_context,
                                         &event_triggers_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->filters, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->filters, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->aggregatable_trigger_data, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& aggregatable_trigger_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->aggregatable_trigger_data, validation_context,
                                         &aggregatable_trigger_data_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->aggregatable_values, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& aggregatable_values_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->aggregatable_values, validation_context,
                                         &aggregatable_values_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->aggregatable_dedup_keys, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& aggregatable_dedup_keys_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->aggregatable_dedup_keys, validation_context,
                                         &aggregatable_dedup_keys_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->aggregation_coordinator_origin, validation_context))
    return false;


  if (!::attribution_reporting::mojom::internal::SourceRegistrationTimeConfig_Data
        ::Validate(object->source_registration_time_config, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& trigger_context_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->trigger_context_id, validation_context,
                                         &trigger_context_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->aggregatable_debug_reporting_config, 13, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->aggregatable_debug_reporting_config, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->attribution_scopes, 14, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->attribution_scopes, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->aggregatable_named_budget_candidates, 15, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& aggregatable_named_budget_candidates_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->aggregatable_named_budget_candidates, validation_context,
                                         &aggregatable_named_budget_candidates_validate_params)) {
    return false;
  }

  return true;
}

TriggerRegistration_Data::TriggerRegistration_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OsRegistrationItem_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OsRegistrationItem_Data* object =
      static_cast<const OsRegistrationItem_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

OsRegistrationItem_Data::OsRegistrationItem_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OsRegistration_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OsRegistration_Data* object =
      static_cast<const OsRegistration_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->items, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& items_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->items, validation_context,
                                         &items_validate_params)) {
    return false;
  }

  return true;
}

OsRegistration_Data::OsRegistration_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace attribution_reporting