// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file was generated by running:
//     ../../../../../qtwebengine/src/3rdparty/chromium/chrome/test/chromedriver/embed_mobile_devices_in_cpp.py --directory gen/chrome/test/chromedriver/chrome ../../../../../qtwebengine/src/3rdparty/chromium/third_party/devtools-frontend/src/front_end/models/emulation/EmulatedDevices.ts

#include "chrome/test/chromedriver/chrome/mobile_device_list.h"

const char kMobileDevices[] =
    "{\n"
    "\"iPhone SE\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 320,\n"
    "\"height\": 568,\n"
    "\"deviceScaleFactor\": 2,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\"\n"
    "},\n"
    "\"iPhone XR\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (iPhone; CPU iPhone OS 16_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/16.6 Mobile/15E148 Safari/604.1\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 414,\n"
    "\"height\": 896,\n"
    "\"deviceScaleFactor\": 2,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\"\n"
    "},\n"
    "\"iPhone 12 Pro\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (iPhone; CPU iPhone OS 16_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/16.6 Mobile/15E148 Safari/604.1\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 390,\n"
    "\"height\": 844,\n"
    "\"deviceScaleFactor\": 3,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\"\n"
    "},\n"
    "\"iPhone 14 Pro Max\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (iPhone; CPU iPhone OS 16_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/16.6 Mobile/15E148 Safari/604.1\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 430,\n"
    "\"height\": 932,\n"
    "\"deviceScaleFactor\": 3,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\"\n"
    "},\n"
    "\"Pixel 3 XL\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (Linux; Android 11; Pixel 3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 393,\n"
    "\"height\": 786,\n"
    "\"deviceScaleFactor\": 2.75,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\",\n"
    "\"clientHints\": {\n"
    "\"architecture\": \"\",\n"
    "\"bitness\": \"\",\n"
    "\"platform\": \"Android\",\n"
    "\"platformVersion\": \"11\",\n"
    "\"model\": \"Pixel 3\",\n"
    "\"mobile\": true,\n"
    "\"wow64\": false\n"
    "}\n"
    "},\n"
    "\"Pixel 7\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (Linux; Android 13; Pixel 7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 412,\n"
    "\"height\": 915,\n"
    "\"deviceScaleFactor\": 2.625,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\",\n"
    "\"clientHints\": {\n"
    "\"architecture\": \"\",\n"
    "\"bitness\": \"\",\n"
    "\"platform\": \"Android\",\n"
    "\"platformVersion\": \"13\",\n"
    "\"model\": \"Pixel 5\",\n"
    "\"mobile\": true,\n"
    "\"wow64\": false\n"
    "}\n"
    "},\n"
    "\"Samsung Galaxy S8+\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (Linux; Android 8.0.0; SM-G955U Build/R16NW) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 360,\n"
    "\"height\": 740,\n"
    "\"deviceScaleFactor\": 4,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\",\n"
    "\"clientHints\": {\n"
    "\"architecture\": \"\",\n"
    "\"bitness\": \"\",\n"
    "\"platform\": \"Android\",\n"
    "\"platformVersion\": \"8.0.0\",\n"
    "\"model\": \"SM-G955U\",\n"
    "\"mobile\": true,\n"
    "\"wow64\": false\n"
    "}\n"
    "},\n"
    "\"Samsung Galaxy S20 Ultra\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (Linux; Android 13; SM-G981B) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 412,\n"
    "\"height\": 915,\n"
    "\"deviceScaleFactor\": 3.5,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\",\n"
    "\"clientHints\": {\n"
    "\"architecture\": \"\",\n"
    "\"bitness\": \"\",\n"
    "\"platform\": \"Android\",\n"
    "\"platformVersion\": \"13\",\n"
    "\"model\": \"SM-G981B\",\n"
    "\"mobile\": true,\n"
    "\"wow64\": false\n"
    "}\n"
    "},\n"
    "\"iPad Mini\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (iPad; CPU OS 16_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/16.6 Mobile/15E148 Safari/604.1\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 768,\n"
    "\"height\": 1024,\n"
    "\"deviceScaleFactor\": 2,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"tablet\"\n"
    "},\n"
    "\"iPad Air\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/16.0 Safari/605.1.15\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 820,\n"
    "\"height\": 1180,\n"
    "\"deviceScaleFactor\": 2,\n"
    "\"touch\": true,\n"
    "\"mobile\": false\n"
    "},\n"
    "\"type\": \"tablet\"\n"
    "},\n"
    "\"iPad Pro\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (iPad; CPU OS 11_0 like Mac OS X) AppleWebKit/604.1.34 (KHTML, like Gecko) Version/11.0 Mobile/15A5341f Safari/604.1\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 1024,\n"
    "\"height\": 1366,\n"
    "\"deviceScaleFactor\": 2,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"tablet\"\n"
    "},\n"
    "\"Surface Pro 7\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Safari/537.36\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 912,\n"
    "\"height\": 1368,\n"
    "\"deviceScaleFactor\": 2,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"tablet\"\n"
    "},\n"
    "\"Surface Duo\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (Linux; Android 11.0; Surface Duo) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 540,\n"
    "\"height\": 720,\n"
    "\"deviceScaleFactor\": 2.5,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\",\n"
    "\"clientHints\": {\n"
    "\"architecture\": \"\",\n"
    "\"bitness\": \"\",\n"
    "\"platform\": \"Android\",\n"
    "\"platformVersion\": \"11.0\",\n"
    "\"model\": \"Surface Duo\",\n"
    "\"mobile\": true,\n"
    "\"wow64\": false\n"
    "}\n"
    "},\n"
    "\"Galaxy Z Fold 5\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 344,\n"
    "\"height\": 882,\n"
    "\"deviceScaleFactor\": 2.625,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\",\n"
    "\"clientHints\": {\n"
    "\"architecture\": \"\",\n"
    "\"bitness\": \"\",\n"
    "\"platform\": \"Android\",\n"
    "\"platformVersion\": \"10.0\",\n"
    "\"model\": \"SM-F946U\",\n"
    "\"mobile\": true,\n"
    "\"wow64\": false\n"
    "}\n"
    "},\n"
    "\"Asus Zenbook Fold\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Safari/537.36\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 853,\n"
    "\"height\": 1280,\n"
    "\"deviceScaleFactor\": 1.5,\n"
    "\"touch\": true,\n"
    "\"mobile\": false\n"
    "},\n"
    "\"type\": \"tablet\",\n"
    "\"clientHints\": {\n"
    "\"architecture\": \"\",\n"
    "\"bitness\": \"\",\n"
    "\"platform\": \"Windows\",\n"
    "\"platformVersion\": \"11.0\",\n"
    "\"model\": \"UX9702AA\",\n"
    "\"mobile\": false,\n"
    "\"wow64\": false\n"
    "}\n"
    "},\n"
    "\"Samsung Galaxy A51/71\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (Linux; Android 8.0.0; SM-G955U Build/R16NW) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 412,\n"
    "\"height\": 914,\n"
    "\"deviceScaleFactor\": 2.625,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\",\n"
    "\"clientHints\": {\n"
    "\"architecture\": \"\",\n"
    "\"bitness\": \"\",\n"
    "\"platform\": \"Android\",\n"
    "\"platformVersion\": \"8.0.0\",\n"
    "\"model\": \"SM-G955U\",\n"
    "\"mobile\": true,\n"
    "\"wow64\": false\n"
    "}\n"
    "},\n"
    "\"Samsung Galaxy A51\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (Linux; Android 8.0.0; SM-G955U Build/R16NW) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 412,\n"
    "\"height\": 914,\n"
    "\"deviceScaleFactor\": 2.625,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\",\n"
    "\"clientHints\": {\n"
    "\"architecture\": \"\",\n"
    "\"bitness\": \"\",\n"
    "\"platform\": \"Android\",\n"
    "\"platformVersion\": \"8.0.0\",\n"
    "\"model\": \"SM-G955U\",\n"
    "\"mobile\": true,\n"
    "\"wow64\": false\n"
    "}\n"
    "},\n"
    "\"Samsung Galaxy 71\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (Linux; Android 8.0.0; SM-G955U Build/R16NW) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 412,\n"
    "\"height\": 914,\n"
    "\"deviceScaleFactor\": 2.625,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\",\n"
    "\"clientHints\": {\n"
    "\"architecture\": \"\",\n"
    "\"bitness\": \"\",\n"
    "\"platform\": \"Android\",\n"
    "\"platformVersion\": \"8.0.0\",\n"
    "\"model\": \"SM-G955U\",\n"
    "\"mobile\": true,\n"
    "\"wow64\": false\n"
    "}\n"
    "},\n"
    "\"Nest Hub Max\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (X11; Linux aarch64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Safari/537.36 CrKey/1.54.250320\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 1280,\n"
    "\"height\": 800,\n"
    "\"deviceScaleFactor\": 2,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"tablet\"\n"
    "},\n"
    "\"Nest Hub\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (Linux; Android) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Safari/537.36 CrKey/1.54.248666\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 1024,\n"
    "\"height\": 600,\n"
    "\"deviceScaleFactor\": 2,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"tablet\",\n"
    "\"clientHints\": {\n"
    "\"architecture\": \"\",\n"
    "\"bitness\": \"\",\n"
    "\"platform\": \"Android\",\n"
    "\"platformVersion\": \"\",\n"
    "\"model\": \"\",\n"
    "\"mobile\": false,\n"
    "\"wow64\": false\n"
    "}\n"
    "},\n"
    "\"iPhone 4\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (iPhone; CPU iPhone OS 7_1_2 like Mac OS X) AppleWebKit/537.51.2 (KHTML, like Gecko) Version/7.0 Mobile/11D257 Safari/9537.53\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 320,\n"
    "\"height\": 480,\n"
    "\"deviceScaleFactor\": 2,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\"\n"
    "},\n"
    "\"iPhone 5/SE\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 320,\n"
    "\"height\": 568,\n"
    "\"deviceScaleFactor\": 2,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\"\n"
    "},\n"
    "\"iPhone 5\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 320,\n"
    "\"height\": 568,\n"
    "\"deviceScaleFactor\": 2,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\"\n"
    "},\n"
    "\"iPhone 6/7/8\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (iPhone; CPU iPhone OS 13_2_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Mobile/15E148 Safari/604.1\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 375,\n"
    "\"height\": 667,\n"
    "\"deviceScaleFactor\": 2,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\"\n"
    "},\n"
    "\"iPhone 6\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (iPhone; CPU iPhone OS 13_2_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Mobile/15E148 Safari/604.1\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 375,\n"
    "\"height\": 667,\n"
    "\"deviceScaleFactor\": 2,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\"\n"
    "},\n"
    "\"iPhone 7\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (iPhone; CPU iPhone OS 13_2_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Mobile/15E148 Safari/604.1\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 375,\n"
    "\"height\": 667,\n"
    "\"deviceScaleFactor\": 2,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\"\n"
    "},\n"
    "\"iPhone 8\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (iPhone; CPU iPhone OS 13_2_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Mobile/15E148 Safari/604.1\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 375,\n"
    "\"height\": 667,\n"
    "\"deviceScaleFactor\": 2,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\"\n"
    "},\n"
    "\"iPhone 6/7/8 Plus\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (iPhone; CPU iPhone OS 13_2_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Mobile/15E148 Safari/604.1\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 414,\n"
    "\"height\": 736,\n"
    "\"deviceScaleFactor\": 3,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\"\n"
    "},\n"
    "\"iPhone 6 Plus\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (iPhone; CPU iPhone OS 13_2_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Mobile/15E148 Safari/604.1\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 414,\n"
    "\"height\": 736,\n"
    "\"deviceScaleFactor\": 3,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\"\n"
    "},\n"
    "\"iPhone 7 Plus\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (iPhone; CPU iPhone OS 13_2_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Mobile/15E148 Safari/604.1\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 414,\n"
    "\"height\": 736,\n"
    "\"deviceScaleFactor\": 3,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\"\n"
    "},\n"
    "\"iPhone 8 Plus\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (iPhone; CPU iPhone OS 13_2_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Mobile/15E148 Safari/604.1\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 414,\n"
    "\"height\": 736,\n"
    "\"deviceScaleFactor\": 3,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\"\n"
    "},\n"
    "\"iPhone X\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (iPhone; CPU iPhone OS 13_2_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Mobile/15E148 Safari/604.1\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 375,\n"
    "\"height\": 812,\n"
    "\"deviceScaleFactor\": 3,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\"\n"
    "},\n"
    "\"BlackBerry Z30\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (BB10; Touch) AppleWebKit/537.10+ (KHTML, like Gecko) Version/10.0.9.2372 Mobile Safari/537.10+\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 360,\n"
    "\"height\": 640,\n"
    "\"deviceScaleFactor\": 2,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\"\n"
    "},\n"
    "\"Nexus 4\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (Linux; Android 4.4.2; Nexus 4 Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 384,\n"
    "\"height\": 640,\n"
    "\"deviceScaleFactor\": 2,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\",\n"
    "\"clientHints\": {\n"
    "\"architecture\": \"\",\n"
    "\"bitness\": \"\",\n"
    "\"platform\": \"Android\",\n"
    "\"platformVersion\": \"4.4.2\",\n"
    "\"model\": \"Nexus 4\",\n"
    "\"mobile\": true,\n"
    "\"wow64\": false\n"
    "}\n"
    "},\n"
    "\"Nexus 5\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (Linux; Android 6.0; Nexus 5 Build/MRA58N) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 360,\n"
    "\"height\": 640,\n"
    "\"deviceScaleFactor\": 3,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\",\n"
    "\"clientHints\": {\n"
    "\"architecture\": \"\",\n"
    "\"bitness\": \"\",\n"
    "\"platform\": \"Android\",\n"
    "\"platformVersion\": \"6.0\",\n"
    "\"model\": \"Nexus 5\",\n"
    "\"mobile\": true,\n"
    "\"wow64\": false\n"
    "}\n"
    "},\n"
    "\"Nexus 5X\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (Linux; Android 8.0.0; Nexus 5X Build/OPR4.170623.006) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 412,\n"
    "\"height\": 732,\n"
    "\"deviceScaleFactor\": 2.625,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\",\n"
    "\"clientHints\": {\n"
    "\"architecture\": \"\",\n"
    "\"bitness\": \"\",\n"
    "\"platform\": \"Android\",\n"
    "\"platformVersion\": \"8.0.0\",\n"
    "\"model\": \"Nexus 5X\",\n"
    "\"mobile\": true,\n"
    "\"wow64\": false\n"
    "}\n"
    "},\n"
    "\"Nexus 6\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (Linux; Android 7.1.1; Nexus 6 Build/N6F26U) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 412,\n"
    "\"height\": 732,\n"
    "\"deviceScaleFactor\": 3.5,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\",\n"
    "\"clientHints\": {\n"
    "\"architecture\": \"\",\n"
    "\"bitness\": \"\",\n"
    "\"platform\": \"Android\",\n"
    "\"platformVersion\": \"7.1.1\",\n"
    "\"model\": \"Nexus 6\",\n"
    "\"mobile\": true,\n"
    "\"wow64\": false\n"
    "}\n"
    "},\n"
    "\"Nexus 6P\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (Linux; Android 8.0.0; Nexus 6P Build/OPP3.170518.006) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 412,\n"
    "\"height\": 732,\n"
    "\"deviceScaleFactor\": 3.5,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\",\n"
    "\"clientHints\": {\n"
    "\"architecture\": \"\",\n"
    "\"bitness\": \"\",\n"
    "\"platform\": \"Android\",\n"
    "\"platformVersion\": \"8.0.0\",\n"
    "\"model\": \"Nexus 6P\",\n"
    "\"mobile\": true,\n"
    "\"wow64\": false\n"
    "}\n"
    "},\n"
    "\"Pixel 2\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (Linux; Android 8.0; Pixel 2 Build/OPD3.170816.012) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 411,\n"
    "\"height\": 731,\n"
    "\"deviceScaleFactor\": 2.625,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\",\n"
    "\"clientHints\": {\n"
    "\"architecture\": \"\",\n"
    "\"bitness\": \"\",\n"
    "\"platform\": \"Android\",\n"
    "\"platformVersion\": \"8.0\",\n"
    "\"model\": \"Pixel 2\",\n"
    "\"mobile\": true,\n"
    "\"wow64\": false\n"
    "}\n"
    "},\n"
    "\"Pixel 2 XL\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (Linux; Android 8.0.0; Pixel 2 XL Build/OPD1.170816.004) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 411,\n"
    "\"height\": 823,\n"
    "\"deviceScaleFactor\": 3.5,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\",\n"
    "\"clientHints\": {\n"
    "\"architecture\": \"\",\n"
    "\"bitness\": \"\",\n"
    "\"platform\": \"Android\",\n"
    "\"platformVersion\": \"8.0.0\",\n"
    "\"model\": \"Pixel 2 XL\",\n"
    "\"mobile\": true,\n"
    "\"wow64\": false\n"
    "}\n"
    "},\n"
    "\"Pixel 3\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (Linux; Android 9; Pixel 3 Build/PQ1A.181105.017.A1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 393,\n"
    "\"height\": 786,\n"
    "\"deviceScaleFactor\": 2.75,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\",\n"
    "\"clientHints\": {\n"
    "\"architecture\": \"\",\n"
    "\"bitness\": \"\",\n"
    "\"platform\": \"Android\",\n"
    "\"platformVersion\": \"9\",\n"
    "\"model\": \"Pixel 3\",\n"
    "\"mobile\": true,\n"
    "\"wow64\": false\n"
    "}\n"
    "},\n"
    "\"Pixel 4\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (Linux; Android 10; Pixel 4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 353,\n"
    "\"height\": 745,\n"
    "\"deviceScaleFactor\": 3,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\",\n"
    "\"clientHints\": {\n"
    "\"architecture\": \"\",\n"
    "\"bitness\": \"\",\n"
    "\"platform\": \"Android\",\n"
    "\"platformVersion\": \"10\",\n"
    "\"model\": \"Pixel 4\",\n"
    "\"mobile\": true,\n"
    "\"wow64\": false\n"
    "}\n"
    "},\n"
    "\"LG Optimus L70\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (Linux; U; Android 4.4.2; en-us; LGMS323 Build/KOT49I.MS32310c) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/%s Mobile Safari/537.36\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 384,\n"
    "\"height\": 640,\n"
    "\"deviceScaleFactor\": 1.25,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\",\n"
    "\"clientHints\": {\n"
    "\"architecture\": \"\",\n"
    "\"bitness\": \"\",\n"
    "\"platform\": \"Android\",\n"
    "\"platformVersion\": \"4.4.2\",\n"
    "\"model\": \"LGMS323\",\n"
    "\"mobile\": true,\n"
    "\"wow64\": false\n"
    "}\n"
    "},\n"
    "\"Nokia N9\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (MeeGo; NokiaN9) AppleWebKit/534.13 (KHTML, like Gecko) NokiaBrowser/8.5.0 Mobile Safari/534.13\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 480,\n"
    "\"height\": 854,\n"
    "\"deviceScaleFactor\": 1,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\"\n"
    "},\n"
    "\"Nokia Lumia 520\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (compatible; MSIE 10.0; Windows Phone 8.0; Trident/6.0; IEMobile/10.0; ARM; Touch; NOKIA; Lumia 520)\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 320,\n"
    "\"height\": 533,\n"
    "\"deviceScaleFactor\": 1.5,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\"\n"
    "},\n"
    "\"Microsoft Lumia 550\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (Windows Phone 10.0; Android 4.2.1; Microsoft; Lumia 550) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36 Edge/14.14263\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 640,\n"
    "\"height\": 360,\n"
    "\"deviceScaleFactor\": 2,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\",\n"
    "\"clientHints\": {\n"
    "\"architecture\": \"\",\n"
    "\"bitness\": \"\",\n"
    "\"platform\": \"Android\",\n"
    "\"platformVersion\": \"4.2.1\",\n"
    "\"model\": \"Lumia 550\",\n"
    "\"mobile\": true,\n"
    "\"wow64\": false\n"
    "}\n"
    "},\n"
    "\"Microsoft Lumia 950\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (Windows Phone 10.0; Android 4.2.1; Microsoft; Lumia 950) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36 Edge/14.14263\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 360,\n"
    "\"height\": 640,\n"
    "\"deviceScaleFactor\": 4,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\",\n"
    "\"clientHints\": {\n"
    "\"architecture\": \"\",\n"
    "\"bitness\": \"\",\n"
    "\"platform\": \"Android\",\n"
    "\"platformVersion\": \"4.2.1\",\n"
    "\"model\": \"Lumia 950\",\n"
    "\"mobile\": true,\n"
    "\"wow64\": false\n"
    "}\n"
    "},\n"
    "\"Galaxy S III\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (Linux; U; Android 4.0; en-us; GT-I9300 Build/IMM76D) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 360,\n"
    "\"height\": 640,\n"
    "\"deviceScaleFactor\": 2,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\",\n"
    "\"clientHints\": {\n"
    "\"architecture\": \"\",\n"
    "\"bitness\": \"\",\n"
    "\"platform\": \"Android\",\n"
    "\"platformVersion\": \"4.0\",\n"
    "\"model\": \"GT-I9300\",\n"
    "\"mobile\": true,\n"
    "\"wow64\": false\n"
    "}\n"
    "},\n"
    "\"Galaxy S5\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (Linux; Android 5.0; SM-G900P Build/LRX21T) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 360,\n"
    "\"height\": 640,\n"
    "\"deviceScaleFactor\": 3,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\",\n"
    "\"clientHints\": {\n"
    "\"architecture\": \"\",\n"
    "\"bitness\": \"\",\n"
    "\"platform\": \"Android\",\n"
    "\"platformVersion\": \"5.0\",\n"
    "\"model\": \"SM-G900P\",\n"
    "\"mobile\": true,\n"
    "\"wow64\": false\n"
    "}\n"
    "},\n"
    "\"Galaxy S8\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (Linux; Android 7.0; SM-G950U Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 360,\n"
    "\"height\": 740,\n"
    "\"deviceScaleFactor\": 3,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\",\n"
    "\"clientHints\": {\n"
    "\"architecture\": \"\",\n"
    "\"bitness\": \"\",\n"
    "\"platform\": \"Android\",\n"
    "\"platformVersion\": \"7.0\",\n"
    "\"model\": \"SM-G950U\",\n"
    "\"mobile\": true,\n"
    "\"wow64\": false\n"
    "}\n"
    "},\n"
    "\"Galaxy S9+\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (Linux; Android 8.0.0; SM-G965U Build/R16NW) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 320,\n"
    "\"height\": 658,\n"
    "\"deviceScaleFactor\": 4.5,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\",\n"
    "\"clientHints\": {\n"
    "\"architecture\": \"\",\n"
    "\"bitness\": \"\",\n"
    "\"platform\": \"Android\",\n"
    "\"platformVersion\": \"8.0.0\",\n"
    "\"model\": \"SM-G965U\",\n"
    "\"mobile\": true,\n"
    "\"wow64\": false\n"
    "}\n"
    "},\n"
    "\"Galaxy Tab S4\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (Linux; Android 8.1.0; SM-T837A) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Safari/537.36\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 712,\n"
    "\"height\": 1138,\n"
    "\"deviceScaleFactor\": 2.25,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\",\n"
    "\"clientHints\": {\n"
    "\"architecture\": \"\",\n"
    "\"bitness\": \"\",\n"
    "\"platform\": \"Android\",\n"
    "\"platformVersion\": \"8.1.0\",\n"
    "\"model\": \"SM-T837A\",\n"
    "\"mobile\": false,\n"
    "\"wow64\": false\n"
    "}\n"
    "},\n"
    "\"JioPhone 2\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (Mobile; LYF/F300B/LYF-F300B-001-01-15-130718-i;Android; rv:48.0) Gecko/48.0 Firefox/48.0 KAIOS/2.5\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 240,\n"
    "\"height\": 320,\n"
    "\"deviceScaleFactor\": 1,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\",\n"
    "\"clientHints\": {\n"
    "\"architecture\": \"\",\n"
    "\"bitness\": \"\",\n"
    "\"platform\": \"Android\",\n"
    "\"platformVersion\": \"\",\n"
    "\"model\": \"LYF/F300B/LYF-F300B-001-01-15-130718-i\",\n"
    "\"mobile\": true,\n"
    "\"wow64\": false\n"
    "}\n"
    "},\n"
    "\"Kindle Fire HDX\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (Linux; U; en-us; KFAPWI Build/JDQ39) AppleWebKit/535.19 (KHTML, like Gecko) Silk/3.13 Safari/535.19 Silk-Accelerated=True\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 800,\n"
    "\"height\": 1280,\n"
    "\"deviceScaleFactor\": 2,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"tablet\"\n"
    "},\n"
    "\"iPad\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (iPad; CPU OS 11_0 like Mac OS X) AppleWebKit/604.1.34 (KHTML, like Gecko) Version/11.0 Mobile/15A5341f Safari/604.1\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 768,\n"
    "\"height\": 1024,\n"
    "\"deviceScaleFactor\": 2,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"tablet\"\n"
    "},\n"
    "\"Blackberry PlayBook\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (PlayBook; U; RIM Tablet OS 2.1.0; en-US) AppleWebKit/536.2+ (KHTML like Gecko) Version/7.2.1.0 Safari/536.2+\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 600,\n"
    "\"height\": 1024,\n"
    "\"deviceScaleFactor\": 1,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"tablet\"\n"
    "},\n"
    "\"Nexus 10\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (Linux; Android 6.0.1; Nexus 10 Build/MOB31T) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Safari/537.36\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 800,\n"
    "\"height\": 1280,\n"
    "\"deviceScaleFactor\": 2,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"tablet\",\n"
    "\"clientHints\": {\n"
    "\"architecture\": \"\",\n"
    "\"bitness\": \"\",\n"
    "\"platform\": \"Android\",\n"
    "\"platformVersion\": \"6.0.1\",\n"
    "\"model\": \"Nexus 10\",\n"
    "\"mobile\": false,\n"
    "\"wow64\": false\n"
    "}\n"
    "},\n"
    "\"Nexus 7\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (Linux; Android 6.0.1; Nexus 7 Build/MOB30X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Safari/537.36\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 600,\n"
    "\"height\": 960,\n"
    "\"deviceScaleFactor\": 2,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"tablet\",\n"
    "\"clientHints\": {\n"
    "\"architecture\": \"\",\n"
    "\"bitness\": \"\",\n"
    "\"platform\": \"Android\",\n"
    "\"platformVersion\": \"6.0.1\",\n"
    "\"model\": \"Nexus 7\",\n"
    "\"mobile\": false,\n"
    "\"wow64\": false\n"
    "}\n"
    "},\n"
    "\"Galaxy Note 3\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (Linux; U; Android 4.3; en-us; SM-N900T Build/JSS15J) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 360,\n"
    "\"height\": 640,\n"
    "\"deviceScaleFactor\": 3,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\",\n"
    "\"clientHints\": {\n"
    "\"architecture\": \"\",\n"
    "\"bitness\": \"\",\n"
    "\"platform\": \"Android\",\n"
    "\"platformVersion\": \"4.3\",\n"
    "\"model\": \"SM-N900T\",\n"
    "\"mobile\": true,\n"
    "\"wow64\": false\n"
    "}\n"
    "},\n"
    "\"Galaxy Note II\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (Linux; U; Android 4.1; en-us; GT-N7100 Build/JRO03C) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 360,\n"
    "\"height\": 640,\n"
    "\"deviceScaleFactor\": 2,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\",\n"
    "\"clientHints\": {\n"
    "\"architecture\": \"\",\n"
    "\"bitness\": \"\",\n"
    "\"platform\": \"Android\",\n"
    "\"platformVersion\": \"4.1\",\n"
    "\"model\": \"GT-N7100\",\n"
    "\"mobile\": true,\n"
    "\"wow64\": false\n"
    "}\n"
    "},\n"
    "\"Laptop with touch\": {\n"
    "\"userAgent\": \"\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 950,\n"
    "\"height\": 1280,\n"
    "\"deviceScaleFactor\": 1,\n"
    "\"touch\": true,\n"
    "\"mobile\": false\n"
    "},\n"
    "\"type\": \"notebook\"\n"
    "},\n"
    "\"Laptop with HiDPI screen\": {\n"
    "\"userAgent\": \"\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 900,\n"
    "\"height\": 1440,\n"
    "\"deviceScaleFactor\": 2,\n"
    "\"touch\": false,\n"
    "\"mobile\": false\n"
    "},\n"
    "\"type\": \"notebook\"\n"
    "},\n"
    "\"Laptop with MDPI screen\": {\n"
    "\"userAgent\": \"\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 800,\n"
    "\"height\": 1280,\n"
    "\"deviceScaleFactor\": 1,\n"
    "\"touch\": false,\n"
    "\"mobile\": false\n"
    "},\n"
    "\"type\": \"notebook\"\n"
    "},\n"
    "\"Moto G4\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (Linux; Android 6.0.1; Moto G (4)) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 360,\n"
    "\"height\": 640,\n"
    "\"deviceScaleFactor\": 3,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\",\n"
    "\"clientHints\": {\n"
    "\"architecture\": \"\",\n"
    "\"bitness\": \"\",\n"
    "\"platform\": \"Android\",\n"
    "\"platformVersion\": \"6.0.1\",\n"
    "\"model\": \"Moto G (4)\",\n"
    "\"mobile\": true,\n"
    "\"wow64\": false\n"
    "}\n"
    "},\n"
    "\"Moto G Power\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (Linux; Android 11; moto g power (2022)) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 412,\n"
    "\"height\": 823,\n"
    "\"deviceScaleFactor\": 1.75,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\",\n"
    "\"clientHints\": {\n"
    "\"architecture\": \"\",\n"
    "\"bitness\": \"\",\n"
    "\"platform\": \"Android\",\n"
    "\"platformVersion\": \"11\",\n"
    "\"model\": \"moto g power (2022)\",\n"
    "\"mobile\": true,\n"
    "\"wow64\": false\n"
    "}\n"
    "},\n"
    "\"Facebook on Android\": {\n"
    "\"userAgent\": \"Mozilla/5.0 (Linux; Android 12; Pixel 6 Build/SQ3A.220705.004; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/%s Mobile Safari/537.36 [FB_IAB/FB4A;FBAV/407.0.0.0.65;]\",\n"
    "\"deviceMetrics\": {\n"
    "\"width\": 412,\n"
    "\"height\": 892,\n"
    "\"deviceScaleFactor\": 3.5,\n"
    "\"touch\": true,\n"
    "\"mobile\": true\n"
    "},\n"
    "\"type\": \"phone\",\n"
    "\"clientHints\": {\n"
    "\"architecture\": \"\",\n"
    "\"bitness\": \"\",\n"
    "\"platform\": \"Android\",\n"
    "\"platformVersion\": \"12\",\n"
    "\"model\": \"Pixel 6\",\n"
    "\"mobile\": true,\n"
    "\"wow64\": false\n"
    "}\n"
    "}\n"
    "}\n";
