
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "ktwofingerswipe_wrapper.h"

// Wrappers providing overrides
#include "kxyselector_wrapper.h"

// Argument includes
#include <qcoreevent.h>
#include <qmetaobject.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpoint.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KTwoFingerSwipe_Type = nullptr;
static PyTypeObject *Sbk_KTwoFingerSwipe_TypeF(void)
{
    return _Sbk_KTwoFingerSwipe_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KTwoFingerSwipeWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KTwoFingerSwipeWrapper::KTwoFingerSwipeWrapper(::QObject * parent) : KTwoFingerSwipe(parent)
{
}

void KTwoFingerSwipeWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTwoFingerSwipe_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KTwoFingerSwipe", funcName, gil, pyOverride, event);
}

void KTwoFingerSwipeWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTwoFingerSwipe_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KTwoFingerSwipe", funcName, gil, pyOverride, signal);
}

void KTwoFingerSwipeWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTwoFingerSwipe_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KTwoFingerSwipe", funcName, gil, pyOverride, event);
}

void KTwoFingerSwipeWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTwoFingerSwipe_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KTwoFingerSwipe", funcName, gil, pyOverride, signal);
}

bool KTwoFingerSwipeWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTwoFingerSwipe_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return KXYSelectorWrapper::sbk_o_event("KTwoFingerSwipe", funcName, gil, pyOverride, event);
}

bool KTwoFingerSwipeWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTwoFingerSwipe_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KTwoFingerSwipe", funcName, gil, pyOverride, watched, event);
}

void KTwoFingerSwipeWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTwoFingerSwipe_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KTwoFingerSwipe", funcName, gil, pyOverride, event);
}

const QMetaObject *KTwoFingerSwipeWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KTwoFingerSwipe::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KTwoFingerSwipeWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KTwoFingerSwipe::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KTwoFingerSwipeWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KTwoFingerSwipeWrapper *>(this));
    }
    return KTwoFingerSwipe::qt_metacast(_clname);
}

KTwoFingerSwipeWrapper::~KTwoFingerSwipeWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KTwoFingerSwipe_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KTwoFingerSwipe_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KTwoFingerSwipe >()))
        return -1;

    KTwoFingerSwipeWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:KTwoFingerSwipe", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KTwoFingerSwipe::KTwoFingerSwipe(QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // KTwoFingerSwipe(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KTwoFingerSwipe(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerSwipe_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerSwipe_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerSwipe_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KTwoFingerSwipe(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KTwoFingerSwipeWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KTwoFingerSwipeWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KTwoFingerSwipe >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerSwipe_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerSwipe_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KTwoFingerSwipeFunc_pos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTwoFingerSwipe *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerSwipe_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // pos()const
        QPointF cppResult = const_cast<const ::KTwoFingerSwipe *>(cppSelf)->pos();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPointF_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KTwoFingerSwipeFunc_scenePos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTwoFingerSwipe *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerSwipe_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // scenePos()const
        QPointF cppResult = const_cast<const ::KTwoFingerSwipe *>(cppSelf)->scenePos();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPointF_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KTwoFingerSwipeFunc_screenPos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTwoFingerSwipe *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerSwipe_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // screenPos()const
        QPointF cppResult = const_cast<const ::KTwoFingerSwipe *>(cppSelf)->screenPos();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPointF_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KTwoFingerSwipeFunc_setPos(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTwoFingerSwipe *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerSwipe_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KTwoFingerSwipe::setPos(QPointF)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPointF_IDX]), (pyArg)))) {
        overloadId = 0; // setPos(QPointF)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setPos", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerSwipe_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPointF cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setPos(QPointF)
            cppSelf->setPos(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KTwoFingerSwipeFunc_setScenePos(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTwoFingerSwipe *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerSwipe_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KTwoFingerSwipe::setScenePos(QPointF)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPointF_IDX]), (pyArg)))) {
        overloadId = 0; // setScenePos(QPointF)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setScenePos", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerSwipe_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPointF cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setScenePos(QPointF)
            cppSelf->setScenePos(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KTwoFingerSwipeFunc_setScreenPos(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTwoFingerSwipe *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerSwipe_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KTwoFingerSwipe::setScreenPos(QPointF)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPointF_IDX]), (pyArg)))) {
        overloadId = 0; // setScreenPos(QPointF)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setScreenPos", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerSwipe_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPointF cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setScreenPos(QPointF)
            cppSelf->setScreenPos(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KTwoFingerSwipeFunc_setSwipeAngle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTwoFingerSwipe *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerSwipe_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KTwoFingerSwipe::setSwipeAngle(qreal)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setSwipeAngle(qreal)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setSwipeAngle", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerSwipe_IDX]);

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setSwipeAngle(qreal)
            cppSelf->setSwipeAngle(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KTwoFingerSwipeFunc_swipeAngle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTwoFingerSwipe *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerSwipe_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // swipeAngle()const
        qreal cppResult = const_cast<const ::KTwoFingerSwipe *>(cppSelf)->swipeAngle();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KTwoFingerSwipe_PropertyStrings[] = {
    "pos::",
    "scenePos::",
    "screenPos::",
    "swipeAngle::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KTwoFingerSwipe_methods[] = {
    {"pos", reinterpret_cast<PyCFunction>(Sbk_KTwoFingerSwipeFunc_pos), METH_NOARGS, nullptr},
    {"scenePos", reinterpret_cast<PyCFunction>(Sbk_KTwoFingerSwipeFunc_scenePos), METH_NOARGS, nullptr},
    {"screenPos", reinterpret_cast<PyCFunction>(Sbk_KTwoFingerSwipeFunc_screenPos), METH_NOARGS, nullptr},
    {"setPos", reinterpret_cast<PyCFunction>(Sbk_KTwoFingerSwipeFunc_setPos), METH_O, nullptr},
    {"setScenePos", reinterpret_cast<PyCFunction>(Sbk_KTwoFingerSwipeFunc_setScenePos), METH_O, nullptr},
    {"setScreenPos", reinterpret_cast<PyCFunction>(Sbk_KTwoFingerSwipeFunc_setScreenPos), METH_O, nullptr},
    {"setSwipeAngle", reinterpret_cast<PyCFunction>(Sbk_KTwoFingerSwipeFunc_setSwipeAngle), METH_O, nullptr},
    {"swipeAngle", reinterpret_cast<PyCFunction>(Sbk_KTwoFingerSwipeFunc_swipeAngle), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KTwoFingerSwipe_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KTwoFingerSwipe *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerSwipe_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KTwoFingerSwipeWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KTwoFingerSwipe_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KTwoFingerSwipe_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KTwoFingerSwipe_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KTwoFingerSwipe_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KTwoFingerSwipe_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KTwoFingerSwipe_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KTwoFingerSwipe_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KTwoFingerSwipe_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KTwoFingerSwipe_spec = {
    "1:KWidgetsAddons.KTwoFingerSwipe",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KTwoFingerSwipe_slots
};

} //extern "C"

static void *Sbk_KTwoFingerSwipe_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KTwoFingerSwipe *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KTwoFingerSwipe_PythonToCpp_KTwoFingerSwipe_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KTwoFingerSwipe_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KTwoFingerSwipe_PythonToCpp_KTwoFingerSwipe_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KTwoFingerSwipe_TypeF()))
        return KTwoFingerSwipe_PythonToCpp_KTwoFingerSwipe_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KTwoFingerSwipe_PTR_CppToPython_KTwoFingerSwipe(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KTwoFingerSwipe *>(const_cast<void *>(cppIn)), Sbk_KTwoFingerSwipe_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KTwoFingerSwipe_SignatureStrings[] = {
    "KWidgetsAddons.KTwoFingerSwipe(self,parent:PySide6.QtCore.QObject=nullptr,*:KeywordOnly=None,pos:QPointF=None,screenPos:QPointF=None,scenePos:QPointF=None,swipeAngle:qreal=None)",
    "KWidgetsAddons.KTwoFingerSwipe.pos(self)->PySide6.QtCore.QPointF",
    "KWidgetsAddons.KTwoFingerSwipe.scenePos(self)->PySide6.QtCore.QPointF",
    "KWidgetsAddons.KTwoFingerSwipe.screenPos(self)->PySide6.QtCore.QPointF",
    "KWidgetsAddons.KTwoFingerSwipe.setPos(self,pos:typing.Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint])",
    "KWidgetsAddons.KTwoFingerSwipe.setScenePos(self,scenePos:typing.Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint])",
    "KWidgetsAddons.KTwoFingerSwipe.setScreenPos(self,screenPos:typing.Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint])",
    "KWidgetsAddons.KTwoFingerSwipe.setSwipeAngle(self,swipeAngle:qreal)",
    "KWidgetsAddons.KTwoFingerSwipe.swipeAngle(self)->qreal",
    nullptr}; // Sentinel
#else
static constexpr size_t KTwoFingerSwipe_SignatureByteSize = 225;
static constexpr uint8_t KTwoFingerSwipe_SignatureBytes[225] = {
    0x78, 0xda, 0xb5, 0x92, 0x4b, 0x0b, 0xc2, 0x30, 0x10, 0x84, 0xef, 0xfe, 0x0a, 0x8f, 0x56, 0x6a,
    0x8e, 0x1e, 0x0a, 0x0a, 0x22, 0x78, 0x29, 0x68, 0x4b, 0x15, 0x0f, 0xe2, 0x41, 0xcd, 0x58, 0x22,
    0x61, 0x13, 0x93, 0x48, 0xe9, 0xbf, 0xb7, 0xd6, 0x57, 0x7d, 0xa0, 0x82, 0xf4, 0x3a, 0x21, 0xdf,
    0xcc, 0xee, 0x4e, 0x38, 0x17, 0x3c, 0x85, 0xb3, 0x03, 0xce, 0x15, 0x59, 0x16, 0x4e, 0x33, 0x35,
    0x12, 0x94, 0xc2, 0x24, 0x99, 0xd0, 0x68, 0x59, 0xc8, 0xad, 0xaf, 0x57, 0x06, 0xe4, 0x82, 0x28,
    0x4f, 0x04, 0x47, 0x97, 0xc5, 0x6e, 0xa8, 0x0c, 0x58, 0x3c, 0x59, 0xef, 0xb0, 0x71, 0x3d, 0x3a,
    0x48, 0xa9, 0x9d, 0xf1, 0xdb, 0x41, 0x88, 0x3c, 0x53, 0x86, 0x4f, 0x48, 0xe6, 0xbd, 0xb1, 0x22,
    0xf8, 0x5a, 0xd9, 0x20, 0x8e, 0x94, 0x20, 0x37, 0x3a, 0x0b, 0x76, 0x63, 0x00, 0x8a, 0x5e, 0x65,
    0x10, 0x5e, 0xd5, 0x53, 0x82, 0x01, 0xa5, 0x12, 0xc1, 0xde, 0x60, 0x25, 0x4b, 0xd5, 0x6b, 0x84,
    0x1f, 0x13, 0xb3, 0xc2, 0xb3, 0x4c, 0xed, 0x75, 0xfa, 0xcf, 0x81, 0xcf, 0xf0, 0x6f, 0x80, 0x6b,
    0x98, 0x7f, 0x29, 0x97, 0x49, 0xff, 0xc4, 0xc0, 0x5d, 0x19, 0xe5, 0x36, 0x5d, 0xae, 0x8b, 0x57,
    0x36, 0x23, 0xa1, 0x68, 0xf1, 0x1e, 0xe9, 0x37, 0xdf, 0xea, 0x4b, 0xef, 0x07, 0xaf, 0xa4, 0x3a,
    0xfb, 0xfd, 0x2c, 0xb5, 0xbb, 0x56, 0x77, 0x55, 0x29, 0x49, 0xdd, 0xbe, 0xb7, 0x82, 0x5d, 0x8c,
    0x9f, 0x0a, 0xf7, 0x9d, 0xf1, 0x08, 0x28, 0xae, 0x5c, 0xfe, 0x6b, 0x1c, 0x01, 0xb1, 0xbe, 0x37,
    0xe3
};
#endif

PyTypeObject *init_KTwoFingerSwipe(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerSwipe_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerSwipe_IDX].type;

    Shiboken::AutoDecRef Sbk_KTwoFingerSwipe_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QGesture_IDX]))));

    _Sbk_KTwoFingerSwipe_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KTwoFingerSwipe",
        "KTwoFingerSwipe*",
        &Sbk_KTwoFingerSwipe_spec,
        &Shiboken::callCppDestructor< KTwoFingerSwipe >,
        Sbk_KTwoFingerSwipe_Type_bases.object(),
        0);
    auto *pyType = Sbk_KTwoFingerSwipe_TypeF(); // references _Sbk_KTwoFingerSwipe_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KTwoFingerSwipe_SignatureStrings);
#else
    InitSignatureBytes(pyType, KTwoFingerSwipe_SignatureBytes, KTwoFingerSwipe_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KTwoFingerSwipe_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerSwipe_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KTwoFingerSwipe_PythonToCpp_KTwoFingerSwipe_PTR,
        is_KTwoFingerSwipe_PythonToCpp_KTwoFingerSwipe_PTR_Convertible,
        KTwoFingerSwipe_PTR_CppToPython_KTwoFingerSwipe);

    Shiboken::Conversions::registerConverterName(converter, "KTwoFingerSwipe");
    Shiboken::Conversions::registerConverterName(converter, "KTwoFingerSwipe*");
    Shiboken::Conversions::registerConverterName(converter, "KTwoFingerSwipe&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KTwoFingerSwipe).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KTwoFingerSwipeWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KTwoFingerSwipe_TypeF(), &Sbk_KTwoFingerSwipe_typeDiscovery);

    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KTwoFingerSwipe::staticMetaObject, sizeof(KTwoFingerSwipeWrapper));

    return pyType;
}
