// Copyright 2019 Istio Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.10
// 	protoc        (unknown)
// source: envoy/extensions/stats/config.proto

// $title: Stats Config
// $description: Configuration for Stats Filter.
// $location: https://istio.io/docs/reference/config/proxy_extensions/stats.html
// $weight: 20

package stats

import (
	duration "github.com/golang/protobuf/ptypes/duration"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type MetricType int32

const (
	MetricType_COUNTER   MetricType = 0
	MetricType_GAUGE     MetricType = 1
	MetricType_HISTOGRAM MetricType = 2
)

// Enum value maps for MetricType.
var (
	MetricType_name = map[int32]string{
		0: "COUNTER",
		1: "GAUGE",
		2: "HISTOGRAM",
	}
	MetricType_value = map[string]int32{
		"COUNTER":   0,
		"GAUGE":     1,
		"HISTOGRAM": 2,
	}
)

func (x MetricType) Enum() *MetricType {
	p := new(MetricType)
	*p = x
	return p
}

func (x MetricType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetricType) Descriptor() protoreflect.EnumDescriptor {
	return file_envoy_extensions_stats_config_proto_enumTypes[0].Descriptor()
}

func (MetricType) Type() protoreflect.EnumType {
	return &file_envoy_extensions_stats_config_proto_enumTypes[0]
}

func (x MetricType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MetricType.Descriptor instead.
func (MetricType) EnumDescriptor() ([]byte, []int) {
	return file_envoy_extensions_stats_config_proto_rawDescGZIP(), []int{0}
}

// Specifies the proxy deployment type.
type Reporter int32

const (
	// Default value is inferred from the listener direction, as either client or
	// server sidecar.
	Reporter_UNSPECIFIED Reporter = 0
	// Shared server gateway, e.g. "waypoint".
	Reporter_SERVER_GATEWAY Reporter = 1
)

// Enum value maps for Reporter.
var (
	Reporter_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "SERVER_GATEWAY",
	}
	Reporter_value = map[string]int32{
		"UNSPECIFIED":    0,
		"SERVER_GATEWAY": 1,
	}
)

func (x Reporter) Enum() *Reporter {
	p := new(Reporter)
	*p = x
	return p
}

func (x Reporter) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Reporter) Descriptor() protoreflect.EnumDescriptor {
	return file_envoy_extensions_stats_config_proto_enumTypes[1].Descriptor()
}

func (Reporter) Type() protoreflect.EnumType {
	return &file_envoy_extensions_stats_config_proto_enumTypes[1]
}

func (x Reporter) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Reporter.Descriptor instead.
func (Reporter) EnumDescriptor() ([]byte, []int) {
	return file_envoy_extensions_stats_config_proto_rawDescGZIP(), []int{1}
}

// Metric instance configuration overrides.
// The metric value and the metric type are optional and permit changing the
// reported value for an existing metric.
// The standard metrics are optimized and reported through a "fast-path".
// The customizations allow full configurability, at the cost of a "slower"
// path.
type MetricConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// (Optional) Collection of tag names and tag expressions to include in the
	// metric. Conflicts are resolved by the tag name by overriding previously
	// supplied values.
	Dimensions map[string]string `protobuf:"bytes,1,rep,name=dimensions,proto3" json:"dimensions,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// (Optional) Metric name to restrict the override to a metric. If not
	// specified, applies to all.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// (Optional) A list of tags to remove.
	TagsToRemove []string `protobuf:"bytes,3,rep,name=tags_to_remove,json=tagsToRemove,proto3" json:"tags_to_remove,omitempty"`
	// NOT IMPLEMENTED. (Optional) Conditional enabling the override.
	Match string `protobuf:"bytes,4,opt,name=match,proto3" json:"match,omitempty"`
	// (Optional) If this is set to true, the metric(s) selected by this
	// configuration will not be generated or reported.
	Drop          bool `protobuf:"varint,5,opt,name=drop,proto3" json:"drop,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MetricConfig) Reset() {
	*x = MetricConfig{}
	mi := &file_envoy_extensions_stats_config_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MetricConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetricConfig) ProtoMessage() {}

func (x *MetricConfig) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_stats_config_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetricConfig.ProtoReflect.Descriptor instead.
func (*MetricConfig) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_stats_config_proto_rawDescGZIP(), []int{0}
}

func (x *MetricConfig) GetDimensions() map[string]string {
	if x != nil {
		return x.Dimensions
	}
	return nil
}

func (x *MetricConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *MetricConfig) GetTagsToRemove() []string {
	if x != nil {
		return x.TagsToRemove
	}
	return nil
}

func (x *MetricConfig) GetMatch() string {
	if x != nil {
		return x.Match
	}
	return ""
}

func (x *MetricConfig) GetDrop() bool {
	if x != nil {
		return x.Drop
	}
	return false
}

type MetricDefinition struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Metric name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Metric value expression.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// NOT IMPLEMENTED (Optional) Metric type.
	Type          MetricType `protobuf:"varint,3,opt,name=type,proto3,enum=stats.MetricType" json:"type,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MetricDefinition) Reset() {
	*x = MetricDefinition{}
	mi := &file_envoy_extensions_stats_config_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MetricDefinition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetricDefinition) ProtoMessage() {}

func (x *MetricDefinition) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_stats_config_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetricDefinition.ProtoReflect.Descriptor instead.
func (*MetricDefinition) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_stats_config_proto_rawDescGZIP(), []int{1}
}

func (x *MetricDefinition) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *MetricDefinition) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *MetricDefinition) GetType() MetricType {
	if x != nil {
		return x.Type
	}
	return MetricType_COUNTER
}

type PluginConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// next id: 7
	// The following settings should be rarely used.
	// Enable debug for this filter.
	// DEPRECATED.
	Debug bool `protobuf:"varint,1,opt,name=debug,proto3" json:"debug,omitempty"`
	// maximum size of the peer metadata cache.
	// A long lived proxy that connects with many transient peers can build up a
	// large cache. To turn off the cache, set this field to a negative value.
	// DEPRECATED.
	MaxPeerCacheSize int32 `protobuf:"varint,2,opt,name=max_peer_cache_size,json=maxPeerCacheSize,proto3" json:"max_peer_cache_size,omitempty"`
	// prefix to add to stats emitted by the plugin.
	// DEPRECATED.
	StatPrefix string `protobuf:"bytes,3,opt,name=stat_prefix,json=statPrefix,proto3" json:"stat_prefix,omitempty"` // default: "istio_"
	// Stats api squashes dimensions in a single string.
	// The squashed string is parsed at prometheus scrape time to recover
	// dimensions. The following 2 fields set the field and value separators {key:
	// value} -->  key{value_separator}value{field_separator}
	FieldSeparator string `protobuf:"bytes,4,opt,name=field_separator,json=fieldSeparator,proto3" json:"field_separator,omitempty"` // default: ";;"
	ValueSeparator string `protobuf:"bytes,5,opt,name=value_separator,json=valueSeparator,proto3" json:"value_separator,omitempty"` // default: "=="
	// Optional: Disable using host header as a fallback if destination service is
	// not available from the controlplane. Disable the fallback if the host
	// header originates outsides the mesh, like at ingress.
	DisableHostHeaderFallback bool `protobuf:"varint,6,opt,name=disable_host_header_fallback,json=disableHostHeaderFallback,proto3" json:"disable_host_header_fallback,omitempty"`
	// Optional. Allows configuration of the time between calls out to for TCP
	// metrics reporting. The default duration is `15s`.
	TcpReportingDuration *duration.Duration `protobuf:"bytes,7,opt,name=tcp_reporting_duration,json=tcpReportingDuration,proto3" json:"tcp_reporting_duration,omitempty"`
	// Metric overrides.
	Metrics []*MetricConfig `protobuf:"bytes,8,rep,name=metrics,proto3" json:"metrics,omitempty"`
	// Metric definitions.
	Definitions []*MetricDefinition `protobuf:"bytes,9,rep,name=definitions,proto3" json:"definitions,omitempty"`
	// Proxy deployment type.
	// $hide_from_docs
	Reporter Reporter `protobuf:"varint,10,opt,name=reporter,proto3,enum=stats.Reporter" json:"reporter,omitempty"`
	// Metric scope rotation interval. Set to 0 to disable the metric scope rotation.
	// Defaults to 0.
	// $hide_from_docs
	RotationInterval *duration.Duration `protobuf:"bytes,11,opt,name=rotation_interval,json=rotationInterval,proto3" json:"rotation_interval,omitempty"`
	// Metric expiry graceful deletion interval. No-op if the metric rotation is disabled.
	// Defaults to 5m. Must be >=1s.
	// $hide_from_docs
	GracefulDeletionInterval *duration.Duration `protobuf:"bytes,12,opt,name=graceful_deletion_interval,json=gracefulDeletionInterval,proto3" json:"graceful_deletion_interval,omitempty"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *PluginConfig) Reset() {
	*x = PluginConfig{}
	mi := &file_envoy_extensions_stats_config_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PluginConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PluginConfig) ProtoMessage() {}

func (x *PluginConfig) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_stats_config_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PluginConfig.ProtoReflect.Descriptor instead.
func (*PluginConfig) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_stats_config_proto_rawDescGZIP(), []int{2}
}

func (x *PluginConfig) GetDebug() bool {
	if x != nil {
		return x.Debug
	}
	return false
}

func (x *PluginConfig) GetMaxPeerCacheSize() int32 {
	if x != nil {
		return x.MaxPeerCacheSize
	}
	return 0
}

func (x *PluginConfig) GetStatPrefix() string {
	if x != nil {
		return x.StatPrefix
	}
	return ""
}

func (x *PluginConfig) GetFieldSeparator() string {
	if x != nil {
		return x.FieldSeparator
	}
	return ""
}

func (x *PluginConfig) GetValueSeparator() string {
	if x != nil {
		return x.ValueSeparator
	}
	return ""
}

func (x *PluginConfig) GetDisableHostHeaderFallback() bool {
	if x != nil {
		return x.DisableHostHeaderFallback
	}
	return false
}

func (x *PluginConfig) GetTcpReportingDuration() *duration.Duration {
	if x != nil {
		return x.TcpReportingDuration
	}
	return nil
}

func (x *PluginConfig) GetMetrics() []*MetricConfig {
	if x != nil {
		return x.Metrics
	}
	return nil
}

func (x *PluginConfig) GetDefinitions() []*MetricDefinition {
	if x != nil {
		return x.Definitions
	}
	return nil
}

func (x *PluginConfig) GetReporter() Reporter {
	if x != nil {
		return x.Reporter
	}
	return Reporter_UNSPECIFIED
}

func (x *PluginConfig) GetRotationInterval() *duration.Duration {
	if x != nil {
		return x.RotationInterval
	}
	return nil
}

func (x *PluginConfig) GetGracefulDeletionInterval() *duration.Duration {
	if x != nil {
		return x.GracefulDeletionInterval
	}
	return nil
}

var File_envoy_extensions_stats_config_proto protoreflect.FileDescriptor

const file_envoy_extensions_stats_config_proto_rawDesc = "" +
	"\n" +
	"#envoy/extensions/stats/config.proto\x12\x05stats\x1a\x1egoogle/protobuf/duration.proto\"\xf6\x01\n" +
	"\fMetricConfig\x12C\n" +
	"\n" +
	"dimensions\x18\x01 \x03(\v2#.stats.MetricConfig.DimensionsEntryR\n" +
	"dimensions\x12\x12\n" +
	"\x04name\x18\x02 \x01(\tR\x04name\x12$\n" +
	"\x0etags_to_remove\x18\x03 \x03(\tR\ftagsToRemove\x12\x14\n" +
	"\x05match\x18\x04 \x01(\tR\x05match\x12\x12\n" +
	"\x04drop\x18\x05 \x01(\bR\x04drop\x1a=\n" +
	"\x0fDimensionsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"c\n" +
	"\x10MetricDefinition\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value\x12%\n" +
	"\x04type\x18\x03 \x01(\x0e2\x11.stats.MetricTypeR\x04type\"\x90\x05\n" +
	"\fPluginConfig\x12\x14\n" +
	"\x05debug\x18\x01 \x01(\bR\x05debug\x12-\n" +
	"\x13max_peer_cache_size\x18\x02 \x01(\x05R\x10maxPeerCacheSize\x12\x1f\n" +
	"\vstat_prefix\x18\x03 \x01(\tR\n" +
	"statPrefix\x12'\n" +
	"\x0ffield_separator\x18\x04 \x01(\tR\x0efieldSeparator\x12'\n" +
	"\x0fvalue_separator\x18\x05 \x01(\tR\x0evalueSeparator\x12?\n" +
	"\x1cdisable_host_header_fallback\x18\x06 \x01(\bR\x19disableHostHeaderFallback\x12O\n" +
	"\x16tcp_reporting_duration\x18\a \x01(\v2\x19.google.protobuf.DurationR\x14tcpReportingDuration\x12-\n" +
	"\ametrics\x18\b \x03(\v2\x13.stats.MetricConfigR\ametrics\x129\n" +
	"\vdefinitions\x18\t \x03(\v2\x17.stats.MetricDefinitionR\vdefinitions\x12+\n" +
	"\breporter\x18\n" +
	" \x01(\x0e2\x0f.stats.ReporterR\breporter\x12F\n" +
	"\x11rotation_interval\x18\v \x01(\v2\x19.google.protobuf.DurationR\x10rotationInterval\x12W\n" +
	"\x1agraceful_deletion_interval\x18\f \x01(\v2\x19.google.protobuf.DurationR\x18gracefulDeletionInterval*3\n" +
	"\n" +
	"MetricType\x12\v\n" +
	"\aCOUNTER\x10\x00\x12\t\n" +
	"\x05GAUGE\x10\x01\x12\r\n" +
	"\tHISTOGRAM\x10\x02*/\n" +
	"\bReporter\x12\x0f\n" +
	"\vUNSPECIFIED\x10\x00\x12\x12\n" +
	"\x0eSERVER_GATEWAY\x10\x01B%Z#istio.io/api/envoy/extensions/statsb\x06proto3"

var (
	file_envoy_extensions_stats_config_proto_rawDescOnce sync.Once
	file_envoy_extensions_stats_config_proto_rawDescData []byte
)

func file_envoy_extensions_stats_config_proto_rawDescGZIP() []byte {
	file_envoy_extensions_stats_config_proto_rawDescOnce.Do(func() {
		file_envoy_extensions_stats_config_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_envoy_extensions_stats_config_proto_rawDesc), len(file_envoy_extensions_stats_config_proto_rawDesc)))
	})
	return file_envoy_extensions_stats_config_proto_rawDescData
}

var file_envoy_extensions_stats_config_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_envoy_extensions_stats_config_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_envoy_extensions_stats_config_proto_goTypes = []any{
	(MetricType)(0),           // 0: stats.MetricType
	(Reporter)(0),             // 1: stats.Reporter
	(*MetricConfig)(nil),      // 2: stats.MetricConfig
	(*MetricDefinition)(nil),  // 3: stats.MetricDefinition
	(*PluginConfig)(nil),      // 4: stats.PluginConfig
	nil,                       // 5: stats.MetricConfig.DimensionsEntry
	(*duration.Duration)(nil), // 6: google.protobuf.Duration
}
var file_envoy_extensions_stats_config_proto_depIdxs = []int32{
	5, // 0: stats.MetricConfig.dimensions:type_name -> stats.MetricConfig.DimensionsEntry
	0, // 1: stats.MetricDefinition.type:type_name -> stats.MetricType
	6, // 2: stats.PluginConfig.tcp_reporting_duration:type_name -> google.protobuf.Duration
	2, // 3: stats.PluginConfig.metrics:type_name -> stats.MetricConfig
	3, // 4: stats.PluginConfig.definitions:type_name -> stats.MetricDefinition
	1, // 5: stats.PluginConfig.reporter:type_name -> stats.Reporter
	6, // 6: stats.PluginConfig.rotation_interval:type_name -> google.protobuf.Duration
	6, // 7: stats.PluginConfig.graceful_deletion_interval:type_name -> google.protobuf.Duration
	8, // [8:8] is the sub-list for method output_type
	8, // [8:8] is the sub-list for method input_type
	8, // [8:8] is the sub-list for extension type_name
	8, // [8:8] is the sub-list for extension extendee
	0, // [0:8] is the sub-list for field type_name
}

func init() { file_envoy_extensions_stats_config_proto_init() }
func file_envoy_extensions_stats_config_proto_init() {
	if File_envoy_extensions_stats_config_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_envoy_extensions_stats_config_proto_rawDesc), len(file_envoy_extensions_stats_config_proto_rawDesc)),
			NumEnums:      2,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_envoy_extensions_stats_config_proto_goTypes,
		DependencyIndexes: file_envoy_extensions_stats_config_proto_depIdxs,
		EnumInfos:         file_envoy_extensions_stats_config_proto_enumTypes,
		MessageInfos:      file_envoy_extensions_stats_config_proto_msgTypes,
	}.Build()
	File_envoy_extensions_stats_config_proto = out.File
	file_envoy_extensions_stats_config_proto_goTypes = nil
	file_envoy_extensions_stats_config_proto_depIdxs = nil
}
